/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.Point2MultVertSS_Fault;

import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.earthquake.AbstractEpistemicListERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.rupForecastImpl.Point2MultVertSS_FaultSource;
import org.opensha.sha.earthquake.rupForecastImpl.SingleFaultRuptureERF;

public class Point2MultVertSS_FaultERF_List
extends AbstractEpistemicListERF {
    protected static String C = new String("Point2MultVertSS_FaultERF_List");
    protected boolean D = false;
    public static final String NAME = "Point2Mult Vertical SS Fault ERF List";
    protected Point2MultVertSS_FaultSource source;
    WC1994_MagLengthRelationship magLengthRel = new WC1994_MagLengthRelationship();
    double upperSeisDepth = 0.0;
    double lowerSeisDepth = 1.0;
    DoubleParameter srcLatParam;
    DoubleParameter srcLonParam;
    DoubleParameter magParam;
    DoubleParameter maxRupOffsetParam;
    DoubleParameter deltaStrikeParam;
    public static final String SRC_LAT_PARAM_NAME = "Latitude";
    private static final String SRC_LAT_PARAM_INFO = "The latitude of the point source";
    private static final String SRC_LAT_PARAM_UNITS = "Degrees";
    private Double SRC_LAT_PARAM_MIN = -90.0;
    private Double SRC_LAT_PARAM_MAX = 90.0;
    private Double SRC_LAT_PARAM_DEFAULT = 35.71;
    public static final String SRC_LON_PARAM_NAME = "Longitude";
    private static final String SRC_LON_PARAM_INFO = "The longitude of the point source";
    private static final String SRC_LON_PARAM_UNITS = "Degrees";
    private Double SRC_LON_PARAM_MIN = -360.0;
    private Double SRC_LON_PARAM_MAX = 360.0;
    private Double SRC_LON_PARAM_DEFAULT = -121.1;
    public static final String MAG_PARAM_NAME = "Magnitude";
    private static final String MAG_PARAM_INFO = "The  magnitude for the point source";
    private static final String MAG_PARAM_UNITS = null;
    private Double MAG_PARAM_MIN = 5.0;
    private Double MAG_PARAM_MAX = 10.0;
    private Double MAG_PARAM_DEFAULT = 7.0;
    public static final String RUP_OFFSET_PARAM_NAME = "Max Rupture Offset";
    private static final String RUP_OFFSET_PARAM_INFO = "The amount by which ruptures are floated along stike (actual value will be slightly less)";
    private static final String RUP_OFFSET_PARAM_UNITS = "km";
    private Double RUP_OFFSET_PARAM_MIN = 0.01;
    private Double RUP_OFFSET_PARAM_MAX = 20.0;
    private Double RUP_OFFSET_PARAM_DEFAULT = 2.0;
    public static final String DELTA_STRIKE_PARAM_NAME = "Delta Strike";
    private static final String DELTA_STRIKE_PARAM_INFO = "Discretization of strike for spinning fault";
    private static final String DELTA_STRIKE_PARAM_UNITS = "degrees";
    private Double DELTA_STRIKE_PARAM_MIN = 0.01;
    private Double DELTA_STRIKE_PARAM_MAX = 90.0;
    private Double DELTA_STRIKE_PARAM_DEFAULT = 5.0;

    public Point2MultVertSS_FaultERF_List() {
        this.timeSpan = null;
        this.srcLatParam = new DoubleParameter(SRC_LAT_PARAM_NAME, this.SRC_LAT_PARAM_MIN, this.SRC_LAT_PARAM_MAX, "Degrees", this.SRC_LAT_PARAM_DEFAULT);
        this.srcLatParam.setInfo(SRC_LAT_PARAM_INFO);
        this.srcLonParam = new DoubleParameter(SRC_LON_PARAM_NAME, this.SRC_LON_PARAM_MIN, this.SRC_LON_PARAM_MAX, "Degrees", this.SRC_LON_PARAM_DEFAULT);
        this.srcLonParam.setInfo(SRC_LON_PARAM_INFO);
        this.magParam = new DoubleParameter(MAG_PARAM_NAME, this.MAG_PARAM_MIN, this.MAG_PARAM_MAX, MAG_PARAM_UNITS, this.MAG_PARAM_DEFAULT);
        this.magParam.setInfo(MAG_PARAM_INFO);
        this.maxRupOffsetParam = new DoubleParameter(RUP_OFFSET_PARAM_NAME, this.RUP_OFFSET_PARAM_MIN, this.RUP_OFFSET_PARAM_MAX, RUP_OFFSET_PARAM_UNITS, this.RUP_OFFSET_PARAM_DEFAULT);
        this.maxRupOffsetParam.setInfo(RUP_OFFSET_PARAM_INFO);
        this.deltaStrikeParam = new DoubleParameter(DELTA_STRIKE_PARAM_NAME, this.DELTA_STRIKE_PARAM_MIN, this.DELTA_STRIKE_PARAM_MAX, DELTA_STRIKE_PARAM_UNITS, this.DELTA_STRIKE_PARAM_DEFAULT);
        this.deltaStrikeParam.setInfo(DELTA_STRIKE_PARAM_INFO);
        this.adjustableParams.addParameter(this.srcLatParam);
        this.adjustableParams.addParameter(this.srcLonParam);
        this.adjustableParams.addParameter(this.magParam);
        this.adjustableParams.addParameter(this.maxRupOffsetParam);
        this.adjustableParams.addParameter(this.deltaStrikeParam);
        this.srcLatParam.addParameterChangeListener(this);
        this.srcLonParam.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.maxRupOffsetParam.addParameterChangeListener(this);
        this.deltaStrikeParam.addParameterChangeListener(this);
    }

    @Override
    public void updateForecast() {
        String S = C + "updateForecast::";
        if (this.parameterChangeFlag) {
            double lat = (Double)this.srcLatParam.getValue();
            double lon = (Double)this.srcLonParam.getValue();
            double mag = (Double)this.magParam.getValue();
            double prob = 1.0;
            double maxRupOffset = (Double)this.maxRupOffsetParam.getValue();
            double deltaStrike = (Double)this.deltaStrikeParam.getValue();
            this.source = new Point2MultVertSS_FaultSource(lat, lon, mag, prob, this.magLengthRel, this.upperSeisDepth, this.lowerSeisDepth, maxRupOffset, deltaStrike);
            int numRups = this.source.getNumRuptures();
            for (int i = 0; i < numRups; ++i) {
                ProbEqkRupture eqkRup = this.source.getRupture(i);
                this.addERF(new SingleFaultRuptureERF(eqkRup, 1.0), eqkRup.getProbability());
            }
            this.parameterChangeFlag = false;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setTimeSpan(TimeSpan time) {
    }

    public static void main(String[] args) {
        Point2MultVertSS_FaultERF_List erfList = new Point2MultVertSS_FaultERF_List();
        erfList.updateForecast();
        System.out.println("numERFs=" + erfList.getNumERFs());
        System.out.println("wtOfFirstERF=" + erfList.getERF_RelativeWeight(0));
        System.out.println("numSrcsInFirstERF=" + erfList.getERF(0).getNumSources());
        System.out.println("numRupsInFirstSrcOfFirstERF=" + erfList.getERF(0).getSource(0).getNumRuptures());
        System.out.println("probOfFirstRupInFirstSrcOfFirstERF=" + erfList.getERF(0).getSource(0).getRupture(0).getProbability());
        System.out.println(erfList.getERF(0).getSource(0).getRupture(0).getRuptureSurface().getFirstLocOnUpperEdge().getLatitude());
        System.out.println(erfList.getERF(1).getSource(0).getRupture(0).getRuptureSurface().getFirstLocOnUpperEdge().getLatitude());
    }
}

