/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.MagScalingRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.PEER_testsMagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.impl.ArbitrarilyDiscretizedFuncParameter;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.LocationParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.PointSource;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.utils.PointSurfaceBuilder;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SingleMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.magdist.YC_1985_CharMagFreqDist;
import org.opensha.sha.param.MagFreqDistParameter;

public class PointToLineSourceERF
extends AbstractERF {
    private static String C = new String("PointToLineSourceERF");
    private boolean D = false;
    public static final String NAME = "Point To Line Source ERF";
    private PointSource source;
    LocationParameter locParam;
    MagFreqDistParameter magDistParam;
    DoubleParameter rakeParam;
    DoubleParameter strikeParam;
    DoubleParameter dipParam;
    StringParameter magScalingRelParam;
    ArbitrarilyDiscretizedFuncParameter rupTopDepthParam;
    DoubleParameter defaultHypoDepthParam;
    DoubleParameter lowerSeisDepthParam;
    DoubleParameter minMagParam;
    BooleanParameter spokedRupturesParam;
    IntegerParameter numStrikeParam;
    DoubleParameter firstStrikeParam;
    public static final String LOC_PARAM_NAME = "Location";
    private static final String LOC_PARAM_INFO = "Location of center of the source";
    public static final String MAG_DIST_PARAM_NAME = "Mag Freq Dist";
    public static final String RAKE_PARAM_NAME = "Rake";
    private static final String RAKE_PARAM_INFO = "The rake of the rupture (direction of slip)";
    private static final String RAKE_PARAM_UNITS = "degrees";
    private Double RAKE_PARAM_MIN = -180.0;
    private Double RAKE_PARAM_MAX = 180.0;
    private Double RAKE_PARAM_DEFAULT = 0.0;
    public static final String STRIKE_PARAM_NAME = "Strike";
    private static final String STRIKE_PARAM_INFO = "The strike of the rupture (put blank for random)";
    private static final String STRIKE_PARAM_UNITS = "degrees";
    private Double STRIKE_PARAM_MIN = -180.0;
    private Double STRIKE_PARAM_MAX = 180.0;
    private Double STRIKE_PARAM_DEFAULT = 0.0;
    public static final String DIP_PARAM_NAME = "Dip";
    private static final String DIP_PARAM_INFO = "The dip of the rupture";
    private static final String DIP_PARAM_UNITS = "degrees";
    private Double DIP_PARAM_MIN = 0.0;
    private Double DIP_PARAM_MAX = 90.0;
    private Double DIP_PARAM_DEFAULT = 90.0;
    public static final String MAG_SCALING_REL_PARAM_NAME = "Mag-Scaling Relationship";
    private static final String MAG_SCALING_REL_PARAM_INFO = "Relationship to use for Area(Mag) or Area(Length) calculations";
    private ArrayList<String> magScalingRelOptions;
    public static final String RUP_TOP_DEPTH_FUNC_PARAM_NAME = "Rup-Top Depth vs Mag";
    private static final String RUP_TOP_DEPTH_FUNC_PARAM_INFO = "Used to set the depth of line sources";
    public static final String LOWER_SEIS_DEPTH_PARAM_NAME = "Lower Seis Depth";
    private static final String LOWER_SEIS_DEPTH_PARAM_INFO = "Lower Seismogenic Depth";
    private static final String LOWER_SEIS_DEPTH_PARAM_UNITS = "km";
    private Double LOWER_SEIS_DEPTH_PARAM_MIN = 0.0;
    private Double LOWER_SEIS_DEPTH_PARAM_MAX = 100.0;
    private Double LOWER_SEIS_DEPTH_PARAM_DEFAULT = 14.0;
    public static final String MIN_MAG_PARAM_NAME = "Min Mag";
    private static final String MIN_MAG_PARAM_INFO = "The minimum mag to be considered from the mag freq dist";
    private Double MIN_MAG_PARAM_MIN = 0.0;
    private Double MIN_MAG_PARAM_MAX = 10.0;
    private Double MIN_MAG_PARAM_DEFAULT = 5.0;
    public static final String SPOKED_RUPTURES_PARAM_NAME = "Apply spoked source?";
    private static final String SPOKED_RUPTURES_PARAM_INFO = "This will apply a number of ruptures whose strikes are evenly spaced";
    public static final String NUM_STRIKE_PARAM_NAME = "Num Strikes";
    private static final String NUM_STRIKE_PARAM_INFO = "Number of strikes for spoked source";
    private Integer NUM_STRIKE_PARAM_MIN = 1;
    private Integer NUM_STRIKE_PARAM_MAX = 180;
    private Integer NUM_STRIKE_PARAM_DEFAULT = 2;
    public static final String FIRST_STRIKE_PARAM_NAME = "First Strike";
    private static final String FIRST_STRIKE_PARAM_INFO = "The first strike for the spoked source";
    private static final String FIRST_STRIKE_PARAM_UNITS = "degrees";
    private Double FIRST_STRIKE_PARAM_MIN = 0.0;
    private Double FIRST_STRIKE_PARAM_MAX = 90.0;
    private Double FIRST_STRIKE_PARAM_DEFAULT = 0.0;

    public PointToLineSourceERF() {
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.addParameterChangeListener(this);
        this.locParam = new LocationParameter(LOC_PARAM_NAME);
        this.locParam.setInfo(LOC_PARAM_INFO);
        ArrayList<String> supportedMagDists = new ArrayList<String>();
        supportedMagDists.add(GaussianMagFreqDist.NAME);
        supportedMagDists.add(SingleMagFreqDist.NAME);
        supportedMagDists.add(GutenbergRichterMagFreqDist.NAME);
        supportedMagDists.add(YC_1985_CharMagFreqDist.NAME);
        supportedMagDists.add(SummedMagFreqDist.NAME);
        supportedMagDists.add(ArbIncrementalMagFreqDist.NAME);
        this.magDistParam = new MagFreqDistParameter(MAG_DIST_PARAM_NAME, supportedMagDists);
        GaussianMagFreqDist mfd = new GaussianMagFreqDist(5.0, 8.0, 31, 6.5, 0.12, 1.0E19);
        this.magDistParam.setValue(mfd);
        this.rakeParam = new DoubleParameter(RAKE_PARAM_NAME, this.RAKE_PARAM_MIN, this.RAKE_PARAM_MAX, "degrees", this.RAKE_PARAM_DEFAULT);
        this.rakeParam.setInfo(RAKE_PARAM_INFO);
        this.strikeParam = new DoubleParameter(STRIKE_PARAM_NAME, this.STRIKE_PARAM_MIN, this.STRIKE_PARAM_MAX, "degrees", this.STRIKE_PARAM_DEFAULT);
        this.strikeParam.setInfo(STRIKE_PARAM_INFO);
        this.strikeParam.getConstraint().setNullAllowed(true);
        this.dipParam = new DoubleParameter(DIP_PARAM_NAME, this.DIP_PARAM_MIN, this.DIP_PARAM_MAX, "degrees", this.DIP_PARAM_DEFAULT);
        this.dipParam.setInfo(DIP_PARAM_INFO);
        this.magScalingRelOptions = new ArrayList();
        this.magScalingRelOptions.add("Wells & Coppersmith (1994)");
        this.magScalingRelOptions.add("W&C 1994 Mag-Length Rel.");
        this.magScalingRelOptions.add("PEER Tests Mag-Area Rel.");
        this.magScalingRelParam = new StringParameter(MAG_SCALING_REL_PARAM_NAME, this.magScalingRelOptions, "Wells & Coppersmith (1994)");
        this.magScalingRelParam.setInfo(MAG_SCALING_REL_PARAM_INFO);
        ArbitrarilyDiscretizedFunc discretizedFunc = new ArbitrarilyDiscretizedFunc();
        discretizedFunc.set(6.0, 5.0);
        discretizedFunc.set(6.5, 5.0);
        discretizedFunc.set(6.6, 1.0);
        discretizedFunc.set(9.0, 1.0);
        this.rupTopDepthParam = new ArbitrarilyDiscretizedFuncParameter(RUP_TOP_DEPTH_FUNC_PARAM_NAME, discretizedFunc);
        this.rupTopDepthParam.setInfo(RUP_TOP_DEPTH_FUNC_PARAM_INFO);
        this.lowerSeisDepthParam = new DoubleParameter(LOWER_SEIS_DEPTH_PARAM_NAME, this.LOWER_SEIS_DEPTH_PARAM_MIN, this.LOWER_SEIS_DEPTH_PARAM_MAX, LOWER_SEIS_DEPTH_PARAM_UNITS, this.LOWER_SEIS_DEPTH_PARAM_DEFAULT);
        this.lowerSeisDepthParam.setInfo(LOWER_SEIS_DEPTH_PARAM_INFO);
        this.minMagParam = new DoubleParameter(MIN_MAG_PARAM_NAME, this.MIN_MAG_PARAM_MIN, this.MIN_MAG_PARAM_MAX, this.MIN_MAG_PARAM_DEFAULT);
        this.minMagParam.setInfo(MIN_MAG_PARAM_INFO);
        this.spokedRupturesParam = new BooleanParameter(SPOKED_RUPTURES_PARAM_NAME, false);
        this.spokedRupturesParam.setInfo(SPOKED_RUPTURES_PARAM_INFO);
        this.numStrikeParam = new IntegerParameter(NUM_STRIKE_PARAM_NAME, this.NUM_STRIKE_PARAM_MIN, this.NUM_STRIKE_PARAM_MAX, this.NUM_STRIKE_PARAM_DEFAULT);
        this.numStrikeParam.setInfo(NUM_STRIKE_PARAM_INFO);
        this.firstStrikeParam = new DoubleParameter(FIRST_STRIKE_PARAM_NAME, this.FIRST_STRIKE_PARAM_MIN, this.FIRST_STRIKE_PARAM_MAX, "degrees", this.FIRST_STRIKE_PARAM_DEFAULT);
        this.firstStrikeParam.setInfo(FIRST_STRIKE_PARAM_INFO);
        this.createParamList();
        this.spokedRupturesParam.addParameterChangeListener(this);
        this.magScalingRelParam.addParameterChangeListener(this);
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        super.parameterChange(event);
        String paramName = event.getParameterName();
        if (paramName.equals(SPOKED_RUPTURES_PARAM_NAME) || paramName.equals(MAG_SCALING_REL_PARAM_NAME)) {
            this.createParamList();
        }
        this.parameterChangeFlag = true;
    }

    private void createParamList() {
        this.adjustableParams = new ParameterList();
        this.adjustableParams.addParameter(this.locParam);
        this.adjustableParams.addParameter(this.magDistParam);
        if (!((Boolean)this.spokedRupturesParam.getValue()).booleanValue()) {
            this.adjustableParams.addParameter(this.strikeParam);
        }
        this.adjustableParams.addParameter(this.dipParam);
        this.adjustableParams.addParameter(this.rakeParam);
        this.adjustableParams.addParameter(this.magScalingRelParam);
        if (this.getmagScalingRelationship((String)this.magScalingRelParam.getValue()) instanceof MagAreaRelationship) {
            this.adjustableParams.addParameter(this.lowerSeisDepthParam);
        }
        this.adjustableParams.addParameter(this.rupTopDepthParam);
        this.adjustableParams.addParameter(this.defaultHypoDepthParam);
        this.adjustableParams.addParameter(this.minMagParam);
        this.adjustableParams.addParameter(this.spokedRupturesParam);
        if (((Boolean)this.spokedRupturesParam.getValue()).booleanValue()) {
            this.adjustableParams.addParameter(this.numStrikeParam);
            this.adjustableParams.addParameter(this.firstStrikeParam);
        }
    }

    @Override
    public void updateForecast() {
        boolean spoke;
        if (this.D) {
            System.out.println(this.adjustableParams.toString());
        }
        Double strikeValue = (spoke = ((Boolean)this.spokedRupturesParam.getValue()).booleanValue()) ? (Double)this.firstStrikeParam.getValue() : (Double)this.strikeParam.getValue();
        double strike = strikeValue == null ? Double.NaN : strikeValue;
        FocalMechanism focalMech = new FocalMechanism(strike, (Double)this.dipParam.getValue(), (Double)this.rakeParam.getValue());
        IncrementalMagFreqDist mfd = (IncrementalMagFreqDist)this.magDistParam.getValue();
        double minMag = (Double)this.minMagParam.getValue();
        if (minMag > mfd.getMinX()) {
            mfd = mfd.getAboveMagnitude(minMag);
        }
        MagScalingRelationship scale = this.getmagScalingRelationship((String)this.magScalingRelParam.getValue());
        ArbitrarilyDiscretizedFunc rupTopDepth = (ArbitrarilyDiscretizedFunc)this.rupTopDepthParam.getValue();
        int numStrikes = spoke ? (Integer)this.numStrikeParam.getValue() : 1;
        this.source = ((PointSource.PoissonBuilder)PointSource.poissonBuilder((Location)this.locParam.getValue()).duration(this.timeSpan.getDuration()).surfaceBuilder(new LineSurfaceBuilder(numStrikes, scale, rupTopDepth, (Double)this.lowerSeisDepthParam.getValue()))).forMFDAndFocalMech(mfd, focalMech).build();
    }

    private MagScalingRelationship getmagScalingRelationship(String magScName) {
        if (magScName.equals("Wells & Coppersmith (1994)")) {
            return new WC1994_MagAreaRelationship();
        }
        if (magScName.equals("W&C 1994 Mag-Length Rel.")) {
            return new WC1994_MagLengthRelationship();
        }
        return new PEER_testsMagAreaRelationship();
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        if (iSource != 0) {
            throw new RuntimeException("Only 1 source available, iSource should be equal to 0");
        }
        return this.source;
    }

    @Override
    public int getNumSources() {
        return 1;
    }

    public ArrayList getSourceList() {
        ArrayList<PointSource> v = new ArrayList<PointSource>();
        v.add(this.source);
        return v;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static void main(String[] args) {
        PointToLineSourceERF src = new PointToLineSourceERF();
        src.updateForecast();
    }

    private static class LineSurfaceBuilder
    implements PointSource.RuptureSurfaceBuilder {
        private int numStrikes;
        private MagScalingRelationship magScaling;
        private ArbitrarilyDiscretizedFunc rupTopDepth;
        private double lowerDepth;
        private Map<Float, EvenlyGriddedSurface[]> surfsCache;

        public LineSurfaceBuilder(int numStrikes, MagScalingRelationship magScaling, ArbitrarilyDiscretizedFunc rupTopDepth, double lowerDepth) {
            Preconditions.checkState((numStrikes >= 1 ? 1 : 0) != 0, (Object)"NumStrikes must be >=1");
            this.numStrikes = numStrikes;
            this.magScaling = magScaling;
            this.rupTopDepth = rupTopDepth;
            this.lowerDepth = lowerDepth;
            if (numStrikes > 1) {
                this.surfsCache = new HashMap<Float, EvenlyGriddedSurface[]>();
            }
        }

        @Override
        public int getNumSurfaces(double magnitude, FocalMechanism mech) {
            return this.numStrikes;
        }

        @Override
        public RuptureSurface getSurface(Location sourceLoc, double magnitude, FocalMechanism mech, int surfaceIndex) {
            EvenlyGriddedSurface[] cached;
            if (this.numStrikes > 1 && (cached = this.surfsCache.get(Float.valueOf((float)magnitude))) != null) {
                return cached[surfaceIndex];
            }
            double upperDepth = magnitude <= this.rupTopDepth.getMinX() ? this.rupTopDepth.getMinX() : (magnitude >= this.rupTopDepth.getMaxX() ? this.rupTopDepth.getMaxX() : this.rupTopDepth.getClosestYtoX(magnitude));
            PointSurfaceBuilder builder = new PointSurfaceBuilder(sourceLoc).magnitude(magnitude).mechanism(mech).scaling(this.magScaling).upperDepth(upperDepth).lowerDepth(this.lowerDepth);
            if (this.numStrikes == 1) {
                if (Double.isNaN(mech.getStrike())) {
                    builder.randomStrike();
                }
                return builder.buildLineSurface();
            }
            EvenlyGriddedSurface[] surfaces = builder.buildRandLineSurfaces(this.numStrikes);
            this.surfsCache.put(Float.valueOf((float)magnitude), surfaces);
            return surfaces[surfaceIndex];
        }

        @Override
        public double getSurfaceWeight(double magnitude, FocalMechanism mech, int surfaceIndex) {
            return 1.0 / (double)this.numStrikes;
        }

        @Override
        public boolean isSurfaceFinite(double magnitude, FocalMechanism mech, int surfaceIndex) {
            return true;
        }

        @Override
        public Location getHypocenter(Location sourceLoc, RuptureSurface rupSurface) {
            return null;
        }
    }
}

