/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WG02;

import org.opensha.commons.data.Site;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurfaceWithSubsets;
import org.opensha.sha.magdist.GaussianMagFreqDist;

public class WG02_CharEqkSource
extends ProbEqkSource {
    private double prob;
    private AbstractEvenlyGriddedSurfaceWithSubsets rupSurface;
    private String sourceName;
    private GaussianMagFreqDist gaussMagDist;
    private int numRupSurfaces;
    private int numMag;
    private double rupWidth;
    private double rupLength;
    private double rupOffset;
    private double rake;
    private String name = "WG02 Char Eqk Source";
    boolean D = false;
    private String C = "WG02_CharEqkSource";

    public WG02_CharEqkSource(double prob, double meanMag, double magSigma, double nSigmaTrunc, double deltaMag, AbstractEvenlyGriddedSurfaceWithSubsets rupSurface, double rupArea, double rupOffset, String sourceName, double rake) {
        this.isPoissonian = false;
        this.prob = prob;
        this.rupSurface = rupSurface;
        this.rupOffset = rupOffset;
        this.rake = rake;
        this.name = sourceName;
        if (this.D) {
            System.out.println("prob=" + prob + "; meanMag=" + meanMag + "; =magSigma" + magSigma + "; nSigmaTrunc=" + nSigmaTrunc + "; rupArea=" + rupArea + "; rupOffset=" + rupOffset + "; sourceName=" + sourceName + "; rake=" + rake);
        }
        double tempMag = (meanMag + nSigmaTrunc * magSigma - meanMag) / deltaMag;
        int tempNum = (int)Math.floor(tempMag);
        double maxMag = meanMag + (double)tempNum * deltaMag;
        double minMag = meanMag - (double)tempNum * deltaMag;
        this.numMag = 2 * tempNum + 1;
        this.gaussMagDist = new GaussianMagFreqDist(minMag, maxMag, this.numMag, meanMag, magSigma, 1.0, nSigmaTrunc, 2);
        this.gaussMagDist.scaleToCumRate(0, 1.0);
        if (this.D) {
            System.out.println(this.gaussMagDist.toString());
        }
        double faultLength = (double)(rupSurface.getNumCols() - 1) * rupSurface.getGridSpacingAlongStrike();
        double ddw = (double)(rupSurface.getNumRows() - 1) * rupSurface.getGridSpacingDownDip();
        this.rupLength = this.rupWidth = Math.sqrt(rupArea);
        if (this.rupWidth > ddw) {
            this.rupWidth = ddw;
            this.rupLength = rupArea / ddw;
        }
        this.numRupSurfaces = rupSurface.getNumSubsetSurfaces(this.rupLength, this.rupWidth, rupOffset);
        if (this.D) {
            System.out.println(this.C + "  Name: " + sourceName);
        }
        if (this.D) {
            System.out.println(this.C + " numMag, numRupSurfaces:" + this.numMag + "  " + this.numRupSurfaces);
        }
        if (this.D) {
            double totProb = 0.0;
            for (int i = 0; i < this.getNumRuptures(); ++i) {
                ProbEqkRupture rup = this.getRupture(i);
                totProb += rup.getProbability();
            }
            System.out.println("  totProb=" + (float)totProb);
        }
    }

    @Override
    public LocationList getAllSourceLocs() {
        return this.rupSurface.getEvenlyDiscritizedListOfLocsOnSurface();
    }

    @Override
    public AbstractEvenlyGriddedSurface getSourceSurface() {
        return this.rupSurface;
    }

    @Override
    public int getNumRuptures() {
        return this.numRupSurfaces * this.numMag;
    }

    @Override
    public ProbEqkRupture getRupture(int nRupture) {
        int iMag = nRupture / this.numRupSurfaces;
        int iRupSurf = nRupture - iMag * this.numRupSurfaces;
        ProbEqkRupture probEqkRupture = new ProbEqkRupture();
        probEqkRupture.setAveRake(this.rake);
        probEqkRupture.setMag(this.gaussMagDist.getX(iMag));
        double p = this.prob * this.gaussMagDist.getIncrRate(iMag) / (double)this.numRupSurfaces;
        probEqkRupture.setProbability(p);
        probEqkRupture.setRuptureSurface(this.rupSurface.getNthSubsetSurface(this.rupLength, this.rupWidth, this.rupOffset, iRupSurf));
        return probEqkRupture;
    }

    @Override
    public double getMinDistance(Site site) {
        LocationVector dir = LocationUtils.vector(site.getLocation(), (Location)this.rupSurface.get(0, 0));
        double min = dir.getHorzDistance();
        if (min > (dir = LocationUtils.vector(site.getLocation(), (Location)this.rupSurface.get(0, this.rupSurface.getNumCols() - 1))).getHorzDistance()) {
            min = dir.getHorzDistance();
        }
        if (min > (dir = LocationUtils.vector(site.getLocation(), (Location)this.rupSurface.get(0, this.rupSurface.getNumCols() / 2))).getHorzDistance()) {
            min = dir.getHorzDistance();
        }
        return min;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

