/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.ListIterator;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.Ellsworth_A_WG02_MagAreaRel;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.Ellsworth_B_WG02_MagAreaRel;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.HanksBakun2002_MagAreaRel;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.Shaw_2007_MagAreaRel;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.Somerville_2006_MagAreaRel;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WGCEP_2007_PowLaw_MagAreaRel;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.ValueWeight;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.ParameterListParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.vo.DeformationModelSummary;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.param.PointSourceDistanceCorrectionParam;
import org.opensha.sha.earthquake.rupForecastImpl.FaultRuptureSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults.A_FaultSegmentedSourceGenerator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.B_FaultFixes;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.EmpiricalModel;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UnsegmentedSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.A_FaultsFetcher;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.B_FaultsFetcher;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.EventRates;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.NonCA_FaultsFetcher;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb.DeformationModelSummaryFinal;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.griddedSeis.NSHMP_GridSourceGenerator;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrection;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrections;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.magdist.TaperedGR_MagFreqDist;

public class UCERF2
extends AbstractERF {
    private static String C = new String("EqkRateModel2_ERF");
    private boolean D = true;
    public static final String NAME = new String("WGCEP Eqk Rate Model 2 ERF");
    public static final double MIN_MAG = 5.05;
    public static final double MAX_MAG = 8.95;
    public static final double DELTA_MAG = 0.1;
    public static final int NUM_MAG = (int)Math.round(38.99999999999999) + 1;
    public static final double BACKGROUND_MAG_LOWER = 5.0;
    public static double GRID_SPACING = 1.0;
    public static final double RUP_OFFSET = 5.0;
    public static final double BACK_SEIS_DEPTH = 5.0;
    private double totMoRateReduction;
    private SummedMagFreqDist bFaultCharSummedMFD;
    private SummedMagFreqDist bFaultGR_SummedMFD;
    private SummedMagFreqDist aFaultSummedMFD;
    private SummedMagFreqDist cZoneSummedMFD;
    private SummedMagFreqDist nonCA_B_FaultsSummedMFD;
    private IncrementalMagFreqDist totBackgroundMFD;
    private ArrayList<IncrementalMagFreqDist> cZonesMFD_List;
    public static final String NON_CA_SOURCES_FILENAME = "/data/erf/ucerf2/NonCA_Faults.txt";
    private ArrayList allSources;
    public static final String BACK_SEIS_NAME = new String("Background Seismicity");
    public static final String BACK_SEIS_INCLUDE = new String("Include");
    public static final String BACK_SEIS_EXCLUDE = new String("Exclude");
    public static final String BACK_SEIS_ONLY = new String("Only Background");
    public static final String BACK_SEIS_DEFAULT = BACK_SEIS_INCLUDE;
    private ArrayList backSeisOptionsStrings = new ArrayList();
    private StringParameter backSeisParam;
    public static final String BACK_SEIS_RUP_NAME = new String("Treat Background Seismicity As");
    public static final String BACK_SEIS_RUP_POINT = new String("Point Sources");
    public static final String BACK_SEIS_RUP_FINITE = new String("One Random Strike Fault");
    public static final String BACK_SEIS_RUP_CROSSHAIR = new String("Two perpendicular faults");
    public static final String BACK_SEIS_RUP_NSHMP_2013 = new String("NSHMP 2013");
    public static final String BACK_SEIS_RUP_DEFAULT = BACK_SEIS_RUP_CROSSHAIR;
    private ArrayList backSeisRupStrings = new ArrayList();
    private StringParameter backSeisRupParam;
    protected PointSourceDistanceCorrectionParam distCorrParam;
    public static final String BACK_SEIS_MAG_NAME = "Backgroud Seis Mmax";
    public static final Double BACK_SEIS_MAG_MIN = 5.0;
    public static final Double BACK_SEIS_MAG_MAX = 9.0;
    public static final Double BACK_SEIS_MAG_DEFAULT = 7.0;
    private static final String BACK_SEIS_MAG_INFO = "Maximum Magnitude for background seismicity";
    private DoubleParameter backSeisMaxMagParam;
    public static final String RUP_OFFSET_PARAM_NAME = "Rupture Offset";
    private Double DEFAULT_RUP_OFFSET_VAL = 10.0;
    private static final String RUP_OFFSET_PARAM_UNITS = "km";
    private static final String RUP_OFFSET_PARAM_INFO = "Length of offset for floating ruptures";
    public static final double RUP_OFFSET_PARAM_MIN = 1.0;
    public static final double RUP_OFFSET_PARAM_MAX = 100.0;
    private DoubleParameter rupOffset_Param;
    public static final String FLOATER_TYPE_PARAM_NAME = "Floater Type";
    public static final String FULL_DDW_FLOATER = "Only along strike ( rupture full DDW)";
    public static final String STRIKE_AND_DOWNDIP_FLOATER = "Along strike and down dip";
    public static final String CENTERED_DOWNDIP_FLOATER = "Along strike & centered down dip";
    public static final String FLOATER_TYPE_PARAM_DEFAULT = "Along strike & centered down dip";
    private StringParameter floaterTypeParam;
    public static final String TOT_MAG_RATE_PARAM_NAME = "Total M\u22655 Rate";
    public static final Double TOT_MAG_RATE_MIN = 2.0;
    public static final Double TOT_MAG_RATE_MAX = 20.0;
    public static final Double TOT_MAG_RATE_DEFAULT = 3.6;
    private static final String TOT_MAG_RATE_INFO = "Total rate of M\u22655 events in the RELM test region (e.g, 3.60 for no aftershocks, or 7.84 including aftershocks)";
    private DoubleParameter totalMagRateParam;
    public static final String AFTERSHOCK_FRACTION_PARAM_NAME = "Fraction Smaller Events & Aftershocks";
    public static final Double AFTERSHOCK_FRACTION_MIN = 0.0;
    public static final Double AFTERSHOCK_FRACTION_MAX = 1.0;
    public static final Double AFTERSHOCK_FRACTION_DEFAULT = 0.1;
    private static final String AFTERSHOCK_FRACTION_INFO = "Fraction of moment rate released in foreshocks and aftershocks";
    private DoubleParameter aftershockFractionParam;
    public static final String COUPLING_COEFF_PARAM_NAME = "Coupling Coefficient";
    public static final Double COUPLING_COEFF_MIN = 0.0;
    public static final Double COUPLING_COEFF_MAX = 1.0;
    public static final Double COUPLING_COEFF_DEFAULT = 1.0;
    private static final String COUPLING_COEFF_INFO = "Fraction of moment rate on A & B faults released via seismogenic processes (e.g., excluding afterslip)";
    private DoubleParameter couplingCoeffParam;
    public static final String MAG_AREA_RELS_PARAM_NAME = "Mag-Area Relationship";
    private static final String MAG_AREA_RELS_PARAM_INFO = "Mag-Area Relationship for computing mean mag from area or vice versa";
    private StringParameter magAreaRelParam;
    private ArrayList magAreaRelationships;
    public static final String DEFORMATION_MODEL_PARAM_NAME = "Deformation Model";
    private static final String DEFORMATION_MODEL_PARAM_INFO = "D2.1 to D2.3 use Fault Model 2.1, and D2.4 to D2.6 use Fault Model 2.2";
    private StringParameter deformationModelsParam;
    private DeformationModelSummaryFinal deformationModelSummaryFinal = new DeformationModelSummaryFinal();
    private ArrayList<DeformationModelSummary> deformationModelSummariesList;
    public static final String ASEIS_INTER_PARAM_NAME = "Aseis Factor Reduces Area?";
    private static final String ASEIS_INTER_PARAM_INFO = "Otherwise it reduces slip rate";
    private BooleanParameter aseisFactorInterParam;
    public static final String REL_A_PRIORI_WT_PARAM_NAME = "Wt On A-Priori Rates";
    private static final Double REL_A_PRIORI_WT_PARAM_MIN = 0.0;
    private static final Double REL_A_PRIORI_WT_PARAM_MAX = Double.MAX_VALUE;
    private static final Double REL_A_PRIORI_WT_PARAM_DEFAULT = 1.0E-4;
    private static final String REL_A_PRIORI_WT_PARAM_INFO = "Applied as rate/uncert (this is important to understand!)";
    private DoubleParameter relativeA_PrioriWeightParam;
    public static final String REL_SEG_RATE_WT_PARAM_NAME = "Relative Wt On Segment Rates";
    private static final Double REL_SEG_RATE_WT_PARAM_MIN = 0.0;
    private static final Double REL_SEG_RATE_WT_PARAM_MAX = Double.MAX_VALUE;
    public static final Double REL_SEG_RATE_WT_PARAM_DEFAULT = 0.0;
    private static final String REL_SEG_RATE_WT_PARAM_INFO = "Relative to that put on the sement slip rates";
    private DoubleParameter relativeSegRateWeightParam;
    public static final String CONNECT_B_FAULTS_PARAM_NAME = "Connect More B Faults?";
    private static final String CONNECT_B_FAULTS_PARAM_INFO = "Connect nearby B-Faults";
    private BooleanParameter connectMoreB_FaultsParam;
    public static final String RUP_MODEL_TYPE_NAME = "A-Fault Solution Type";
    public static final String RUP_MODEL_TYPE_INFO = "The type of solution to apply for all A-Fault Sources";
    public static final String UNSEGMENTED_A_FAULT_MODEL = "Unsegmented Model";
    public static final String SEGMENTED_A_FAULT_MODEL = "Segmented Model";
    private StringParameter rupModelParam;
    public static final String SEGMENTED_RUP_MODEL_TYPE_NAME = "Segmented A-Fault Solution Types";
    public static final String SEGMENTED_RUP_MODEL_TYPE_INFO = "To set the a-prior solution for each type-A Fault Source";
    private ParameterListParameter segmentedRupModelParam;
    public static final String MIN_A_FAULT_RATE_1_PARAM_NAME = "Min Fraction for Unknown Ruptures";
    private static final Double MIN_A_FAULT_RATE_MIN = 0.0;
    private static final Double MIN_A_FAULT_RATE_MAX = 1.0;
    public static final Double MIN_A_FAULT_RATE_1_DEFAULT = 0.5;
    private static final String MIN_A_FAULT_RATE_1_INFO = "The min rate for unknown ruptures, defined as fraction of min non-zero a-priori rate";
    private DoubleParameter minA_FaultRate1Param;
    public static final String MIN_A_FAULT_RATE_2_PARAM_NAME = "Min Fraction for Unlikely Ruptures";
    public static final Double MIN_A_FAULT_RATE_2_DEFAULT = 0.1;
    private static final String MIN_A_FAULT_RATE_2_INFO = "The min rate for unlikely ruptures, defined as fraction of min non-zero a-priori rate";
    private DoubleParameter minA_FaultRate2Param;
    public static final String WEIGHTED_INVERSION_PARAM_NAME = "Weighted Inversion?";
    private static final String WEIGHTED_INVERSION_PARAM_INFO = "Use segment rate and slip rate uncertainties to weight the inversion";
    private BooleanParameter weightedInversionParam;
    public static final String SLIP_MODEL_TYPE_NAME = "A-Fault Slip Model";
    public static final String SLIP_MODEL_TYPE_INFO = "Type of slip on a segment for each rupture on all A-Fault Sources";
    private StringParameter slipModelParam;
    public static final String CHAR_VS_GR_PARAM_NAME = "% Char vs GR";
    private static final Double CHAR_VS_GR_MIN = 0.0;
    private static final Double CHAR_VS_GR_MAX = 100.0;
    private static final Double CHAR_VS_GR_DEFAULT = 67.0;
    private static final String CHAR_VS_GR_INFO = "The % moment rate put into characteristic (vs GR) events on B-Faults (and A-Faults for un-segmented option)";
    private DoubleParameter percentCharVsGRParam;
    public static final String MAG_SIGMA_PARAM_NAME = "Mag Sigma";
    private static final Double MAG_SIGMA_MIN = 0.0;
    private static final Double MAG_SIGMA_MAX = 1.0;
    public static final Double MAG_SIGMA_DEFAULT = 0.12;
    private static final String MAG_SIGMA_INFO = "Standard Deviation for characteristic MFD";
    private DoubleParameter magSigmaParam;
    public static final String TRUNC_LEVEL_PARAM_NAME = "Truncation Level";
    private static final String TRUNC_LEVEL_PARAM_UNITS = "Number of sigmas";
    private static final Double TRUNC_LEVEL_MIN = 0.0;
    private static final Double TRUNC_LEVEL_MAX = 6.0;
    public static final Double TRUNC_LEVEL_DEFAULT = 2.0;
    private static final String TRUNC_LEVEL_INFO = "This defines the last non-zero value on the characteristic MFD";
    private DoubleParameter truncLevelParam;
    public static final String B_FAULTS_B_VAL_PARAM_NAME = "B-Faults b-value";
    public static final String B_FAULTS_B_VAL_PARAM_INFO = "GR-distribution b-value to apply to B-Faults";
    public static final Double B_FAULT_GR_B_DEFAULT = 0.8;
    public static final Double B_VAL_MIN = -1.0;
    public static final Double B_VAL_MAX = 2.0;
    private DoubleParameter bFaultB_ValParam;
    public static final String A_FAULTS_B_VAL_PARAM_NAME = "A-Faults b-value";
    public static final String A_FAULTS_B_VAL_PARAM_INFO = "GR-distribution b-value to apply to A-Faults";
    public static final Double A_FAULT_GR_B_DEFAULT = 0.0;
    public static final Double A_VAL_MIN = -1.0;
    public static final Double A_VAL_MAX = 2.0;
    private DoubleParameter aFaultB_ValParam;
    public static final String BACK_SEIS_B_VAL_PARAM_NAME = "Background Seis b-value";
    public static final String BACK_SEIS_B_VAL_PARAM_INFO = "GR-distribution b-value to apply to the background seismicity";
    public static final Double BACK_SEIS_B_DEFAULT = 0.9;
    private DoubleParameter regionB_ValParam;
    public static final String B_FAULTS_MIN_MAG = "B-Faults Min Mag";
    private static final Double B_FAULTS_MIN_MAG_DEFAULT = 6.5;
    private static final String B_FAULTS_MIN_MAG_INFO = "Min Mag to apply to B-Faults GR-distribution";
    private DoubleParameter bFaultsMinMagParam;
    public static final String C_ZONE_WT_PARAM_NAME = "C-Zone Weight";
    private static final Double C_ZONE_WT_DEFAULT = 0.5;
    private static final String C_ZONE_WT_INFO = "Weight to apply to type C-zones";
    private DoubleParameter c_ZoneWtParam;
    public static final String ABC_MO_RATE_REDUCTION_PARAM_NAME = "Fract MoRate to Background";
    public static final Double ABC_MO_RATE_REDUCTION_MIN = 0.0;
    public static final Double ABC_MO_RATE_REDUCTION_MAX = 1.0;
    public static final Double ABC_MO_RATE_REDUCTION_DEFAULT = 0.0;
    public static final String ABC_MO_RATE_REDUCTION_INFO = "Fraction of Moment Rate to take from A & B Faults & C zones to put into background seismicity";
    private DoubleParameter moRateFracToBackgroundParam;
    public static final String MEAN_MAG_CORRECTION = "Mean Mag Correction";
    private static final Double MEAN_MAG_CORRECTION_MIN = -0.5;
    private static final Double MEAN_MAG_CORRECTION_MAX = 0.5;
    public static final Double MEAN_MAG_CORRECTION_DEFAULT = 0.0;
    private static final String MEAN_MAG_CORRECTION_INFO = "Increment added to mean mag as additional epistemic uncertainity";
    private DoubleParameter meanMagCorrectionParam;
    public static final String SET_FOR_BCK_PARAM_NAME = "MFD for Background";
    private static final String SET_FOR_BCK_PARAM_FRAC_MO_RATE_TR_GR = "Trunc. GR (Mmax from fraction)";
    private static final String SET_FOR_BCK_PARAM_FRAC_MO_RATE_TA_GR = "Tapered GR (Mcorner from fraction)";
    private static final String SET_FOR_BCK_PARAM_BCK_MAX_MAG = "Trunc. GR (w/ set Mmax)";
    private static final String SET_FOR_BCK_PARAM_NSHMP07 = "NSHMP07 MFD";
    private static final String SET_FOR_BCK_PARAM_INFO = "This specifies the type of magnitude-frequency dist. to use for the background";
    private StringParameter setForBckParam;
    public static final String PROB_MODEL_PARAM_NAME = "Probability Model";
    public static final String PROB_MODEL_PARAM_INFO = "Probability Model for Time Dependence";
    public static final String PROB_MODEL_POISSON = "Poisson";
    public static final String PROB_MODEL_BPT = "BPT";
    public static final String PROB_MODEL_EMPIRICAL = "Empirical";
    public static final String PROB_MODEL_DEFAULT = "BPT";
    private StringParameter probModelParam;
    public static final String APERIODICITY_PARAM_NAME = "Aperiodicity";
    private static final String APERIODICITY_PARAM_INFO = "Aperiodicity for Time dependence";
    private static final Double APERIODICITY_PARAM_MIN = 0.1;
    private static final Double APERIODICITY_PARAM_MAX = 2.0;
    private static final Double APERIODICITY_PARAM_DEFAULT = 0.5;
    private DoubleParameter aperiodicityParam;
    public static final String DEF_APERIODICITY_PARAM_NAME = "Default Aperiodicity";
    private static final String DEF_APERIODICITY_PARAM_INFO = "Default Aperiodicity for Time dependence";
    private static final Double DEF_APERIODICITY_PARAM_MIN = 0.1;
    private static final Double DEF_APERIODICITY_PARAM_MAX = 2.0;
    private static final Double DEF_APERIODICITY_PARAM_DEFAULT = 0.5;
    private DoubleParameter defaultAperiodicityParam;
    public static final String SEG_DEP_APERIODICITY_PARAM_NAME = "Seg Dependent Aperiodicity";
    private static final String SEG_DEP_APERIODICITY_PARAM_INFO = "Segment Aperiodicity for Time dependence";
    private static final Boolean SEG_DEP_APERIODICITY_PARAM_DEFAULT = false;
    private BooleanParameter segDepAperiodicityParam;
    private static final double DURATION_DEFAULT = 30.0;
    private static final double DURATION_MIN = 1.0;
    private static final double DURATION_MAX = 100.0;
    public static final int START_TIME_DEFAULT = 2007;
    private static final int START_TIME_MIN = 2007;
    private static final int START_TIME_MAX = 2107;
    private double[] totalRelativeGriddedRates;
    private CaliforniaRegions.RELM_GRIDDED region = new CaliforniaRegions.RELM_GRIDDED();
    private A_FaultsFetcher aFaultsFetcher = new A_FaultsFetcher();
    private B_FaultsFetcher bFaultsFetcher = new B_FaultsFetcher();
    private EmpiricalModel empiricalModel = new EmpiricalModel();
    private ArrayList aFaultSourceGenerators;
    private ArrayList<UnsegmentedSource> bFaultSources;
    private ArrayList<ProbEqkSource> nonCA_bFaultSources;
    private B_FaultFixes bFaultFixes = new B_FaultFixes();
    private NSHMP_GridSourceGenerator nshmp_gridSrcGen;
    private boolean reCalcB_Faults = true;
    private boolean reCalcBck = true;
    private boolean reCalcA_Faults = true;
    private boolean reCalcC_Zones = true;
    private boolean updateA_FaultsFetcher = true;
    private boolean updateB_FaultsFetcher = true;
    private boolean reCalcNonCA_B_Fauts = true;

    public UCERF2() {
        this.initAdjParams();
        this.setParamDefaults();
        this.createParamList();
        this.setTimespanParameter();
        this.nshmp_gridSrcGen = new NSHMP_GridSourceGenerator((WeightedList<PointSourceDistanceCorrection>)((PointSourceDistanceCorrections)this.distCorrParam.getValue()).get());
        this.rupOffset_Param.addParameterChangeListener(this);
        this.backSeisParam.addParameterChangeListener(this);
        this.backSeisRupParam.addParameterChangeListener(this);
        this.distCorrParam.addParameterChangeListener(this);
        this.deformationModelsParam.addParameterChangeListener(this);
        this.rupModelParam.addParameterChangeListener(this);
        this.connectMoreB_FaultsParam.addParameterChangeListener(this);
        this.probModelParam.addParameterChangeListener(this);
        this.segDepAperiodicityParam.addParameterChangeListener(this);
        this.updateFetchersBasedonDefModels();
    }

    public A_FaultsFetcher getA_FaultsFetcher() {
        return this.aFaultsFetcher;
    }

    private void initAdjParams() {
        this.backSeisOptionsStrings.add(BACK_SEIS_EXCLUDE);
        this.backSeisOptionsStrings.add(BACK_SEIS_INCLUDE);
        this.backSeisOptionsStrings.add(BACK_SEIS_ONLY);
        this.backSeisParam = new StringParameter(BACK_SEIS_NAME, this.backSeisOptionsStrings, BACK_SEIS_DEFAULT);
        this.backSeisRupStrings.add(BACK_SEIS_RUP_POINT);
        this.backSeisRupStrings.add(BACK_SEIS_RUP_FINITE);
        this.backSeisRupStrings.add(BACK_SEIS_RUP_CROSSHAIR);
        this.backSeisRupParam = new StringParameter(BACK_SEIS_RUP_NAME, this.backSeisRupStrings, BACK_SEIS_RUP_DEFAULT);
        this.distCorrParam = new PointSourceDistanceCorrectionParam(PointSourceDistanceCorrections.NSHM_2008);
        this.backSeisMaxMagParam = new DoubleParameter(BACK_SEIS_MAG_NAME, BACK_SEIS_MAG_MIN, BACK_SEIS_MAG_MAX, BACK_SEIS_MAG_DEFAULT);
        this.backSeisMaxMagParam.setInfo(BACK_SEIS_MAG_INFO);
        this.rupOffset_Param = new DoubleParameter(RUP_OFFSET_PARAM_NAME, 1.0, 100.0, RUP_OFFSET_PARAM_UNITS, this.DEFAULT_RUP_OFFSET_VAL);
        this.rupOffset_Param.setInfo(RUP_OFFSET_PARAM_INFO);
        this.totalMagRateParam = new DoubleParameter(TOT_MAG_RATE_PARAM_NAME, TOT_MAG_RATE_MIN, TOT_MAG_RATE_MAX, TOT_MAG_RATE_DEFAULT);
        this.totalMagRateParam.setInfo(TOT_MAG_RATE_INFO);
        this.aftershockFractionParam = new DoubleParameter(AFTERSHOCK_FRACTION_PARAM_NAME, AFTERSHOCK_FRACTION_MIN, AFTERSHOCK_FRACTION_MAX, AFTERSHOCK_FRACTION_DEFAULT);
        this.aftershockFractionParam.setInfo(AFTERSHOCK_FRACTION_INFO);
        this.couplingCoeffParam = new DoubleParameter(COUPLING_COEFF_PARAM_NAME, COUPLING_COEFF_MIN, COUPLING_COEFF_MAX, COUPLING_COEFF_DEFAULT);
        this.couplingCoeffParam.setInfo(COUPLING_COEFF_INFO);
        this.percentCharVsGRParam = new DoubleParameter(CHAR_VS_GR_PARAM_NAME, CHAR_VS_GR_MIN, CHAR_VS_GR_MAX, CHAR_VS_GR_DEFAULT);
        this.percentCharVsGRParam.setInfo(CHAR_VS_GR_INFO);
        this.aseisFactorInterParam = new BooleanParameter(ASEIS_INTER_PARAM_NAME, true);
        this.aseisFactorInterParam.setInfo(ASEIS_INTER_PARAM_INFO);
        this.relativeA_PrioriWeightParam = new DoubleParameter(REL_A_PRIORI_WT_PARAM_NAME, REL_A_PRIORI_WT_PARAM_MIN, REL_A_PRIORI_WT_PARAM_MAX, REL_A_PRIORI_WT_PARAM_DEFAULT);
        this.relativeA_PrioriWeightParam.setInfo(REL_A_PRIORI_WT_PARAM_INFO);
        this.relativeSegRateWeightParam = new DoubleParameter(REL_SEG_RATE_WT_PARAM_NAME, REL_SEG_RATE_WT_PARAM_MIN, REL_SEG_RATE_WT_PARAM_MAX, REL_SEG_RATE_WT_PARAM_DEFAULT);
        this.relativeSegRateWeightParam.setInfo(REL_SEG_RATE_WT_PARAM_INFO);
        this.minA_FaultRate1Param = new DoubleParameter(MIN_A_FAULT_RATE_1_PARAM_NAME, MIN_A_FAULT_RATE_MIN, MIN_A_FAULT_RATE_MAX, MIN_A_FAULT_RATE_1_DEFAULT);
        this.minA_FaultRate1Param.setInfo(MIN_A_FAULT_RATE_1_INFO);
        this.minA_FaultRate2Param = new DoubleParameter(MIN_A_FAULT_RATE_2_PARAM_NAME, MIN_A_FAULT_RATE_MIN, MIN_A_FAULT_RATE_MAX, MIN_A_FAULT_RATE_2_DEFAULT);
        this.minA_FaultRate2Param.setInfo(MIN_A_FAULT_RATE_2_INFO);
        this.weightedInversionParam = new BooleanParameter(WEIGHTED_INVERSION_PARAM_NAME, true);
        this.weightedInversionParam.setInfo(WEIGHTED_INVERSION_PARAM_INFO);
        this.connectMoreB_FaultsParam = new BooleanParameter(CONNECT_B_FAULTS_PARAM_NAME, true);
        this.connectMoreB_FaultsParam.setInfo(CONNECT_B_FAULTS_PARAM_INFO);
        this.magAreaRelationships = new ArrayList();
        this.magAreaRelationships.add(new Ellsworth_A_WG02_MagAreaRel());
        this.magAreaRelationships.add(new Ellsworth_B_WG02_MagAreaRel());
        this.magAreaRelationships.add(new HanksBakun2002_MagAreaRel());
        this.magAreaRelationships.add(new Somerville_2006_MagAreaRel());
        this.magAreaRelationships.add(new WGCEP_2007_PowLaw_MagAreaRel());
        this.magAreaRelationships.add(new Shaw_2007_MagAreaRel());
        ArrayList<String> magAreaNamesList = new ArrayList<String>();
        for (int i = 0; i < this.magAreaRelationships.size(); ++i) {
            magAreaNamesList.add(((MagAreaRelationship)this.magAreaRelationships.get(i)).getName());
        }
        this.magAreaRelParam = new StringParameter(MAG_AREA_RELS_PARAM_NAME, magAreaNamesList, (String)magAreaNamesList.get(1));
        this.magAreaRelParam.setInfo(MAG_AREA_RELS_PARAM_INFO);
        this.deformationModelSummariesList = this.deformationModelSummaryFinal.getAllDeformationModels();
        ArrayList<String> deformationModelNames = new ArrayList<String>();
        for (int i = 0; i < this.deformationModelSummariesList.size(); ++i) {
            deformationModelNames.add(this.deformationModelSummariesList.get(i).getDeformationModelName());
        }
        this.deformationModelsParam = new StringParameter(DEFORMATION_MODEL_PARAM_NAME, deformationModelNames, (String)deformationModelNames.get(0));
        this.deformationModelsParam.setInfo(DEFORMATION_MODEL_PARAM_INFO);
        ArrayList<String> rupModels = new ArrayList<String>();
        rupModels.add(SEGMENTED_A_FAULT_MODEL);
        rupModels.add(UNSEGMENTED_A_FAULT_MODEL);
        this.rupModelParam = new StringParameter(RUP_MODEL_TYPE_NAME, rupModels, (String)rupModels.get(0));
        this.rupModelParam.setInfo(RUP_MODEL_TYPE_INFO);
        this.makeSegmentedA_FaultParam();
        this.slipModelParam = new StringParameter(SLIP_MODEL_TYPE_NAME, A_FaultSegmentedSourceGenerator.getSupportedSlipModels(), "Tapered Ends ([Sin(x)]^0.5)");
        this.slipModelParam.setInfo(SLIP_MODEL_TYPE_INFO);
        this.magSigmaParam = new DoubleParameter(MAG_SIGMA_PARAM_NAME, MAG_SIGMA_MIN, MAG_SIGMA_MAX, MAG_SIGMA_DEFAULT);
        this.magSigmaParam.setInfo(MAG_SIGMA_INFO);
        this.truncLevelParam = new DoubleParameter(TRUNC_LEVEL_PARAM_NAME, TRUNC_LEVEL_MIN, TRUNC_LEVEL_MAX, TRUNC_LEVEL_PARAM_UNITS, TRUNC_LEVEL_DEFAULT);
        this.truncLevelParam.setInfo(TRUNC_LEVEL_INFO);
        this.bFaultB_ValParam = new DoubleParameter(B_FAULTS_B_VAL_PARAM_NAME, B_VAL_MIN, B_VAL_MAX, B_FAULT_GR_B_DEFAULT);
        this.bFaultB_ValParam.setInfo(B_FAULTS_B_VAL_PARAM_INFO);
        this.regionB_ValParam = new DoubleParameter(BACK_SEIS_B_VAL_PARAM_NAME, B_VAL_MIN, B_VAL_MAX, BACK_SEIS_B_DEFAULT);
        this.regionB_ValParam.setInfo(BACK_SEIS_B_VAL_PARAM_INFO);
        this.aFaultB_ValParam = new DoubleParameter(A_FAULTS_B_VAL_PARAM_NAME, A_VAL_MIN, A_VAL_MAX, A_FAULT_GR_B_DEFAULT);
        this.aFaultB_ValParam.setInfo(A_FAULTS_B_VAL_PARAM_INFO);
        this.moRateFracToBackgroundParam = new DoubleParameter(ABC_MO_RATE_REDUCTION_PARAM_NAME, ABC_MO_RATE_REDUCTION_MIN, ABC_MO_RATE_REDUCTION_MAX, ABC_MO_RATE_REDUCTION_DEFAULT);
        this.moRateFracToBackgroundParam.setInfo(ABC_MO_RATE_REDUCTION_INFO);
        this.meanMagCorrectionParam = new DoubleParameter(MEAN_MAG_CORRECTION, MEAN_MAG_CORRECTION_MIN, MEAN_MAG_CORRECTION_MAX, MEAN_MAG_CORRECTION_DEFAULT);
        this.meanMagCorrectionParam.setInfo(MEAN_MAG_CORRECTION_INFO);
        this.bFaultsMinMagParam = new DoubleParameter(B_FAULTS_MIN_MAG, 5.0, 8.0, B_FAULTS_MIN_MAG_DEFAULT);
        this.bFaultsMinMagParam.setInfo(B_FAULTS_MIN_MAG_INFO);
        this.c_ZoneWtParam = new DoubleParameter(C_ZONE_WT_PARAM_NAME, 0.0, 1.0, C_ZONE_WT_DEFAULT);
        this.c_ZoneWtParam.setInfo(C_ZONE_WT_INFO);
        ArrayList<String> options = new ArrayList<String>();
        options.add(SET_FOR_BCK_PARAM_FRAC_MO_RATE_TR_GR);
        options.add(SET_FOR_BCK_PARAM_FRAC_MO_RATE_TA_GR);
        options.add(SET_FOR_BCK_PARAM_BCK_MAX_MAG);
        options.add(SET_FOR_BCK_PARAM_NSHMP07);
        this.setForBckParam = new StringParameter(SET_FOR_BCK_PARAM_NAME, options, SET_FOR_BCK_PARAM_NSHMP07);
        this.setForBckParam.setInfo(SET_FOR_BCK_PARAM_INFO);
        this.setForBckParam.addParameterChangeListener(this);
        ArrayList<String> probModelOptions = new ArrayList<String>();
        probModelOptions.add(PROB_MODEL_POISSON);
        probModelOptions.add("BPT");
        probModelOptions.add(PROB_MODEL_EMPIRICAL);
        this.probModelParam = new StringParameter(PROB_MODEL_PARAM_NAME, probModelOptions, "BPT");
        this.probModelParam.setInfo(PROB_MODEL_PARAM_INFO);
        this.aperiodicityParam = new DoubleParameter(APERIODICITY_PARAM_NAME, APERIODICITY_PARAM_MIN, APERIODICITY_PARAM_MAX, APERIODICITY_PARAM_DEFAULT);
        this.aperiodicityParam.setInfo(APERIODICITY_PARAM_INFO);
        this.defaultAperiodicityParam = new DoubleParameter(DEF_APERIODICITY_PARAM_NAME, DEF_APERIODICITY_PARAM_MIN, DEF_APERIODICITY_PARAM_MAX, DEF_APERIODICITY_PARAM_DEFAULT);
        this.defaultAperiodicityParam.setInfo(DEF_APERIODICITY_PARAM_INFO);
        this.segDepAperiodicityParam = new BooleanParameter(SEG_DEP_APERIODICITY_PARAM_NAME, SEG_DEP_APERIODICITY_PARAM_DEFAULT);
        this.segDepAperiodicityParam.setInfo(SEG_DEP_APERIODICITY_PARAM_INFO);
        ArrayList<String> floaterTypes = new ArrayList<String>();
        floaterTypes.add(FULL_DDW_FLOATER);
        floaterTypes.add(STRIKE_AND_DOWNDIP_FLOATER);
        floaterTypes.add("Along strike & centered down dip");
        this.floaterTypeParam = new StringParameter(FLOATER_TYPE_PARAM_NAME, floaterTypes, "Along strike & centered down dip");
    }

    public void setParamDefaults() {
        this.backSeisParam.setValue(BACK_SEIS_DEFAULT);
        this.backSeisRupParam.setValue(BACK_SEIS_RUP_DEFAULT);
        this.distCorrParam.setValue(PointSourceDistanceCorrections.NSHM_2008);
        this.backSeisMaxMagParam.setValue(BACK_SEIS_MAG_DEFAULT);
        this.rupOffset_Param.setValue(this.DEFAULT_RUP_OFFSET_VAL);
        this.totalMagRateParam.setValue(TOT_MAG_RATE_DEFAULT);
        this.aftershockFractionParam.setValue(AFTERSHOCK_FRACTION_DEFAULT);
        this.couplingCoeffParam.setValue(COUPLING_COEFF_DEFAULT);
        this.percentCharVsGRParam.setValue(CHAR_VS_GR_DEFAULT);
        this.aseisFactorInterParam.setValue(true);
        this.relativeA_PrioriWeightParam.setValue(REL_A_PRIORI_WT_PARAM_DEFAULT);
        this.relativeSegRateWeightParam.setValue(REL_SEG_RATE_WT_PARAM_DEFAULT);
        this.minA_FaultRate1Param.setValue(MIN_A_FAULT_RATE_1_DEFAULT);
        this.minA_FaultRate2Param.setValue(MIN_A_FAULT_RATE_2_DEFAULT);
        this.weightedInversionParam.setValue(true);
        this.connectMoreB_FaultsParam.setValue(true);
        this.connectMoreB_FaultsParam.setInfo(CONNECT_B_FAULTS_PARAM_INFO);
        this.magAreaRelParam.setValue("Ellsworth-B (WGCEP, 2002, Eq 4.5b)");
        this.deformationModelsParam.setValue(this.deformationModelSummariesList.get(0).getDeformationModelName());
        this.rupModelParam.setValue(SEGMENTED_A_FAULT_MODEL);
        ListIterator it = this.segmentedRupModelParam.getParametersIterator();
        while (it.hasNext()) {
            StringParameter param = (StringParameter)it.next();
            ArrayList<String> allowedVals = param.getAllowedStrings();
            param.setValue(allowedVals.get(0));
        }
        this.slipModelParam.setValue("Tapered Ends ([Sin(x)]^0.5)");
        this.magSigmaParam.setValue(MAG_SIGMA_DEFAULT);
        this.truncLevelParam.setValue(TRUNC_LEVEL_DEFAULT);
        this.bFaultB_ValParam.setValue(B_FAULT_GR_B_DEFAULT);
        this.aFaultB_ValParam.setValue(A_FAULT_GR_B_DEFAULT);
        this.regionB_ValParam.setValue(BACK_SEIS_B_DEFAULT);
        this.moRateFracToBackgroundParam.setValue(ABC_MO_RATE_REDUCTION_DEFAULT);
        this.meanMagCorrectionParam.setValue(MEAN_MAG_CORRECTION_DEFAULT);
        this.bFaultsMinMagParam.setValue(B_FAULTS_MIN_MAG_DEFAULT);
        this.c_ZoneWtParam.setValue(C_ZONE_WT_DEFAULT);
        this.setForBckParam.setValue(SET_FOR_BCK_PARAM_NSHMP07);
        this.probModelParam.setValue("BPT");
        this.aperiodicityParam.setValue(APERIODICITY_PARAM_DEFAULT);
        this.defaultAperiodicityParam.setValue(DEF_APERIODICITY_PARAM_DEFAULT);
        this.segDepAperiodicityParam.setValue(SEG_DEP_APERIODICITY_PARAM_DEFAULT);
        this.floaterTypeParam.setValue("Along strike & centered down dip");
    }

    public boolean areAfterShocksIncluded() {
        String setForBackground = (String)this.setForBckParam.getValue();
        if (setForBackground.equalsIgnoreCase(SET_FOR_BCK_PARAM_NSHMP07)) {
            return false;
        }
        double rate = (Double)this.getParameter(TOT_MAG_RATE_PARAM_NAME).getValue();
        boolean includeAfterShocks = rate > 5.85;
        return includeAfterShocks;
    }

    private void createParamList() {
        this.adjustableParams = new ParameterList();
        this.adjustableParams.addParameter(this.deformationModelsParam);
        this.adjustableParams.addParameter(this.moRateFracToBackgroundParam);
        this.adjustableParams.addParameter(this.couplingCoeffParam);
        this.adjustableParams.addParameter(this.aftershockFractionParam);
        this.adjustableParams.addParameter(this.rupModelParam);
        String rupModel = (String)this.rupModelParam.getValue();
        if (rupModel.equalsIgnoreCase(SEGMENTED_A_FAULT_MODEL)) {
            this.adjustableParams.addParameter(this.segmentedRupModelParam);
            this.adjustableParams.addParameter(this.slipModelParam);
            this.adjustableParams.addParameter(this.relativeA_PrioriWeightParam);
            this.adjustableParams.addParameter(this.relativeSegRateWeightParam);
            this.adjustableParams.addParameter(this.weightedInversionParam);
            this.adjustableParams.addParameter(this.minA_FaultRate1Param);
            this.adjustableParams.addParameter(this.minA_FaultRate2Param);
        }
        if (rupModel.equalsIgnoreCase(UNSEGMENTED_A_FAULT_MODEL)) {
            this.adjustableParams.addParameter(this.aFaultB_ValParam);
        }
        this.adjustableParams.addParameter(this.magAreaRelParam);
        this.adjustableParams.addParameter(this.magSigmaParam);
        this.adjustableParams.addParameter(this.truncLevelParam);
        this.adjustableParams.addParameter(this.meanMagCorrectionParam);
        this.adjustableParams.addParameter(this.percentCharVsGRParam);
        this.adjustableParams.addParameter(this.floaterTypeParam);
        this.adjustableParams.addParameter(this.bFaultB_ValParam);
        this.adjustableParams.addParameter(this.bFaultsMinMagParam);
        this.adjustableParams.addParameter(this.connectMoreB_FaultsParam);
        this.adjustableParams.addParameter(this.backSeisParam);
        if (!((String)this.backSeisParam.getValue()).equals(BACK_SEIS_EXCLUDE)) {
            this.adjustableParams.addParameter(this.backSeisRupParam);
            this.adjustableParams.addParameter(this.distCorrParam);
        }
        this.adjustableParams.addParameter(this.c_ZoneWtParam);
        this.adjustableParams.addParameter(this.setForBckParam);
        String setForBackground = (String)this.setForBckParam.getValue();
        if (setForBackground.equalsIgnoreCase(SET_FOR_BCK_PARAM_FRAC_MO_RATE_TR_GR) || setForBackground.equalsIgnoreCase(SET_FOR_BCK_PARAM_FRAC_MO_RATE_TA_GR)) {
            this.adjustableParams.addParameter(this.totalMagRateParam);
            this.adjustableParams.addParameter(this.regionB_ValParam);
        } else if (setForBackground.equalsIgnoreCase(SET_FOR_BCK_PARAM_BCK_MAX_MAG)) {
            this.adjustableParams.addParameter(this.totalMagRateParam);
            this.adjustableParams.addParameter(this.regionB_ValParam);
            this.adjustableParams.addParameter(this.backSeisMaxMagParam);
        }
        this.adjustableParams.addParameter(this.probModelParam);
        if (((String)this.probModelParam.getValue()).equals("BPT")) {
            this.adjustableParams.addParameter(this.segDepAperiodicityParam);
            boolean isSegDepApriodicity = (Boolean)this.segDepAperiodicityParam.getValue();
            if (isSegDepApriodicity) {
                this.adjustableParams.addParameter(this.defaultAperiodicityParam);
            } else {
                this.adjustableParams.addParameter(this.aperiodicityParam);
            }
        }
    }

    private void makeSegmentedA_FaultParam() {
        ParameterList paramList = new ParameterList();
        ArrayList<String> faultNames = this.aFaultsFetcher.getAllFaultNames();
        for (int i = 0; i < faultNames.size(); ++i) {
            ArrayList<String> supportedRupModels = this.aFaultsFetcher.getRupModels(faultNames.get(i));
            StringParameter rupModelParam = new StringParameter(faultNames.get(i), supportedRupModels, supportedRupModels.get(0));
            paramList.addParameter(rupModelParam);
        }
        this.segmentedRupModelParam = new ParameterListParameter(SEGMENTED_RUP_MODEL_TYPE_NAME, paramList);
        this.segmentedRupModelParam.setInfo(SEGMENTED_RUP_MODEL_TYPE_INFO);
    }

    private DeformationModelSummary getSelectedDeformationModelSummary() {
        String selectedDefModel = (String)this.deformationModelsParam.getValue();
        for (int i = 0; i < this.deformationModelSummariesList.size(); ++i) {
            DeformationModelSummary deformationModelSum = this.deformationModelSummariesList.get(i);
            if (!deformationModelSum.getDeformationModelName().equalsIgnoreCase(selectedDefModel)) continue;
            return deformationModelSum;
        }
        return null;
    }

    public ArrayList getMagAreaRelationships() {
        return this.magAreaRelationships;
    }

    public MagAreaRelationship getMagAreaRelationship() {
        String magAreaRelName = (String)this.magAreaRelParam.getValue();
        for (int i = 0; i < this.magAreaRelationships.size(); ++i) {
            MagAreaRelationship magAreaRel = (MagAreaRelationship)this.magAreaRelationships.get(i);
            if (!magAreaRel.getName().equalsIgnoreCase(magAreaRelName)) continue;
            return magAreaRel;
        }
        return null;
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        if (iSource < this.allSources.size()) {
            return (ProbEqkSource)this.allSources.get(iSource);
        }
        if (((String)this.backSeisRupParam.getValue()).equals(BACK_SEIS_RUP_CROSSHAIR)) {
            return this.nshmp_gridSrcGen.getCrosshairGriddedSource(iSource - this.allSources.size(), this.timeSpan.getDuration());
        }
        return this.nshmp_gridSrcGen.getRandomStrikeGriddedSource(iSource - this.allSources.size(), this.timeSpan.getDuration());
    }

    @Override
    public int getNumSources() {
        if (((String)this.backSeisParam.getValue()).equals(BACK_SEIS_INCLUDE) || ((String)this.backSeisParam.getValue()).equals(BACK_SEIS_ONLY)) {
            return this.allSources.size() + this.nshmp_gridSrcGen.getNumSources();
        }
        return this.allSources.size();
    }

    private void makeBackgroundGridSources() {
        double rate = (Double)this.totalMagRateParam.getValue();
        double bValue = (Double)this.regionB_ValParam.getValue();
        String backgroundTreatment = (String)this.setForBckParam.getValue();
        String backSeis = (String)this.backSeisParam.getValue();
        if (backgroundTreatment.equals(SET_FOR_BCK_PARAM_NSHMP07)) {
            this.totBackgroundMFD = this.nshmp_gridSrcGen.getTotMFDForRegion(null, false, true, true, true);
        } else {
            if (backSeis.equalsIgnoreCase(BACK_SEIS_ONLY)) {
                throw new IllegalStateException("Can only use Only Background when using the NSHMP07 background MFD");
            }
            double totRateABC = this.aFaultSummedMFD.getTotalIncrRate() + this.bFaultCharSummedMFD.getTotalIncrRate() + this.bFaultGR_SummedMFD.getTotalIncrRate() + this.cZoneSummedMFD.getTotalIncrRate() + this.nonCA_B_FaultsSummedMFD.getTotalIncrRate();
            double totBackRate = rate - totRateABC;
            if (backgroundTreatment.equals(SET_FOR_BCK_PARAM_FRAC_MO_RATE_TR_GR) || backgroundTreatment.equals(SET_FOR_BCK_PARAM_FRAC_MO_RATE_TA_GR)) {
                double totMoRateABC = this.aFaultSummedMFD.getTotalMomentRate() + this.bFaultCharSummedMFD.getTotalMomentRate() + this.bFaultGR_SummedMFD.getTotalMomentRate() + this.cZoneSummedMFD.getTotalMomentRate() + this.nonCA_B_FaultsSummedMFD.getTotalMomentRate();
                double moRateFracToBackground = (Double)this.moRateFracToBackgroundParam.getValue();
                double totBackMoRate = (totMoRateABC /= 1.0 - this.totMoRateReduction) * moRateFracToBackground;
                if (backgroundTreatment.equals(SET_FOR_BCK_PARAM_FRAC_MO_RATE_TR_GR)) {
                    this.totBackgroundMFD = new GutenbergRichterMagFreqDist(5.05, NUM_MAG, 0.1);
                    if (moRateFracToBackground > 0.0) {
                        ((GutenbergRichterMagFreqDist)this.totBackgroundMFD).setAllButMagUpper(5.05, totBackMoRate, totBackRate, bValue, true);
                    }
                } else {
                    this.totBackgroundMFD = new TaperedGR_MagFreqDist(5.05, NUM_MAG, 0.1);
                    if (moRateFracToBackground > 0.0) {
                        ((TaperedGR_MagFreqDist)this.totBackgroundMFD).setAllButCornerMag(5.05, totBackMoRate, totBackRate, bValue);
                    }
                }
            } else if (backgroundTreatment.equals(SET_FOR_BCK_PARAM_BCK_MAX_MAG)) {
                double magMax = (Double)this.backSeisMaxMagParam.getValue();
                this.totBackgroundMFD = new GutenbergRichterMagFreqDist(5.05, NUM_MAG, 0.1);
                ((GutenbergRichterMagFreqDist)this.totBackgroundMFD).setAllButTotMoRate(5.05, magMax, totBackRate, bValue);
            }
        }
        if (backSeis.equalsIgnoreCase(BACK_SEIS_INCLUDE) || backSeis.equalsIgnoreCase(BACK_SEIS_ONLY)) {
            String backSeisRup = (String)this.backSeisRupParam.getValue();
            if (backSeisRup.equalsIgnoreCase(BACK_SEIS_RUP_POINT)) {
                this.nshmp_gridSrcGen.setAsPointSources(true);
            } else if (backSeisRup.equalsIgnoreCase(BACK_SEIS_RUP_FINITE)) {
                this.nshmp_gridSrcGen.setAsPointSources(false);
            } else {
                this.nshmp_gridSrcGen.setAsPointSources(false);
            }
            this.allSources.addAll(this.nshmp_gridSrcGen.getAllFixedStrikeSources(this.timeSpan.getDuration()));
        }
        this.reCalcBck = false;
    }

    private IncrementalMagFreqDist getNSHMP02_Backgr_MFD() {
        IncrementalMagFreqDist nshmp02_Backgr_MFD = new IncrementalMagFreqDist(5.05, NUM_MAG, 0.1);
        nshmp02_Backgr_MFD.set(5.0, 0.6585475);
        nshmp02_Backgr_MFD.set(5.1, 0.54740715);
        nshmp02_Backgr_MFD.set(5.2, 0.45473993);
        nshmp02_Backgr_MFD.set(5.3, 0.37777004);
        nshmp02_Backgr_MFD.set(5.4, 0.31383651);
        nshmp02_Backgr_MFD.set(5.5, 0.26072985);
        nshmp02_Backgr_MFD.set(5.6, 0.21661529);
        nshmp02_Backgr_MFD.set(5.7, 0.17996927);
        nshmp02_Backgr_MFD.set(5.8, 0.14947392);
        nshmp02_Backgr_MFD.set(5.9, 0.12414886);
        nshmp02_Backgr_MFD.set(6.0, 0.1005595);
        nshmp02_Backgr_MFD.set(6.1, 0.081493765);
        nshmp02_Backgr_MFD.set(6.2, 0.06763025);
        nshmp02_Backgr_MFD.set(6.3, 0.056068648);
        nshmp02_Backgr_MFD.set(6.4, 0.046449963);
        nshmp02_Backgr_MFD.set(6.5, 0.034433957);
        nshmp02_Backgr_MFD.set(6.6, 0.025387786);
        nshmp02_Backgr_MFD.set(6.7, 0.020769943);
        nshmp02_Backgr_MFD.set(6.8, 0.016882885);
        nshmp02_Backgr_MFD.set(6.9, 0.013718917);
        nshmp02_Backgr_MFD.set(7.0, 0.0021095828);
        return nshmp02_Backgr_MFD;
    }

    private void makeC_ZoneSources() {
        this.cZoneSummedMFD = new SummedMagFreqDist(5.05, 8.95, NUM_MAG);
        this.cZonesMFD_List = new ArrayList();
        double cZoneWt = (Double)this.c_ZoneWtParam.getValue();
        if (cZoneWt > 0.0) {
            String[] names = new String[]{"Foothills Fault System", "Mohawk-Honey Lake Zone", "Northeastern California", "Western Nevada", "Eastern California Shear Zone", "San Gorgonio Knot"};
            double[] slipRates = new double[]{0.1, 4.0, 4.0, 8.0, 4.0, 4.0};
            double[] depthTop = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            double[] depthBottom = new double[]{12.0, 15.0, 15.0, 15.0, 15.0, 18.0};
            double[] strike = new double[]{325.0, 315.0, 335.0, 315.0, 313.0, 293.0};
            double[] length = new double[]{360.0, 88.0, 230.0, 245.0, 219.0, 102.0};
            double[] magLower = new double[]{6.5, 6.5, 6.5, 6.5, 6.5, 6.5};
            double[] magUpper = new double[]{7.6, 7.6, 7.6, 7.6, 7.6, 7.6};
            double bValue = 0.8;
            for (int i = 0; i < names.length; ++i) {
                double slipRate = cZoneWt * slipRates[i] / 1000.0;
                double moRate = FaultMomentCalc.getMoment((depthBottom[i] - depthTop[i]) * length[i] * 1000000.0, slipRate);
                GutenbergRichterMagFreqDist grMFD = new GutenbergRichterMagFreqDist(5.05, 8.95, NUM_MAG);
                grMFD.setAllButTotCumRate(magLower[i] + 0.05, magUpper[i] - 0.05, moRate, bValue);
                grMFD.setName(names[i]);
                this.cZonesMFD_List.add(grMFD);
                this.cZoneSummedMFD.addIncrementalMagFreqDist(grMFD);
            }
        }
        this.reCalcC_Zones = false;
    }

    private void mkA_FaultSegmentedSources() {
        double relativeA_PrioriWeight = (Double)this.relativeA_PrioriWeightParam.getValue();
        double relativeSegRateWeight = (Double)this.relativeSegRateWeightParam.getValue();
        double magSigma = (Double)this.magSigmaParam.getValue();
        double magTruncLevel = (Double)this.truncLevelParam.getValue();
        ParameterList rupModels = (ParameterList)this.segmentedRupModelParam.getValue();
        String slipModel = (String)this.slipModelParam.getValue();
        boolean isAseisReducesArea = (Boolean)this.aseisFactorInterParam.getValue();
        double meanMagCorrection = (Double)this.meanMagCorrectionParam.getValue();
        boolean wtedInversion = (Boolean)this.weightedInversionParam.getValue();
        ArrayList<FaultSegmentData> aFaultSegmentData = this.aFaultsFetcher.getFaultSegmentDataList(isAseisReducesArea);
        this.aFaultSourceGenerators = new ArrayList();
        this.aFaultSummedMFD = new SummedMagFreqDist(5.05, 8.95, NUM_MAG);
        double duration = this.timeSpan.getDuration();
        double startYear = Double.NaN;
        double aperiodicity = Double.NaN;
        boolean isSegDependentAperiodicity = false;
        if (((String)this.probModelParam.getValue()).equals("BPT")) {
            startYear = this.timeSpan.getStartTimeYear();
            isSegDependentAperiodicity = (Boolean)this.segDepAperiodicityParam.getValue();
            aperiodicity = (Double)this.aperiodicityParam.getValue();
        }
        for (int i = 0; i < aFaultSegmentData.size(); ++i) {
            int rup;
            FaultSegmentData segmentData = aFaultSegmentData.get(i);
            ValueWeight[] aPrioriRates = this.aFaultsFetcher.getAprioriRupRates(segmentData.getFaultName(), (String)rupModels.getValue(segmentData.getFaultName()));
            double[] minRates = new double[aPrioriRates.length];
            double minRateFrac1 = (Double)this.minA_FaultRate1Param.getValue();
            double minRateFrac2 = (Double)this.minA_FaultRate2Param.getValue();
            double minRate = Double.MAX_VALUE;
            for (rup = 0; rup < aPrioriRates.length; ++rup) {
                if (!(aPrioriRates[rup].getValue() < minRate) || !(aPrioriRates[rup].getValue() >= 0.0)) continue;
                minRate = aPrioriRates[rup].getValue();
            }
            for (rup = 0; rup < aPrioriRates.length; ++rup) {
                double rate = aPrioriRates[rup].getValue();
                if (rate >= 0.0) {
                    minRates[rup] = minRate * minRateFrac1;
                    continue;
                }
                if (rate == -1.0) {
                    minRates[rup] = minRate * minRateFrac1;
                    aPrioriRates[rup].setValue(0.0);
                    continue;
                }
                if (rate == -2.0) {
                    minRates[rup] = minRate * minRateFrac2;
                    aPrioriRates[rup].setValue(0.0);
                    continue;
                }
                throw new RuntimeException("Problem with a-priori rates for fault " + segmentData.getFaultName());
            }
            A_FaultSegmentedSourceGenerator aFaultSourceGenerator = new A_FaultSegmentedSourceGenerator(segmentData, this.getMagAreaRelationship(), slipModel, aPrioriRates, magSigma, magTruncLevel, this.totMoRateReduction, meanMagCorrection, minRates, wtedInversion, relativeSegRateWeight, relativeA_PrioriWeight);
            this.aFaultSourceGenerators.add(aFaultSourceGenerator);
            if (((String)this.probModelParam.getValue()).equals(PROB_MODEL_POISSON)) {
                this.allSources.addAll(aFaultSourceGenerator.getTimeIndependentSources(duration));
            } else if (((String)this.probModelParam.getValue()).equals("BPT")) {
                this.allSources.addAll(aFaultSourceGenerator.getTimeDependentSources(duration, startYear, aperiodicity, isSegDependentAperiodicity));
            } else {
                this.allSources.addAll(aFaultSourceGenerator.getTimeDepEmpiricalSources(duration, this.empiricalModel));
            }
            this.aFaultSummedMFD.addIncrementalMagFreqDist(aFaultSourceGenerator.getTotalRupMFD());
        }
        this.reCalcA_Faults = false;
    }

    private void mkA_FaultUnsegmentedSources() {
        double magSigma = (Double)this.magSigmaParam.getValue();
        double magTruncLevel = (Double)this.truncLevelParam.getValue();
        double fractCharVsGR = 0.0;
        MagAreaRelationship magAreaRel = this.getMagAreaRelationship();
        boolean isAseisReducesArea = (Boolean)this.aseisFactorInterParam.getValue();
        double bValue = (Double)this.aFaultB_ValParam.getValue();
        double meanMagCorrection = (Double)this.meanMagCorrectionParam.getValue();
        double minMagGR = (Double)this.bFaultsMinMagParam.getValue();
        ArrayList<FaultSegmentData> aFaultSegmentData = this.aFaultsFetcher.getFaultSegmentDataList(isAseisReducesArea);
        this.aFaultSourceGenerators = new ArrayList();
        this.aFaultSummedMFD = new SummedMagFreqDist(5.05, 8.95, NUM_MAG);
        double duration = this.timeSpan.getDuration();
        EmpiricalModel empiricalModel = null;
        int floaterType = this.getFloaterType();
        if (((String)this.probModelParam.getValue()).equals(PROB_MODEL_EMPIRICAL)) {
            empiricalModel = this.empiricalModel;
        }
        for (int i = 0; i < aFaultSegmentData.size(); ++i) {
            FaultSegmentData segmentData = aFaultSegmentData.get(i);
            UnsegmentedSource source = new UnsegmentedSource(segmentData, magAreaRel, fractCharVsGR, 5.05, 8.95, NUM_MAG, magSigma, magTruncLevel, minMagGR, bValue, this.totMoRateReduction, Double.NaN, Double.NaN, meanMagCorrection, empiricalModel, floaterType);
            source.setDuration(duration);
            this.aFaultSourceGenerators.add(source);
            this.allSources.add(source);
            this.aFaultSummedMFD.addIncrementalMagFreqDist(source.getMagFreqDist());
        }
        this.reCalcA_Faults = false;
    }

    private int getFloaterType() {
        String floaterType = (String)this.floaterTypeParam.getValue();
        if (floaterType.equalsIgnoreCase(FULL_DDW_FLOATER)) {
            return 0;
        }
        if (floaterType.equalsIgnoreCase(STRIKE_AND_DOWNDIP_FLOATER)) {
            return 1;
        }
        if (floaterType.equalsIgnoreCase("Along strike & centered down dip")) {
            return 2;
        }
        throw new RuntimeException("Unsupported Floating ruptures option");
    }

    private void mkB_FaultSources() {
        double magSigma = (Double)this.magSigmaParam.getValue();
        double magTruncLevel = (Double)this.truncLevelParam.getValue();
        double fractCharVsGR = (Double)this.percentCharVsGRParam.getValue() / 100.0;
        MagAreaRelationship magAreaRel = this.getMagAreaRelationship();
        boolean isAseisReducesArea = (Boolean)this.aseisFactorInterParam.getValue();
        double meanMagCorrection = (Double)this.meanMagCorrectionParam.getValue();
        double minMagGR = (Double)this.bFaultsMinMagParam.getValue();
        double bValue = (Double)this.bFaultB_ValParam.getValue();
        ArrayList bFaultSegmentData = this.bFaultsFetcher.getFaultSegmentDataList(isAseisReducesArea);
        this.bFaultCharSummedMFD = new SummedMagFreqDist(5.05, 8.95, NUM_MAG);
        this.bFaultGR_SummedMFD = new SummedMagFreqDist(5.05, 8.95, NUM_MAG);
        int floaterType = this.getFloaterType();
        this.bFaultSources = new ArrayList();
        double duration = this.timeSpan.getDuration();
        try {
            EmpiricalModel empiricalModel = null;
            if (((String)this.probModelParam.getValue()).equals(PROB_MODEL_EMPIRICAL)) {
                empiricalModel = this.empiricalModel;
            }
            for (int i = 0; i < bFaultSegmentData.size(); ++i) {
                FaultSegmentData segmentData = (FaultSegmentData)bFaultSegmentData.get(i);
                double fixMag = Double.NaN;
                double fixRate = Double.NaN;
                if (segmentData.getFaultName().equals("Mendocino") || segmentData.getFaultName().equals("Brawley (Seismic Zone), alt 1") || segmentData.getFaultName().equals("Brawley (Seismic Zone), alt 2") || segmentData.getFaultName().equals("Carson Range (Genoa)") || segmentData.getFaultName().equals("Antelope Valley")) continue;
                UnsegmentedSource source = new UnsegmentedSource(segmentData, magAreaRel, fractCharVsGR, 5.05, 8.95, NUM_MAG, magSigma, magTruncLevel, minMagGR, bValue, this.totMoRateReduction, fixMag, fixRate, meanMagCorrection, empiricalModel, floaterType);
                source.setDuration(duration);
                this.bFaultSources.add(source);
                this.allSources.add(source);
                IncrementalMagFreqDist charMagFreqDist = source.getCharMagFreqDist();
                this.bFaultCharSummedMFD.addIncrementalMagFreqDist(charMagFreqDist);
                IncrementalMagFreqDist grMagFreqDist = source.getGR_MagFreqDist();
                if (source.getGR_MagFreqDist() == null) continue;
                this.bFaultGR_SummedMFD.addIncrementalMagFreqDist(grMagFreqDist);
            }
            this.reCalcB_Faults = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void mkNonCA_B_FaultSources() {
        double magSigma = (Double)this.magSigmaParam.getValue();
        double magTruncLevel = (Double)this.truncLevelParam.getValue();
        double duration = this.timeSpan.getDuration();
        NonCA_FaultsFetcher fetcher = new NonCA_FaultsFetcher();
        EmpiricalModel empiricalModel = null;
        if (((String)this.probModelParam.getValue()).equals(PROB_MODEL_EMPIRICAL)) {
            empiricalModel = this.empiricalModel;
        }
        ArrayList<ProbEqkSource> sources = fetcher.getSources(NON_CA_SOURCES_FILENAME, duration, magSigma, magTruncLevel, 5.0, empiricalModel);
        this.nonCA_bFaultSources = new ArrayList();
        this.nonCA_bFaultSources.addAll(sources);
        this.allSources.addAll(sources);
        this.nonCA_B_FaultsSummedMFD = fetcher.getSummedMFD();
        this.reCalcNonCA_B_Fauts = false;
    }

    public ArrayList get_A_FaultSourceGenerators() {
        return this.aFaultSourceGenerators;
    }

    public ArrayList getNonCA_B_FaultSources() {
        return this.nonCA_bFaultSources;
    }

    public ArrayList get_B_FaultSources() {
        return this.bFaultSources;
    }

    public ArrayList getSourceList() {
        boolean isBackground;
        ArrayList<ProbEqkSource> sourceList = new ArrayList<ProbEqkSource>();
        sourceList.addAll(this.allSources);
        boolean bl = isBackground = ((String)this.backSeisParam.getValue()).equals(BACK_SEIS_INCLUDE) || ((String)this.backSeisParam.getValue()).equals(BACK_SEIS_ONLY);
        if (isBackground && ((String)this.backSeisRupParam.getValue()).equals(BACK_SEIS_RUP_CROSSHAIR)) {
            sourceList.addAll(this.nshmp_gridSrcGen.getAllCrosshairGriddedSources(this.timeSpan.getDuration()));
        } else if (isBackground) {
            sourceList.addAll(this.nshmp_gridSrcGen.getAllRandomStrikeGriddedSources(this.timeSpan.getDuration()));
        }
        return sourceList;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static ArrayList<ArbitrarilyDiscretizedFunc> getObsIncrMFD(boolean includeAftershocks) {
        ArrayList<EvenlyDiscretizedFunc> obsCumMFD = UCERF2.getObsCumMFD(includeAftershocks);
        return UCERF2.getIncrFromCumMFD(obsCumMFD);
    }

    public ArrayList<ArbitrarilyDiscretizedFunc> getObsIncrNoCalMFD() {
        ArrayList<EvenlyDiscretizedFunc> obsCumMFD = this.getObsCumNoCalMFD();
        return UCERF2.getIncrFromCumMFD(obsCumMFD);
    }

    public ArrayList<ArbitrarilyDiscretizedFunc> getObsIncrSoCalMFD() {
        ArrayList<EvenlyDiscretizedFunc> obsCumMFD = this.getObsCumSoCalMFD();
        return UCERF2.getIncrFromCumMFD(obsCumMFD);
    }

    private static ArrayList<ArbitrarilyDiscretizedFunc> getIncrFromCumMFD(ArrayList<EvenlyDiscretizedFunc> obsCumMFD) {
        ArrayList<ArbitrarilyDiscretizedFunc> obsIncrMFDList = new ArrayList<ArbitrarilyDiscretizedFunc>();
        for (int i = 0; i < 1; ++i) {
            EvenlyDiscretizedFunc cumMFD = obsCumMFD.get(i);
            ArbIncrementalMagFreqDist arbIncrMFD = new ArbIncrementalMagFreqDist(cumMFD.getMinX() + 0.1, cumMFD.getMaxX() - 0.1, 24);
            arbIncrMFD.setCumRateDist(cumMFD);
            ArbitrarilyDiscretizedFunc arbDiscFun = new ArbitrarilyDiscretizedFunc();
            arbDiscFun.set(5.1, arbIncrMFD.getY(5.1));
            arbDiscFun.set(5.5, arbIncrMFD.getY(5.5));
            arbDiscFun.set(6.0, arbIncrMFD.getY(6.0));
            arbDiscFun.set(6.5, arbIncrMFD.getY(6.5));
            arbDiscFun.set(7.0, arbIncrMFD.getY(7.0));
            arbDiscFun.set(7.4, arbIncrMFD.getY(7.4));
            obsIncrMFDList.add(arbDiscFun);
        }
        return obsIncrMFDList;
    }

    public ArrayList<EvenlyDiscretizedFunc> getObsCumNoCalMFD() {
        IncrementalMagFreqDist obsCumMFD = new IncrementalMagFreqDist(5.0, 7.5, 6);
        IncrementalMagFreqDist obsCumLowMFD = new IncrementalMagFreqDist(5.0, 7.5, 6);
        IncrementalMagFreqDist obsCumHighMFD = new IncrementalMagFreqDist(5.0, 7.5, 6);
        double[] cumRates = new double[]{1.32, 0.56, 0.25, 0.06, 0.03, 0.007};
        double[] cumRatesLow = new double[]{1.06, 0.38000000000000006, 0.12, 0.03, 0.009999999999999998, 4.000000000000002E-4};
        double[] cumRatesHigh = new double[]{1.62, 0.79, 0.45, 0.11, 0.074, 0.033};
        for (int i = 5; i >= 0; --i) {
            obsCumMFD.set(i, cumRates[i]);
            obsCumLowMFD.set(i, cumRatesLow[i]);
            obsCumHighMFD.set(i, cumRatesHigh[i]);
        }
        obsCumMFD.setInfo("Cumulative MFD for observed catalog for No Cal polygon (from Karen Felzer's Sep 27, 2007 email)");
        obsCumLowMFD.setInfo("Lower 95% confidence of cumulative MFD for No Cal polygon(from Karen Felzer's Sep 27, 2007 email)");
        obsCumHighMFD.setInfo("Upper 95% confidence of cumulative MFD for No Cal polygon (from Karen Felzer's Sep 27, 2007 email)");
        ArrayList<EvenlyDiscretizedFunc> obsCumList = new ArrayList<EvenlyDiscretizedFunc>();
        obsCumList.add(obsCumMFD);
        obsCumList.add(obsCumLowMFD);
        obsCumList.add(obsCumHighMFD);
        return obsCumList;
    }

    public ArrayList<EvenlyDiscretizedFunc> getObsCumSoCalMFD() {
        IncrementalMagFreqDist obsCumMFD = new IncrementalMagFreqDist(5.0, 7.5, 6);
        IncrementalMagFreqDist obsCumLowMFD = new IncrementalMagFreqDist(5.0, 7.5, 6);
        IncrementalMagFreqDist obsCumHighMFD = new IncrementalMagFreqDist(5.0, 7.5, 6);
        double[] cumRates = new double[]{1.43, 0.77, 0.31, 0.16, 0.043, 0.014};
        double[] cumRatesLow = new double[]{1.16, 0.56, 0.18, 0.1, 0.012999999999999998, 0.002};
        double[] cumRatesHigh = new double[]{1.73, 1.02, 0.49, 0.25, 0.093, 0.044};
        for (int i = 5; i >= 0; --i) {
            obsCumMFD.set(i, cumRates[i]);
            obsCumLowMFD.set(i, cumRatesLow[i]);
            obsCumHighMFD.set(i, cumRatesHigh[i]);
        }
        obsCumMFD.setInfo("Cumulative MFD for observed catalog for So Cal polygon (from Karen Felzer's Sep 27, 2007 email)");
        obsCumLowMFD.setInfo("Lower 95% confidence of cumulative MFD for So Cal polygon(from Karen Felzer's Sep 27, 2007 email)");
        obsCumHighMFD.setInfo("Upper 95% confidence of cumulative MFD for So Cal polygon (from Karen Felzer's Sep 27, 2007 email)");
        ArrayList<EvenlyDiscretizedFunc> obsCumList = new ArrayList<EvenlyDiscretizedFunc>();
        obsCumList.add(obsCumMFD);
        obsCumList.add(obsCumLowMFD);
        obsCumList.add(obsCumHighMFD);
        return obsCumList;
    }

    public static ArrayList<EvenlyDiscretizedFunc> getObsCumMFD(boolean includeAftershocks) {
        IncrementalMagFreqDist obsCumMFD = new IncrementalMagFreqDist(5.0, 7.5, 6);
        IncrementalMagFreqDist obsCumLowMFD = new IncrementalMagFreqDist(5.0, 7.5, 6);
        IncrementalMagFreqDist obsCumHighMFD = new IncrementalMagFreqDist(5.0, 7.5, 6);
        double[] cumRatesWith = new double[]{7.5, 2.4, 0.74, 0.23, 0.07, 0.017};
        double[] cumRatesLowWith = new double[]{3.56, 1.2999999999999998, 0.39999999999999997, 0.12000000000000001, 0.030000000000000006, 0.004000000000000002};
        double[] cumRatesHighWith = new double[]{10.5, 3.3499999999999996, 1.03, 0.35, 0.13, 0.039};
        double[] cumRates = new double[]{4.17, 1.65, 0.65, 0.24, 0.09, 0.02};
        double[] cumRatesLow = new double[]{2.2199999999999998, 0.9899999999999999, 0.39, 0.13, 0.049999999999999996, 0.004};
        double[] cumRatesHigh = new double[]{5.84, 2.31, 0.96, 0.35, 0.15, 0.044};
        if (includeAftershocks) {
            cumRates = cumRatesWith;
            cumRatesLow = cumRatesLowWith;
            cumRatesHigh = cumRatesHighWith;
        }
        for (int i = 5; i >= 0; --i) {
            obsCumMFD.set(i, cumRates[i]);
            obsCumLowMFD.set(i, cumRatesLow[i]);
            obsCumHighMFD.set(i, cumRatesHigh[i]);
        }
        if (includeAftershocks) {
            obsCumMFD.setInfo("Cumulative MFD for observed catalog including aftershocks (Table 21 of Karen Felzer's Appendix_I_v03.pdf)");
            obsCumLowMFD.setInfo("Lower 98% confidence of cumulative MFD for observed catalog including aftershocks (Table 21 of Karen Felzer's Appendix_I_v03.pdf)");
            obsCumHighMFD.setInfo("Upper 98% confidence of cumulative MFD for observed catalog including aftershocks (Table 21 of Karen Felzer's Appendix_I_v03.pdf)");
        } else {
            obsCumMFD.setInfo("Cumulative MFD for observed catalog excluding aftershocks (from Karen Felzer's Aug 27, 2007 email)");
            obsCumLowMFD.setInfo("Lower 95% confidence of cumulative MFD for observed catalog excluding aftershocks (from Karen Felzer's Aug 27, 2007 email)");
            obsCumHighMFD.setInfo("Upper 95% confidence of cumulative MFD for observed catalog excluding aftershocks (from Karen Felzer's Aug 27, 2007 email)");
        }
        ArrayList<EvenlyDiscretizedFunc> obsCumList = new ArrayList<EvenlyDiscretizedFunc>();
        obsCumList.add(obsCumMFD);
        obsCumList.add(obsCumLowMFD);
        obsCumList.add(obsCumHighMFD);
        return obsCumList;
    }

    public void getTotal_B_FaultsProb(DiscretizedFunc magProbDist, Region region) {
        int numMags = magProbDist.size();
        for (int i = 0; i < numMags; ++i) {
            double prob = 1.0;
            double minMag = magProbDist.getX(i);
            for (int srcIndex = 0; srcIndex < this.bFaultSources.size(); ++srcIndex) {
                prob *= this.getProbForUnsegmentedSrc(this.bFaultSources.get(srcIndex), minMag, region);
            }
            magProbDist.set(i, 1.0 - prob);
        }
    }

    private double getProbForSegmentedSrc(A_FaultSegmentedSourceGenerator segmentedSrcGenerator, double minMag, Region region) {
        String faultName = segmentedSrcGenerator.getFaultSegmentData().getFaultName();
        if (faultName.equals("N. San Andreas") && region instanceof CaliforniaRegions.SF_BOX_GRIDDED) {
            return 1.0 - segmentedSrcGenerator.getApproxTotFaultProb(minMag, null);
        }
        return 1.0 - segmentedSrcGenerator.getApproxTotFaultProb(minMag, region);
    }

    private double getProbForUnsegmentedSrc(UnsegmentedSource unsegmentedSrc, double minMag, Region region) {
        String faultName = unsegmentedSrc.getFaultSegmentData().getFaultName();
        if ((faultName.equals("San Gregorio Connected") || faultName.equals("N. San Andreas")) && region instanceof CaliforniaRegions.SF_BOX_GRIDDED) {
            return 1.0 - unsegmentedSrc.computeApproxTotalProbAbove(minMag, null);
        }
        return 1.0 - unsegmentedSrc.computeApproxTotalProbAbove(minMag, region);
    }

    public void getProbsForB_Fault(String bFaultName, DiscretizedFunc magProbDist, Region region) {
        int numMags = magProbDist.size();
        for (int srcIndex = 0; srcIndex < this.bFaultSources.size(); ++srcIndex) {
            if (!this.bFaultSources.get(srcIndex).getFaultSegmentData().getFaultName().equals(bFaultName)) continue;
            for (int i = 0; i < numMags; ++i) {
                double minMag = magProbDist.getX(i);
                double prob = this.getProbForUnsegmentedSrc(this.bFaultSources.get(srcIndex), minMag, region);
                magProbDist.set(i, 1.0 - prob);
            }
            break;
        }
    }

    public void getTotal_NonCA_B_FaultsProb(DiscretizedFunc magProbDist, Region region) {
        int numMags = magProbDist.size();
        for (int i = 0; i < numMags; ++i) {
            double prob = 1.0;
            double minMag = magProbDist.getX(i);
            for (int srcIndex = 0; srcIndex < this.nonCA_bFaultSources.size(); ++srcIndex) {
                prob *= 1.0 - this.nonCA_bFaultSources.get(srcIndex).computeApproxTotalProbAbove(minMag, region);
            }
            magProbDist.set(i, 1.0 - prob);
        }
    }

    public void getTotal_A_FaultsProb(DiscretizedFunc magProbDist, Region region) {
        int numMags = magProbDist.size();
        for (int i = 0; i < numMags; ++i) {
            double prob = 1.0;
            double minMag = magProbDist.getX(i);
            for (int srcIndex = 0; srcIndex < this.aFaultSourceGenerators.size(); ++srcIndex) {
                Object source = this.aFaultSourceGenerators.get(srcIndex);
                if (source instanceof A_FaultSegmentedSourceGenerator) {
                    prob *= this.getProbForSegmentedSrc((A_FaultSegmentedSourceGenerator)source, minMag, region);
                    continue;
                }
                prob *= this.getProbForUnsegmentedSrc((UnsegmentedSource)source, minMag, region);
            }
            magProbDist.set(i, 1.0 - prob);
        }
    }

    public void getProbForA_Fault(String aFaultName, DiscretizedFunc magProbDist, Region region) {
        int numMags = magProbDist.size();
        for (int srcIndex = 0; srcIndex < this.aFaultSourceGenerators.size(); ++srcIndex) {
            Object source = this.aFaultSourceGenerators.get(srcIndex);
            if (source instanceof A_FaultSegmentedSourceGenerator) {
                A_FaultSegmentedSourceGenerator srcGen = (A_FaultSegmentedSourceGenerator)source;
                if (!srcGen.getFaultSegmentData().getFaultName().equals(aFaultName)) continue;
                for (int i = 0; i < numMags; ++i) {
                    double minMag = magProbDist.getX(i);
                    double prob = this.getProbForSegmentedSrc(srcGen, minMag, region);
                    magProbDist.set(i, 1.0 - prob);
                }
            } else {
                UnsegmentedSource unsegmentedSrc = (UnsegmentedSource)source;
                if (aFaultName.equalsIgnoreCase("San Jacinto")) {
                    DiscretizedFunc sj1 = magProbDist.deepClone();
                    DiscretizedFunc sj2 = magProbDist.deepClone();
                    this.getProbForA_Fault("San Jacinto (SB to C)", sj1, region);
                    this.getProbForA_Fault("San Jacinto (CC to SM)", sj2, region);
                    for (int i = 0; i < numMags; ++i) {
                        double prob = (1.0 - sj1.getY(i)) * (1.0 - sj2.getY(i));
                        magProbDist.set(i, 1.0 - prob);
                    }
                } else {
                    if (!unsegmentedSrc.getFaultSegmentData().getFaultName().equals(aFaultName)) continue;
                    for (int i = 0; i < numMags; ++i) {
                        double minMag = magProbDist.getX(i);
                        double prob = this.getProbForUnsegmentedSrc(unsegmentedSrc, minMag, region);
                        magProbDist.set(i, 1.0 - prob);
                    }
                }
            }
            break;
        }
    }

    public void getTotal_BackgroundProb(DiscretizedFunc magProbDist, Region region) {
        int numMags = magProbDist.size();
        SummedMagFreqDist incrMFD = this.nshmp_gridSrcGen.getTotMFDForRegion(region, false, true, true, true);
        for (int i = 0; i < numMags; ++i) {
            double minMag = magProbDist.getX(i);
            int index = (int)Math.ceil((minMag - 5.05 - 1.0E-5) / 0.1);
            magProbDist.set(i, 1.0 - Math.exp(-this.timeSpan.getDuration() * incrMFD.getCumRate(index)));
        }
    }

    public void getTotal_BackgroundMFD(DiscretizedFunc magFreqDist, Region region) {
        int numMags = magFreqDist.size();
        SummedMagFreqDist incrMFD = this.nshmp_gridSrcGen.getTotMFDForRegion(region, false, true, true, true);
        for (int i = 0; i < numMags; ++i) {
            double minMag = magFreqDist.getX(i);
            int index = (int)Math.ceil((minMag - 5.05 - 1.0E-5) / 0.1);
            magFreqDist.set(i, incrMFD.getCumRate(index));
        }
    }

    public void getTotal_C_ZoneProb(DiscretizedFunc magProbDist, Region region) {
        int numMags = magProbDist.size();
        IncrementalMagFreqDist incrMFD = this.nshmp_gridSrcGen.getTotalC_ZoneMFD_InRegion(region);
        for (int i = 0; i < numMags; ++i) {
            double minMag = magProbDist.getX(i);
            int index = (int)Math.ceil((minMag - 5.05 - 1.0E-5) / 0.1);
            magProbDist.set(i, 1.0 - Math.exp(-this.timeSpan.getDuration() * incrMFD.getCumRate(index)));
        }
    }

    public void getTotalProb(DiscretizedFunc magProbDist, Region region) {
        int numMags = magProbDist.size();
        DiscretizedFunc bFaultsProbDist = magProbDist.deepClone();
        DiscretizedFunc nonCA_B_FaultsProbDist = magProbDist.deepClone();
        DiscretizedFunc aFaultsProbDist = magProbDist.deepClone();
        DiscretizedFunc bckProbDist = magProbDist.deepClone();
        DiscretizedFunc cZoneProbDist = magProbDist.deepClone();
        this.getTotal_B_FaultsProb(bFaultsProbDist, region);
        this.getTotal_NonCA_B_FaultsProb(nonCA_B_FaultsProbDist, region);
        this.getTotal_A_FaultsProb(aFaultsProbDist, region);
        this.getTotal_BackgroundProb(bckProbDist, region);
        this.getTotal_C_ZoneProb(cZoneProbDist, region);
        for (int i = 0; i < numMags; ++i) {
            double prob = 1.0;
            prob *= 1.0 - bFaultsProbDist.getY(i);
            prob *= 1.0 - nonCA_B_FaultsProbDist.getY(i);
            prob *= 1.0 - aFaultsProbDist.getY(i);
            prob *= 1.0 - bckProbDist.getY(i);
            magProbDist.set(i, 1.0 - (prob *= 1.0 - cZoneProbDist.getY(i)));
        }
    }

    public IncrementalMagFreqDist getTotal_B_FaultsCharMFD() {
        return this.bFaultCharSummedMFD;
    }

    public IncrementalMagFreqDist getTotal_B_FaultsGR_MFD() {
        return this.bFaultGR_SummedMFD;
    }

    public IncrementalMagFreqDist getTotal_NonCA_B_FaultsMFD() {
        return this.nonCA_B_FaultsSummedMFD;
    }

    public IncrementalMagFreqDist getTotal_A_FaultsMFD() {
        return this.aFaultSummedMFD;
    }

    public IncrementalMagFreqDist getTotal_BackgroundMFD() {
        return this.totBackgroundMFD;
    }

    public IncrementalMagFreqDist getTotal_C_ZoneMFD() {
        return this.cZoneSummedMFD;
    }

    public ArrayList<IncrementalMagFreqDist> getC_ZoneMFD_List() {
        return this.cZonesMFD_List;
    }

    public IncrementalMagFreqDist getTotalMFD() {
        SummedMagFreqDist totalMFD = new SummedMagFreqDist(5.05, 8.95, NUM_MAG);
        totalMFD.addIncrementalMagFreqDist(this.bFaultCharSummedMFD);
        totalMFD.addIncrementalMagFreqDist(this.bFaultGR_SummedMFD);
        totalMFD.addIncrementalMagFreqDist(this.aFaultSummedMFD);
        totalMFD.addIncrementalMagFreqDist(this.totBackgroundMFD);
        totalMFD.addIncrementalMagFreqDist(this.cZoneSummedMFD);
        totalMFD.addIncrementalMagFreqDist(this.nonCA_B_FaultsSummedMFD);
        return totalMFD;
    }

    public double getGeneralPredErr() {
        double genPredErr = 0.0;
        for (A_FaultSegmentedSourceGenerator source : this.aFaultSourceGenerators) {
            if (!(source.getTotalAPrioriRate() > 0.0)) continue;
            genPredErr += source.getGeneralizedPredictionError();
        }
        return genPredErr;
    }

    public double getModSlipRateError() {
        double modSlipRateError = 0.0;
        for (A_FaultSegmentedSourceGenerator source : this.aFaultSourceGenerators) {
            if (!(source.getTotalAPrioriRate() > 0.0)) continue;
            modSlipRateError += source.getNormModSlipRateError();
        }
        return modSlipRateError;
    }

    public double getDataER_Err() {
        double dataER_Error = 0.0;
        for (A_FaultSegmentedSourceGenerator source : this.aFaultSourceGenerators) {
            if (!(source.getTotalAPrioriRate() > 0.0)) continue;
            dataER_Error += source.getNormDataER_Error();
        }
        return dataER_Error;
    }

    public double getNormalizedA_PrioriRateErr() {
        double aPrioriRateError = 0.0;
        for (A_FaultSegmentedSourceGenerator source : this.aFaultSourceGenerators) {
            if (!(source.getTotalAPrioriRate() > 0.0)) continue;
            aPrioriRateError += source.getA_PrioriModelError();
        }
        return aPrioriRateError;
    }

    public double getNonNormalizedA_PrioriRateErr() {
        double nonNorm_aPrioriRateError = 0.0;
        for (A_FaultSegmentedSourceGenerator source : this.aFaultSourceGenerators) {
            if (!(source.getTotalAPrioriRate() > 0.0)) continue;
            nonNorm_aPrioriRateError += source.getNonNormA_PrioriModelError();
        }
        return nonNorm_aPrioriRateError;
    }

    @Override
    public void updateForecast() {
        if (this.updateA_FaultsFetcher) {
            this.updateFetchersBasedonDefModels();
        }
        if (this.updateB_FaultsFetcher) {
            this.bFaultsFetcher.setDeformationModel((Boolean)this.connectMoreB_FaultsParam.getValue(), this.getSelectedDeformationModelSummary(), this.aFaultsFetcher);
            this.updateB_FaultsFetcher = false;
        }
        double totToKeep = 1.0;
        totToKeep *= 1.0 - (Double)this.moRateFracToBackgroundParam.getValue();
        totToKeep *= ((Double)this.couplingCoeffParam.getValue()).doubleValue();
        this.totMoRateReduction = 1.0 - (totToKeep *= 1.0 - (Double)this.aftershockFractionParam.getValue());
        this.allSources = new ArrayList();
        String rupModel = (String)this.rupModelParam.getValue();
        String backSeis = (String)this.backSeisParam.getValue();
        if (!backSeis.equalsIgnoreCase(BACK_SEIS_ONLY)) {
            if (rupModel.equalsIgnoreCase(UNSEGMENTED_A_FAULT_MODEL)) {
                this.mkA_FaultUnsegmentedSources();
                ArrayList<EventRates> eventRatesList = this.aFaultsFetcher.getEventRatesList();
                int numSources = this.aFaultSourceGenerators.size();
                for (int locIndex = 0; locIndex < eventRatesList.size(); ++locIndex) {
                    EventRates event = eventRatesList.get(locIndex);
                    double rate = 0.0;
                    double obsRate = 0.0;
                    for (int iSource = 0; iSource < numSources; ++iSource) {
                        UnsegmentedSource source = (UnsegmentedSource)this.aFaultSourceGenerators.get(iSource);
                        if (!source.getFaultSegmentData().getFaultName().equalsIgnoreCase(event.getFaultName())) continue;
                        Location loc = Location.backwardsCompatible(event.getLatitude(), event.getLongitude());
                        rate += source.getPredEventRate(loc);
                        obsRate += source.getPredObsEventRate(loc);
                    }
                    event.setPredictedRate(rate);
                    event.setPredictedObsRate(obsRate);
                }
            } else {
                this.mkA_FaultSegmentedSources();
            }
            this.mkB_FaultSources();
            this.mkNonCA_B_FaultSources();
            this.makeC_ZoneSources();
        }
        this.makeBackgroundGridSources();
    }

    private void setTimespanParameter() {
        if (((String)this.probModelParam.getValue()).equals("BPT")) {
            this.timeSpan = new TimeSpan("Years", "Years");
            this.timeSpan.setDuractionConstraint(1.0, 100.0);
            this.timeSpan.setDuration(30.0);
            this.timeSpan.setStartTimeConstraint("Start Year", 2007, 2107);
            this.timeSpan.setStartTime(2007);
            this.timeSpan.addParameterChangeListener(this);
        } else {
            this.timeSpan = new TimeSpan("None", "Years");
            this.timeSpan.setDuration(30.0);
            this.timeSpan.addParameterChangeListener(this);
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        super.parameterChange(event);
        String paramName = event.getParameterName();
        if (paramName.equalsIgnoreCase(SET_FOR_BCK_PARAM_NAME) || paramName.equalsIgnoreCase(SEG_DEP_APERIODICITY_PARAM_NAME) || paramName.equalsIgnoreCase(BACK_SEIS_NAME)) {
            this.createParamList();
        } else if (paramName.equalsIgnoreCase(PROB_MODEL_PARAM_NAME)) {
            this.createParamList();
            this.setTimespanParameter();
            this.timeSpanChange(new EventObject(this.timeSpan));
        } else if (paramName.equalsIgnoreCase(RUP_MODEL_TYPE_NAME)) {
            this.createParamList();
            this.updateA_FaultsFetcher = true;
        } else if (paramName.equalsIgnoreCase(CONNECT_B_FAULTS_PARAM_NAME)) {
            this.updateB_FaultsFetcher = true;
        } else if (paramName.equalsIgnoreCase(DEFORMATION_MODEL_PARAM_NAME)) {
            this.updateA_FaultsFetcher = true;
            this.updateB_FaultsFetcher = true;
        } else if (paramName.equalsIgnoreCase(this.distCorrParam.getName())) {
            this.nshmp_gridSrcGen.setDistanceCorrections((WeightedList<PointSourceDistanceCorrection>)((PointSourceDistanceCorrections)this.distCorrParam.getValue()).get());
        }
    }

    @Override
    public void timeSpanChange(EventObject event) {
        this.parameterChangeFlag = true;
    }

    private void updateFetchersBasedonDefModels() {
        String rupModelName = (String)this.rupModelParam.getValue();
        boolean isUnsegmented = rupModelName.equalsIgnoreCase(UNSEGMENTED_A_FAULT_MODEL);
        this.aFaultsFetcher.setDeformationModel(this.getSelectedDeformationModelSummary(), isUnsegmented);
        this.bFaultsFetcher.setDeformationModel((Boolean)this.connectMoreB_FaultsParam.getValue(), this.getSelectedDeformationModelSummary(), this.aFaultsFetcher);
        this.updateA_FaultsFetcher = false;
        this.updateB_FaultsFetcher = false;
    }

    private void makeMatlabNNLS_testScript() {
        ArrayList<String> magAreaOptions = ((StringConstraint)this.magAreaRelParam.getConstraint()).getAllowedStrings();
        ArrayList<String> slipModelOptions = ((StringConstraint)this.slipModelParam.getConstraint()).getAllowedStrings();
        for (int imag = 0; imag < magAreaOptions.size(); ++imag) {
            for (int islip = 0; islip < slipModelOptions.size(); ++islip) {
                this.magAreaRelParam.setValue(magAreaOptions.get(imag));
                this.slipModelParam.setValue(slipModelOptions.get(islip));
                System.out.println("% " + String.valueOf(magAreaOptions.get(imag)) + "\n% " + String.valueOf(slipModelOptions.get(islip)));
                System.out.println("display CASE_" + imag + "_" + islip);
                this.mkA_FaultSegmentedSources();
            }
        }
    }

    public static void testNSAF_TimePredProbs() {
        UCERF2 erRateModel2_ERF = new UCERF2();
        erRateModel2_ERF.setParamDefaults();
        erRateModel2_ERF.updateForecast();
        int nsaf_index = 3;
        A_FaultSegmentedSourceGenerator nsaf_src_gen = (A_FaultSegmentedSourceGenerator)erRateModel2_ERF.get_A_FaultSourceGenerators().get(nsaf_index);
        ArrayList<FaultRuptureSource> junk = nsaf_src_gen.getTimeDependentSources(30.0, 2007.0, 0.5, false);
        int nrup = nsaf_src_gen.getNumRupSources();
        double[] wg02_probs = new double[nrup];
        for (int r = 0; r < nrup; ++r) {
            wg02_probs[r] = nsaf_src_gen.getRupSourceProb(r);
        }
        double[] timePredProbs = nsaf_src_gen.tryTimePredProbs(30.0, 2007.0, 0.5);
        System.out.println("wg02_probs\ttimePredProbs\twg02_probs/timePredProbs");
        for (int r = 0; r < nrup; ++r) {
            System.out.println((float)wg02_probs[r] + "\t" + (float)timePredProbs[r] + "\t" + (float)(wg02_probs[r] / timePredProbs[r]) + "\t" + nsaf_src_gen.getLongRupName(r));
        }
    }

    public static void simulateSSAF_events() {
        UCERF2 erRateModel2_ERF = new UCERF2();
        erRateModel2_ERF.setParamDefaults();
        erRateModel2_ERF.updateForecast();
        int ssaf_index = 4;
        A_FaultSegmentedSourceGenerator ssaf_src_gen = (A_FaultSegmentedSourceGenerator)erRateModel2_ERF.get_A_FaultSourceGenerators().get(ssaf_index);
        ArrayList<FaultRuptureSource> junk = ssaf_src_gen.getTimeDependentSources(30.0, 2007.0, 0.5, false);
        ssaf_src_gen.simulateEvents(20000);
        junk = ssaf_src_gen.getTimeDependentSources(30.0, 2007.0, 0.5, true);
        ssaf_src_gen.simulateEvents(20000);
    }

    public static void main(String[] args) {
        UCERF2 erRateModel2_ERF = new UCERF2();
        erRateModel2_ERF.getParameter(PROB_MODEL_PARAM_NAME).setValue(PROB_MODEL_POISSON);
        erRateModel2_ERF.updateForecast();
        System.out.println(erRateModel2_ERF.getTotal_BackgroundMFD().getCumRateDistWithOffset());
    }
}

