/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final;

import java.util.ArrayList;
import org.opensha.commons.data.TimeSpan;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2_TimeIndependentEpistemicList;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis.ParamOptions;

public class UCERF2_TimeDependentEpistemicList
extends UCERF2_TimeIndependentEpistemicList {
    public UCERF2_TimeDependentEpistemicList() {
        this.timeSpan = new TimeSpan("Years", "Years");
        this.timeSpan.setDuration(30.0);
        this.timeSpan.setStartTime(2007);
        this.timeSpan.addParameterChangeListener(this);
        System.out.println("timeSpan.getStartTimeYear()=" + this.timeSpan.getStartTimeYear());
    }

    @Override
    protected void fillLogicTreeParams() {
        this.ucerf2.getParameter("Seg Dependent Aperiodicity").setValue(false);
        this.logicTreeParamNames = new ArrayList();
        this.logicTreeParamValues = new ArrayList();
        this.logicTreeParamNames.add("Deformation Model");
        ParamOptions options = new ParamOptions();
        options.addValueWeight("D2.1", 0.25);
        options.addValueWeight("D2.2", 0.1);
        options.addValueWeight("D2.3", 0.15);
        options.addValueWeight("D2.4", 0.25);
        options.addValueWeight("D2.5", 0.1);
        options.addValueWeight("D2.6", 0.15);
        this.logicTreeParamValues.add(options);
        this.logicTreeParamNames.add("Mag-Area Relationship");
        options = new ParamOptions();
        options.addValueWeight("Ellsworth-B (WGCEP, 2002, Eq 4.5b)", 0.5);
        options.addValueWeight("Hanks & Bakun (2002)", 0.5);
        this.logicTreeParamValues.add(options);
        this.logicTreeParamNames.add("A-Fault Solution Type");
        options = new ParamOptions();
        options.addValueWeight("Segmented Model", 0.9);
        options.addValueWeight("Unsegmented Model", 0.1);
        this.logicTreeParamValues.add(options);
        this.logicTreeParamNames.add("Wt On A-Priori Rates");
        options = new ParamOptions();
        options.addValueWeight(1.0E-4, 0.5);
        options.addValueWeight(1.0E10, 0.5);
        this.logicTreeParamValues.add(options);
        this.logicTreeParamNames.add("Connect More B Faults?");
        options = new ParamOptions();
        options.addValueWeight(true, 0.5);
        options.addValueWeight(false, 0.5);
        this.logicTreeParamValues.add(options);
        this.logicTreeParamNames.add("B-Faults b-value");
        options = new ParamOptions();
        options.addValueWeight(0.8, 0.5);
        options.addValueWeight(0.0, 0.5);
        this.logicTreeParamValues.add(options);
        this.logicTreeParamNames.add("Probability Model");
        options = new ParamOptions();
        options.addValueWeight("BPT", 0.7);
        options.addValueWeight("Empirical", 0.3);
        this.logicTreeParamValues.add(options);
        this.logicTreeParamNames.add("Aperiodicity");
        options = new ParamOptions();
        options.addValueWeight(0.3, 0.2);
        options.addValueWeight(0.5, 0.5);
        options.addValueWeight(0.7, 0.3);
        this.logicTreeParamValues.add(options);
    }

    public static void main(String[] args) {
        UCERF2_TimeDependentEpistemicList ucerf2EpistemicList = new UCERF2_TimeDependentEpistemicList();
        ucerf2EpistemicList.getTimeSpan().setStartTime(2013);
        int numERFs = ucerf2EpistemicList.getNumERFs();
        System.out.println("Num Branches=" + numERFs);
        for (int i = 0; i < numERFs; ++i) {
            System.out.println("Weight of Branch " + i + "=\t" + ucerf2EpistemicList.getERF_RelativeWeight(i));
            ucerf2EpistemicList.getERF(i);
        }
    }
}

