/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.DeformationModelPrefDataDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DeformationModelSummaryDB_DAO;
import org.opensha.refFaultParamDb.dao.db.FaultSectionVer2_DB_DAO;
import org.opensha.refFaultParamDb.vo.DeformationModelSummary;
import org.opensha.refFaultParamDb.vo.FaultSectionData;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;

public class CheckFaultSectionDatabase {
    public static void main(String[] args) {
        HashMap<String, Double> prefFaultSectionSlipRates = new HashMap<String, Double>();
        HashMap<String, Double> prefFaultSectionSlipRateStdDevs = new HashMap<String, Double>();
        HashMap<String, Double> prefFaultSectionAseisFactors = new HashMap<String, Double>();
        FaultSectionVer2_DB_DAO faultSectionDAO = new FaultSectionVer2_DB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
        ArrayList<FaultSectionData> faultSectionsList = faultSectionDAO.getAllFaultSections();
        for (int i = 0; i < faultSectionsList.size(); ++i) {
            FaultSectionPrefData faultSectionPrefData = faultSectionsList.get(i).getFaultSectionPrefData();
            prefFaultSectionSlipRates.put(faultSectionPrefData.getSectionName(), faultSectionPrefData.getOrigAveSlipRate());
            prefFaultSectionAseisFactors.put(faultSectionPrefData.getSectionName(), faultSectionPrefData.getAseismicSlipFactor());
            prefFaultSectionSlipRateStdDevs.put(faultSectionPrefData.getSectionName(), faultSectionPrefData.getOrigSlipRateStdDev());
        }
        ArrayList<String> defModels = new ArrayList<String>();
        defModels.add("D2.1");
        defModels.add("D2.2");
        defModels.add("D2.3");
        defModels.add("D2.4");
        defModels.add("D2.5");
        defModels.add("D2.6");
        DeformationModelSummaryDB_DAO defModelSummaryDAO = new DeformationModelSummaryDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
        DeformationModelPrefDataDB_DAO defModelPrefDAO = new DeformationModelPrefDataDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
        for (int i = 0; i < defModels.size(); ++i) {
            String defModelName = (String)defModels.get(i);
            DeformationModelSummary defModelSummary = defModelSummaryDAO.getDeformationModel(defModelName);
            int defModelId = defModelSummary.getDeformationModelId();
            ArrayList<Integer> faultSectionsIdList = defModelPrefDAO.getFaultSectionIdsForDeformationModel(defModelId);
            for (int j = 0; j < faultSectionsIdList.size(); ++j) {
                FaultSectionPrefData defModelData = defModelPrefDAO.getFaultSectionPrefData(defModelId, faultSectionsIdList.get(j));
                String faultName = defModelData.getSectionName();
                double origSlipRate = (Double)prefFaultSectionSlipRates.get(faultName);
                double origAseisFactor = (Double)prefFaultSectionAseisFactors.get(faultName);
                double origSlipRateStdDev = (Double)prefFaultSectionSlipRateStdDevs.get(faultName);
                if (!(Double.isNaN(defModelData.getOrigAveSlipRate()) && Double.isNaN(origSlipRate) || !(Math.abs(defModelData.getOrigAveSlipRate() - origSlipRate) > 1.0E-6))) {
                    System.out.println(faultName + "\tOrigSlipRate\t" + origSlipRate + "\t" + defModelName + "\t" + defModelData.getOrigAveSlipRate());
                }
                if (!(Double.isNaN(defModelData.getOrigSlipRateStdDev()) && Double.isNaN(origSlipRateStdDev) || !(Math.abs(defModelData.getOrigSlipRateStdDev() - origSlipRateStdDev) > 1.0E-6))) {
                    System.out.println(faultName + "\tOrigSlipStdDev\t" + origSlipRateStdDev + "\t" + defModelName + "\t" + defModelData.getOrigSlipRateStdDev());
                }
                if (Double.isNaN(defModelData.getAseismicSlipFactor()) && Double.isNaN(origAseisFactor) || !(Math.abs(defModelData.getAseismicSlipFactor() - origAseisFactor) > 1.0E-6)) continue;
                System.out.println(faultName + "\tOrigAseisSlipFactor\t" + origAseisFactor + "\t" + defModelName + "\t" + defModelData.getAseismicSlipFactor());
            }
        }
    }
}

