/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.griddedForecast.GriddedHypoMagFreqDistForecast;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtLoc;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;

class ERF_ToGriddedParticipationRatesMFD_Forecast
extends GriddedHypoMagFreqDistForecast {
    private AbstractERF eqkRupForecast;
    private HypoMagFreqDistAtLoc[] magFreqDistForLocations;

    public ERF_ToGriddedParticipationRatesMFD_Forecast(AbstractERF eqkRupForecast, GriddedRegion griddedRegion, double minMag, double maxMag, int numMagBins, double duration) {
        this.eqkRupForecast = eqkRupForecast;
        this.setRegion(griddedRegion);
        SummedMagFreqDist[] summedMFDs = this.calcMFD_ForGriddedRegion(minMag, maxMag, numMagBins, duration);
        this.magFreqDistForLocations = new HypoMagFreqDistAtLoc[this.getNumHypoLocs()];
        for (int i = 0; i < this.magFreqDistForLocations.length; ++i) {
            IncrementalMagFreqDist[] magFreqDistArray = new IncrementalMagFreqDist[]{summedMFDs[i]};
            this.magFreqDistForLocations[i] = new HypoMagFreqDistAtLoc(magFreqDistArray, griddedRegion.locationForIndex(i));
        }
    }

    @Override
    public HypoMagFreqDistAtLoc getHypoMagFreqDistAtLoc(int ithLocation) {
        return this.magFreqDistForLocations[ithLocation];
    }

    private SummedMagFreqDist[] calcMFD_ForGriddedRegion(double minMag, double maxMag, int numMagBins, double duration) {
        int numSources = this.eqkRupForecast.getNumSources();
        int numLocations = this.getRegion().getNodeCount();
        SummedMagFreqDist[] summedMFDs = new SummedMagFreqDist[numLocations];
        for (int i = 0; i < numLocations; ++i) {
            summedMFDs[i] = new SummedMagFreqDist(minMag, maxMag, numMagBins);
        }
        for (int sourceIndex = 0; sourceIndex < numSources; ++sourceIndex) {
            ProbEqkSource source = this.eqkRupForecast.getSource(sourceIndex);
            int numRuptures = source.getNumRuptures();
            for (int rupIndex = 0; rupIndex < numRuptures; ++rupIndex) {
                ProbEqkRupture rupture = source.getRupture(rupIndex);
                double mag = rupture.getMag();
                double meanAnnualRate = rupture.getMeanAnnualRate(duration);
                ArrayList<Integer> locIndices = new ArrayList<Integer>();
                RuptureSurface rupSurface = rupture.getRuptureSurface();
                ListIterator<Location> it = rupSurface.getLocationsIterator();
                while (it.hasNext()) {
                    Location ptLoc = it.next();
                    int locIndex = this.getRegion().indexForLocation(ptLoc);
                    if (locIndices.contains(locIndex) || locIndex < 0) continue;
                    locIndices.add(locIndex);
                    summedMFDs[locIndex].addResampledMagRate(mag, meanAnnualRate, true);
                }
            }
        }
        return summedMFDs;
    }
}

