/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.impl.ParameterListParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults.A_FaultSegmentedSourceGenerator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.A_FaultsFetcher;

public class GenerateTestExcelSheets {
    private UCERF2 ucerf2;
    private Parameter magAreaRelParam;
    private Parameter slipModelParam;
    private ParameterListParameter segmentedRupModelParam;
    private ParameterList adjustableParams;
    private ArrayList aFaultSourceGenerators;
    private A_FaultsFetcher aFaultsFetcher;
    private ArrayList magAreaOptions;
    private ArrayList slipModelOptions;

    public GenerateTestExcelSheets() {
        this(new UCERF2());
    }

    public GenerateTestExcelSheets(UCERF2 ucerf2) {
        this.ucerf2 = ucerf2;
        this.adjustableParams = ucerf2.getAdjustableParameterList();
        this.magAreaRelParam = ucerf2.getParameter("Mag-Area Relationship");
        this.segmentedRupModelParam = (ParameterListParameter)ucerf2.getParameter("Segmented A-Fault Solution Types");
        this.slipModelParam = ucerf2.getParameter("A-Fault Slip Model");
        this.aFaultsFetcher = ucerf2.getA_FaultsFetcher();
        this.magAreaOptions = ((StringConstraint)this.magAreaRelParam.getConstraint()).getAllowedStrings();
        this.slipModelOptions = ((StringConstraint)this.slipModelParam.getConstraint()).getAllowedStrings();
    }

    public void mkExcelSheetTests() {
        this.ucerf2.setParamDefaults();
        this.generateExcelSheetsForRupMagRates("Test1_A_FaultRupRates.xls");
        this.generateExcelSheetsForNormResSR_And_ER("Test1_A_FaultNormResids.xls");
        this.ucerf2.getParameter("Fraction Smaller Events & Aftershocks").setValue(0.0);
        this.generateExcelSheetsForRupMagRates("Test2_A_FaultRupRates.xls");
        this.generateExcelSheetsForNormResSR_And_ER("Test2_A_FaultNormResids.xls");
        this.ucerf2.setParamDefaults();
        this.ucerf2.getParameter("Mean Mag Correction").setValue(0.1);
        this.generateExcelSheetsForRupMagRates("Test3_A_FaultRupRates.xls");
        this.generateExcelSheetsForNormResSR_And_ER("Test3_A_FaultNormResids.xls");
        this.ucerf2.getParameter("Mean Mag Correction").setValue(-0.1);
        this.generateExcelSheetsForRupMagRates("Test4_A_FaultRupRates.xls");
        this.generateExcelSheetsForNormResSR_And_ER("Test4_A_FaultNormResids.xls");
        this.ucerf2.setParamDefaults();
        this.ucerf2.getParameter("Deformation Model").setValue("D2.2");
        this.generateExcelSheetsForRupMagRates("Test5_A_FaultRupRates.xls");
        this.generateExcelSheetsForNormResSR_And_ER("Test5_A_FaultNormResids.xls");
        this.ucerf2.getParameter("Deformation Model").setValue("D2.3");
        this.generateExcelSheetsForRupMagRates("Test6_A_FaultRupRates.xls");
        this.generateExcelSheetsForNormResSR_And_ER("Test6_A_FaultNormResids.xls");
    }

    private void generateExcelSheetsForRupMagRates(String outputFileName) {
        System.out.println(outputFileName);
        int numA_Faults = this.aFaultsFetcher.getAllFaultNames().size();
        String[] columnHeaders = new String[]{"Rup_Name", "A-Priori Rate", "Char Mag", "Char Rate"};
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setColor((short)10);
        cellStyle.setFont(font);
        HSSFSheet metadataSheet = wb.createSheet();
        wb.setSheetName(0, "README");
        String metadataStr = "This file contains final (post-inversion) rupture rates for the four different magnitude-area relationships, the four slip models, and the three solution types (min rate, max rate, and geologic insight).  All other parameters were set as listed below.  The sheet for each fault lists the following for each solution type: rupture name; the a-prior rate; the characteristic magnitude and characteristic rate resulting from the characteristic-slip model (which does not use a magnitude-area relationship); and the rates for the other three slip models for each magnitude-area relationship (twelve columns).  Listed at the bottom of the sheet for each fault are the following total-rate ratios: min/geol, max/geol, and max/min (useful for seeing the extent to which the different a-priori models converge to the same final rates).  The \"Total Rates\" sheet lists the total rates (summed over all faults) for each case.  The \"Gen. Pred. Err\" sheet lists the generalized prediction errors for each case (smaller values mean a better overall fit to the slip-rate and total segment event-rate data).";
        this.writeMetadata(wb, cellStyle, metadataSheet, metadataStr);
        for (int i = 0; i < numA_Faults; ++i) {
            wb.createSheet();
        }
        HSSFSheet genPredErrSheet = wb.createSheet();
        wb.setSheetName(wb.getNumberOfSheets() - 1, "Gen. Pred. Err");
        HSSFSheet totalRatesSheet = wb.createSheet();
        wb.setSheetName(wb.getNumberOfSheets() - 1, "Total Rates");
        int[] currRow = new int[numA_Faults];
        for (int irup = 0; irup < 3; ++irup) {
            int[] rupStartRow = new int[numA_Faults];
            ListIterator it = this.segmentedRupModelParam.getParametersIterator();
            while (it.hasNext()) {
                StringParameter param = (StringParameter)it.next();
                ArrayList<String> allowedVals = param.getAllowedStrings();
                param.setValue(allowedVals.get(irup));
            }
            for (int imag = 0; imag < this.magAreaOptions.size(); ++imag) {
                for (int islip = 0; islip < this.slipModelOptions.size(); ++islip) {
                    int rup;
                    HSSFSheet sheet;
                    int i;
                    this.magAreaRelParam.setValue(this.magAreaOptions.get(imag));
                    this.slipModelParam.setValue(this.slipModelOptions.get(islip));
                    this.ucerf2.updateForecast();
                    this.aFaultSourceGenerators = this.ucerf2.get_A_FaultSourceGenerators();
                    this.genPredErrAndTotRateSheet(genPredErrSheet, totalRatesSheet, imag, islip, irup, cellStyle);
                    if (imag == 0 && islip == 0) {
                        for (i = 0; i < this.aFaultSourceGenerators.size(); ++i) {
                            HSSFRow row;
                            sheet = wb.getSheetAt(i + 1);
                            String sheetName = ((A_FaultSegmentedSourceGenerator)this.aFaultSourceGenerators.get(i)).getFaultSegmentData().getFaultName();
                            wb.setSheetName(i + 1, sheetName);
                            this.generateExcelSheetHeader(cellStyle, currRow[i], irup, sheet, columnHeaders);
                            int n = i;
                            currRow[n] = currRow[n] + 3;
                            A_FaultSegmentedSourceGenerator source = (A_FaultSegmentedSourceGenerator)this.aFaultSourceGenerators.get(i);
                            rupStartRow[i] = currRow[i];
                            for (rup = 0; rup < source.getNumRupSources(); ++rup) {
                                int n2 = i;
                                int n3 = currRow[n2];
                                currRow[n2] = n3 + 1;
                                row = sheet.createRow((int)((short)n3));
                                row.createCell(0).setCellValue(source.getLongRupName(rup));
                                row.createCell(1).setCellValue(source.getAPrioriRupRate(rup));
                            }
                            int n4 = i;
                            int n5 = currRow[n4];
                            currRow[n4] = n5 + 1;
                            row = sheet.createRow((int)((short)n5));
                            int totRow1 = currRow[i];
                            int totRow2 = 2 * totRow1 + 2;
                            int totRow3 = 3 * totRow1 + 4;
                            int ratioRowIndex1 = totRow3 + 2;
                            this.createTotalRow(row, rupStartRow[i], rupStartRow[i] + source.getNumRupSources());
                            if (irup != 0) continue;
                            this.createRatioRows(sheet, ratioRowIndex1, totRow1, totRow2, totRow3);
                        }
                    }
                    for (i = 0; i < this.aFaultSourceGenerators.size(); ++i) {
                        sheet = wb.getSheetAt(i + 1);
                        A_FaultSegmentedSourceGenerator source = (A_FaultSegmentedSourceGenerator)this.aFaultSourceGenerators.get(i);
                        int magCol = this.getMagCol(islip, imag);
                        int rateCol = this.getRateCol(islip, imag);
                        for (rup = 0; rup < source.getNumRupSources(); ++rup) {
                            sheet.getRow(rup + rupStartRow[i]).createCell((int)((short)magCol)).setCellValue(source.getRupMeanMag(rup));
                            sheet.getRow(rup + rupStartRow[i]).createCell((int)((short)rateCol)).setCellValue(source.getRupRate(rup));
                        }
                    }
                }
            }
            for (int i = 1; i < wb.getNumberOfSheets() - 2; ++i) {
                HSSFSheet sheet = wb.getSheetAt(i);
                int n = i - 1;
                int n6 = currRow[n];
                currRow[n] = n6 + 1;
                sheet.createRow((int)((short)n6));
                int n7 = i - 1;
                int n8 = currRow[n7];
                currRow[n7] = n8 + 1;
                sheet.createRow((int)((short)n8));
            }
        }
        try {
            FileOutputStream fileOut = new FileOutputStream(outputFileName);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateExcelSheetsForNormResSR_And_ER(String outputFileName) {
        System.out.println(outputFileName);
        int numA_Faults = this.aFaultsFetcher.getAllFaultNames().size();
        String[] columnHeaders = new String[]{"Segment Name", "A-Priori Rate", "Char Mag", "Char Rate"};
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setColor((short)10);
        cellStyle.setFont(font);
        HSSFSheet metadataSheet = wb.createSheet();
        wb.setSheetName(0, "README");
        String metadataStr = "This file contains normalized residuals for each segment and for each combination of parameters.";
        this.writeMetadata(wb, cellStyle, metadataSheet, metadataStr);
        for (int i = 0; i < numA_Faults; ++i) {
            wb.createSheet();
        }
        int[] currRow = new int[numA_Faults];
        for (int irup = 0; irup < 3; ++irup) {
            int[] segSRStartRow = new int[numA_Faults];
            int[] segERStartRow = new int[numA_Faults];
            ListIterator it = this.segmentedRupModelParam.getParametersIterator();
            while (it.hasNext()) {
                StringParameter param = (StringParameter)it.next();
                ArrayList<String> allowedVals = param.getAllowedStrings();
                param.setValue(allowedVals.get(irup));
            }
            for (int imag = 0; imag < this.magAreaOptions.size(); ++imag) {
                for (int islip = 0; islip < this.slipModelOptions.size(); ++islip) {
                    int seg;
                    HSSFSheet sheet;
                    int i;
                    this.magAreaRelParam.setValue(this.magAreaOptions.get(imag));
                    this.slipModelParam.setValue(this.slipModelOptions.get(islip));
                    this.ucerf2.updateForecast();
                    this.aFaultSourceGenerators = this.ucerf2.get_A_FaultSourceGenerators();
                    if (imag == 0 && islip == 0) {
                        for (i = 0; i < this.aFaultSourceGenerators.size(); ++i) {
                            HSSFRow row;
                            sheet = wb.getSheetAt(i + 1);
                            String sheetName = ((A_FaultSegmentedSourceGenerator)this.aFaultSourceGenerators.get(i)).getFaultSegmentData().getFaultName();
                            wb.setSheetName(i + 1, sheetName);
                            A_FaultSegmentedSourceGenerator source = (A_FaultSegmentedSourceGenerator)this.aFaultSourceGenerators.get(i);
                            FaultSegmentData faultSegmentData = source.getFaultSegmentData();
                            int n = i;
                            int n2 = currRow[n];
                            currRow[n] = n2 + 1;
                            sheet.createRow((int)((short)n2)).createCell(0).setCellValue("Normalized Residual Slip Rate");
                            this.generateExcelSheetHeader(cellStyle, currRow[i], irup, sheet, columnHeaders);
                            int n3 = i;
                            currRow[n3] = currRow[n3] + 3;
                            segSRStartRow[i] = currRow[i];
                            for (seg = 0; seg < faultSegmentData.getNumSegments(); ++seg) {
                                int n4 = i;
                                int n5 = currRow[n4];
                                currRow[n4] = n5 + 1;
                                row = sheet.createRow((int)((short)n5));
                                row.createCell(0).setCellValue(faultSegmentData.getSegmentName(seg));
                            }
                            int n6 = i;
                            currRow[n6] = currRow[n6] + 3;
                            int n7 = i;
                            int n8 = currRow[n7];
                            currRow[n7] = n8 + 1;
                            sheet.createRow((int)((short)n8)).createCell(0).setCellValue("Normalized Residual Event Rates");
                            this.generateExcelSheetHeader(cellStyle, currRow[i], irup, sheet, columnHeaders);
                            int n9 = i;
                            currRow[n9] = currRow[n9] + 3;
                            segERStartRow[i] = currRow[i];
                            for (seg = 0; seg < faultSegmentData.getNumSegments(); ++seg) {
                                int n10 = i;
                                int n11 = currRow[n10];
                                currRow[n10] = n11 + 1;
                                row = sheet.createRow((int)((short)n11));
                                row.createCell(0).setCellValue(faultSegmentData.getSegmentName(seg));
                            }
                        }
                    }
                    for (i = 0; i < this.aFaultSourceGenerators.size(); ++i) {
                        sheet = wb.getSheetAt(i + 1);
                        A_FaultSegmentedSourceGenerator source = (A_FaultSegmentedSourceGenerator)this.aFaultSourceGenerators.get(i);
                        double[] normModSR = source.getNormModSlipRateResids();
                        double[] normModER = source.getNormDataER_Resids();
                        int rateCol = this.getRateCol(islip, imag);
                        for (seg = 0; seg < normModSR.length; ++seg) {
                            sheet.getRow(seg + segSRStartRow[i]).createCell((int)((short)rateCol)).setCellValue(normModSR[seg]);
                            sheet.getRow(seg + segERStartRow[i]).createCell((int)((short)rateCol)).setCellValue(normModER[seg]);
                        }
                    }
                }
            }
            for (int i = 1; i < wb.getNumberOfSheets(); ++i) {
                HSSFSheet sheet = wb.getSheetAt(i);
                int n = i - 1;
                int n12 = currRow[n];
                currRow[n] = n12 + 1;
                sheet.createRow((int)((short)n12));
                int n13 = i - 1;
                int n14 = currRow[n13];
                currRow[n13] = n14 + 1;
                sheet.createRow((int)((short)n14));
            }
        }
        try {
            FileOutputStream fileOut = new FileOutputStream(outputFileName);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeMetadata(HSSFWorkbook wb, HSSFCellStyle cellStyle, HSSFSheet metadataSheet, String metadataStr) {
        metadataSheet.setColumnWidth(0, 32000);
        metadataSheet.createRow(0).createCell(0).setCellValue(metadataStr);
        HSSFCellStyle wrapCellStyle = wb.createCellStyle();
        wrapCellStyle.setWrapText(true);
        metadataSheet.getRow(0).getCell(0).setCellStyle(wrapCellStyle);
        metadataSheet.createRow(2).createCell(0).setCellValue("Parameter Settings");
        metadataSheet.getRow(2).getCell(0).setCellStyle(cellStyle);
        int row = 3;
        ListIterator<Parameter<?>> it = this.adjustableParams.getParametersIterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            if (param.getName().equals("Mag-Area Relationship") || param.getName().equals("A-Fault Slip Model") || param.getName().equals("Segmented A-Fault Solution Types")) continue;
            metadataSheet.createRow(row++).createCell(0).setCellValue(param.getMetadataString());
        }
    }

    private int getRateCol(int islip, int imag) {
        if (this.slipModelOptions.get(islip).equals("Characteristic (Dsr=Ds)")) {
            return 3;
        }
        return this.getMagCol(islip, imag) + islip;
    }

    private int getMagCol(int islip, int imag) {
        if (this.slipModelOptions.get(islip).equals("Characteristic (Dsr=Ds)")) {
            return 2;
        }
        return 4 + imag * this.slipModelOptions.size();
    }

    private void createRatioRows(HSSFSheet sheet, int ratioRowIndex1, int totRow1, int totRow2, int totRow3) {
        HSSFRow ratioRow1 = null;
        HSSFRow ratioRow2 = null;
        HSSFRow ratioRow3 = null;
        ratioRow1 = sheet.createRow((int)((short)ratioRowIndex1));
        ratioRow2 = sheet.createRow((int)((short)(ratioRowIndex1 + 1)));
        ratioRow3 = sheet.createRow((int)((short)(ratioRowIndex1 + 2)));
        ratioRow1.createCell(0).setCellValue("min/geol");
        ratioRow2.createCell(0).setCellValue("max/geol");
        ratioRow3.createCell(0).setCellValue("max/min");
        Object colStr = "B";
        HSSFCell cell = ratioRow1.createCell(1);
        cell.setCellType(2);
        cell.setCellFormula((String)colStr + totRow2 + "/" + (String)colStr + totRow1);
        cell = ratioRow2.createCell(1);
        cell.setCellType(2);
        cell.setCellFormula((String)colStr + totRow3 + "/" + (String)colStr + totRow1);
        cell = ratioRow3.createCell(1);
        cell.setCellType(2);
        cell.setCellFormula((String)colStr + totRow3 + "/" + (String)colStr + totRow2);
        colStr = "D";
        cell = ratioRow1.createCell(3);
        cell.setCellType(2);
        cell.setCellFormula((String)colStr + totRow2 + "/" + (String)colStr + totRow1);
        cell = ratioRow2.createCell(3);
        cell.setCellType(2);
        cell.setCellFormula((String)colStr + totRow3 + "/" + (String)colStr + totRow1);
        cell = ratioRow3.createCell(3);
        cell.setCellType(2);
        cell.setCellFormula((String)colStr + totRow3 + "/" + (String)colStr + totRow2);
        for (int k = 0; k < this.slipModelOptions.size(); ++k) {
            if (this.slipModelOptions.get(k).equals("Characteristic (Dsr=Ds)")) continue;
            for (int j = 0; j < this.magAreaOptions.size(); ++j) {
                int totCol = 4 + j * this.slipModelOptions.size() + k;
                colStr = "" + (char)(65 + totCol);
                cell = ratioRow1.createCell((int)((short)totCol));
                cell.setCellType(2);
                cell.setCellFormula((String)colStr + totRow2 + "/" + (String)colStr + totRow1);
                cell = ratioRow2.createCell((int)((short)totCol));
                cell.setCellType(2);
                cell.setCellFormula((String)colStr + totRow3 + "/" + (String)colStr + totRow1);
                cell = ratioRow3.createCell((int)((short)totCol));
                cell.setCellType(2);
                cell.setCellFormula((String)colStr + totRow3 + "/" + (String)colStr + totRow2);
            }
        }
    }

    private void createTotalRow(HSSFRow row, int sumStartIndex, int sumEndIndex) {
        row.createCell(0).setCellValue("Totals");
        HSSFCell cell = row.createCell(1);
        Object colStr = "B";
        cell.setCellType(2);
        cell.setCellFormula("SUM(" + (String)colStr + sumStartIndex + ":" + (String)colStr + sumEndIndex + ")");
        cell = row.createCell(3);
        colStr = "D";
        cell.setCellType(2);
        cell.setCellFormula("SUM(" + (String)colStr + sumStartIndex + ":" + (String)colStr + sumEndIndex + ")");
        for (int k = 0; k < this.slipModelOptions.size(); ++k) {
            if (this.slipModelOptions.get(k).equals("Characteristic (Dsr=Ds)")) continue;
            for (int j = 0; j < this.magAreaOptions.size(); ++j) {
                int totCol = 4 + j * this.slipModelOptions.size() + k;
                cell = row.createCell((int)((short)totCol));
                colStr = "" + (char)(65 + totCol);
                cell.setCellType(2);
                cell.setCellFormula("SUM(" + (String)colStr + sumStartIndex + ":" + (String)colStr + sumEndIndex + ")");
            }
        }
    }

    private void generateExcelSheetHeader(HSSFCellStyle cellStyle, int rowIndex, int irup, HSSFSheet sheet, String[] columLabels) {
        String[] models = new String[]{"Geological Insight", "Min Rate", "Max Rate"};
        HSSFRow row = sheet.createRow((int)((short)rowIndex++));
        HSSFCell cell = row.createCell(0);
        cell.setCellValue(models[irup]);
        cell.setCellStyle(cellStyle);
        row = sheet.createRow((int)((short)rowIndex++));
        int col = 4;
        int j = 0;
        while (j < this.magAreaOptions.size()) {
            cell = row.createCell((int)((short)col));
            cell.setCellValue((String)this.magAreaOptions.get(j));
            cell.setCellStyle(cellStyle);
            ++j;
            col += this.slipModelOptions.size();
        }
        row = sheet.createRow((int)((short)rowIndex++));
        col = 0;
        cell = row.createCell((int)((short)col++));
        cell.setCellValue("Rup_Name");
        cell.setCellStyle(cellStyle);
        cell = row.createCell((int)((short)col++));
        cell.setCellValue("A-Priori Rate");
        cell.setCellStyle(cellStyle);
        cell = row.createCell((int)((short)col++));
        cell.setCellValue("Char Mag");
        cell.setCellStyle(cellStyle);
        cell = row.createCell((int)((short)col++));
        cell.setCellValue("Char Rate");
        cell.setCellStyle(cellStyle);
        for (j = 0; j < this.magAreaOptions.size(); ++j) {
            cell = row.createCell((int)((short)col++));
            cell.setCellValue("Mag");
            cell.setCellStyle(cellStyle);
            for (int k = 0; k < this.slipModelOptions.size(); ++k) {
                String slipModel = (String)this.slipModelOptions.get(k);
                if (slipModel.equals("Characteristic (Dsr=Ds)")) continue;
                cell = row.createCell((int)((short)col++));
                cell.setCellValue((String)this.slipModelOptions.get(k));
                cell.setCellStyle(cellStyle);
            }
        }
    }

    private void genPredErrAndTotRateSheet(HSSFSheet predErrSheet, HSSFSheet totRateSheet, int imag, int islip, int irup, HSSFCellStyle cellStyle) {
        int rupIndex;
        String[] columnHeaders1 = new String[]{"Fault Name", "A-Priori Rate", "Char Mag", "Char Rate"};
        String[] columnHeaders2 = new String[]{"Total", "A-Priori Rate", "Char Mag", "Char Rate"};
        int numA_Faults = this.aFaultsFetcher.getAllFaultNames().size();
        double totRate = 0.0;
        int currRow = irup * (numA_Faults + 6);
        int faultNamesStartRow = currRow + 3;
        if (irup == 0) {
            int ratioRowIndex1 = 2 * (numA_Faults + 6) + 3 + 3;
            int totRow1 = faultNamesStartRow + 1;
            int totRow2 = numA_Faults + 6 + 3 + 1;
            int n = 2 * (numA_Faults + 6) + 3 + 1;
        }
        if (imag == 0 && islip == 0) {
            this.generateExcelSheetHeader(cellStyle, currRow, irup, predErrSheet, columnHeaders1);
            this.generateExcelSheetHeader(cellStyle, currRow, irup, totRateSheet, columnHeaders2);
            currRow += 3;
            totRate = 0.0;
            for (int iSource = 0; iSource < this.aFaultSourceGenerators.size(); ++iSource) {
                HSSFRow row1 = predErrSheet.createRow((int)((short)(faultNamesStartRow + iSource)));
                A_FaultSegmentedSourceGenerator src = (A_FaultSegmentedSourceGenerator)this.aFaultSourceGenerators.get(iSource);
                for (rupIndex = 0; rupIndex < src.getNumRupSources(); ++rupIndex) {
                    totRate += src.getAPrioriRupRate(rupIndex);
                }
                row1.createCell(0).setCellValue(src.getFaultSegmentData().getFaultName());
            }
            totRateSheet.createRow(faultNamesStartRow).createCell(0).setCellValue("Total Rate");
            totRateSheet.getRow(faultNamesStartRow).createCell(1).setCellValue(totRate);
            currRow += this.aFaultSourceGenerators.size();
            HSSFRow row1 = predErrSheet.createRow((int)((short)currRow++));
            this.createTotalRow(row1, faultNamesStartRow, faultNamesStartRow + numA_Faults);
        }
        int col = this.getRateCol(islip, imag);
        totRate = 0.0;
        for (int i = 0; i < this.aFaultSourceGenerators.size(); ++i) {
            A_FaultSegmentedSourceGenerator source = (A_FaultSegmentedSourceGenerator)this.aFaultSourceGenerators.get(i);
            for (rupIndex = 0; rupIndex < source.getNumRupSources(); ++rupIndex) {
                totRate += source.getRupRate(rupIndex);
            }
            predErrSheet.getRow(i + faultNamesStartRow).createCell((int)((short)col)).setCellValue(source.getGeneralizedPredictionError());
        }
        totRateSheet.getRow(faultNamesStartRow).createCell((int)((short)col)).setCellValue(totRate);
    }

    public static void main(String[] args) {
        GenerateTestExcelSheets genExcelSheets = new GenerateTestExcelSheets();
        genExcelSheets.mkExcelSheetTests();
    }
}

