/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.WarningParameter;
import org.opensha.commons.param.event.ParameterChangeWarningEvent;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.BA_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CB_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CY_2008_AttenRel;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;

public class HazardProfileCalculator
implements ParameterChangeWarningListener {
    private final double GRID_SPACING = 0.05;
    private final DoubleParameter VS_30_PARAM;
    private final DepthTo2pt5kmPerSecParam DEPTH_2_5KM_PARAM = new DepthTo2pt5kmPerSecParam(2.0);
    private final DepthTo1pt0kmPerSecParam DEPTH_1_0KM_PARAM = new DepthTo1pt0kmPerSecParam();
    private final Vs30_TypeParam VS_30_TYPE_PARAM = new Vs30_TypeParam();
    private final DecimalFormat latLonFormat = new DecimalFormat("0.00");
    private final DecimalFormat periodFormat = new DecimalFormat("0.0");
    private MeanUCERF2 meanUCERF2;
    private ScalarIMR imr;
    private HazardCurveCalculator hazardCurveCalculator;

    HazardProfileCalculator(double lat, double minLon, double maxLon, String imrID, double period, double vs30, ArbitrarilyDiscretizedFunc function, String outDir) {
        this.VS_30_PARAM = new DoubleParameter("Vs30", vs30);
        try {
            String imt = period == 0.0 ? "PGA" : "SA";
            Object imtString = imt;
            imtString = (String)imtString + (String)(period != 0.0 ? "_" + this.periodFormat.format(period) + "sec" : "");
            System.out.println("Setting up ERF: " + (String)imtString + " at " + lat);
            this.setupERF();
            System.out.println("Setting up IMR: " + (String)imtString + " at " + lat);
            this.setupIMR(imrID);
            this.imr.setIntensityMeasure(imt);
            if (imt != "PGA") {
                this.imr.getParameter("SA Period").setValue(period);
            }
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet();
            sheet.createRow(0);
            int numX_Vals = function.size();
            for (int i = 0; i < numX_Vals; ++i) {
                sheet.createRow(i + 1).createCell(0).setCellValue(function.getX(i));
            }
            int twoPercentProbRoIndex = numX_Vals + 2;
            int tenPercentProbRoIndex = numX_Vals + 3;
            sheet.createRow(twoPercentProbRoIndex).createCell(0).setCellValue("2% PE");
            sheet.createRow(tenPercentProbRoIndex).createCell(0).setCellValue("10% PE");
            this.hazardCurveCalculator = new HazardCurveCalculator();
            File outputDir = new File(outDir);
            outputDir.mkdirs();
            String outputFileName = outDir + "/" + imrID + "_" + this.periodFormat.format(lat) + "_" + (String)imtString + "_vs" + Double.valueOf(vs30).intValue() + ".xls";
            int colIndex = 1;
            double lon = minLon;
            while (lon <= maxLon) {
                double tenPercentProb;
                double twoPercentProb;
                int i;
                System.out.println("Doing Site :" + this.latLonFormat.format(lat) + "," + this.latLonFormat.format(lon) + " " + (String)imtString);
                this.DEPTH_2_5KM_PARAM.setValueAsDefault();
                if (vs30 == 760.0) {
                    this.DEPTH_1_0KM_PARAM.setValue(40.0);
                } else if (vs30 == 259.0) {
                    this.DEPTH_1_0KM_PARAM.setValue(330.0);
                }
                Site site = new Site(new Location(lat, lon));
                site.addParameter(this.VS_30_PARAM);
                site.addParameter(this.DEPTH_2_5KM_PARAM);
                site.addParameter(this.DEPTH_1_0KM_PARAM);
                site.addParameter(this.VS_30_TYPE_PARAM);
                ArbitrarilyDiscretizedFunc hazFunc = new ArbitrarilyDiscretizedFunc();
                for (int i2 = 0; i2 < numX_Vals; ++i2) {
                    hazFunc.set(Math.log(function.getX(i2)), 1.0);
                }
                this.hazardCurveCalculator.getHazardCurve((DiscretizedFunc)hazFunc, site, this.imr, (ERF)this.meanUCERF2);
                ArbitrarilyDiscretizedFunc newFunc = new ArbitrarilyDiscretizedFunc();
                for (i = 0; i < numX_Vals; ++i) {
                    newFunc.set(function.getX(i), hazFunc.getY(i));
                }
                try {
                    twoPercentProb = newFunc.getFirstInterpolatedX_inLogXLogYDomain(0.02);
                }
                catch (InvalidRangeException ire) {
                    twoPercentProb = 0.0;
                }
                try {
                    tenPercentProb = newFunc.getFirstInterpolatedX_inLogXLogYDomain(0.1);
                }
                catch (InvalidRangeException ire) {
                    tenPercentProb = 0.0;
                }
                sheet.getRow(0).createCell((int)((short)colIndex)).setCellValue(this.latLonFormat.format(lon));
                for (i = 0; i < numX_Vals; ++i) {
                    sheet.createRow(i + 1).createCell((int)((short)colIndex)).setCellValue(newFunc.getY(i));
                }
                sheet.createRow(twoPercentProbRoIndex).createCell((int)((short)colIndex)).setCellValue(twoPercentProb);
                sheet.createRow(tenPercentProbRoIndex).createCell((int)((short)colIndex)).setCellValue(tenPercentProb);
                lon += 0.05;
                ++colIndex;
            }
            FileOutputStream fileOut = new FileOutputStream(outputFileName);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private void setupERF() {
        this.meanUCERF2 = new MeanUCERF2();
        this.meanUCERF2.setParameter("Rupture Offset", 5.0);
        this.meanUCERF2.setParameter("Apply CyberShake DDW Corr", false);
        this.meanUCERF2.setParameter("Probability Model", "Poisson");
        this.meanUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_INCLUDE);
        this.meanUCERF2.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_CROSSHAIR);
        this.meanUCERF2.setParameter("Floater Type", "Along strike & centered down dip");
        this.meanUCERF2.getTimeSpan().setDuration(50.0);
        this.meanUCERF2.updateForecast();
    }

    private void setupIMR(String id) {
        if (id == "BA") {
            this.imr = new BA_2008_AttenRel(this);
        } else if (id == "CB") {
            this.imr = new CB_2008_AttenRel(this);
        } else if (id == "CY") {
            this.imr = new CY_2008_AttenRel(this);
        }
        this.imr.setParamDefaults();
        this.imr.getParameter("Gaussian Truncation").setValue("1 Sided");
        this.imr.getParameter("Truncation Level").setValue(3.0);
    }

    @Override
    public void parameterChangeWarning(ParameterChangeWarningEvent e) {
        String S = " : parameterChangeWarning(): ";
        WarningParameter param = e.getWarningParameter();
        param.setValueIgnoreWarning(e.getNewValue());
    }
}

