/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Frankel02_AdjustableEqkRupForecast;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2_TimeIndependentEpistemicList;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;

public class LogicTreeMFDsPlotter {
    private static final String X_AXIS_LABEL = "Magnitude";
    private static final String CUM_Y_AXIS_LABEL = "Cumulative Rate (per year)";
    private static final String INCR_Y_AXIS_LABEL = "Incremental Rate (per year)";
    protected ArrayList<IncrementalMagFreqDist> aFaultMFDsList;
    protected ArrayList<IncrementalMagFreqDist> bFaultCharMFDsList;
    protected ArrayList<IncrementalMagFreqDist> bFaultGRMFDsList;
    protected ArrayList<IncrementalMagFreqDist> totMFDsList;
    protected ArrayList<IncrementalMagFreqDist> nonCA_B_FaultsMFDsList;
    private IncrementalMagFreqDist cZoneMFD;
    private IncrementalMagFreqDist bckMFD;
    private IncrementalMagFreqDist nshmp02TotMFD;
    private static final String DEFAULT_PATH = "data/logicTreeMFDs/";
    private static final String BCK_FRAC_PATH = "data/logicTreeMFDs/BackGrdFrac0_1/";
    private static final String BFAULT_BVAL_PATH = "data/logicTreeMFDs/BFault_BVal0/";
    protected static final String A_FAULTS_MFD_FILENAME = "A_Faults_MFDs.txt";
    protected static final String B_FAULTS_CHAR_MFD_FILENAME = "B_FaultsCharMFDs.txt";
    protected static final String B_FAULTS_GR_MFD_FILENAME = "B_FaultsGR_MFDs.txt";
    protected static final String NON_CA_B_FAULTS_MFD_FILENAME = "Non_CA_B_Faults_MFDs.txt";
    protected static final String TOT_MFD_FILENAME = "TotMFDs.txt";
    private static final String NSHMP_02_MFD_FILENAME = "NSHMP02_MFDs.txt";
    private static final String METADATA_EXCEL_SHEET = "Metadata.xls";
    private static final String COMBINED_AVG_FILENAME = "CombinedAvgMFDs.txt";
    protected final PlotCurveCharacterstics PLOT_CHAR1 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE);
    private final PlotCurveCharacterstics PLOT_CHAR1_1 = new PlotCurveCharacterstics(PlotLineType.DOTTED_AND_DASHED, 2.0f, Color.BLUE);
    private final PlotCurveCharacterstics PLOT_CHAR1_2 = new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE);
    private final PlotCurveCharacterstics PLOT_CHAR1_3 = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, PlotSymbol.FILLED_CIRCLE, 4.0f, Color.BLUE);
    protected final PlotCurveCharacterstics PLOT_CHAR2 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.LIGHT_GRAY);
    private final PlotCurveCharacterstics PLOT_CHAR2_1 = new PlotCurveCharacterstics(PlotLineType.DOTTED_AND_DASHED, 2.0f, Color.LIGHT_GRAY);
    private final PlotCurveCharacterstics PLOT_CHAR2_2 = new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.LIGHT_GRAY);
    private final PlotCurveCharacterstics PLOT_CHAR2_3 = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, PlotSymbol.FILLED_CIRCLE, 4.0f, Color.LIGHT_GRAY);
    protected final PlotCurveCharacterstics PLOT_CHAR3 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN);
    private final PlotCurveCharacterstics PLOT_CHAR3_1 = new PlotCurveCharacterstics(PlotLineType.DOTTED_AND_DASHED, 2.0f, Color.GREEN);
    private final PlotCurveCharacterstics PLOT_CHAR3_2 = new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GREEN);
    private final PlotCurveCharacterstics PLOT_CHAR3_3 = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, PlotSymbol.FILLED_CIRCLE, 4.0f, Color.GREEN);
    protected final PlotCurveCharacterstics PLOT_CHAR10 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.ORANGE);
    protected final PlotCurveCharacterstics PLOT_CHAR4 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK);
    private final PlotCurveCharacterstics PLOT_CHAR4_1 = new PlotCurveCharacterstics(PlotLineType.DOTTED_AND_DASHED, 2.0f, Color.BLACK);
    private final PlotCurveCharacterstics PLOT_CHAR4_2 = new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLACK);
    private final PlotCurveCharacterstics PLOT_CHAR4_3 = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, PlotSymbol.FILLED_CIRCLE, 4.0f, Color.BLACK);
    protected final PlotCurveCharacterstics PLOT_CHAR5 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.MAGENTA);
    private final PlotCurveCharacterstics PLOT_CHAR5_1 = new PlotCurveCharacterstics(PlotLineType.DOTTED_AND_DASHED, 2.0f, Color.MAGENTA);
    private final PlotCurveCharacterstics PLOT_CHAR5_2 = new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.MAGENTA);
    protected final PlotCurveCharacterstics PLOT_CHAR6 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.PINK);
    protected final PlotCurveCharacterstics PLOT_CHAR7 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED);
    protected final PlotCurveCharacterstics PLOT_CHAR8 = new PlotCurveCharacterstics(PlotSymbol.CROSS, 5.0f, Color.RED);
    protected final PlotCurveCharacterstics PLOT_CHAR9 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(188, 143, 143));
    protected ArrayList funcs;
    protected ArrayList<PlotCurveCharacterstics> plottingFeaturesList = new ArrayList();
    private boolean isCumulative;
    private HSSFSheet excelSheet;
    private ArrayList<String> adjustableParamNames;
    private UCERF2_TimeIndependentEpistemicList ucerf2List = new UCERF2_TimeIndependentEpistemicList();
    protected UCERF2 ucerf2 = (UCERF2)this.ucerf2List.getERF(0);

    public LogicTreeMFDsPlotter() {
        this.aFaultMFDsList = new ArrayList();
        this.bFaultCharMFDsList = new ArrayList();
        this.bFaultGRMFDsList = new ArrayList();
        this.nonCA_B_FaultsMFDsList = new ArrayList();
        this.totMFDsList = new ArrayList();
    }

    public void generateMFDsData(String path) {
        if (path == null) {
            path = DEFAULT_PATH;
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        this.excelSheet = wb.createSheet();
        ParameterList adjustableParams = this.ucerf2.getAdjustableParameterList();
        ListIterator<Parameter<?>> it = adjustableParams.getParametersIterator();
        this.adjustableParamNames = new ArrayList();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            this.adjustableParamNames.add(param.getName());
        }
        HSSFRow row = this.excelSheet.createRow(0);
        for (int i = 1; i <= this.adjustableParamNames.size(); ++i) {
            if (i <= 0) continue;
            row.createCell((int)((short)i)).setCellValue(this.adjustableParamNames.get(i - 1));
        }
        int colNum = adjustableParams.size() + 1;
        row.createCell((int)((short)colNum)).setCellValue("M 6.5 pred/obs");
        row.createCell((int)((short)(++colNum))).setCellValue("Weight");
        row.createCell((int)((short)(++colNum))).setCellValue("A-Fault MoRate");
        row.createCell((int)((short)(++colNum))).setCellValue("B-Faults Char MoRate");
        row.createCell((int)((short)(++colNum))).setCellValue("B-Faults GR Mo Rate");
        row.createCell((int)((short)(++colNum))).setCellValue("Non-CA B-Faults Mo Rate");
        row.createCell((int)((short)(++colNum))).setCellValue("C-Zone MoRate");
        row.createCell((int)((short)(++colNum))).setCellValue("Background MoRate");
        row.createCell((int)((short)(++colNum))).setCellValue("Total MoRate");
        this.calcMFDs();
        this.saveMFDsToFile(path + A_FAULTS_MFD_FILENAME, this.aFaultMFDsList);
        this.saveMFDsToFile(path + B_FAULTS_CHAR_MFD_FILENAME, this.bFaultCharMFDsList);
        this.saveMFDsToFile(path + B_FAULTS_GR_MFD_FILENAME, this.bFaultGRMFDsList);
        this.saveMFDsToFile(path + NON_CA_B_FAULTS_MFD_FILENAME, this.nonCA_B_FaultsMFDsList);
        this.saveMFDsToFile(path + TOT_MFD_FILENAME, this.totMFDsList);
        this.saveMFDToFile(path + NSHMP_02_MFD_FILENAME, Frankel02_AdjustableEqkRupForecast.getTotalMFD_InsideRELM_region());
        try {
            FileOutputStream fileOut = new FileOutputStream(path + METADATA_EXCEL_SHEET);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveMFDsToFile(String fileName, ArrayList<IncrementalMagFreqDist> mfdList) {
        try {
            File f = new File(UCERF2.class.getResource(fileName).toURI());
            FileWriter fw = new FileWriter(f);
            for (int i = 0; i < mfdList.size(); ++i) {
                IncrementalMagFreqDist mfd = mfdList.get(i);
                fw.write("#Run " + (i + 1) + "\n");
                for (int magIndex = 0; magIndex < mfd.size(); ++magIndex) {
                    fw.write(mfd.getX(magIndex) + "\t" + mfd.getY(magIndex) + "\n");
                }
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveMFDToFile(String fileName, IncrementalMagFreqDist mfd) {
        ArrayList<IncrementalMagFreqDist> mfdList = new ArrayList<IncrementalMagFreqDist>();
        mfdList.add(mfd);
        this.saveMFDsToFile(fileName, mfdList);
    }

    protected void readMFDsFromFile(String fileName, ArrayList<IncrementalMagFreqDist> mfdList, boolean isNSHMP02) {
        try {
            InputStream is = UCERF2.class.getResourceAsStream(fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = br.readLine();
            IncrementalMagFreqDist mfd = null;
            while (line != null) {
                if (line.startsWith("#")) {
                    mfd = isNSHMP02 ? new IncrementalMagFreqDist(4.0, 9.0, 101) : new IncrementalMagFreqDist(this.getMinMag(), this.getMaxMag(), this.getNumMags());
                    mfdList.add(mfd);
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(line);
                    double mag = Double.parseDouble(tokenizer.nextToken());
                    double rate = Double.parseDouble(tokenizer.nextToken());
                    mfd.set(mag, rate);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected double getMinMag() {
        return 5.05;
    }

    protected double getMaxMag() {
        return 8.95;
    }

    protected int getNumMags() {
        return UCERF2.NUM_MAG;
    }

    private IncrementalMagFreqDist readMFDFromFile(String fileName, boolean isNSHMP02) {
        ArrayList<IncrementalMagFreqDist> mfdList = new ArrayList<IncrementalMagFreqDist>();
        this.readMFDsFromFile(fileName, mfdList, isNSHMP02);
        return mfdList.get(0);
    }

    public ArrayList getPlottingFeatures() {
        return this.plottingFeaturesList;
    }

    public ArrayList getCurveFunctionList() {
        return this.funcs;
    }

    private void calcMFDs() {
        double obs6_5CumRate = this.getObsCumMFD(this.ucerf2).get(0).getY(6.5);
        int numBranches = this.ucerf2List.getNumERFs();
        for (int i = 0; i < numBranches; ++i) {
            UCERF2 ucerf2 = (UCERF2)this.ucerf2List.getERF(i);
            System.out.println("Doing run " + (this.aFaultMFDsList.size() + 1) + " of " + numBranches);
            this.aFaultMFDsList.add(this.getTotal_A_FaultsMFD(ucerf2));
            this.bFaultCharMFDsList.add(this.getTotal_B_FaultsCharMFD(ucerf2));
            this.bFaultGRMFDsList.add(this.getTotal_B_FaultsGR_MFD(ucerf2));
            this.nonCA_B_FaultsMFDsList.add(this.getTotal_NonCA_B_FaultsMFD(ucerf2));
            this.totMFDsList.add(this.getTotalMFD(ucerf2));
            short colIndex = (short)this.totMFDsList.size();
            HSSFRow row = this.excelSheet.createRow((int)colIndex);
            row.createCell(0).setCellValue("Plot " + colIndex);
            ParameterList paramList = ucerf2.getAdjustableParameterList();
            for (int p = 0; p < this.adjustableParamNames.size(); ++p) {
                String pName = this.adjustableParamNames.get(p);
                if (!paramList.containsParameter(pName)) continue;
                row.createCell((int)((short)(p + 1))).setCellValue(paramList.getValue(pName).toString());
            }
            int colNum = this.adjustableParamNames.size() + 1;
            row.createCell((int)((short)colNum)).setCellValue(this.getCumRateAt6_5(this.totMFDsList.get(colIndex - 1)) / obs6_5CumRate);
            row.createCell((int)((short)(++colNum))).setCellValue(this.ucerf2List.getERF_RelativeWeight(i));
            row.createCell((int)((short)(++colNum))).setCellValue(this.aFaultMFDsList.get(colIndex - 1).getTotalMomentRate());
            row.createCell((int)((short)(++colNum))).setCellValue(this.bFaultCharMFDsList.get(colIndex - 1).getTotalMomentRate());
            row.createCell((int)((short)(++colNum))).setCellValue(this.bFaultGRMFDsList.get(colIndex - 1).getTotalMomentRate());
            row.createCell((int)((short)(++colNum))).setCellValue(this.nonCA_B_FaultsMFDsList.get(colIndex - 1).getTotalMomentRate());
            row.createCell((int)((short)(++colNum))).setCellValue(ucerf2.getTotal_C_ZoneMFD().getTotalMomentRate());
            row.createCell((int)((short)(++colNum))).setCellValue(ucerf2.getTotal_BackgroundMFD().getTotalMomentRate());
            row.createCell((int)((short)(++colNum))).setCellValue(this.totMFDsList.get(colIndex - 1).getTotalMomentRate());
        }
    }

    protected double getCumRateAt6_5(IncrementalMagFreqDist mfd) {
        return mfd.getCumRate(6.55);
    }

    protected ArrayList<EvenlyDiscretizedFunc> getObsCumMFD(UCERF2 ucerf2) {
        boolean includeAfterShocks = ucerf2.areAfterShocksIncluded();
        return UCERF2.getObsCumMFD(includeAfterShocks);
    }

    protected ArrayList<ArbitrarilyDiscretizedFunc> getObsIncrMFD(UCERF2 ucerf2) {
        boolean includeAfterShocks = ucerf2.areAfterShocksIncluded();
        return UCERF2.getObsIncrMFD(includeAfterShocks);
    }

    protected IncrementalMagFreqDist getTotal_A_FaultsMFD(UCERF2 ucerf2) {
        return ucerf2.getTotal_A_FaultsMFD();
    }

    protected IncrementalMagFreqDist getTotal_C_ZoneMFD(UCERF2 ucerf2) {
        return ucerf2.getTotal_C_ZoneMFD();
    }

    protected IncrementalMagFreqDist getTotal_BackgroundMFD(UCERF2 ucerf2) {
        return ucerf2.getTotal_BackgroundMFD();
    }

    protected IncrementalMagFreqDist getTotal_B_FaultsCharMFD(UCERF2 ucerf2) {
        return ucerf2.getTotal_B_FaultsCharMFD();
    }

    protected IncrementalMagFreqDist getTotal_B_FaultsGR_MFD(UCERF2 ucerf2) {
        return ucerf2.getTotal_B_FaultsGR_MFD();
    }

    protected IncrementalMagFreqDist getTotal_NonCA_B_FaultsMFD(UCERF2 ucerf2) {
        return ucerf2.getTotal_NonCA_B_FaultsMFD();
    }

    protected IncrementalMagFreqDist getTotalMFD(UCERF2 ucerf2) {
        return ucerf2.getTotalMFD();
    }

    public void plotMFDs(String path, boolean isCumulative) {
        this.isCumulative = isCumulative;
        if (path == null) {
            path = DEFAULT_PATH;
        }
        this.readMFDsFromFile(path + A_FAULTS_MFD_FILENAME, this.aFaultMFDsList, false);
        this.readMFDsFromFile(path + B_FAULTS_CHAR_MFD_FILENAME, this.bFaultCharMFDsList, false);
        this.readMFDsFromFile(path + B_FAULTS_GR_MFD_FILENAME, this.bFaultGRMFDsList, false);
        this.readMFDsFromFile(path + NON_CA_B_FAULTS_MFD_FILENAME, this.nonCA_B_FaultsMFDsList, false);
        this.readMFDsFromFile(path + TOT_MFD_FILENAME, this.totMFDsList, false);
        this.nshmp02TotMFD = this.readMFDFromFile(path + NSHMP_02_MFD_FILENAME, true);
        this.ucerf2.updateForecast();
        this.cZoneMFD = this.getTotal_C_ZoneMFD(this.ucerf2);
        this.bckMFD = this.getTotal_BackgroundMFD(this.ucerf2);
        this.plotMFDs(null, null, true, true, true, true, true, false);
        this.plotMFDs(null, null, false, false, false, false, false, true);
        String paramName = "Deformation Model";
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("D2.1");
        values.add("D2.4");
        this.plotMFDs(paramName, values, false, true, false, false, false, false);
        paramName = "Deformation Model";
        values = new ArrayList();
        values.add("D2.1");
        values.add("D2.2");
        values.add("D2.3");
        this.plotMFDs(paramName, values, true, false, false, false, false, false);
        paramName = "Mag-Area Relationship";
        values = new ArrayList();
        values.add("Ellsworth-B (WGCEP, 2002, Eq 4.5b)");
        values.add("Hanks & Bakun (2002)");
        this.plotMFDs(paramName, values, true, true, false, false, false, false);
        paramName = "A-Fault Solution Type";
        values = new ArrayList();
        values.add("Segmented Model");
        values.add("Unsegmented Model");
        this.plotMFDs(paramName, values, true, false, false, false, false, false);
        paramName = "Wt On A-Priori Rates";
        values = new ArrayList();
        values.add(1.0E-4);
        values.add(1.0E10);
        this.plotMFDs(paramName, values, true, false, false, false, false, false);
        paramName = "Connect More B Faults?";
        values = new ArrayList();
        values.add(true);
        values.add(false);
        this.plotMFDs(paramName, values, false, true, false, false, false, false);
        paramName = "B-Faults b-value";
        values = new ArrayList();
        values.add(0.0);
        paramName = "Fract MoRate to Background";
        values = new ArrayList();
        values.add(0.1);
    }

    private void plotMFDs(String paramName, ArrayList values, boolean showAFaults, boolean showBFaults, boolean showNonCA_B_Faults, boolean showCZones, boolean showBackground, boolean showNSHMP_TotMFD) {
        SummedMagFreqDist avgTotMFD = this.doAverageMFDs(showAFaults, showBFaults, showNonCA_B_Faults, showCZones, showBackground, showNSHMP_TotMFD);
        for (int i = 0; values != null && i < values.size(); ++i) {
            Object metadata;
            PlotCurveCharacterstics plot4;
            PlotCurveCharacterstics plot3;
            PlotCurveCharacterstics plot2;
            PlotCurveCharacterstics plot1;
            ArrayList<IncrementalMagFreqDist> mfds;
            IncrementalMagFreqDist aFaultMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
            IncrementalMagFreqDist bFaultCharMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
            IncrementalMagFreqDist bFaultGRMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
            SummedMagFreqDist nonCA__B_FaultsMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
            IncrementalMagFreqDist totMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
            if (paramName.equalsIgnoreCase("Fract MoRate to Background")) {
                mfds = this.getMFDsWhenBckFrac0_1();
                aFaultMFD = mfds.get(0);
                aFaultMFD.setInfo("A-Faults MFD");
                bFaultCharMFD = mfds.get(1);
                bFaultCharMFD.setInfo("B-Faults Char MFD");
                bFaultGRMFD = mfds.get(2);
                bFaultGRMFD.setInfo("B-Faults GR MFD");
                totMFD = mfds.get(3);
                totMFD.setInfo("Total MFD");
            } else if (paramName.equalsIgnoreCase("B-Faults b-value")) {
                mfds = this.getMFDsWhenBVal0();
                aFaultMFD = mfds.get(0);
                aFaultMFD.setInfo("A-Faults MFD");
                bFaultCharMFD = mfds.get(1);
                bFaultCharMFD.setInfo("B-Faults Char MFD");
                bFaultGRMFD = mfds.get(2);
                bFaultGRMFD.setInfo("B-Faults GR MFD");
                totMFD = mfds.get(3);
                totMFD.setInfo("Total MFD");
            } else {
                this.doWeightedSum(paramName, values.get(i), (SummedMagFreqDist)aFaultMFD, (SummedMagFreqDist)bFaultCharMFD, (SummedMagFreqDist)bFaultGRMFD, nonCA__B_FaultsMFD, (SummedMagFreqDist)totMFD);
            }
            if (i == 0) {
                plot1 = this.PLOT_CHAR1_1;
                plot2 = this.PLOT_CHAR2_1;
                plot3 = this.PLOT_CHAR3_1;
                plot4 = this.PLOT_CHAR4_1;
                metadata = "Dotted Dashed Line - ";
            } else if (i == 1) {
                plot1 = this.PLOT_CHAR1_2;
                plot2 = this.PLOT_CHAR2_2;
                plot3 = this.PLOT_CHAR3_2;
                plot4 = this.PLOT_CHAR4_2;
                metadata = "Dashed Line - ";
            } else {
                plot1 = this.PLOT_CHAR1_3;
                plot2 = this.PLOT_CHAR2_3;
                plot3 = this.PLOT_CHAR3_3;
                plot4 = this.PLOT_CHAR4_3;
                metadata = "Lines and Circles - ";
            }
            metadata = (String)metadata + "(" + paramName + "=" + String.valueOf(values.get(i)) + ")  ";
            if (showAFaults) {
                this.addToFuncList(aFaultMFD, (String)metadata + "A-Fault MFD", plot1);
            }
            if (showBFaults) {
                this.addToFuncList(bFaultCharMFD, (String)metadata + "Char B-Fault MFD", plot2);
            }
            if (showBFaults) {
                this.addToFuncList(bFaultGRMFD, (String)metadata + "GR B-Fault MFD", plot3);
            }
            this.addToFuncList(totMFD, (String)metadata + "Total MFD, M6.5 Cum Ratio = " + totMFD.getCumRate(6.55) / avgTotMFD.getCumRate(6.55), plot4);
        }
        GraphWindow graphWindow = new GraphWindow(this.getCurveFunctionList(), "Mag Freq Dist", this.getPlottingFeatures());
        graphWindow.setVisible(true);
    }

    private SummedMagFreqDist doAverageMFDs(boolean showAFaults, boolean showBFaults, boolean showNonCA_B_Faults, boolean showCZones, boolean showBackground, boolean showNSHMP_TotMFD) {
        ArrayList<AbstractDiscretizedFunc> obsMFD;
        this.funcs = new ArrayList();
        this.plottingFeaturesList = new ArrayList();
        SummedMagFreqDist avgAFaultMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
        SummedMagFreqDist avgBFaultCharMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
        SummedMagFreqDist avgBFaultGRMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
        SummedMagFreqDist avgNonCA_B_FaultsMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
        SummedMagFreqDist avgTotMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
        this.doWeightedSum(null, null, avgAFaultMFD, avgBFaultCharMFD, avgBFaultGRMFD, avgNonCA_B_FaultsMFD, avgTotMFD);
        Object metadata = "Solid Line-";
        if (showAFaults) {
            this.addToFuncList(avgAFaultMFD, (String)metadata + "Average A-Fault MFD", this.PLOT_CHAR1);
        }
        if (showBFaults) {
            this.addToFuncList(avgBFaultCharMFD, (String)metadata + "Average Char B-Fault MFD", this.PLOT_CHAR2);
        }
        if (showBFaults) {
            this.addToFuncList(avgBFaultGRMFD, (String)metadata + "Average GR B-Fault MFD", this.PLOT_CHAR3);
        }
        if (showNonCA_B_Faults) {
            this.addToFuncList(avgNonCA_B_FaultsMFD, (String)metadata + "Average Non-CA B-Fault MFD", this.PLOT_CHAR10);
        }
        if (showBackground) {
            this.addToFuncList(this.bckMFD, (String)metadata + "Average Background MFD", this.PLOT_CHAR5);
        }
        if (showCZones) {
            this.addToFuncList(this.cZoneMFD, (String)metadata + "Average C-Zones MFD", this.PLOT_CHAR6);
        }
        if (showNSHMP_TotMFD) {
            EvenlyDiscretizedFunc nshmpCumMFD = this.nshmp02TotMFD.getCumRateDistWithOffset();
            ArbitrarilyDiscretizedFunc resampledNSHMP_MFD = new ArbitrarilyDiscretizedFunc();
            for (int i = 0; i < nshmpCumMFD.size(); i += 2) {
                resampledNSHMP_MFD.set(nshmpCumMFD.getX(i), nshmpCumMFD.getY(i));
            }
            resampledNSHMP_MFD.setName("NSHMP-2002 Total MFD");
            if (this.isCumulative) {
                this.funcs.add(resampledNSHMP_MFD);
            } else {
                ArbIncrementalMagFreqDist nshmpIncrMFD = new ArbIncrementalMagFreqDist(5.1, 8.899999999999999, UCERF2.NUM_MAG - 1);
                nshmpIncrMFD.setCumRateDist(resampledNSHMP_MFD);
                this.funcs.add(nshmpIncrMFD);
            }
            this.plottingFeaturesList.add(this.PLOT_CHAR9);
        }
        if (this.isCumulative) {
            obsMFD = this.getObsCumMFD(this.ucerf2);
            metadata = (String)metadata + "Average Total MFD, M6.5 Cum Ratio = " + avgTotMFD.getCumRate(6.55) / ((EvenlyDiscretizedFunc)obsMFD.get(0)).getY(6.5);
        } else {
            obsMFD = this.getObsIncrMFD(this.ucerf2);
            metadata = (String)metadata + "Average Total MFD";
        }
        this.addToFuncList(avgTotMFD, (String)metadata, this.PLOT_CHAR4);
        this.funcs.add(obsMFD.get(0));
        this.plottingFeaturesList.add(this.PLOT_CHAR7);
        this.funcs.addAll(obsMFD);
        this.plottingFeaturesList.add(this.PLOT_CHAR8);
        if (obsMFD.size() > 1) {
            this.plottingFeaturesList.add(this.PLOT_CHAR8);
            this.plottingFeaturesList.add(this.PLOT_CHAR8);
        }
        return avgTotMFD;
    }

    private void addToFuncList(IncrementalMagFreqDist mfd, String metadata, PlotCurveCharacterstics curveCharateristic) {
        EvenlyDiscretizedFunc func = this.isCumulative ? mfd.getCumRateDistWithOffset() : mfd;
        func.setName(metadata);
        this.funcs.add(func);
        this.plottingFeaturesList.add(curveCharateristic);
    }

    protected void doWeightedSum(String constantParamName, Object value, SummedMagFreqDist aFaultTotMFD, SummedMagFreqDist bFaultTotCharMFD, SummedMagFreqDist bFaultTotGRMFD, SummedMagFreqDist nonCA_B_FaultsTotMFD, SummedMagFreqDist totMFD) {
        int numBranches = this.ucerf2List.getNumERFs();
        double paramWt = 1.0;
        if (constantParamName != null) {
            paramWt = this.ucerf2List.getWtForParamVal(constantParamName, value);
        }
        for (int i = 0; i < numBranches; ++i) {
            ParameterList paramList = this.ucerf2List.getParameterList(i);
            double wt = this.ucerf2List.getERF_RelativeWeight(i);
            if (constantParamName != null && !paramList.containsParameter(constantParamName)) continue;
            if (constantParamName != null) {
                Parameter param = paramList.getParameter(constantParamName);
                if (!param.getValue().equals(value)) continue;
                wt /= paramWt;
            }
            this.addMFDs(aFaultTotMFD, this.aFaultMFDsList.get(i), wt);
            this.addMFDs(bFaultTotCharMFD, this.bFaultCharMFDsList.get(i), wt);
            this.addMFDs(bFaultTotGRMFD, this.bFaultGRMFDsList.get(i), wt);
            this.addMFDs(nonCA_B_FaultsTotMFD, this.nonCA_B_FaultsMFDsList.get(i), wt);
            this.addMFDs(totMFD, this.totMFDsList.get(i), wt);
        }
    }

    private ArrayList<IncrementalMagFreqDist> getMFDsWhenBVal0() {
        ArrayList<IncrementalMagFreqDist> mfdList = new ArrayList<IncrementalMagFreqDist>();
        this.readMFDsFromFile("data/logicTreeMFDs/BFault_BVal0/CombinedAvgMFDs.txt", mfdList, false);
        return mfdList;
    }

    private ArrayList<IncrementalMagFreqDist> getMFDsWhenBckFrac0_1() {
        ArrayList<IncrementalMagFreqDist> mfdList = new ArrayList<IncrementalMagFreqDist>();
        this.readMFDsFromFile("data/logicTreeMFDs/BackGrdFrac0_1/CombinedAvgMFDs.txt", mfdList, false);
        return mfdList;
    }

    private void addMFDs(SummedMagFreqDist targetMFD, IncrementalMagFreqDist sourceMFD, double wt) {
        for (int i = 0; i < sourceMFD.size(); ++i) {
            targetMFD.add(sourceMFD.getX(i), wt * sourceMFD.getY(i));
        }
    }

    public boolean getXLog() {
        return false;
    }

    public boolean getYLog() {
        return true;
    }

    public String getXAxisLabel() {
        return X_AXIS_LABEL;
    }

    public String getYAxisLabel() {
        if (this.isCumulative) {
            return CUM_Y_AXIS_LABEL;
        }
        return INCR_Y_AXIS_LABEL;
    }

    public boolean isCustomAxis() {
        return true;
    }

    public double getUserMinX() {
        return 5.0;
    }

    public double getUserMaxX() {
        return 9.255;
    }

    public double getUserMinY() {
        return 1.0E-4;
    }

    public double getUserMaxY() {
        return 10.0;
    }

    public static void main(String[] args) {
        LogicTreeMFDsPlotter logicTreeMFDsPlotter = new LogicTreeMFDsPlotter();
        logicTreeMFDsPlotter.plotMFDs(null, true);
    }
}

