/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.calc.ERF2GriddedSeisRatesCalc;
import org.opensha.sha.earthquake.rupForecastImpl.FaultRuptureSource;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Frankel02_TypeB_EqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults.A_FaultSegmentedSourceGenerator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UnsegmentedSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.EmpiricalModelDataFetcher;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.griddedSeis.NSHMP_GridSourceGenerator;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurfaceWithSubsets;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.RuptureSurface;

public class PolygonRatesAnalysis {
    private UCERF2 ucerf2;
    private CaliforniaRegions.RELM_GRIDDED relmRegion = new CaliforniaRegions.RELM_GRIDDED();
    private EmpiricalModelDataFetcher empiricalModelFetcher = new EmpiricalModelDataFetcher();
    private ERF2GriddedSeisRatesCalc erf2GriddedSeisRatesCalc = new ERF2GriddedSeisRatesCalc();
    private static final double MIN_MAG = 5.0;
    private static final String PATH = "/data/erf/ucerf2/";
    private static final String A_FAULT_FILENAME = "/data/erf/ucerf2/A_FaultsPolygonFractions.txt";
    private static final String B_FAULT_FILENAME = "/data/erf/ucerf2/B_FaultsPolygonFractions.txt";
    private static final String NON_CA_B_FAULT_FILENAME = "/data/erf/ucerf2/NonCA_B_FaultsPolygonFractions.txt";
    private static final String C_ZONES_FILENAME = "/data/erf/ucerf2/C_ZonesPolygonFractions.txt";
    private double totPointsInRELM_Region;

    public PolygonRatesAnalysis() {
        this.ucerf2 = new UCERF2();
        this.ucerf2.setParameter("Probability Model", "Empirical");
        this.ucerf2.updateForecast();
    }

    public void calcRatesInPolygons() {
        double totRate = this.erf2GriddedSeisRatesCalc.getTotalSeisRateInRegion(5.0, this.ucerf2, this.relmRegion);
        int numPolygons = this.empiricalModelFetcher.getNumRegions();
        System.out.println("Total rate in RELM region:" + totRate);
        double rateRestOfRegion = totRate;
        for (int regionIndex = 0; regionIndex < numPolygons; ++regionIndex) {
            Region polygon = this.empiricalModelFetcher.getRegion(regionIndex);
            if (polygon.getBorder() == null) continue;
            double rateInPoly = this.erf2GriddedSeisRatesCalc.getTotalSeisRateInRegion(5.0, this.ucerf2, polygon);
            rateRestOfRegion -= rateInPoly;
            System.out.println("Rate in region " + polygon.getName() + " is\t\t" + rateInPoly);
        }
        System.out.println("Rate in rest of region is " + rateRestOfRegion);
    }

    public void mkA_SourcesFile() {
        ArrayList aFaultGenerators = this.ucerf2.get_A_FaultSourceGenerators();
        int numA_Faults = aFaultGenerators.size();
        try {
            FileWriter fw = new FileWriter(A_FAULT_FILENAME);
            fw.write(this.getFileHeader());
            int index = 0;
            for (int i = 0; i < numA_Faults; ++i) {
                if (aFaultGenerators.get(i) instanceof A_FaultSegmentedSourceGenerator) {
                    A_FaultSegmentedSourceGenerator srcGen = (A_FaultSegmentedSourceGenerator)aFaultGenerators.get(i);
                    ArrayList<FaultRuptureSource> aFaultSources = srcGen.getTimeIndependentSources(1.0);
                    int numSrc = aFaultSources.size();
                    for (int srcIndex = 0; srcIndex < numSrc; ++srcIndex) {
                        FaultRuptureSource faultRupSrc = aFaultSources.get(srcIndex);
                        RuptureSurface surface = faultRupSrc.getSourceSurface();
                        this.writeFractonOfPointsInFile(fw, srcGen.getFaultSegmentData().getFaultName(), index++, surface);
                    }
                    continue;
                }
                UnsegmentedSource unsegmentedSource = (UnsegmentedSource)aFaultGenerators.get(i);
                AbstractEvenlyGriddedSurfaceWithSubsets surface = unsegmentedSource.getSourceSurface();
                this.writeFractonOfPointsInFile(fw, unsegmentedSource.getName(), i, surface);
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getFileHeader() {
        Object header = "#FaultName, Index, RELM Region";
        int numPolygons = this.empiricalModelFetcher.getNumRegions();
        for (int regionIndex = 0; regionIndex < numPolygons; ++regionIndex) {
            Region polygon = this.empiricalModelFetcher.getRegion(regionIndex);
            header = (String)header + "," + polygon.getName();
        }
        header = (String)header + "\n";
        return header;
    }

    public void mkB_SourcesFile() {
        ArrayList bFaultSources = this.ucerf2.get_B_FaultSources();
        int numB_Faults = bFaultSources.size();
        try {
            FileWriter fw = new FileWriter(B_FAULT_FILENAME);
            fw.write(this.getFileHeader());
            for (int i = 0; i < numB_Faults; ++i) {
                UnsegmentedSource unsegmentedSource = (UnsegmentedSource)bFaultSources.get(i);
                AbstractEvenlyGriddedSurfaceWithSubsets surface = unsegmentedSource.getSourceSurface();
                this.writeFractonOfPointsInFile(fw, unsegmentedSource.getName(), i, surface);
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mkNonCA_B_SourcesFile() {
        ArrayList nonCA_B_FaultSources = this.ucerf2.getNonCA_B_FaultSources();
        int numNonCA_B_Faults = nonCA_B_FaultSources.size();
        try {
            FileWriter fw = new FileWriter(NON_CA_B_FAULT_FILENAME);
            fw.write(this.getFileHeader());
            for (int i = 0; i < numNonCA_B_Faults; ++i) {
                ProbEqkSource probEqkSrc = (ProbEqkSource)nonCA_B_FaultSources.get(i);
                RuptureSurface surface = null;
                surface = probEqkSrc instanceof FaultRuptureSource ? ((FaultRuptureSource)probEqkSrc).getRupture(0).getRuptureSurface() : ((Frankel02_TypeB_EqkSource)probEqkSrc).getSourceSurface();
                this.writeFractonOfPointsInFile(fw, probEqkSrc.getName(), i, surface);
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mkC_ZonesFile() {
        NSHMP_GridSourceGenerator nshmpGridSrcGen = new NSHMP_GridSourceGenerator(null);
        String PATH = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/griddedSeis/";
        try {
            FileWriter fw = new FileWriter(C_ZONES_FILENAME);
            fw.write(this.getFileHeader());
            double[] area1new_agrid = nshmpGridSrcGen.readGridFile(PATH + "area1new.agrid.asc", true);
            int cZoneIndex = 0;
            this.calcFractionC_Zone(nshmpGridSrcGen, fw, "Area 1", area1new_agrid, cZoneIndex);
            double[] area2new_agrid = nshmpGridSrcGen.readGridFile(PATH + "area2new.agrid.asc", true);
            this.calcFractionC_Zone(nshmpGridSrcGen, fw, "Area 2", area2new_agrid, ++cZoneIndex);
            double[] area3new_agrid = nshmpGridSrcGen.readGridFile(PATH + "area3new.agrid.asc", true);
            this.calcFractionC_Zone(nshmpGridSrcGen, fw, "Area 3", area3new_agrid, ++cZoneIndex);
            double[] area4new_agrid = nshmpGridSrcGen.readGridFile(PATH + "area4new.agrid.asc", true);
            this.calcFractionC_Zone(nshmpGridSrcGen, fw, "Area 4", area4new_agrid, ++cZoneIndex);
            double[] mojave_agrid = nshmpGridSrcGen.readGridFile(PATH + "mojave.agrid.asc", true);
            this.calcFractionC_Zone(nshmpGridSrcGen, fw, "Mojave", mojave_agrid, ++cZoneIndex);
            double[] sangreg_agrid = nshmpGridSrcGen.readGridFile(PATH + "sangreg.agrid.asc", true);
            this.calcFractionC_Zone(nshmpGridSrcGen, fw, "San Gregonio", sangreg_agrid, ++cZoneIndex);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void calcFractionC_Zone(NSHMP_GridSourceGenerator nshmpGridSrcGen, FileWriter fw, String cZoneName, double[] area1new_agrid, int cZoneIndex) throws IOException {
        int numPolygons = this.empiricalModelFetcher.getNumRegions();
        int[] pointInEachPolygon = new int[numPolygons];
        int totPointsInRELM_Region = 0;
        block0: for (int i = 0; i < area1new_agrid.length; ++i) {
            if (area1new_agrid[i] == 0.0) continue;
            ++totPointsInRELM_Region;
            Location loc = nshmpGridSrcGen.getGriddedRegion().locationForIndex(i);
            for (int regionIndex = 0; regionIndex < numPolygons; ++regionIndex) {
                Region polygon = this.empiricalModelFetcher.getRegion(regionIndex);
                if (polygon.getBorder() == null || !polygon.contains(loc)) continue;
                int n = regionIndex;
                pointInEachPolygon[n] = pointInEachPolygon[n] + 1;
                continue block0;
            }
        }
        fw.write(cZoneName + "," + cZoneIndex + "," + (float)totPointsInRELM_Region / (float)totPointsInRELM_Region);
        int pointsOutsidePolygon = totPointsInRELM_Region;
        for (int regionIndex = 0; regionIndex < numPolygons; ++regionIndex) {
            Region polygon = this.empiricalModelFetcher.getRegion(regionIndex);
            pointsOutsidePolygon -= pointInEachPolygon[regionIndex];
            if (polygon.getBorder() == null) continue;
            fw.write("," + (float)pointInEachPolygon[regionIndex] / (float)totPointsInRELM_Region);
        }
        fw.write("," + (float)pointsOutsidePolygon / (float)totPointsInRELM_Region + "\n");
    }

    private void writeFractonOfPointsInFile(FileWriter fw, String faultName, int srcIndex, RuptureSurface surface) throws IOException {
        double[] pointInEachPolygon = this.findFractionOfPointsInPolygons((EvenlyGriddedSurface)surface);
        fw.write(faultName + "," + srcIndex + "," + (float)this.totPointsInRELM_Region);
        for (int regionIndex = 0; regionIndex < pointInEachPolygon.length; ++regionIndex) {
            fw.write("," + (float)pointInEachPolygon[regionIndex]);
        }
        fw.write("\n");
    }

    private double[] findFractionOfPointsInPolygons(EvenlyGriddedSurface surface) {
        int numPolygons = this.empiricalModelFetcher.getNumRegions();
        double[] pointInEachPolygon = new double[numPolygons];
        int numPoints = surface.getNumCols();
        this.totPointsInRELM_Region = 0.0;
        block0: for (int ptIndex = 0; ptIndex < numPoints; ++ptIndex) {
            Location loc = surface.getLocation(0, ptIndex);
            if (this.relmRegion.contains(loc)) {
                this.totPointsInRELM_Region += 1.0;
            }
            for (int regionIndex = 0; regionIndex < numPolygons; ++regionIndex) {
                Region polygon = this.empiricalModelFetcher.getRegion(regionIndex);
                if (polygon.getBorder() == null || !polygon.contains(loc)) continue;
                int n = regionIndex;
                pointInEachPolygon[n] = pointInEachPolygon[n] + 1.0;
                continue block0;
            }
        }
        int pointsOutsidePolygon = (int)Math.round(this.totPointsInRELM_Region);
        for (int regionIndex = 0; regionIndex < numPolygons; ++regionIndex) {
            pointsOutsidePolygon = (int)((double)pointsOutsidePolygon - pointInEachPolygon[regionIndex]);
            pointInEachPolygon[regionIndex] = pointInEachPolygon[regionIndex] / (double)numPoints;
        }
        pointInEachPolygon[numPolygons - 1] = (float)pointsOutsidePolygon / (float)numPoints;
        this.totPointsInRELM_Region /= (double)numPoints;
        return pointInEachPolygon;
    }

    public static void main(String[] args) {
        PolygonRatesAnalysis polygonRatesAnalysis = new PolygonRatesAnalysis();
        polygonRatesAnalysis.calcRatesInPolygons();
    }
}

