/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2_TimeDependentEpistemicList;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2_TimeIndependentEpistemicList;

public class ProbabilityDistHistogramPlotter {
    private static final String PATH = "src/org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/analysis/probContr/";
    private static final double MIN_PROB = 0.025;
    private static final double MAX_PROB = 0.975;
    private static final double DELTA_PROB = 0.05;
    private static final int NUM_PROB = Math.round(19.0f) + 1;
    private static final String X_AXIS_LABEL = "Probability";
    private static final String Y_AXIS_LABEL = "Contribution";
    private static final String PLOT_LABEL = "Probability Contribution";
    private final PlotCurveCharacterstics HISTOGRAM1 = new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 2.0f, Color.BLACK);
    private final PlotCurveCharacterstics STACKED_BAR1 = new PlotCurveCharacterstics(PlotLineType.STACKED_BAR, 2.0f, Color.BLACK);
    private final PlotCurveCharacterstics STACKED_BAR2 = new PlotCurveCharacterstics(PlotLineType.STACKED_BAR, 2.0f, Color.GREEN);
    private final PlotCurveCharacterstics STACKED_BAR3 = new PlotCurveCharacterstics(PlotLineType.STACKED_BAR, 2.0f, Color.BLUE);
    private ArrayList funcs;
    private ArrayList<PlotCurveCharacterstics> plottingCurveChars;
    private HSSFWorkbook workbook;
    private double[] mags = new double[]{5.0, 5.25, 5.5, 5.75, 6.0, 6.25, 6.5, 6.7, 7.0, 7.25, 7.5, 7.75, 8.0, 8.25};
    public static final String A_FAULTS = "A-Faults";
    public static final String B_FAULTS = "B-Faults";
    public static final String NON_CA_B_FAULTS = "Non-CA B-Faults";
    public static final String C_ZONES = "C-Zones";
    public static final String BACKGROUND = "Background";
    public static final String TOTAL = "Total";
    private String[] sources = new String[]{"A-Faults", "B-Faults", "Non-CA B-Faults", "C-Zones", "Background", "Total"};
    private UCERF2_TimeIndependentEpistemicList ucerf2EpistemicList;
    private String[] bFaultNames = new String[]{"San Gregorio Connected", "Greenville Connected", "Green Valley Connected", "Mount Diablo Thrust"};
    private String[] aFaultNames = new String[]{"Elsinore", "Garlock", "San Jacinto", "N. San Andreas", "S. San Andreas", "Hayward-Rodgers Creek", "Calaveras"};

    public void generateProbContributionsExcelSheet(boolean isTimeDependent, double duration, String fileName, Region region) {
        int magIndex;
        int i;
        if (this.ucerf2EpistemicList == null) {
            this.ucerf2EpistemicList = isTimeDependent ? new UCERF2_TimeDependentEpistemicList() : new UCERF2_TimeIndependentEpistemicList();
        }
        this.workbook = new HSSFWorkbook();
        this.createParamSettingsSheet();
        int numSources = this.sources.length;
        for (int i2 = 0; i2 < this.sources.length; ++i2) {
            this.workbook.createSheet(this.sources[i2]);
        }
        HSSFRow row1 = null;
        for (i = 0; i < this.aFaultNames.length; ++i) {
            this.workbook.createSheet(this.aFaultNames[i]);
        }
        for (i = 0; i < this.bFaultNames.length; ++i) {
            this.workbook.createSheet(this.bFaultNames[i]);
        }
        for (i = 0; i < this.sources.length; ++i) {
            row1 = this.workbook.getSheet(this.sources[i]).createRow(0);
            for (magIndex = 0; magIndex < this.mags.length; ++magIndex) {
                row1.createCell((int)((short)(magIndex + 1))).setCellValue(" Mag " + this.mags[magIndex]);
            }
        }
        for (i = 0; i < this.aFaultNames.length; ++i) {
            row1 = this.workbook.getSheet(this.aFaultNames[i]).createRow(0);
            for (magIndex = 0; magIndex < this.mags.length; ++magIndex) {
                row1.createCell((int)((short)(magIndex + 1))).setCellValue(" Mag " + this.mags[magIndex]);
            }
        }
        for (i = 0; i < this.bFaultNames.length; ++i) {
            row1 = this.workbook.getSheet(this.bFaultNames[i]).createRow(0);
            for (magIndex = 0; magIndex < this.mags.length; ++magIndex) {
                row1.createCell((int)((short)(magIndex + 1))).setCellValue(" Mag " + this.mags[magIndex]);
            }
        }
        int numERFs = this.ucerf2EpistemicList.getNumERFs();
        int startRowIndex = 2;
        DiscretizedFunc bckgroundProbs = null;
        DiscretizedFunc cZoneProbs = null;
        this.ucerf2EpistemicList.getTimeSpan().setDuration(duration);
        for (int erfIndex = 0; erfIndex < numERFs; ++erfIndex) {
            int magIndex2;
            int i3;
            System.out.println("Doing run " + (erfIndex + 1) + " of " + numERFs);
            UCERF2 ucerf2 = (UCERF2)this.ucerf2EpistemicList.getERF(erfIndex);
            if (bckgroundProbs == null) {
                bckgroundProbs = this.getDiscretizedFunc();
                cZoneProbs = this.getDiscretizedFunc();
                ucerf2.getTotal_C_ZoneProb(cZoneProbs, region);
                ucerf2.getTotal_BackgroundProb(bckgroundProbs, region);
            }
            DiscretizedFunc aFaultsProbs = this.getDiscretizedFunc();
            DiscretizedFunc bFaultsProbs = this.getDiscretizedFunc();
            DiscretizedFunc nonCA_B_FaultsProbs = this.getDiscretizedFunc();
            DiscretizedFunc totalProbs = this.getDiscretizedFunc();
            ucerf2.getTotal_A_FaultsProb(aFaultsProbs, region);
            ucerf2.getTotal_B_FaultsProb(bFaultsProbs, region);
            ucerf2.getTotal_NonCA_B_FaultsProb(nonCA_B_FaultsProbs, region);
            this.getTotalProb(totalProbs, aFaultsProbs, bFaultsProbs, nonCA_B_FaultsProbs, cZoneProbs, bckgroundProbs);
            for (i3 = 0; i3 < this.sources.length; ++i3) {
                row1 = this.workbook.getSheet(this.sources[i3]).createRow(startRowIndex + erfIndex);
                row1.createCell(0).setCellValue("Branch " + (erfIndex + 1));
                DiscretizedFunc func = null;
                if (this.sources[i3].equals(A_FAULTS)) {
                    func = aFaultsProbs;
                } else if (this.sources[i3].equals(B_FAULTS)) {
                    func = bFaultsProbs;
                } else if (this.sources[i3].equals(NON_CA_B_FAULTS)) {
                    func = nonCA_B_FaultsProbs;
                } else if (this.sources[i3].equals(BACKGROUND)) {
                    func = bckgroundProbs;
                } else if (this.sources[i3].equals(C_ZONES)) {
                    func = cZoneProbs;
                } else if (this.sources[i3].equals(TOTAL)) {
                    func = totalProbs;
                }
                for (magIndex2 = 0; magIndex2 < this.mags.length; ++magIndex2) {
                    row1.createCell((int)((short)(magIndex2 + 1))).setCellValue(func.getY(magIndex2));
                }
            }
            for (i3 = 0; i3 < this.aFaultNames.length; ++i3) {
                DiscretizedFunc aFaultProbDist = this.getDiscretizedFunc();
                row1 = this.workbook.getSheet(this.aFaultNames[i3]).createRow(startRowIndex + erfIndex);
                row1.createCell(0).setCellValue("Branch " + (erfIndex + 1));
                ucerf2.getProbForA_Fault(this.aFaultNames[i3], aFaultProbDist, region);
                for (magIndex2 = 0; magIndex2 < this.mags.length; ++magIndex2) {
                    row1.createCell((int)((short)(magIndex2 + 1))).setCellValue(aFaultProbDist.getY(magIndex2));
                }
            }
            for (i3 = 0; i3 < this.bFaultNames.length; ++i3) {
                DiscretizedFunc bFaultProbDist = this.getDiscretizedFunc();
                row1 = this.workbook.getSheet(this.bFaultNames[i3]).createRow(startRowIndex + erfIndex);
                row1.createCell(0).setCellValue("Branch " + (erfIndex + 1));
                ucerf2.getProbsForB_Fault(this.bFaultNames[i3], bFaultProbDist, region);
                for (magIndex2 = 0; magIndex2 < this.mags.length; ++magIndex2) {
                    row1.createCell((int)((short)(magIndex2 + 1))).setCellValue(bFaultProbDist.getY(magIndex2));
                }
            }
        }
        try {
            FileOutputStream fileOut = new FileOutputStream(fileName);
            this.workbook.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getTotalProb(DiscretizedFunc totalProbs, DiscretizedFunc aFaultsProbs, DiscretizedFunc bFaultsProbs, DiscretizedFunc nonCA_B_FaultsProbs, DiscretizedFunc cZoneProbs, DiscretizedFunc bckgroundProbs) {
        int numMags = totalProbs.size();
        for (int i = 0; i < numMags; ++i) {
            double prob = 1.0;
            prob *= 1.0 - bFaultsProbs.getY(i);
            prob *= 1.0 - nonCA_B_FaultsProbs.getY(i);
            prob *= 1.0 - aFaultsProbs.getY(i);
            prob *= 1.0 - bckgroundProbs.getY(i);
            totalProbs.set(i, 1.0 - (prob *= 1.0 - cZoneProbs.getY(i)));
        }
    }

    private DiscretizedFunc getDiscretizedFunc() {
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < this.mags.length; ++i) {
            func.set(this.mags[i], 1.0);
        }
        return func;
    }

    public void plotMagAreaComparisonProbPlot(double mag, String fileName, String sourceType) {
        try {
            POIFSFileSystem fs = new POIFSFileSystem(this.getClass().getClassLoader().getResourceAsStream(fileName));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet paramSettingsSheet = wb.getSheetAt(0);
            ArrayList<Integer> ellB_BranchIndices = this.getBranchIndices(paramSettingsSheet, "Mag-Area Relationship", "Ellsworth-B (WGCEP, 2002, Eq 4.5b)");
            ArrayList<Integer> hansBakunBranchIndices = this.getBranchIndices(paramSettingsSheet, "Mag-Area Relationship", "Hanks & Bakun (2002)");
            int totProbColIndex = this.getColIndexForMag(mag);
            HSSFSheet probSheet = wb.getSheet(sourceType);
            EvenlyDiscretizedFunc ellB_Func = this.getFunc("Histogram Plot for Ellsworth B  for " + sourceType + " for fileName " + fileName + " at Mag=" + mag, ellB_BranchIndices, paramSettingsSheet, totProbColIndex, probSheet);
            EvenlyDiscretizedFunc hansBakunFunc = this.getFunc("Histogram Plot for Hans & Bakun for " + sourceType + " for fileName " + fileName + " at Mag=" + mag, hansBakunBranchIndices, paramSettingsSheet, totProbColIndex, probSheet);
            this.addFuncs(hansBakunFunc, ellB_Func);
            this.funcs = new ArrayList();
            this.funcs.add(ellB_Func);
            this.funcs.add(hansBakunFunc);
            this.plottingCurveChars = new ArrayList();
            this.plottingCurveChars.add(this.STACKED_BAR1);
            this.plottingCurveChars.add(this.STACKED_BAR2);
            GraphWindow graphWindow = new GraphWindow(this.getCurveFunctionList(), PLOT_LABEL, this.getPlottingFeatures());
            graphWindow.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void plotAperiodicity_ComparisonProbPlot(double mag, String fileName, String sourceType) {
        try {
            POIFSFileSystem fs = new POIFSFileSystem(this.getClass().getClassLoader().getResourceAsStream(fileName));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet paramSettingsSheet = wb.getSheetAt(0);
            ArrayList<Integer> aperiodicity0_3 = this.getBranchIndices(paramSettingsSheet, "Aperiodicity", "0.3");
            ArrayList<Integer> aperiodicity0_5 = this.getBranchIndices(paramSettingsSheet, "Aperiodicity", "0.5");
            ArrayList<Integer> aperiodicity0_7 = this.getBranchIndices(paramSettingsSheet, "Aperiodicity", "0.7");
            int totProbColIndex = this.getColIndexForMag(mag);
            HSSFSheet probSheet = wb.getSheet(sourceType);
            EvenlyDiscretizedFunc func0_3 = this.getFunc("Histogram Plot for Aperiodicity = 0.3 for " + sourceType + " for fileName " + fileName + " at Mag=" + mag, aperiodicity0_3, paramSettingsSheet, totProbColIndex, probSheet);
            EvenlyDiscretizedFunc func0_5 = this.getFunc("Histogram Plot for Aperiodicity = 0.5 for " + sourceType + " for fileName " + fileName + " at Mag=" + mag, aperiodicity0_5, paramSettingsSheet, totProbColIndex, probSheet);
            this.addFuncs(func0_5, func0_3);
            EvenlyDiscretizedFunc func0_7 = this.getFunc("Histogram Plot for Aperiodicity = 0.7 for " + sourceType + " for fileName " + fileName + " at Mag=" + mag, aperiodicity0_7, paramSettingsSheet, totProbColIndex, probSheet);
            this.addFuncs(func0_7, func0_5);
            this.funcs = new ArrayList();
            this.funcs.add(func0_3);
            this.funcs.add(func0_5);
            this.funcs.add(func0_7);
            this.plottingCurveChars = new ArrayList();
            this.plottingCurveChars.add(this.STACKED_BAR1);
            this.plottingCurveChars.add(this.STACKED_BAR2);
            this.plottingCurveChars.add(this.STACKED_BAR3);
            GraphWindow graphWindow = new GraphWindow(this.getCurveFunctionList(), PLOT_LABEL, this.getPlottingFeatures());
            graphWindow.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void plotAprioiMoBal_ComparisonPlot(double mag, String fileName, String sourceType) {
        try {
            POIFSFileSystem fs = new POIFSFileSystem(this.getClass().getClassLoader().getResourceAsStream(fileName));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet paramSettingsSheet = wb.getSheetAt(0);
            ArrayList<Integer> moBal = this.getBranchIndices(paramSettingsSheet, "Wt On A-Priori Rates", "1.0E-4");
            ArrayList<Integer> apriori = this.getBranchIndices(paramSettingsSheet, "Wt On A-Priori Rates", "1.0E10");
            int totProbColIndex = this.getColIndexForMag(mag);
            HSSFSheet probSheet = wb.getSheet(sourceType);
            EvenlyDiscretizedFunc aprioriFunc = this.getFunc("Histogram Plot for Apriori for " + sourceType + " for fileName " + fileName + " at Mag=" + mag, apriori, paramSettingsSheet, totProbColIndex, probSheet);
            EvenlyDiscretizedFunc moBalFunc = this.getFunc("Histogram Plot for Mo Bal  for " + sourceType + " for fileName " + fileName + " at Mag=" + mag, moBal, paramSettingsSheet, totProbColIndex, probSheet);
            this.addFuncs(moBalFunc, aprioriFunc);
            this.funcs = new ArrayList();
            this.funcs.add(aprioriFunc);
            this.funcs.add(moBalFunc);
            this.plottingCurveChars = new ArrayList();
            this.plottingCurveChars.add(this.STACKED_BAR1);
            this.plottingCurveChars.add(this.STACKED_BAR2);
            GraphWindow graphWindow = new GraphWindow(this.getCurveFunctionList(), PLOT_LABEL, this.getPlottingFeatures());
            graphWindow.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addFuncs(EvenlyDiscretizedFunc func1, EvenlyDiscretizedFunc func2) {
        for (int i = 0; i < func1.size(); ++i) {
            func1.add(i, func2.getY(i));
        }
    }

    public void plotEmpiricalBPT_ComparisonProbPlot(double mag, String fileName, String sourceType) {
        try {
            POIFSFileSystem fs = new POIFSFileSystem(this.getClass().getClassLoader().getResourceAsStream(fileName));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet paramSettingsSheet = wb.getSheetAt(0);
            ArrayList<Integer> bptBranchIndices = this.getBranchIndices(paramSettingsSheet, "Probability Model", "BPT");
            bptBranchIndices.addAll(this.getBranchIndices(paramSettingsSheet, "Probability Model", "Poisson"));
            ArrayList<Integer> empiricalBranchIndices = this.getBranchIndices(paramSettingsSheet, "Probability Model", "Empirical");
            int totProbColIndex = this.getColIndexForMag(mag);
            HSSFSheet probSheet = wb.getSheet(sourceType);
            EvenlyDiscretizedFunc bptFunc = this.getFunc("Histogram Plot for BPT/Poisson for " + sourceType + " for fileName " + fileName + " at Mag=" + mag, bptBranchIndices, paramSettingsSheet, totProbColIndex, probSheet);
            EvenlyDiscretizedFunc empFunc = this.getFunc("Histogram Plot for Empirical for " + sourceType + " for fileName " + fileName + " at Mag=" + mag, empiricalBranchIndices, paramSettingsSheet, totProbColIndex, probSheet);
            this.addFuncs(empFunc, bptFunc);
            this.funcs = new ArrayList();
            this.funcs.add(bptFunc);
            this.funcs.add(empFunc);
            this.plottingCurveChars = new ArrayList();
            this.plottingCurveChars.add(this.STACKED_BAR1);
            this.plottingCurveChars.add(this.STACKED_BAR2);
            GraphWindow graphWindow = new GraphWindow(this.getCurveFunctionList(), PLOT_LABEL, this.getPlottingFeatures());
            graphWindow.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addMinMaxAvgSheet(String inputFileName) {
        try {
            FileInputStream is = new FileInputStream(inputFileName);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet paramSettingSheet = wb.getSheetAt(0);
            int numSheets = wb.getNumberOfSheets();
            ArrayList<Integer> bIndices = this.getBranchIndices(wb.getSheetAt(0), "Probability Model", null);
            HSSFSheet newSheet = wb.createSheet("MinMaxAvg");
            newSheet.createRow(0);
            newSheet.createRow(1);
            int startRowIndex = 2;
            for (int magIndex = 0; magIndex < this.mags.length; ++magIndex) {
                newSheet.createRow(magIndex + 2).createCell(0).setCellValue(this.mags[magIndex]);
            }
            int lastColIndex = this.mags.length;
            for (int sheetIndex = 1; sheetIndex < numSheets; ++sheetIndex) {
                String sheetName = wb.getSheetName(sheetIndex);
                HSSFSheet origSheet = wb.getSheetAt(sheetIndex);
                int startColIndex = 3 * (sheetIndex - 1) + 1;
                newSheet.getRow(0).createCell((int)((short)startColIndex)).setCellValue(sheetName);
                newSheet.getRow(1).createCell((int)((short)startColIndex)).setCellValue("Min");
                newSheet.getRow(1).createCell((int)((short)(startColIndex + 1))).setCellValue("Max");
                newSheet.getRow(1).createCell((int)((short)(startColIndex + 2))).setCellValue("Avg");
                for (int colIndex = 1; colIndex <= lastColIndex; ++colIndex) {
                    double[] minMaxAvg = this.getMinMaxAvg(paramSettingSheet, bIndices, colIndex, origSheet);
                    HSSFRow row = newSheet.getRow(2 + colIndex - 1);
                    row.createCell((int)((short)startColIndex)).setCellValue(minMaxAvg[0]);
                    row.createCell((int)((short)(startColIndex + 1))).setCellValue(minMaxAvg[1]);
                    row.createCell((int)((short)(startColIndex + 2))).setCellValue(minMaxAvg[2]);
                }
            }
            FileOutputStream fileOut = new FileOutputStream(inputFileName);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mkHistogramSheet(String inputFileName, String outputFileName) {
        try {
            POIFSFileSystem fs = new POIFSFileSystem(this.getClass().getClassLoader().getResourceAsStream(inputFileName));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            int numSheets = wb.getNumberOfSheets();
            ArrayList<Integer> bIndices = this.getBranchIndices(wb.getSheetAt(0), "Probability Model", null);
            HSSFWorkbook newWorkbook = new HSSFWorkbook();
            for (int sheetIndex = 1; sheetIndex < numSheets; ++sheetIndex) {
                int rowIndex;
                HSSFSheet origSheet = wb.getSheetAt(sheetIndex);
                int lastColIndex = this.mags.length;
                HSSFSheet newSheet = newWorkbook.createSheet(wb.getSheetName(sheetIndex));
                EvenlyDiscretizedFunc xValuesFunc = new EvenlyDiscretizedFunc(0.025, 0.975, NUM_PROB);
                for (rowIndex = 0; rowIndex < 2; ++rowIndex) {
                    HSSFRow newRow = newSheet.createRow(rowIndex);
                    HSSFRow origRow = origSheet.getRow(rowIndex);
                    if (origRow == null) continue;
                    for (int colIndex = 0; colIndex <= lastColIndex; ++colIndex) {
                        HSSFCell origCell = origRow.getCell((int)((short)colIndex));
                        if (origCell == null) continue;
                        newRow.createCell((int)((short)colIndex)).setCellValue(origCell.getStringCellValue());
                    }
                }
                rowIndex = 2;
                newSheet.createRow(rowIndex++).createCell(0).setCellValue("Min");
                newSheet.createRow(rowIndex++).createCell(0).setCellValue("Max");
                newSheet.createRow(rowIndex++).createCell(0).setCellValue("Avg");
                rowIndex = 6;
                for (int i = 0; i < xValuesFunc.size(); ++i) {
                    newSheet.createRow(rowIndex++).createCell(0).setCellValue(xValuesFunc.getX(i));
                }
                for (int colIndex = 1; colIndex <= lastColIndex; ++colIndex) {
                    double[] minMaxAvg = this.getMinMaxAvg(wb.getSheetAt(0), bIndices, colIndex, origSheet);
                    EvenlyDiscretizedFunc func = this.getFunc("", bIndices, wb.getSheetAt(0), colIndex, origSheet);
                    rowIndex = 2;
                    newSheet.getRow(rowIndex++).createCell((int)((short)colIndex)).setCellValue(minMaxAvg[0]);
                    newSheet.createRow(rowIndex++).createCell((int)((short)colIndex)).setCellValue(minMaxAvg[1]);
                    newSheet.createRow(rowIndex++).createCell((int)((short)colIndex)).setCellValue(minMaxAvg[2]);
                    rowIndex = 6;
                    for (int i = 0; i < func.size(); ++i) {
                        newSheet.createRow(rowIndex++).createCell((int)((short)colIndex)).setCellValue(func.getY(i));
                    }
                }
            }
            FileOutputStream fileOut = new FileOutputStream(outputFileName);
            newWorkbook.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private double[] getMinMaxAvg(HSSFSheet paramSettingsSheet, ArrayList<Integer> branchIndices, int probColIndex, HSSFSheet probSheet) {
        double totProb = 0.0;
        double totWt = 0.0;
        double minProb = Double.MAX_VALUE;
        double maxProb = Double.NEGATIVE_INFINITY;
        int weightColIndex = this.getColIndexForParam(paramSettingsSheet, "Branch Weight");
        for (int i = 0; i < branchIndices.size(); ++i) {
            int branchNum = branchIndices.get(i);
            double wt = paramSettingsSheet.getRow(branchNum).getCell((int)((short)weightColIndex)).getNumericCellValue();
            double prob = probSheet.getRow(branchNum + 1).getCell((int)((short)probColIndex)).getNumericCellValue();
            totProb += wt * prob;
            totWt += wt;
            if (prob > maxProb) {
                maxProb = prob;
            }
            if (!(prob < minProb)) continue;
            minProb = prob;
        }
        double[] minMaxAvg = new double[]{minProb, maxProb, totProb / totWt};
        return minMaxAvg;
    }

    private EvenlyDiscretizedFunc getFunc(String metadata, ArrayList<Integer> branchIndices, HSSFSheet paramSettingsSheet, int probColIndex, HSSFSheet probSheet) {
        int weightColIndex = this.getColIndexForParam(paramSettingsSheet, "Branch Weight");
        EvenlyDiscretizedFunc bptFunc = new EvenlyDiscretizedFunc(0.025, 0.975, NUM_PROB);
        bptFunc.setInfo(metadata);
        bptFunc.setTolerance(0.05);
        double totProbWt = 0.0;
        double totWt = 0.0;
        for (int i = 0; i < branchIndices.size(); ++i) {
            int branchNum = branchIndices.get(i);
            double wt = paramSettingsSheet.getRow(branchNum).getCell((int)((short)weightColIndex)).getNumericCellValue();
            totWt += wt;
            double prob = probSheet.getRow(branchNum + 1).getCell((int)((short)probColIndex)).getNumericCellValue();
            totProbWt += wt * prob;
            if (prob > 0.975) {
                prob = 0.975;
            }
            bptFunc.add(prob, wt);
        }
        bptFunc.setName("Mean=" + totProbWt / totWt);
        return bptFunc;
    }

    public void plotHistogramsForMagAndSource(double minMag, String fileName, String sourceType) {
        int colIndex = this.getColIndexForMag(minMag);
        try {
            POIFSFileSystem fs = new POIFSFileSystem(this.getClass().getClassLoader().getResourceAsStream(fileName));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheet(sourceType);
            ArrayList<Integer> bIndices = this.getBranchIndices(wb.getSheetAt(0), "Probability Model", null);
            EvenlyDiscretizedFunc func = this.getFunc("Histogram plot for " + fileName + " for Mag>=" + minMag, bIndices, wb.getSheetAt(0), colIndex, sheet);
            this.funcs = new ArrayList();
            this.funcs.add(func);
            this.plottingCurveChars = new ArrayList();
            this.plottingCurveChars.add(this.HISTOGRAM1);
            GraphWindow graphWindow = new GraphWindow(this.getCurveFunctionList(), PLOT_LABEL, this.getPlottingFeatures());
            graphWindow.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getColIndexForMag(double minMag) {
        boolean found = false;
        int colIndex = -1;
        for (int magIndex = 0; magIndex < this.mags.length && !found; ++magIndex) {
            if (this.mags[magIndex] != minMag) continue;
            colIndex = magIndex + 1;
            found = true;
        }
        if (!found) {
            throw new RuntimeException("Invalid minimum magnitude");
        }
        return colIndex;
    }

    private ArrayList<Integer> getBranchIndices(HSSFSheet sheet, String paramName, String value) {
        int colIndex = this.getColIndexForParam(sheet, paramName);
        int lastRowIndex = sheet.getLastRowNum();
        ArrayList<Integer> branchIndices = new ArrayList<Integer>();
        for (int i = 1; i <= lastRowIndex; ++i) {
            HSSFCell cell = sheet.getRow(i).getCell((int)((short)colIndex));
            if (cell == null) continue;
            String cellVal = cell.getStringCellValue();
            if (value != null && !cellVal.equals(value)) continue;
            branchIndices.add(i);
        }
        return branchIndices;
    }

    private int getColIndexForParam(HSSFSheet sheet, String paramName) {
        HSSFRow row = sheet.getRow(0);
        int firsColIndex = row.getFirstCellNum();
        short lastColIndex = row.getLastCellNum();
        for (int i = firsColIndex; i <= lastColIndex; ++i) {
            if (!row.getCell((int)((short)i)).getStringCellValue().equals(paramName)) continue;
            return i;
        }
        throw new RuntimeException("Parameter " + paramName + " does not exist in the sheet");
    }

    private void createParamSettingsSheet() {
        HSSFSheet paramSettingsSheet = this.workbook.createSheet("Parameter Settings");
        ParameterList adjustableParams = this.ucerf2EpistemicList.getParameterList(0);
        ListIterator<Parameter<?>> it = adjustableParams.getParametersIterator();
        ArrayList<String> adjustableParamNames = new ArrayList<String>();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            adjustableParamNames.add(param.getName());
        }
        HSSFRow row = paramSettingsSheet.createRow(0);
        for (int i = 1; i <= adjustableParamNames.size(); ++i) {
            row.createCell((int)((short)i)).setCellValue((String)adjustableParamNames.get(i - 1));
        }
        int weightCol = adjustableParamNames.size() + 1;
        row.createCell((int)((short)weightCol)).setCellValue("Branch Weight");
        int numERFs = this.ucerf2EpistemicList.getNumERFs();
        for (int i = 0; i < numERFs; ++i) {
            row = paramSettingsSheet.createRow(i + 1);
            row.createCell(0).setCellValue("Branch " + (i + 1));
            adjustableParams = this.ucerf2EpistemicList.getParameterList(i);
            for (int paramIndex = 0; paramIndex < adjustableParamNames.size(); ++paramIndex) {
                String pName = (String)adjustableParamNames.get(paramIndex);
                if (!adjustableParams.containsParameter(pName)) continue;
                row.createCell((int)((short)(paramIndex + 1))).setCellValue(adjustableParams.getValue(pName).toString());
            }
            row.createCell((int)((short)weightCol)).setCellValue(this.ucerf2EpistemicList.getERF_RelativeWeight(i));
        }
    }

    public ArrayList getCurveFunctionList() {
        return this.funcs;
    }

    public boolean getXLog() {
        return false;
    }

    public boolean getYLog() {
        return false;
    }

    public String getXAxisLabel() {
        return X_AXIS_LABEL;
    }

    public String getYAxisLabel() {
        return Y_AXIS_LABEL;
    }

    public ArrayList<PlotCurveCharacterstics> getPlottingFeatures() {
        return this.plottingCurveChars;
    }

    public boolean isCustomAxis() {
        return false;
    }

    public double getUserMinX() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    public double getUserMaxX() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    public double getUserMinY() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    public double getUserMaxY() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    public static void main(String[] args) {
        ProbabilityDistHistogramPlotter plotter = new ProbabilityDistHistogramPlotter();
        plotter.generateProbContributionsExcelSheet(true, 30.0, "src/org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/analysis/probContr/ProbabilityContributions_30yrs_LA_Box.xls", new CaliforniaRegions.LA_BOX());
        plotter.addMinMaxAvgSheet("src/org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/analysis/probContr/ProbabilityContributions_30yrs_LA_Box.xls");
    }
}

