/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import org.opensha.commons.geo.Location;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.DeformationModelSummaryDB_DAO;
import org.opensha.refFaultParamDb.vo.DeformationModelSummary;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.A_FaultsFetcher;
import org.opensha.sha.faultSurface.FaultTrace;

public class WriteSegLatLons {
    private DeformationModelSummaryDB_DAO defModelSummaryDAO = new DeformationModelSummaryDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private static final boolean IS_ASEIS_REDUCES_AREA = false;

    public WriteSegLatLons(String dir) {
        A_FaultsFetcher faultFetcher = new A_FaultsFetcher();
        ArrayList<DeformationModelSummary> defModelSummaryList = this.defModelSummaryDAO.getAllDeformationModels();
        String defModelName = "D2.1";
        DeformationModelSummary defModelSummary = null;
        for (int i = 0; i < defModelSummaryList.size() && defModelSummary == null; ++i) {
            if (!defModelSummaryList.get(i).getDeformationModelName().equalsIgnoreCase(defModelName)) continue;
            defModelSummary = defModelSummaryList.get(i);
        }
        faultFetcher.setDeformationModel(defModelSummary, false);
        ArrayList<FaultSegmentData> faultSegDataList = faultFetcher.getFaultSegmentDataList(false);
        try {
            for (int i = 0; i < faultSegDataList.size(); ++i) {
                FaultSegmentData faultSegData = faultSegDataList.get(i);
                ArrayList sectionToSegData = faultSegData.getSectionToSegmentData();
                String faultName = faultSegData.getFaultName();
                int numSegs = sectionToSegData.size();
                String faultDir = dir + "/" + faultName;
                File file = new File(faultDir);
                file.mkdirs();
                for (int segIndex = 0; segIndex < numSegs; ++segIndex) {
                    String segName = faultSegData.getSegmentName(segIndex);
                    ArrayList prefFaultSectionList = (ArrayList)sectionToSegData.get(segIndex);
                    FileWriter fw = new FileWriter(faultDir + "/" + segName + ".txt");
                    for (int prefFaultSectionId = 0; prefFaultSectionId < prefFaultSectionList.size(); ++prefFaultSectionId) {
                        FaultSectionPrefData prefFaultSectionData = (FaultSectionPrefData)prefFaultSectionList.get(prefFaultSectionId);
                        FaultTrace faultTrace = prefFaultSectionData.getFaultTrace();
                        for (int pt = 0; pt < faultTrace.getNumLocations(); ++pt) {
                            Location loc = (Location)faultTrace.get(pt);
                            fw.write((float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t0\n");
                        }
                    }
                    fw.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new WriteSegLatLons("SegmentFiles");
    }
}

