/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.NearCA_NSHMP;

import java.io.FileWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.FileUtils;

public class MakeNonCA_File {
    private static final String PATH = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/NearCA_NSHMP/";
    private CaliforniaRegions.RELM_GRIDDED relmRegion = new CaliforniaRegions.RELM_GRIDDED();
    private static final String OUT_FILE = "NonCA_Faults.txt";

    public MakeNonCA_File() {
        try {
            FileWriter fw = new FileWriter("org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/NearCA_NSHMP/NonCA_Faults.txt");
            this.processFile("azz.65", fw);
            this.processFile("nv.65.aug", fw);
            this.processFile("orwa.65.aug", fw);
            this.processFile("azc", fw);
            this.processFile("azgr", fw);
            this.processFile("nv.char", fw);
            this.processFile("nv.gr", fw);
            this.processFile("orwa.new.char", fw);
            this.processFile("orwa.new.gr", fw);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processFile(String fileName, FileWriter fw) {
        int i = 0;
        try {
            ArrayList<String> fileLines = FileUtils.loadFile(PATH + fileName);
            int numLines = fileLines.size();
            while (i < numLines) {
                ArrayList<String> faultLines = new ArrayList<String>();
                faultLines.add(fileLines.get(i++));
                faultLines.add(fileLines.get(i++));
                faultLines.add(fileLines.get(i++));
                faultLines.add(fileLines.get(i++));
                int numTracePoints = Integer.parseInt(((String)faultLines.get(3)).trim());
                boolean isFaultInsideRELM = false;
                for (int locIndex = 0; locIndex < numTracePoints; ++locIndex) {
                    String locLine = fileLines.get(i++);
                    faultLines.add(locLine);
                    StringTokenizer tokenizer = new StringTokenizer(locLine);
                    double latitude = Double.parseDouble(tokenizer.nextToken().trim());
                    double longitude = Double.parseDouble(tokenizer.nextToken().trim());
                    if (!this.relmRegion.contains(new Location(latitude, longitude))) continue;
                    isFaultInsideRELM = true;
                }
                if (!isFaultInsideRELM) continue;
                System.out.println((String)faultLines.get(0));
                for (int lineIndex = 0; lineIndex < faultLines.size(); ++lineIndex) {
                    fw.write((String)faultLines.get(lineIndex) + "\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new MakeNonCA_File();
    }
}

