/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;

public class A_FaultsMFD_Plotter {
    private static final String X_AXIS_LABEL = "Magnitude";
    private static final String RATE_AXIS_LABEL = "Rate (per year)";
    private static final String CUM_RATE_AXIS_LABEL = "Cum Rate (per year)";
    private String yAxisLabel;
    private List<DiscretizedFunc> funcs;
    private final PlotCurveCharacterstics PLOT_CHAR1 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 4.0f, Color.BLUE);
    private final PlotCurveCharacterstics PLOT_CHAR2 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 4.0f, Color.GRAY);
    private final PlotCurveCharacterstics PLOT_CHAR3 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 4.0f, Color.GREEN);
    private final PlotCurveCharacterstics PLOT_CHAR4 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 4.0f, Color.MAGENTA);
    private final PlotCurveCharacterstics PLOT_CHAR5 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 4.0f, Color.PINK);
    private final PlotCurveCharacterstics PLOT_CHAR6 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 4.0f, Color.YELLOW);
    private final PlotCurveCharacterstics PLOT_CHAR7 = new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, null, 4.0f, Color.RED);
    private final PlotCurveCharacterstics PLOT_CHAR8 = new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, null, 4.0f, Color.BLACK);
    private List<PlotCurveCharacterstics> plottingFeatures;

    public A_FaultsMFD_Plotter(List<DiscretizedFunc> funcs, boolean isCumRate) {
        this.funcs = funcs;
        this.yAxisLabel = isCumRate ? CUM_RATE_AXIS_LABEL : RATE_AXIS_LABEL;
        this.plottingFeatures = Lists.newArrayList();
        this.plottingFeatures.add(this.PLOT_CHAR8);
        this.plottingFeatures.add(this.PLOT_CHAR7);
        if (funcs.size() > 2) {
            this.plottingFeatures.add(this.PLOT_CHAR1);
            this.plottingFeatures.add(this.PLOT_CHAR2);
            this.plottingFeatures.add(this.PLOT_CHAR3);
            this.plottingFeatures.add(this.PLOT_CHAR4);
            this.plottingFeatures.add(this.PLOT_CHAR5);
            this.plottingFeatures.add(this.PLOT_CHAR6);
        }
    }

    public List<DiscretizedFunc> getCurveFunctionList() {
        return this.funcs;
    }

    public boolean getXLog() {
        return false;
    }

    public boolean getYLog() {
        return true;
    }

    public String getXAxisLabel() {
        return X_AXIS_LABEL;
    }

    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public List<PlotCurveCharacterstics> getPlottingFeatures() {
        return this.plottingFeatures;
    }

    public PlotSpec getPlotSpec() {
        return new PlotSpec(this.funcs, this.plottingFeatures, "", this.getXAxisLabel(), this.getYAxisLabel());
    }

    public void setPlottingFeatures(ArrayList plotFeatures) {
        this.plottingFeatures = plotFeatures;
    }

    public boolean isCustomAxis() {
        return true;
    }

    public double getUserMinX() {
        return 6.0;
    }

    public double getUserMaxX() {
        return 8.5;
    }

    public double getUserMinY() {
        return 1.0E-7;
    }

    public double getUserMaxY() {
        return 0.1;
    }
}

