/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;

public class CreatePlotFromMagRateFile {
    private static final String X_AXIS_LABEL = "Index";
    private static final String Y_AXIS_LABEL = "Rate";
    private static final String PLOT_LABEL = "Rates";
    private ArrayList funcs;
    private static final String[] names = new String[]{"A-Priori Rates", "Char Rate", "Ellsworth-A_Uniform/Boxcar", "Ellsworth-A_WGCEP-2002", "Ellsworth-A_Tapered", "Ellsworth-B_Uniform/Boxcar", "Ellsworth-B_WGCEP-2002", "Ellsworth-B_Tapered", "Hanks & Bakun (2002)_Uniform/Boxcar", "Hanks & Bakun (2002)_WGCEP-2002", "Hanks & Bakun (2002)_Tapered", "Somerville (2006)_Uniform/Boxcar", "Somerville (2006)_WGCEP-2002", "Somerville (2006)_Tapered"};
    private final PlotCurveCharacterstics PLOT_CHAR1 = new PlotCurveCharacterstics(PlotSymbol.CROSS, 10.0f, new Color(0, 0, 0));
    private final PlotCurveCharacterstics PLOT_CHAR2 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(192, 192, 192));
    private final PlotCurveCharacterstics PLOT_CHAR3 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(128, 0, 0));
    private final PlotCurveCharacterstics PLOT_CHAR4 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(255, 0, 0));
    private final PlotCurveCharacterstics PLOT_CHAR5 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(128, 0, 128));
    private final PlotCurveCharacterstics PLOT_CHAR6 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(255, 0, 255));
    private final PlotCurveCharacterstics PLOT_CHAR7 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(0, 128, 0));
    private final PlotCurveCharacterstics PLOT_CHAR8 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(0, 255, 0));
    private final PlotCurveCharacterstics PLOT_CHAR9 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(128, 128, 0));
    private final PlotCurveCharacterstics PLOT_CHAR10 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(255, 255, 0));
    private final PlotCurveCharacterstics PLOT_CHAR11 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(0, 0, 128));
    private final PlotCurveCharacterstics PLOT_CHAR12 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(0, 0, 255));
    private final PlotCurveCharacterstics PLOT_CHAR13 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(0, 128, 128));
    private final PlotCurveCharacterstics PLOT_CHAR14 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(0, 255, 255));
    private boolean yLog = false;

    public CreatePlotFromMagRateFile(ArrayList funcList) {
        this.funcs = funcList;
    }

    public ArrayList getCurveFunctionList() {
        return this.funcs;
    }

    public boolean getXLog() {
        return false;
    }

    public void setYLog(boolean yLog) {
        this.yLog = yLog;
    }

    public boolean getYLog() {
        return this.yLog;
    }

    public String getXAxisLabel() {
        return X_AXIS_LABEL;
    }

    public String getYAxisLabel() {
        return Y_AXIS_LABEL;
    }

    public ArrayList getPlottingFeatures() {
        ArrayList<PlotCurveCharacterstics> list = new ArrayList<PlotCurveCharacterstics>();
        int numFuncs = this.funcs.size();
        if (numFuncs > 0) {
            list.add(this.PLOT_CHAR7);
        }
        if (numFuncs > 1) {
            list.add(this.PLOT_CHAR1);
        }
        if (numFuncs > 2) {
            list.add(this.PLOT_CHAR3);
        }
        if (numFuncs > 3) {
            list.add(this.PLOT_CHAR4);
        }
        if (numFuncs > 4) {
            list.add(this.PLOT_CHAR5);
        }
        if (numFuncs > 5) {
            list.add(this.PLOT_CHAR6);
        }
        if (numFuncs > 6) {
            list.add(this.PLOT_CHAR2);
        }
        if (numFuncs > 7) {
            list.add(this.PLOT_CHAR8);
        }
        if (numFuncs > 8) {
            list.add(this.PLOT_CHAR9);
        }
        if (numFuncs > 9) {
            list.add(this.PLOT_CHAR10);
        }
        if (numFuncs > 10) {
            list.add(this.PLOT_CHAR11);
        }
        if (numFuncs > 11) {
            list.add(this.PLOT_CHAR12);
        }
        if (numFuncs > 12) {
            list.add(this.PLOT_CHAR13);
        }
        if (numFuncs > 13) {
            list.add(this.PLOT_CHAR14);
        }
        return list;
    }

    public boolean isCustomAxis() {
        return false;
    }

    public double getUserMinX() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    public double getUserMaxX() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    public double getUserMinY() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    public double getUserMaxY() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    public static void createPlots(String masterDirName, String excelSheetName) {
        try {
            String dirName = masterDirName + "/A_FaultRupRatesPlots_2_1/";
            File file = new File(dirName);
            if (!file.isDirectory()) {
                file.mkdir();
            }
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(excelSheetName));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            String[] models = new String[]{"Geological Insight", "Min Rate", "Max Rate"};
            for (int i = 1; i < wb.getNumberOfSheets() - 2; ++i) {
                HSSFSheet sheet = wb.getSheetAt(i);
                String sheetName = wb.getSheetName(i);
                int lastIndex = sheet.getLastRowNum();
                int count = 0;
                for (int r = 3; r <= lastIndex && count < 3; ++r) {
                    int j = -1;
                    String modelType = models[count++];
                    ArrayList<ArbitrarilyDiscretizedFunc> funcList = new ArrayList<ArbitrarilyDiscretizedFunc>();
                    for (int k = 0; k < 14; ++k) {
                        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
                        func.setName(names[k]);
                        funcList.add(func);
                    }
                    while (true) {
                        ++j;
                        HSSFRow row = sheet.getRow(r);
                        HSSFCell cell = row.getCell(0);
                        String rupName = cell.getStringCellValue().trim();
                        if (rupName.equalsIgnoreCase("Totals")) {
                            r += 5;
                            break;
                        }
                        ((ArbitrarilyDiscretizedFunc)funcList.get(0)).set((double)j, row.getCell(1).getNumericCellValue());
                        ((ArbitrarilyDiscretizedFunc)funcList.get(1)).set((double)j, row.getCell(3).getNumericCellValue());
                        ((ArbitrarilyDiscretizedFunc)funcList.get(2)).set((double)j, row.getCell(5).getNumericCellValue());
                        ((ArbitrarilyDiscretizedFunc)funcList.get(3)).set((double)j, row.getCell(6).getNumericCellValue());
                        ((ArbitrarilyDiscretizedFunc)funcList.get(4)).set((double)j, row.getCell(7).getNumericCellValue());
                        ((ArbitrarilyDiscretizedFunc)funcList.get(5)).set((double)j, row.getCell(9).getNumericCellValue());
                        ((ArbitrarilyDiscretizedFunc)funcList.get(6)).set((double)j, row.getCell(10).getNumericCellValue());
                        ((ArbitrarilyDiscretizedFunc)funcList.get(7)).set((double)j, row.getCell(11).getNumericCellValue());
                        ((ArbitrarilyDiscretizedFunc)funcList.get(8)).set((double)j, row.getCell(13).getNumericCellValue());
                        ((ArbitrarilyDiscretizedFunc)funcList.get(9)).set((double)j, row.getCell(14).getNumericCellValue());
                        ((ArbitrarilyDiscretizedFunc)funcList.get(10)).set((double)j, row.getCell(15).getNumericCellValue());
                        ((ArbitrarilyDiscretizedFunc)funcList.get(11)).set((double)j, row.getCell(17).getNumericCellValue());
                        ((ArbitrarilyDiscretizedFunc)funcList.get(12)).set((double)j, row.getCell(18).getNumericCellValue());
                        ((ArbitrarilyDiscretizedFunc)funcList.get(13)).set((double)j, row.getCell(19).getNumericCellValue());
                        ++r;
                    }
                    CreatePlotFromMagRateFile plot = new CreatePlotFromMagRateFile(funcList);
                    GraphWindow graphWindow = new GraphWindow(plot.getCurveFunctionList(), PLOT_LABEL, plot.getPlottingFeatures());
                    graphWindow.setX_AxisLabel(plot.getXAxisLabel());
                    graphWindow.setY_AxisLabel(plot.getYAxisLabel());
                    graphWindow.setTitle(sheetName + " " + modelType);
                    graphWindow.pack();
                    graphWindow.setVisible(true);
                    graphWindow.getGraphWidget().saveAsPDF(dirName + sheetName + " " + modelType + ".pdf");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

