/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;

public class CreatePlotFromSegRecurIntvFile {
    private static final String X_AXIS_LABEL = "Index";
    private static final String Y_AXIS_LABEL = "Recurrence Interval";
    private static final String PLOT_LABEL = "Segment Recurrence Intervals";
    private ArrayList funcs;
    private static final String[] names = new String[]{"Mean Recurrence Interval", "Min Recurrence Interval", "Max Recurrence Interval", "Characteristic", "Ellsworth-A_UniformBoxcar", "Ellsworth-A_WGCEP-2002", "Ellsworth-A_Tapered", "Ellsworth-B_UniformBoxcar", "Ellsworth-B_WGCEP-2002", "Ellsworth-B_Tapered", "Hanks & Bakun (2002)_UniformBoxcar", "Hanks & Bakun (2002)_WGCEP-2002", "Hanks & Bakun (2002)_Tapered", "Somerville (2006)_UniformBoxcar", "Somerville (2006)_WGCEP-2002", "Somerville (2006)_Tapered"};
    private final PlotCurveCharacterstics PLOT_CHAR1 = new PlotCurveCharacterstics(PlotSymbol.CROSS, 10.0f, new Color(0, 0, 0));
    private final PlotCurveCharacterstics PLOT_CHAR2 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(192, 192, 192));
    private final PlotCurveCharacterstics PLOT_CHAR3 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(128, 0, 0));
    private final PlotCurveCharacterstics PLOT_CHAR4 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(255, 0, 0));
    private final PlotCurveCharacterstics PLOT_CHAR5 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(128, 0, 128));
    private final PlotCurveCharacterstics PLOT_CHAR6 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(255, 0, 255));
    private final PlotCurveCharacterstics PLOT_CHAR7 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(0, 128, 0));
    private final PlotCurveCharacterstics PLOT_CHAR8 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(0, 255, 0));
    private final PlotCurveCharacterstics PLOT_CHAR9 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(128, 128, 0));
    private final PlotCurveCharacterstics PLOT_CHAR10 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(255, 255, 0));
    private final PlotCurveCharacterstics PLOT_CHAR11 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(0, 0, 128));
    private final PlotCurveCharacterstics PLOT_CHAR12 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(0, 0, 255));
    private final PlotCurveCharacterstics PLOT_CHAR13 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(0, 128, 128));
    private final PlotCurveCharacterstics PLOT_CHAR14 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, new Color(0, 255, 255));

    public CreatePlotFromSegRecurIntvFile(ArrayList funcList) {
        this.funcs = funcList;
    }

    public ArrayList getCurveFunctionList() {
        return this.funcs;
    }

    public boolean getXLog() {
        return false;
    }

    public boolean getYLog() {
        return true;
    }

    public String getXAxisLabel() {
        return X_AXIS_LABEL;
    }

    public String getYAxisLabel() {
        return Y_AXIS_LABEL;
    }

    public ArrayList getPlottingFeatures() {
        ArrayList<PlotCurveCharacterstics> list = new ArrayList<PlotCurveCharacterstics>();
        list.add(this.PLOT_CHAR1);
        list.add(this.PLOT_CHAR1);
        list.add(this.PLOT_CHAR1);
        list.add(this.PLOT_CHAR2);
        list.add(this.PLOT_CHAR3);
        list.add(this.PLOT_CHAR4);
        list.add(this.PLOT_CHAR5);
        list.add(this.PLOT_CHAR6);
        list.add(this.PLOT_CHAR7);
        list.add(this.PLOT_CHAR8);
        list.add(this.PLOT_CHAR9);
        list.add(this.PLOT_CHAR10);
        list.add(this.PLOT_CHAR11);
        list.add(this.PLOT_CHAR12);
        list.add(this.PLOT_CHAR13);
        list.add(this.PLOT_CHAR14);
        return list;
    }

    public boolean isCustomAxis() {
        return false;
    }

    public double getUserMinX() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    public double getUserMaxX() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    public double getUserMinY() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    public double getUserMaxY() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    public static void createPlots(String masterDirName, String excelSheetName) {
        try {
            String dirName = masterDirName + "/A_FaultSegRecurIntvPlots_2_1/";
            File file = new File(dirName);
            if (!file.isDirectory()) {
                file.mkdir();
            }
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(excelSheetName));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            String[] models = new String[]{"Geological Insight", "Min Rate", "Max Rate"};
            for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                HSSFSheet sheet = wb.getSheetAt(i);
                String sheetName = wb.getSheetName(i);
                int lastIndex = sheet.getLastRowNum();
                int count = 0;
                for (int r = 3; r <= lastIndex; ++r) {
                    int j = -1;
                    String modelType = models[count++];
                    ArrayList<ArbitrarilyDiscretizedFunc> funcList = new ArrayList<ArbitrarilyDiscretizedFunc>();
                    for (int k = 0; k < 16; ++k) {
                        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
                        func.setName(names[k]);
                        funcList.add(func);
                    }
                    while (true) {
                        ++j;
                        HSSFRow row = sheet.getRow(r);
                        HSSFCell cell = null;
                        String rupName = "";
                        if (row != null) {
                            cell = row.getCell(0);
                        }
                        if (cell != null) {
                            rupName = cell.getStringCellValue().trim();
                        }
                        if (row == null || cell == null || cell.getCellType() == 3 || rupName.equalsIgnoreCase("")) {
                            r += 4;
                            break;
                        }
                        for (int col = 1; col <= names.length; ++col) {
                            cell = row.getCell((int)((short)col));
                            if (cell == null) continue;
                            ((ArbitrarilyDiscretizedFunc)funcList.get(col - 1)).set((double)j, cell.getNumericCellValue());
                        }
                        ++r;
                    }
                    JOptionPane.showMessageDialog(null, "This was disabled during refactor because it will probably never be used again. If you need it, resurrect it.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

