/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import java.awt.Color;
import java.util.ArrayList;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class EqkRateModel2_MFDsPlotter {
    private static final String X_AXIS_LABEL = "Magnitude";
    private static final String Y_AXIS_LABEL = "Rate";
    private ArrayList funcs;
    private final PlotCurveCharacterstics PLOT_CHAR1 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE);
    private final PlotCurveCharacterstics PLOT_CHAR2 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.LIGHT_GRAY);
    private final PlotCurveCharacterstics PLOT_CHAR3 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN);
    private final PlotCurveCharacterstics PLOT_CHAR4 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.MAGENTA);
    private final PlotCurveCharacterstics PLOT_CHAR5 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.PINK);
    private final PlotCurveCharacterstics PLOT_CHAR6 = new PlotCurveCharacterstics(PlotLineType.SOLID, 5.0f, Color.BLACK);
    private final PlotCurveCharacterstics PLOT_CHAR7 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED);
    private final PlotCurveCharacterstics PLOT_CHAR8 = new PlotCurveCharacterstics(PlotSymbol.CROSS, 5.0f, Color.RED);
    private final PlotCurveCharacterstics PLOT_CHAR9 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.ORANGE);
    private static final String A_FAULTS_METADATA = "Type A-Faults Total Mag Freq Dist";
    private static final String B_FAULTS_CHAR_METADATA = "Type B-Faults Total Char Mag Freq Dist";
    private static final String B_FAULTS_GR_METADATA = "Type B-Faults Total GR Mag Freq Dist";
    private static final String NON_CA_B_FAULTS_METADATA = "Non-CA Type B-Faults Total Mag Freq Dist";
    private static final String BACKGROUND_METADATA = "BackGround Total  Mag Freq Dist";
    private static final String C_ZONES_METADATA = "C Zone Total  Mag Freq Dist";
    private static final String TOTAL_METADATA = "Total  Mag Freq Dist";

    public EqkRateModel2_MFDsPlotter(UCERF2 ucerf2, boolean isCumMFD) {
        if (isCumMFD) {
            this.createCumFunctionList(ucerf2);
        } else {
            this.createIncrFunctionList(ucerf2);
        }
    }

    private void createCumFunctionList(UCERF2 ucerf2) {
        this.funcs = new ArrayList();
        EvenlyDiscretizedFunc cumDist = ucerf2.getTotal_A_FaultsMFD().getCumRateDistWithOffset();
        cumDist.setInfo(A_FAULTS_METADATA);
        this.funcs.add(cumDist);
        cumDist = ucerf2.getTotal_B_FaultsCharMFD().getCumRateDistWithOffset();
        cumDist.setInfo(B_FAULTS_CHAR_METADATA);
        this.funcs.add(cumDist);
        cumDist = ucerf2.getTotal_B_FaultsGR_MFD().getCumRateDistWithOffset();
        cumDist.setInfo(B_FAULTS_GR_METADATA);
        this.funcs.add(cumDist);
        cumDist = ucerf2.getTotal_NonCA_B_FaultsMFD().getCumRateDistWithOffset();
        cumDist.setInfo(NON_CA_B_FAULTS_METADATA);
        this.funcs.add(cumDist);
        cumDist = ucerf2.getTotal_BackgroundMFD().getCumRateDistWithOffset();
        cumDist.setInfo(BACKGROUND_METADATA);
        this.funcs.add(cumDist);
        cumDist = ucerf2.getTotal_C_ZoneMFD().getCumRateDistWithOffset();
        cumDist.setInfo(C_ZONES_METADATA);
        this.funcs.add(cumDist);
        cumDist = ucerf2.getTotalMFD().getCumRateDistWithOffset();
        cumDist.setInfo(TOTAL_METADATA);
        this.funcs.add(cumDist);
        boolean includeAfterShocks = ucerf2.areAfterShocksIncluded();
        ArrayList<EvenlyDiscretizedFunc> obsCumMFD = UCERF2.getObsCumMFD(includeAfterShocks);
        this.funcs.add(obsCumMFD.get(0));
        this.funcs.addAll(obsCumMFD);
    }

    private void createIncrFunctionList(UCERF2 eqkRateModelERF) {
        this.funcs = new ArrayList();
        IncrementalMagFreqDist incrMFD = eqkRateModelERF.getTotal_A_FaultsMFD();
        incrMFD.setInfo(A_FAULTS_METADATA);
        this.funcs.add(incrMFD);
        incrMFD = eqkRateModelERF.getTotal_B_FaultsCharMFD();
        incrMFD.setInfo(B_FAULTS_CHAR_METADATA);
        this.funcs.add(incrMFD);
        incrMFD = eqkRateModelERF.getTotal_B_FaultsGR_MFD();
        incrMFD.setInfo(B_FAULTS_GR_METADATA);
        this.funcs.add(incrMFD);
        incrMFD = eqkRateModelERF.getTotal_NonCA_B_FaultsMFD();
        incrMFD.setInfo(NON_CA_B_FAULTS_METADATA);
        this.funcs.add(incrMFD);
        incrMFD = eqkRateModelERF.getTotal_BackgroundMFD();
        incrMFD.setInfo(BACKGROUND_METADATA);
        this.funcs.add(incrMFD);
        incrMFD = eqkRateModelERF.getTotal_C_ZoneMFD();
        incrMFD.setInfo(C_ZONES_METADATA);
        this.funcs.add(incrMFD);
        incrMFD = eqkRateModelERF.getTotalMFD();
        incrMFD.setInfo(TOTAL_METADATA);
        this.funcs.add(incrMFD);
        boolean includeAfterShocks = eqkRateModelERF.areAfterShocksIncluded();
        ArrayList<ArbitrarilyDiscretizedFunc> obsIncrMFDList = UCERF2.getObsIncrMFD(includeAfterShocks);
        this.funcs.add(obsIncrMFDList.get(0));
        this.funcs.addAll(obsIncrMFDList);
    }

    public ArrayList getCurveFunctionList() {
        return this.funcs;
    }

    public boolean getXLog() {
        return false;
    }

    public boolean getYLog() {
        return true;
    }

    public String getXAxisLabel() {
        return X_AXIS_LABEL;
    }

    public String getYAxisLabel() {
        return Y_AXIS_LABEL;
    }

    public ArrayList getPlottingFeatures() {
        ArrayList<PlotCurveCharacterstics> list = new ArrayList<PlotCurveCharacterstics>();
        list.add(this.PLOT_CHAR1);
        list.add(this.PLOT_CHAR2);
        list.add(this.PLOT_CHAR3);
        list.add(this.PLOT_CHAR9);
        list.add(this.PLOT_CHAR4);
        list.add(this.PLOT_CHAR5);
        list.add(this.PLOT_CHAR6);
        if (this.funcs.size() > 7) {
            list.add(this.PLOT_CHAR7);
        }
        if (this.funcs.size() > 8) {
            list.add(this.PLOT_CHAR8);
        }
        if (this.funcs.size() > 9) {
            list.add(this.PLOT_CHAR8);
        }
        if (this.funcs.size() > 10) {
            list.add(this.PLOT_CHAR8);
        }
        return list;
    }

    public boolean isCustomAxis() {
        return true;
    }

    public double getUserMinX() {
        return 5.0;
    }

    public double getUserMaxX() {
        return 9.255;
    }

    public double getUserMinY() {
        return 1.0E-4;
    }

    public double getUserMaxY() {
        return 10.0;
    }
}

