/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults.A_FaultSegmentedSourceGenerator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.UCERF1MfdReader;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.CreatePlotFromMagRateFile;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.RupAveSlipTableModel;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.RuptureTableModel;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class RuptureDataPanel
extends JPanel
implements ActionListener {
    private RuptureTableModel rupTableModel = new RuptureTableModel();
    private JButton mfdButton = new JButton("Plot Selected Fault MFDs");
    private JButton magAreaPlotButton = new JButton("Mag Area Plot (Color coded by Relative Rup Rates)");
    private JButton magAreaPlotButton2 = new JButton("Mag Area Plot (Color coded by Fault names)");
    private JButton aveSlipDataButton = new JButton("Show Ave Slip Data");
    private JButton rupRatesButton = new JButton("Plot A-Priori and final rates");
    private JButton rupRatesRatioButton = new JButton("(FinalRate-A_PrioriRate)/Max(A_PrioriRate,FinalRate)");
    private A_FaultSegmentedSourceGenerator source;
    public final PlotCurveCharacterstics PLOT_CHAR1 = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 2.0f, Color.BLUE);
    protected final PlotCurveCharacterstics PLOT_CHAR2 = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 2.0f, Color.RED);
    protected final PlotCurveCharacterstics PLOT_CHAR3 = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 2.0f, Color.GREEN);
    protected final PlotCurveCharacterstics PLOT_CHAR4 = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 2.0f, Color.BLACK);
    protected final PlotCurveCharacterstics PLOT_CHAR5 = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 2.0f, Color.MAGENTA);
    protected final PlotCurveCharacterstics PLOT_CHAR6 = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 2.0f, Color.ORANGE);
    protected final PlotCurveCharacterstics PLOT_CHAR7 = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 2.0f, Color.PINK);
    protected final PlotCurveCharacterstics PLOT_CHAR8 = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 2.0f, Color.YELLOW);
    protected final PlotCurveCharacterstics PLOT_CHAR9 = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 2.0f, Color.CYAN);
    protected final PlotCurveCharacterstics PLOT_CHAR10 = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 2.0f, Color.DARK_GRAY);
    protected final PlotCurveCharacterstics PLOT_CHAR11 = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 2.0f, Color.LIGHT_GRAY);
    protected final PlotCurveCharacterstics PLOT_CHAR12 = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 2.0f, Color.GRAY);
    public final PlotCurveCharacterstics MAG_AREA_PLOT_CHAR1 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE);
    protected final PlotCurveCharacterstics MAG_AREA_PLOT_CHAR2 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED);
    protected final PlotCurveCharacterstics MAG_AREA_PLOT_CHAR3 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN);
    protected final PlotCurveCharacterstics MAG_AREA_PLOT_CHAR4 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK);
    protected final PlotCurveCharacterstics MAG_AREA_PLOT_CHAR5 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.MAGENTA);
    protected final PlotCurveCharacterstics MAG_AREA_PLOT_CHAR6 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.ORANGE);
    protected final PlotCurveCharacterstics MAG_AREA_PLOT_CHAR7 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.PINK);
    private static final double MIN_AREA = 100.0;
    private static final double MAX_AREA = 10000.0;
    private ArrayList plottingFeatures;
    private ArrayList magAreaFuncs;
    private ArrayList aFaultSegmentedSourceList;
    private ArrayList magAreaRels;

    public RuptureDataPanel() {
        this.setLayout(new GridBagLayout());
        JTable table = new JTable(this.rupTableModel);
        table.setColumnSelectionAllowed(true);
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.mfdButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.magAreaPlotButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.magAreaPlotButton2, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.aveSlipDataButton, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.rupRatesButton, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.rupRatesRatioButton, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aveSlipDataButton.setToolTipText("Show Average Slip for each segment for each rupture");
        this.mfdButton.addActionListener(this);
        this.magAreaPlotButton.addActionListener(this);
        this.magAreaPlotButton2.addActionListener(this);
        this.aveSlipDataButton.addActionListener(this);
        this.rupRatesButton.addActionListener(this);
        this.rupRatesRatioButton.addActionListener(this);
    }

    public void setSourcesForMagAreaPlot(ArrayList aFaultSegmentedSourceList, ArrayList magAreaRels) {
        this.aFaultSegmentedSourceList = aFaultSegmentedSourceList;
        this.magAreaRels = magAreaRels;
    }

    private void createFuncListColorCodingByRupRates() {
        double area;
        int i;
        this.plottingFeatures = new ArrayList();
        this.magAreaFuncs = new ArrayList();
        this.magAreaPlotButton.setEnabled(true);
        int numFaults = this.aFaultSegmentedSourceList.size();
        int numMagAreaRels = this.magAreaRels.size();
        int numRateDiscretizations = 30;
        for (int i2 = 0; i2 < numRateDiscretizations; ++i2) {
            ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
            this.magAreaFuncs.add(func);
        }
        double maxRelativeRate = 1.0;
        double minRelativeRate = 0.001;
        double deltaRate = (Math.log10(maxRelativeRate) - Math.log10(minRelativeRate)) / (double)numRateDiscretizations;
        for (i = 0; i < numFaults; ++i) {
            A_FaultSegmentedSourceGenerator aFaultSegmentedSource = (A_FaultSegmentedSourceGenerator)this.aFaultSegmentedSourceList.get(i);
            double[] relativeRupRates = this.getRelativeRupRates(aFaultSegmentedSource);
            for (int j = 0; j < aFaultSegmentedSource.getNumRupSources(); ++j) {
                area = aFaultSegmentedSource.getRupArea(j) / 1000000.0;
                int index = relativeRupRates[j] <= minRelativeRate ? numRateDiscretizations - 1 : numRateDiscretizations - (int)((Math.log10(relativeRupRates[j]) - Math.log10(minRelativeRate)) / deltaRate);
                ArbitrarilyDiscretizedFunc func = (ArbitrarilyDiscretizedFunc)this.magAreaFuncs.get(index);
                if (func.getXIndex(area) != -1) {
                    System.out.println("RuptureDataPanel::setSourcesForMagAreaPlot()::**********Duplicate Area********");
                }
                func.set(area, aFaultSegmentedSource.getRupMeanMag(j));
            }
        }
        for (i = 0; i < this.magAreaFuncs.size(); ++i) {
            ArbitrarilyDiscretizedFunc func = (ArbitrarilyDiscretizedFunc)this.magAreaFuncs.get(i);
            if (func.size() != 0) continue;
            this.magAreaFuncs.remove(i);
            --i;
        }
        int minColor = 0;
        int maxColor = 255;
        int deltaColor = (maxColor - minColor) / this.magAreaFuncs.size();
        for (int i3 = 0; i3 < this.magAreaFuncs.size(); ++i3) {
            int colorVal = minColor + i3 * deltaColor;
            this.plottingFeatures.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 2.0f, new Color(colorVal, colorVal, colorVal)));
        }
        double min = Math.log10(100.0);
        double max = Math.log10(10000.0);
        int numPoints = 101;
        double delta = (max - min) / (double)(numPoints - 1);
        for (int i4 = 0; i4 < numMagAreaRels; ++i4) {
            MagAreaRelationship magAreaRel = (MagAreaRelationship)this.magAreaRels.get(i4);
            ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
            for (int j = 0; j <= numPoints; ++j) {
                area = Math.pow(10.0, min + (double)j * delta);
                func.set(area, magAreaRel.getMedianMag(area));
            }
            func.setName(magAreaRel.getName());
            this.magAreaFuncs.add(func);
        }
        if (numMagAreaRels > 0) {
            this.plottingFeatures.add(this.MAG_AREA_PLOT_CHAR1);
        }
        if (numMagAreaRels > 1) {
            this.plottingFeatures.add(this.MAG_AREA_PLOT_CHAR2);
        }
        if (numMagAreaRels > 2) {
            this.plottingFeatures.add(this.MAG_AREA_PLOT_CHAR3);
        }
        if (numMagAreaRels > 3) {
            this.plottingFeatures.add(this.MAG_AREA_PLOT_CHAR4);
        }
        if (numMagAreaRels > 4) {
            this.plottingFeatures.add(this.MAG_AREA_PLOT_CHAR5);
        }
        if (numMagAreaRels > 5) {
            this.plottingFeatures.add(this.MAG_AREA_PLOT_CHAR6);
        }
        if (numMagAreaRels > 6) {
            this.plottingFeatures.add(this.MAG_AREA_PLOT_CHAR7);
        }
    }

    public void setColorCodingbyFaultNames() {
        double area;
        this.plottingFeatures = new ArrayList();
        this.magAreaFuncs = new ArrayList();
        int numFaults = this.aFaultSegmentedSourceList.size();
        int numMagAreaRels = this.magAreaRels.size();
        for (int i = 0; i < numFaults; ++i) {
            A_FaultSegmentedSourceGenerator aFaultSegmentedSource = (A_FaultSegmentedSourceGenerator)this.aFaultSegmentedSourceList.get(i);
            ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
            for (int j = 0; j < aFaultSegmentedSource.getNumRupSources(); ++j) {
                area = aFaultSegmentedSource.getRupArea(j) / 1000000.0;
                if (func.getXIndex(area) != -1) {
                    System.out.println("RuptureDataPanel::setSourcesForMagAreaPlot()::**********Duplicate Area********");
                }
                func.set(area, aFaultSegmentedSource.getRupMeanMag(j));
            }
            func.setName(aFaultSegmentedSource.getFaultSegmentData().getFaultName());
            this.magAreaFuncs.add(func);
        }
        double min = Math.log10(100.0);
        double max = Math.log10(10000.0);
        int numPoints = 101;
        double delta = (max - min) / (double)(numPoints - 1);
        for (int i = 0; i < numMagAreaRels; ++i) {
            MagAreaRelationship magAreaRel = (MagAreaRelationship)this.magAreaRels.get(i);
            ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
            for (int j = 0; j <= numPoints; ++j) {
                area = Math.pow(10.0, min + (double)j * delta);
                func.set(area, magAreaRel.getMedianMag(area));
            }
            func.setName(magAreaRel.getName());
            this.magAreaFuncs.add(func);
        }
        if (numFaults > 0) {
            this.plottingFeatures.add(this.PLOT_CHAR1);
        }
        if (numFaults > 1) {
            this.plottingFeatures.add(this.PLOT_CHAR2);
        }
        if (numFaults > 2) {
            this.plottingFeatures.add(this.PLOT_CHAR3);
        }
        if (numFaults > 3) {
            this.plottingFeatures.add(this.PLOT_CHAR4);
        }
        if (numFaults > 4) {
            this.plottingFeatures.add(this.PLOT_CHAR5);
        }
        if (numFaults > 5) {
            this.plottingFeatures.add(this.PLOT_CHAR6);
        }
        if (numFaults > 6) {
            this.plottingFeatures.add(this.PLOT_CHAR7);
        }
        if (numFaults > 7) {
            this.plottingFeatures.add(this.PLOT_CHAR8);
        }
        if (numFaults > 8) {
            this.plottingFeatures.add(this.PLOT_CHAR9);
        }
        if (numFaults > 9) {
            this.plottingFeatures.add(this.PLOT_CHAR10);
        }
        if (numFaults > 10) {
            this.plottingFeatures.add(this.PLOT_CHAR11);
        }
        if (numFaults > 11) {
            this.plottingFeatures.add(this.PLOT_CHAR12);
        }
        if (numMagAreaRels > 0) {
            this.plottingFeatures.add(this.MAG_AREA_PLOT_CHAR1);
        }
        if (numMagAreaRels > 1) {
            this.plottingFeatures.add(this.MAG_AREA_PLOT_CHAR2);
        }
        if (numMagAreaRels > 2) {
            this.plottingFeatures.add(this.MAG_AREA_PLOT_CHAR3);
        }
        if (numMagAreaRels > 3) {
            this.plottingFeatures.add(this.MAG_AREA_PLOT_CHAR4);
        }
        if (numMagAreaRels > 4) {
            this.plottingFeatures.add(this.MAG_AREA_PLOT_CHAR5);
        }
        if (numMagAreaRels > 5) {
            this.plottingFeatures.add(this.MAG_AREA_PLOT_CHAR6);
        }
        if (numMagAreaRels > 6) {
            this.plottingFeatures.add(this.MAG_AREA_PLOT_CHAR7);
        }
    }

    public double[] getRelativeRupRates(A_FaultSegmentedSourceGenerator aFaultSegmentedSource) {
        int i;
        double[] relativeRates = new double[aFaultSegmentedSource.getNumRupSources()];
        double maxRate = 0.0;
        for (i = 0; i < aFaultSegmentedSource.getNumRupSources(); ++i) {
            if (!(maxRate < aFaultSegmentedSource.getRupRate(i))) continue;
            maxRate = aFaultSegmentedSource.getRupRate(i);
        }
        for (i = 0; i < aFaultSegmentedSource.getNumRupSources(); ++i) {
            relativeRates[i] = aFaultSegmentedSource.getRupRate(i) / maxRate;
        }
        return relativeRates;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object eventSource = event.getSource();
        if (eventSource == this.mfdButton) {
            ArrayList<AbstractDiscretizedFunc> funcs = new ArrayList<AbstractDiscretizedFunc>();
            IncrementalMagFreqDist magFreqDist = this.source.getTotalRupMFD();
            EvenlyDiscretizedFunc cumRateDist = magFreqDist.getCumRateDistWithOffset();
            cumRateDist.setInfo("Cumulative Mag Freq Dist");
            funcs.add(magFreqDist);
            funcs.add(cumRateDist);
            ArbitrarilyDiscretizedFunc ucerf1Rate = UCERF1MfdReader.getUCERF1IncrementalMFD(this.source.getFaultSegmentData().getFaultName());
            ArbitrarilyDiscretizedFunc ucerf1CumRate = UCERF1MfdReader.getUCERF1CumMFD(this.source.getFaultSegmentData().getFaultName());
            funcs.add(ucerf1Rate);
            funcs.add(ucerf1CumRate);
            GraphWindow gw = new GraphWindow(funcs, "Mag");
            gw.setX_AxisLabel("Rate");
            gw.setY_AxisLabel("Mag Rate");
        } else if (eventSource == this.magAreaPlotButton) {
            this.createFuncListColorCodingByRupRates();
            GraphWindow graphWindow = new GraphWindow(this.getCurveFunctionList(), "Mag Area Plot", this.getPlottingFeatures());
            graphWindow.setLocationRelativeTo(this);
            graphWindow.setVisible(true);
        } else if (eventSource == this.magAreaPlotButton2) {
            this.setColorCodingbyFaultNames();
            GraphWindow graphWindow = new GraphWindow(this.getCurveFunctionList(), "Mag Area Plot", this.getPlottingFeatures());
            graphWindow.setLocationRelativeTo(this);
            graphWindow.setVisible(true);
        } else if (eventSource == this.aveSlipDataButton) {
            RupAveSlipTableModel tableModel = new RupAveSlipTableModel(this.source.getSegSlipInRupMatrix());
            JTable table = new JTable(tableModel);
            JFrame frame = new JFrame(this.source.getFaultSegmentData().getFaultName());
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)new JScrollPane(table), "Center");
            frame.pack();
            frame.setVisible(true);
        } else if (eventSource == this.rupRatesButton) {
            ArrayList<ArbitrarilyDiscretizedFunc> plottingFuncList = new ArrayList<ArbitrarilyDiscretizedFunc>();
            ArbitrarilyDiscretizedFunc aPrioriRatesFunc = new ArbitrarilyDiscretizedFunc();
            aPrioriRatesFunc.setName("A-Priori Rupture Rates");
            ArbitrarilyDiscretizedFunc finalRupRatesFunc = new ArbitrarilyDiscretizedFunc();
            finalRupRatesFunc.setName("Final Rupture Rates");
            int numRups = this.source.getNumRupSources();
            for (int i = 0; i < numRups; ++i) {
                aPrioriRatesFunc.set((double)i + 1.0, this.source.getAPrioriRupRate(i));
                finalRupRatesFunc.set((double)i + 1.0, this.source.getRupRate(i));
            }
            plottingFuncList.add(aPrioriRatesFunc);
            plottingFuncList.add(finalRupRatesFunc);
            CreatePlotFromMagRateFile plot = new CreatePlotFromMagRateFile(plottingFuncList);
            GraphWindow graphWindow = new GraphWindow(plot.getCurveFunctionList(), this.source.getFaultSegmentData().getFaultName(), plot.getPlottingFeatures());
            graphWindow.setX_AxisLabel("Rupture Index");
            graphWindow.setY_AxisLabel("Rupture Rate");
            graphWindow.setTitle("Rupture Rates");
            graphWindow.setVisible(true);
        } else if (eventSource == this.rupRatesRatioButton) {
            ArrayList<ArbitrarilyDiscretizedFunc> plottingFuncList = new ArrayList<ArbitrarilyDiscretizedFunc>();
            ArbitrarilyDiscretizedFunc ratioFunc = new ArbitrarilyDiscretizedFunc();
            ratioFunc.setName("(FinalRate-A_PrioriRate)/Max(A_PrioriRate,FinalRate)");
            int numRups = this.source.getNumRupSources();
            for (int i = 0; i < numRups; ++i) {
                ratioFunc.set((double)i + 1.0, this.source.getRupRateResid(i));
            }
            plottingFuncList.add(ratioFunc);
            CreatePlotFromMagRateFile plot = new CreatePlotFromMagRateFile(plottingFuncList);
            GraphWindow graphWindow = new GraphWindow(plot.getCurveFunctionList(), "(FinalRate-A_PrioriRate)/Max(A_PrioriRate,FinalRate)", plot.getPlottingFeatures());
            graphWindow.setTitle(this.source.getFaultSegmentData().getFaultName());
            graphWindow.setVisible(true);
        }
    }

    public void setSource(A_FaultSegmentedSourceGenerator aFaultSegmentedSource) {
        this.source = aFaultSegmentedSource;
        if (this.source != null) {
            this.mfdButton.setEnabled(true);
        } else {
            this.mfdButton.setEnabled(false);
        }
        this.rupTableModel.setFaultSegmentedSource(aFaultSegmentedSource);
        this.rupTableModel.fireTableDataChanged();
    }

    public ArrayList getCurveFunctionList() {
        return this.magAreaFuncs;
    }

    public boolean getXLog() {
        return true;
    }

    public boolean getYLog() {
        return false;
    }

    public String getXAxisLabel() {
        return "Area";
    }

    public String getYAxisLabel() {
        return "Mag";
    }

    public ArrayList getPlottingFeatures() {
        return this.plottingFeatures;
    }

    public boolean isCustomAxis() {
        return true;
    }

    public double getUserMinX() {
        return 40.0;
    }

    public double getUserMaxX() {
        return 10000.0;
    }

    public double getUserMinY() {
        return 5.5;
    }

    public double getUserMaxY() {
        return 8.5;
    }
}

