/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import java.text.DecimalFormat;
import javax.swing.table.AbstractTableModel;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults.A_FaultSegmentedSourceGenerator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UnsegmentedSource;

class SegmentDataTableModel
extends AbstractTableModel {
    public static final String[] columnNames = new String[]{"Seg Name", "Num", "DDW", "Length", "Aseis", "Area", "Orig SR", "SR Sigma", "Final SR", "Mo Rate", "Data ER", "ER Sigma", "Pred ER", "Final ER", "Seg Prob", "Seg Gain", "Seg Aper.", "Cal Yr. of Last Event", "Sections In Segment"};
    private FaultSegmentData segFaultData;
    private static final DecimalFormat SLIP_RATE_FORMAT = new DecimalFormat("0.###");
    private static final DecimalFormat EVENT_RATE_FORMAT = new DecimalFormat("0.000E0");
    private static final DecimalFormat ASEIS_FORMAT = new DecimalFormat("0.##");
    private static final DecimalFormat AREA_LENGTH_FORMAT = new DecimalFormat("0.0");
    private static final DecimalFormat MOMENT_FORMAT = new DecimalFormat("0.000E0");
    private A_FaultSegmentedSourceGenerator segmentedSource;
    private UnsegmentedSource unsegmentedSource;

    public SegmentDataTableModel() {
        this(null, null);
    }

    public SegmentDataTableModel(FaultSegmentData segFaultData, A_FaultSegmentedSourceGenerator segmentedSource) {
        this.setFaultData(segFaultData, segmentedSource, null);
    }

    public void setFaultData(FaultSegmentData segFaultData, A_FaultSegmentedSourceGenerator segmentedSource, UnsegmentedSource unsegmentedSource) {
        this.segFaultData = segFaultData;
        this.segmentedSource = segmentedSource;
        this.unsegmentedSource = unsegmentedSource;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int index) {
        return columnNames[index];
    }

    @Override
    public int getRowCount() {
        if (this.segFaultData == null) {
            return 0;
        }
        return this.segFaultData.getNumSegments() + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.segFaultData == null) {
            return "";
        }
        if (rowIndex == this.segFaultData.getNumSegments()) {
            return this.getTotalValues(columnIndex);
        }
        switch (columnIndex) {
            case 0: {
                return this.segFaultData.getSegmentName(rowIndex);
            }
            case 1: {
                return "" + (rowIndex + 1);
            }
            case 2: {
                return AREA_LENGTH_FORMAT.format(this.segFaultData.getOrigSegmentDownDipWidth(rowIndex) / 1000.0);
            }
            case 3: {
                return AREA_LENGTH_FORMAT.format(this.segFaultData.getSegmentLength(rowIndex) / 1000.0);
            }
            case 4: {
                return ASEIS_FORMAT.format(this.segFaultData.getAveSegAseisFactor(rowIndex));
            }
            case 5: {
                return AREA_LENGTH_FORMAT.format(this.segFaultData.getSegmentArea(rowIndex) / 1000000.0);
            }
            case 6: {
                return SLIP_RATE_FORMAT.format(this.segFaultData.getSegmentSlipRate(rowIndex) * 1000.0);
            }
            case 7: {
                return SLIP_RATE_FORMAT.format(this.segFaultData.getSegSlipRateStdDev(rowIndex) * 1000.0);
            }
            case 8: {
                if (this.segmentedSource != null) {
                    return SLIP_RATE_FORMAT.format(this.segmentedSource.getFinalSegSlipRate(rowIndex) * 1000.0);
                }
                return SLIP_RATE_FORMAT.format(this.unsegmentedSource.getFinalAveSegSlipRate(rowIndex) * 1000.0);
            }
            case 9: {
                return MOMENT_FORMAT.format(this.segFaultData.getSegmentMomentRate(rowIndex));
            }
            case 10: {
                double segRateMean = this.segFaultData.getSegRateMean(rowIndex);
                if (Double.isNaN(segRateMean)) {
                    return "";
                }
                return EVENT_RATE_FORMAT.format(segRateMean);
            }
            case 11: {
                double stdDev = this.segFaultData.getSegRateStdDevOfMean(rowIndex);
                if (Double.isNaN(stdDev)) {
                    return "";
                }
                return EVENT_RATE_FORMAT.format(stdDev);
            }
            case 12: {
                if (this.segmentedSource == null) {
                    return "";
                }
                return EVENT_RATE_FORMAT.format(this.segmentedSource.getSegRateFromAprioriRates(rowIndex));
            }
            case 13: {
                if (this.segmentedSource == null) {
                    return "";
                }
                return EVENT_RATE_FORMAT.format(this.segmentedSource.getFinalSegmentRate(rowIndex));
            }
            case 14: {
                if (this.segmentedSource == null) {
                    return "";
                }
                return MOMENT_FORMAT.format(this.segmentedSource.getSegProb(rowIndex));
            }
            case 15: {
                if (this.segmentedSource == null) {
                    return "";
                }
                return SLIP_RATE_FORMAT.format(this.segmentedSource.getSegProbGain(rowIndex));
            }
            case 16: {
                if (this.segmentedSource == null) {
                    return "";
                }
                return SLIP_RATE_FORMAT.format(this.segmentedSource.getSegAperiodicity(rowIndex));
            }
            case 17: {
                if (this.segmentedSource == null) {
                    return "";
                }
                return "" + (int)this.segFaultData.getSegCalYearOfLastEvent(rowIndex);
            }
            case 18: {
                return this.segFaultData.getSectionsInSeg(rowIndex);
            }
        }
        return "";
    }

    private double getCharSlip(int rowIndex) {
        return 1.0 / this.segmentedSource.getSegRateFromAprioriRates(rowIndex) * this.segFaultData.getSegmentSlipRate(rowIndex);
    }

    private Object getTotalValues(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Total";
            }
            case 3: {
                return AREA_LENGTH_FORMAT.format(this.segFaultData.getTotalLength() / 1000.0);
            }
            case 5: {
                return AREA_LENGTH_FORMAT.format(this.segFaultData.getTotalArea() / 1000000.0);
            }
            case 9: {
                return MOMENT_FORMAT.format(this.segFaultData.getTotalMomentRate());
            }
        }
        return "";
    }
}

