/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.rupCalc;

import java.util.ArrayList;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.geo.Location;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.PrefFaultSectionDataDB_DAO;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.oldClasses.UCERF2_Final_RelativeLocation;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.rupCalc.MultipleSectionRup;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.rupCalc.Tree;
import org.opensha.sha.faultSurface.FaultTrace;

public class SubSectionsRupCalc {
    private double subSectionsCutoffDist = 10.0;
    private double maxSubSectionLength = 10.0;
    private ArrayList<MultipleSectionRup> rupList;
    private final PrefFaultSectionDataDB_DAO faultSectionPrefDataDAO = new PrefFaultSectionDataDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private ArrayList subSectionList;
    private ArrayList doneList;
    private ArrayList<Tree> clusterList;

    public SubSectionsRupCalc() {
        this.doProcessing();
    }

    public SubSectionsRupCalc(double maxSubSectionLength, double cutOffDistance) {
        this.maxSubSectionLength = maxSubSectionLength;
        this.subSectionsCutoffDist = cutOffDistance;
        this.doProcessing();
    }

    public void doProcessing() {
        try {
            this.subSectionList = this.getAllSubSections();
            this.createTreesForFaultSections();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList getAllSubSections() {
        ArrayList<FaultSectionPrefData> faultSectionPrefList = this.faultSectionPrefDataDAO.getAllFaultSectionPrefData();
        ArrayList subSecList = new ArrayList();
        for (int i = 0; i < faultSectionPrefList.size(); ++i) {
            FaultSectionPrefData faultSectionPrefData = faultSectionPrefList.get(i);
            subSecList.addAll(faultSectionPrefData.getSubSectionsList(this.maxSubSectionLength));
        }
        return subSecList;
    }

    private void createTreesForFaultSections() throws InvalidRangeException {
        this.clusterList = new ArrayList();
        this.rupList = new ArrayList();
        this.doneList = new ArrayList();
        for (int i = 0; i < this.subSectionList.size(); ++i) {
            FaultSectionPrefData faultSectionPrefData = (FaultSectionPrefData)this.subSectionList.get(i);
            if (this.doneList.contains(faultSectionPrefData.getSectionName())) continue;
            Tree tree = new Tree();
            this.getAdjacentFaultSectionNodes(tree, i);
            this.clusterList.add(tree);
            ArrayList treeRupList = tree.getRuptures();
            this.rupList.addAll(treeRupList);
        }
        System.out.println("Total Subsections =" + this.subSectionList.size());
        System.out.println("Total Clusters =" + this.clusterList.size());
        System.out.println("Total ruptures=" + this.rupList.size());
    }

    public int getNumClusters() {
        return this.clusterList.size();
    }

    public Tree getCluster(int index) {
        return this.clusterList.get(index);
    }

    public int getNumRuptures() {
        return this.rupList.size();
    }

    public MultipleSectionRup getRupture(int rupIndex) {
        return this.rupList.get(rupIndex);
    }

    public ArrayList<MultipleSectionRup> getRupList() {
        return this.rupList;
    }

    private void getAdjacentFaultSectionNodes(Tree tree, int subSectionIndex) {
        FaultSectionPrefData faultSectionPrefData = (FaultSectionPrefData)this.subSectionList.get(subSectionIndex);
        this.doneList.add(faultSectionPrefData.getSectionName());
        tree.connectInTree(faultSectionPrefData.getSectionId(), faultSectionPrefData.getSectionId());
        for (int i = 0; i < this.subSectionList.size(); ++i) {
            FaultSectionPrefData faultSectionPrefData1;
            if (i == subSectionIndex || !this.isWithinCutOffDist(faultSectionPrefData, faultSectionPrefData1 = (FaultSectionPrefData)this.subSectionList.get(i))) continue;
            tree.connectInTree(faultSectionPrefData.getSectionId(), faultSectionPrefData1.getSectionId());
            if (this.doneList.contains(faultSectionPrefData1.getSectionName())) continue;
            this.getAdjacentFaultSectionNodes(tree, i);
        }
    }

    private boolean isWithinCutOffDist(FaultSectionPrefData faultSectionPrefData1, FaultSectionPrefData faultSectionPrefData2) {
        FaultTrace trace1 = faultSectionPrefData1.getFaultTrace();
        int endIndex1 = trace1.getNumLocations() - 1;
        FaultTrace trace2 = faultSectionPrefData2.getFaultTrace();
        int endIndex2 = trace2.getNumLocations() - 1;
        if (UCERF2_Final_RelativeLocation.getApproxHorzDistance((Location)trace1.get(0), (Location)trace2.get(0)) <= this.subSectionsCutoffDist) {
            return true;
        }
        if (UCERF2_Final_RelativeLocation.getApproxHorzDistance((Location)trace1.get(0), (Location)trace2.get(endIndex2)) <= this.subSectionsCutoffDist) {
            return true;
        }
        if (UCERF2_Final_RelativeLocation.getApproxHorzDistance((Location)trace1.get(endIndex1), (Location)trace2.get(0)) <= this.subSectionsCutoffDist) {
            return true;
        }
        return UCERF2_Final_RelativeLocation.getApproxHorzDistance((Location)trace1.get(endIndex1), (Location)trace2.get(endIndex2)) <= this.subSectionsCutoffDist;
    }

    public static void main(String[] args) {
        SubSectionsRupCalc rupCalc = new SubSectionsRupCalc(10.0, 10.0);
    }
}

