/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.YuccaMountain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.estimate.DiscreteValueEstimate;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.EstimateConstraint;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EstimateParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.TreeBranchWeightsParameter;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.AbstractEpistemicListERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.rupForecastImpl.YuccaMountain.YuccaMountainERF;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;

public class YuccaMountainERF_List
extends AbstractEpistemicListERF {
    public static final String NAME = new String("Yucca Mountain ERF Epistemic List");
    protected YuccaMountainERF yuccaMountainERF = new YuccaMountainERF();
    private static final double DURATION_DEFAULT = 30.0;
    private static final double DELTA_MAG = 0.1;
    private String FAULT_LOGIC_TREE_FILENAME = "/data/erf/yucca_mountain/FaultsLogicTree.txt";
    private String BACKGROUND_LOGIC_TREE_FILE_NAME = "/data/erf/yucca_mountain/BackgroundLogicTree.txt";
    private static final String MAG = "Mag-";
    private static final String MOMENT_RATE = "MomentRate-";
    private static final String BACKGROUND = "Background";
    private HashMap<Double, GutenbergRichterMagFreqDist> backgroundOptions;
    private static final String BACKGROUND1_PARAM_NAME = "Wt for Min Cum Rate Option";
    private static final String BACKGROUND2_PARAM_NAME = "Wt for Pref Cum Rate Option";
    private static final String BACKGROUND3_PARAM_NAME = "Wt for Max Cum Rate Option";
    private static final String NUM_REALIZATIONS_PARAM_NAME = "Num Realizations";
    private Integer DEFAULT_NUM_REALIZATIONS_VAL = 1000;
    private int NUM_REALIZATIONS_MIN = 1;
    private int NUM_REALIZATIONS_MAX = 10000;
    private static final String NUM_REALIZATIONS_PARAM_INFO = "Number of Monte Carlo ERF realizations";
    IntegerParameter numRealizationsParam = new IntegerParameter("Num Realizations", this.NUM_REALIZATIONS_MIN, this.NUM_REALIZATIONS_MAX, this.DEFAULT_NUM_REALIZATIONS_VAL);
    private EstimateConstraint discreteValueEstimateConstraint;
    private double bckPrefCumRate;
    private double bckMinCumRate;
    private double bckMaxCumRate;

    public YuccaMountainERF_List() {
        this.numRealizationsParam.setInfo(NUM_REALIZATIONS_PARAM_INFO);
        this.adjustableParams.addParameter(this.numRealizationsParam);
        ArrayList<String> allowedEstimates = new ArrayList<String>();
        allowedEstimates.add("Discrete Values");
        this.discreteValueEstimateConstraint = new EstimateConstraint(allowedEstimates);
        this.fillFaultsLogicTree();
        this.addBackgroundBranches();
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.setDuration(30.0);
    }

    private void fillFaultsLogicTree() {
        try {
            ArrayList<String> faultBranchesLines = FileUtils.loadJarFile(this.FAULT_LOGIC_TREE_FILENAME);
            for (int i = 14; i < faultBranchesLines.size(); i += 3) {
                String sourceCodeNameLine = faultBranchesLines.get(i);
                StringTokenizer st = new StringTokenizer(sourceCodeNameLine);
                String srcCode = st.nextToken();
                ++i;
                String paramName = MAG + srcCode;
                DiscreteValueEstimate magEstimate = this.getDiscreteValueEstimate(faultBranchesLines, ++i);
                EstimateParameter magParam = new EstimateParameter(paramName, this.discreteValueEstimateConstraint, null, magEstimate);
                this.adjustableParams.addParameter(magParam);
                paramName = MOMENT_RATE + srcCode;
                DiscreteValueEstimate moRateEstimate = this.getDiscreteValueEstimate(faultBranchesLines, i += 4);
                EstimateParameter moRateParam = new EstimateParameter(paramName, this.discreteValueEstimateConstraint, null, moRateEstimate);
                this.adjustableParams.addParameter(moRateParam);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DiscreteValueEstimate getDiscreteValueEstimate(ArrayList<String> faultBranchesLines, int lineIndex) {
        StringTokenizer tokenizer = new StringTokenizer(faultBranchesLines.get(lineIndex));
        double prefMag = Double.parseDouble(tokenizer.nextToken());
        double prefWt = Double.parseDouble(tokenizer.nextToken());
        tokenizer = new StringTokenizer(faultBranchesLines.get(++lineIndex));
        double minMag = Double.parseDouble(tokenizer.nextToken());
        double minWt = Double.parseDouble(tokenizer.nextToken());
        tokenizer = new StringTokenizer(faultBranchesLines.get(++lineIndex));
        double maxMag = Double.parseDouble(tokenizer.nextToken());
        double maxWt = Double.parseDouble(tokenizer.nextToken());
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        func.set(minMag, minWt);
        func.set(prefMag, prefWt);
        func.set(maxMag, maxWt);
        return new DiscreteValueEstimate(func, true);
    }

    private void addBackgroundBranches() {
        this.backgroundOptions = new HashMap();
        try {
            ArrayList<String> backgroundLines = FileUtils.loadJarFile(this.BACKGROUND_LOGIC_TREE_FILE_NAME);
            int index = 0;
            double prefWt = 0.0;
            double minWt = 0.0;
            double maxWt = 0.0;
            for (int i = 8; i < backgroundLines.size(); ++i) {
                String line = backgroundLines.get(i);
                StringTokenizer tokenizer = new StringTokenizer(line);
                double cumRate = Double.parseDouble(tokenizer.nextToken());
                double bValue = Double.parseDouble(tokenizer.nextToken());
                double minMag = Double.parseDouble(tokenizer.nextToken());
                double maxMag = Double.parseDouble(tokenizer.nextToken());
                double weight = Double.parseDouble(tokenizer.nextToken());
                int numMag = (int)Math.round((maxMag - minMag) / 0.1) + 1;
                GutenbergRichterMagFreqDist grMFD = new GutenbergRichterMagFreqDist(bValue, cumRate, minMag, maxMag, numMag);
                this.backgroundOptions.put(cumRate, grMFD);
                if (index == 0) {
                    this.bckPrefCumRate = cumRate;
                    prefWt = weight;
                } else if (index == 1) {
                    this.bckMinCumRate = cumRate;
                    minWt = weight;
                } else if (index == 2) {
                    this.bckMaxCumRate = cumRate;
                    maxWt = weight;
                }
                ++index;
            }
            ParameterList backgroundParamList = new ParameterList();
            backgroundParamList.addParameter(new DoubleParameter(BACKGROUND1_PARAM_NAME, 0.0, 1.0, (Double)minWt));
            backgroundParamList.addParameter(new DoubleParameter(BACKGROUND2_PARAM_NAME, 0.0, 1.0, (Double)prefWt));
            backgroundParamList.addParameter(new DoubleParameter(BACKGROUND3_PARAM_NAME, 0.0, 1.0, (Double)maxWt));
            this.adjustableParams.addParameter(new TreeBranchWeightsParameter(BACKGROUND, backgroundParamList));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getNumERFs() {
        return (Integer)this.numRealizationsParam.getValue();
    }

    public ArrayList getRelativeWeightsList() {
        ArrayList<Double> weightList = new ArrayList<Double>();
        int numERFs = this.getNumERFs();
        for (int i = 0; i < numERFs; ++i) {
            weightList.add(this.getERF_RelativeWeight(i));
        }
        return weightList;
    }

    @Override
    public ERF getERF(int index) {
        ListIterator<String> it = this.adjustableParams.getParameterNamesIterator();
        while (it.hasNext()) {
            String faultName;
            String paramName = (String)it.next();
            if (paramName.equalsIgnoreCase(BACKGROUND)) {
                ParameterList paramList = (ParameterList)this.adjustableParams.getValue(paramName);
                double minProb = (Double)paramList.getValue(BACKGROUND1_PARAM_NAME);
                double prefProb = (Double)paramList.getValue(BACKGROUND2_PARAM_NAME);
                double maxProb = (Double)paramList.getValue(BACKGROUND3_PARAM_NAME);
                ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
                func.set(this.bckMinCumRate, minProb);
                func.set(this.bckPrefCumRate, prefProb);
                func.set(this.bckMaxCumRate, maxProb);
                DiscreteValueEstimate backgroundEstimate = new DiscreteValueEstimate(func, true);
                double randomValue = backgroundEstimate.getRandomValue();
                this.yuccaMountainERF.setBackgroundMFD(this.backgroundOptions.get(randomValue));
                continue;
            }
            Object value = this.adjustableParams.getValue(paramName);
            if (!(value instanceof DiscreteValueEstimate)) continue;
            DiscreteValueEstimate estimate = (DiscreteValueEstimate)value;
            double randomValue = estimate.getRandomValue();
            if (paramName.startsWith(MAG)) {
                faultName = paramName.substring(MAG.length());
                this.yuccaMountainERF.setMeanMagForSource(faultName, randomValue);
            }
            if (!paramName.startsWith(MOMENT_RATE)) continue;
            faultName = paramName.substring(MOMENT_RATE.length());
            this.yuccaMountainERF.setMomentRateForSource(faultName, randomValue);
        }
        this.yuccaMountainERF.getTimeSpan().setDuration(this.timeSpan.getDuration());
        this.yuccaMountainERF.updateForecast();
        return this.yuccaMountainERF;
    }

    @Override
    public double getERF_RelativeWeight(int index) {
        return 1.0;
    }

    public static void main(String[] args) {
        YuccaMountainERF_List ymEpistemicList = new YuccaMountainERF_List();
        int numERFs = ymEpistemicList.getNumERFs();
        System.out.println("Num Branches=" + numERFs);
        for (int i = 0; i < 5; ++i) {
            ymEpistemicList.getERF(i);
        }
    }
}

