/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.data.IntegerSampler;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.data.uncertainty.UncertainBoundedIncrMagFreqDist;
import org.opensha.commons.data.uncertainty.UncertainIncrMagFreqDist;
import org.opensha.commons.data.uncertainty.Uncertainty;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.LaplacianSmoothingInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.MFDInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoRateInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoSlipInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.ParkfieldInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.RupRateMinimizationConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.SectionTotalRateConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.SlipRateInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.SubSectMFDInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionTargetMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.earthquake.faultSysSolution.modules.PaleoseismicConstraintData;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SectBValuePlot;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSectionUtils;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_PaleoUncertainties;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SegmentationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SectionSupraSeisBValues;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SegmentationMFD_Adjustment;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SubSectConstraintModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.SupraSeisBValInversionTargetMFDs;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.APrioriSectNuclEstimator;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.PaleoSectNuclEstimator;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.ScalingRelSlipRateMFD_Estimator;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.SectNucleationMFD_Estimator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.analysis.FaultSystemRupSetCalc;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.inversion.UCERF2_ComparisonSolutionFetcher;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.utils.U3SectionMFD_constraint;
import scratch.UCERF3.utils.UCERF2_A_FaultMapper;

public class NSHM23_ConstraintBuilder {
    private List<InversionConstraint> constraints;
    private FaultSystemRupSet rupSet;
    private double supraBVal;
    private double[] sectSpecificBValues;
    private boolean applyDefModelUncertaintiesToNucl;
    private boolean addSectCountUncertaintiesToMFD;
    public static boolean ADJ_FOR_INCOMPATIBLE_DATA_DEFAULT = true;
    private boolean adjustForIncompatibleData = ADJ_FOR_INCOMPATIBLE_DATA_DEFAULT;
    public static boolean ADJ_FOR_ACTUAL_RUP_SLIPS_DEFAULT = true;
    public static boolean ADJ_FOR_SLIP_ALONG_DEFAULT = false;
    private boolean adjustForActualRupSlips = ADJ_FOR_ACTUAL_RUP_SLIPS_DEFAULT;
    private boolean adjustForSlipAlong = ADJ_FOR_SLIP_ALONG_DEFAULT;
    static int MAX_NUM_ZERO_SLIP_SECTS_PER_RUP = 1;
    private SupraSeisBValInversionTargetMFDs.SubSeisMoRateReduction subSeisMoRateReduction = SupraSeisBValInversionTargetMFDs.SUB_SEIS_MO_RATE_REDUCTION_DEFAULT;
    private static final double DEFAULT_REL_STD_DEV = 0.1;
    private DoubleUnaryOperator magDepRelStdDev = M -> 0.1;
    private RuptureProbabilityCalc.BinaryRuptureProbabilityCalc rupExclusionModel;
    private JumpProbabilityCalc segModel;
    public static SegmentationMFD_Adjustment SEG_ADJ_METHOD_DEFAULT = SegmentationMFD_Adjustment.REL_GR_THRESHOLD_AVG;
    private SegmentationMFD_Adjustment segAdjMethod = SEG_ADJ_METHOD_DEFAULT;
    public static ParkfieldSelectionCriteria PARKFIELD_SELECT_DEFAULT = ParkfieldSelectionCriteria.MAG_6;
    private ParkfieldSelectionCriteria parkfieldSelect = PARKFIELD_SELECT_DEFAULT;
    private NSHM23_PaleoUncertainties paleoUncert;
    private double proxyFaultMagCorner = Double.NaN;
    private double proxyFaultBValue = Double.NaN;
    private SupraSeisBValInversionTargetMFDs targetCache;
    private SupraSeisBValInversionTargetMFDs externalTargetMFDs;
    public static final UncertainDataConstraint PARKFIELD_RATE = new UncertainDataConstraint("Parkfield", 0.04, new Uncertainty(0.006));

    public NSHM23_ConstraintBuilder(FaultSystemRupSet rupSet, double supraSeisB) {
        this(rupSet, supraSeisB, null);
    }

    public NSHM23_ConstraintBuilder(FaultSystemRupSet rupSet, double[] sectSpecificBValues) {
        this(rupSet, NSHM23_ConstraintBuilder.momentWeightedAverage(rupSet, sectSpecificBValues), sectSpecificBValues);
    }

    public static double momentWeightedAverage(FaultSystemRupSet rupSet, double[] sectSpecificBValues) {
        double sumMoment = 0.0;
        double sumProduct = 0.0;
        Preconditions.checkState((sectSpecificBValues.length == rupSet.getNumSections() ? 1 : 0) != 0);
        for (int s = 0; s < sectSpecificBValues.length; ++s) {
            double moment = FaultMomentCalc.getMoment(rupSet.getAreaForSection(s), rupSet.getSlipRateForSection(s));
            sumMoment += moment;
            sumProduct += moment * sectSpecificBValues[s];
        }
        if (sumMoment == 0.0) {
            return StatUtils.mean((double[])sectSpecificBValues);
        }
        return sumProduct / sumMoment;
    }

    public NSHM23_ConstraintBuilder(FaultSystemRupSet rupSet, SectionSupraSeisBValues bValues) {
        this(rupSet, bValues.getB(), bValues.getSectBValues(rupSet));
    }

    public NSHM23_ConstraintBuilder(FaultSystemRupSet rupSet, double supraSeisB, double[] sectSpecificBValues) {
        this(rupSet, supraSeisB, sectSpecificBValues, true, false, ADJ_FOR_INCOMPATIBLE_DATA_DEFAULT);
    }

    public NSHM23_ConstraintBuilder(FaultSystemRupSet rupSet, double supraBVal, double[] sectSpecificBValues, boolean applyDefModelUncertaintiesToNucl, boolean addSectCountUncertaintiesToMFD, boolean adjustForIncompatibleData) {
        this.rupSet = rupSet;
        if (!Double.isFinite(supraBVal)) {
            Preconditions.checkNotNull((Object)sectSpecificBValues, (Object)"b=%s but not section-specific values");
            supraBVal = NSHM23_ConstraintBuilder.momentWeightedAverage(rupSet, sectSpecificBValues);
        }
        this.supraBVal = supraBVal;
        this.sectSpecificBValues = sectSpecificBValues;
        this.applyDefModelUncertaintiesToNucl = applyDefModelUncertaintiesToNucl;
        this.addSectCountUncertaintiesToMFD = addSectCountUncertaintiesToMFD;
        this.adjustForIncompatibleData = adjustForIncompatibleData;
        this.constraints = new ArrayList<InversionConstraint>();
    }

    public List<InversionConstraint> build() {
        return this.constraints;
    }

    public NSHM23_ConstraintBuilder defaultConstraints() {
        return this.defaultConstraints(SubSectConstraintModels.TOT_NUCL_RATE);
    }

    public NSHM23_ConstraintBuilder defaultConstraints(SubSectConstraintModels subSectConstrModel) {
        return this.defaultDataConstraints(subSectConstrModel).defaultMetaConstraints();
    }

    public NSHM23_ConstraintBuilder except(Class<? extends InversionConstraint> clazz) {
        int i = this.constraints.size();
        while (--i >= 0) {
            if (!clazz.isAssignableFrom(this.constraints.get(i).getClass())) continue;
            this.constraints.remove(i);
        }
        return this;
    }

    public NSHM23_ConstraintBuilder add(InversionConstraint constraint) {
        this.constraints.add(constraint);
        return this;
    }

    public NSHM23_ConstraintBuilder defaultDataConstraints() {
        return this.defaultDataConstraints(SubSectConstraintModels.TOT_NUCL_RATE);
    }

    public NSHM23_ConstraintBuilder defaultDataConstraints(SubSectConstraintModels subSectConstrModel) {
        this.magDepRelStdDev(M -> 0.1 * Math.pow(10.0, this.supraBVal * 0.5 * (M - 6.0))).slipRates().weight(1.0).paleoRates().weight(5.0).paleoSlips().weight(5.0).parkfield().weight(10.0);
        if (subSectConstrModel == SubSectConstraintModels.TOT_NUCL_RATE) {
            this.supraBValMFDs().weight(10.0).sectSupraRates().weight(0.5);
        } else if (subSectConstrModel == SubSectConstraintModels.NUCL_MFD) {
            this.supraBValMFDs().weight(1.0).sectSupraNuclMFDs().weight(0.5);
        } else if (subSectConstrModel == null || subSectConstrModel == SubSectConstraintModels.NONE) {
            this.supraBValMFDs().weight(1.0);
        }
        return this;
    }

    public NSHM23_ConstraintBuilder paleoUncerts(NSHM23_PaleoUncertainties paleoUncert) {
        this.paleoUncert = paleoUncert;
        return this;
    }

    public NSHM23_ConstraintBuilder slipRates() {
        this.constraints.add(new SlipRateInversionConstraint(1.0, ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY, this.rupSet));
        return this;
    }

    public NSHM23_ConstraintBuilder paleo() {
        return this.paleoRates().paleoSlips();
    }

    public NSHM23_ConstraintBuilder paleoRates() {
        PaleoseismicConstraintData data = this.rupSet.requireModule(PaleoseismicConstraintData.class);
        if (data.hasPaleoRateConstraints()) {
            List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> datas = data.getPaleoRateConstraints();
            if (this.paleoUncert != null) {
                datas = this.paleoUncert.getScaled(datas);
            }
            this.constraints.add(new PaleoRateInversionConstraint(this.rupSet, 1.0, datas, data.getPaleoProbModel()));
        }
        return this;
    }

    public NSHM23_ConstraintBuilder paleoSlips() {
        PaleoseismicConstraintData data = this.rupSet.requireModule(PaleoseismicConstraintData.class);
        if (data.hasPaleoSlipConstraints()) {
            List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> datas = data.getPaleoSlipConstraints();
            if (this.paleoUncert != null) {
                datas = this.paleoUncert.getScaled(datas);
            }
            this.constraints.add(new PaleoSlipInversionConstraint(this.rupSet, 1.0, datas, data.getPaleoSlipProbModel(), true));
        }
        return this;
    }

    public NSHM23_ConstraintBuilder subSeisMoRateReduction(SupraSeisBValInversionTargetMFDs.SubSeisMoRateReduction subSeisMoRateReduction) {
        this.subSeisMoRateReduction = subSeisMoRateReduction;
        this.targetCache = null;
        return this;
    }

    public NSHM23_ConstraintBuilder magDepRelStdDev(DoubleUnaryOperator magDepRelStdDev) {
        this.magDepRelStdDev = magDepRelStdDev;
        this.targetCache = null;
        return this;
    }

    public NSHM23_ConstraintBuilder adjustForSegmentationModel(JumpProbabilityCalc segModel) {
        this.segModel = segModel;
        this.targetCache = null;
        return this;
    }

    public NSHM23_ConstraintBuilder adjustForSegmentationModel(JumpProbabilityCalc segModel, SegmentationMFD_Adjustment segAdjMethod) {
        this.segModel = segModel;
        this.segAdjMethod = segAdjMethod;
        this.targetCache = null;
        return this;
    }

    public NSHM23_ConstraintBuilder proxyFaultMagCorner(double proxyFaultMagCorner) {
        this.proxyFaultMagCorner = proxyFaultMagCorner;
        this.targetCache = null;
        return this;
    }

    public NSHM23_ConstraintBuilder proxyFaultBValue(double proxyFaultBValue) {
        this.proxyFaultBValue = proxyFaultBValue;
        this.targetCache = null;
        return this;
    }

    public JumpProbabilityCalc getSegmentationModel() {
        return this.segModel;
    }

    public SegmentationMFD_Adjustment getSegmentationAdjustmentMethod() {
        return this.segAdjMethod;
    }

    public NSHM23_ConstraintBuilder excludeRuptures(RuptureProbabilityCalc.BinaryRuptureProbabilityCalc rupExclusionModel) {
        this.rupExclusionModel = rupExclusionModel;
        this.targetCache = null;
        return this;
    }

    public RuptureProbabilityCalc.BinaryRuptureProbabilityCalc getRupExclusionModel() {
        return this.rupExclusionModel;
    }

    public NSHM23_ConstraintBuilder adjustForActualRupSlips(boolean adjustForActualRupSlips, boolean adjustForSlipAlong) {
        this.adjustForActualRupSlips = adjustForActualRupSlips;
        this.adjustForSlipAlong = adjustForSlipAlong;
        return this;
    }

    public SupraSeisBValInversionTargetMFDs getTargetMFDs() {
        return this.getTargetMFDs(this.supraBVal, this.sectSpecificBValues);
    }

    public void setExternalTargetMFDs(SupraSeisBValInversionTargetMFDs externalTargetMFDs) {
        this.externalTargetMFDs = externalTargetMFDs;
    }

    private SupraSeisBValInversionTargetMFDs getTargetMFDs(double supraBVal, double[] sectSpecificBValues) {
        SupraSeisBValInversionTargetMFDs target;
        if (this.externalTargetMFDs != null) {
            return this.externalTargetMFDs;
        }
        if (this.targetCache != null && this.targetCache.getSupraSeisBValue() == supraBVal && Objects.equals(this.targetCache.getSectSpecificBValues(), sectSpecificBValues)) {
            return this.targetCache;
        }
        if (Double.isFinite(this.proxyFaultBValue)) {
            int i;
            if (sectSpecificBValues == null) {
                sectSpecificBValues = new double[this.rupSet.getNumSections()];
                for (i = 0; i < sectSpecificBValues.length; ++i) {
                    sectSpecificBValues[i] = supraBVal;
                }
            } else {
                sectSpecificBValues = Arrays.copyOf(sectSpecificBValues, sectSpecificBValues.length);
            }
            for (i = 0; i < sectSpecificBValues.length; ++i) {
                if (!this.rupSet.getFaultSectionData(i).isProxyFault()) continue;
                sectSpecificBValues[i] = this.proxyFaultBValue;
            }
        }
        SupraSeisBValInversionTargetMFDs.Builder builder = sectSpecificBValues == null ? new SupraSeisBValInversionTargetMFDs.Builder(this.rupSet, supraBVal) : new SupraSeisBValInversionTargetMFDs.Builder(this.rupSet, sectSpecificBValues);
        builder.applyDefModelUncertainties(this.applyDefModelUncertaintiesToNucl);
        builder.magDepDefaultRelStdDev(this.magDepRelStdDev);
        builder.addSectCountUncertainties(this.addSectCountUncertaintiesToMFD);
        builder.subSeisMoRateReduction(this.subSeisMoRateReduction);
        builder.maxNumZeroSlipSectsPerRup(MAX_NUM_ZERO_SLIP_SECTS_PER_RUP);
        if (this.proxyFaultMagCorner > 0.0) {
            double[] magCorners = new double[this.rupSet.getNumSections()];
            for (int s = 0; s < magCorners.length; ++s) {
                magCorners[s] = this.rupSet.getFaultSectionData(s).isProxyFault() ? this.proxyFaultMagCorner : Double.NaN;
            }
            builder.sectSpecificMagCorner(magCorners);
        } else {
            builder.supraSeisMagCorner(Double.NaN);
        }
        if (this.segModel != null) {
            if (this.segModel instanceof RuptureProbabilityCalc.BinaryRuptureProbabilityCalc) {
                builder.forBinaryRupProbModel((RuptureProbabilityCalc.BinaryRuptureProbabilityCalc)((Object)this.segModel));
            } else {
                SectNucleationMFD_Estimator adjustment = this.segAdjMethod.getAdjustment(this.segModel);
                if (adjustment != null) {
                    builder.adjustTargetsForData(adjustment);
                }
            }
        }
        if (this.rupExclusionModel != null) {
            builder.forBinaryRupProbModel(this.rupExclusionModel, false);
        }
        if (this.adjustForActualRupSlips) {
            builder.adjustTargetsForData(new ScalingRelSlipRateMFD_Estimator(this.adjustForSlipAlong));
        }
        if (this.adjustForIncompatibleData) {
            UncertaintyBoundType dataWithinType = UncertaintyBoundType.ONE_SIGMA;
            ArrayList<SectNucleationMFD_Estimator> dataConstraints = new ArrayList<SectNucleationMFD_Estimator>();
            dataConstraints.add(new APrioriSectNuclEstimator(this.rupSet, this.findParkfieldRups(), PARKFIELD_RATE));
            if (this.rupSet.hasModule(PaleoseismicConstraintData.class)) {
                PaleoseismicConstraintData paleoData = this.rupSet.requireModule(PaleoseismicConstraintData.class);
                if (paleoData.getPaleoSlipConstraints() != null) {
                    this.rupSet.addModule(builder.buildSlipRatesOnly());
                }
                dataConstraints.addAll(PaleoSectNuclEstimator.buildPaleoEstimates(this.rupSet, true, this.paleoUncert));
            }
            builder.expandUncertaintiesForData(dataConstraints, dataWithinType);
        }
        builder.useCreepReducedSlipStdDevs(false);
        builder.slipStdDevFloor(1.0E-4);
        this.targetCache = target = builder.build();
        this.rupSet.addModule(target);
        return target;
    }

    public NSHM23_ConstraintBuilder supraBValMFDs() {
        SupraSeisBValInversionTargetMFDs target = this.getTargetMFDs(this.supraBVal, this.sectSpecificBValues);
        List<? extends IncrementalMagFreqDist> origMFDs = ((InversionTargetMFDs)target).getMFD_Constraints();
        ArrayList<UncertainIncrMagFreqDist> uncertainMFDs = new ArrayList<UncertainIncrMagFreqDist>();
        for (IncrementalMagFreqDist incrementalMagFreqDist : origMFDs) {
            if (incrementalMagFreqDist instanceof UncertainIncrMagFreqDist) {
                uncertainMFDs.add((UncertainIncrMagFreqDist)incrementalMagFreqDist);
                continue;
            }
            System.err.println("WARNING: temporary relative standard deviation of 0.1 set for all MFD bins");
            UncertainIncrMagFreqDist uMFD = UncertainIncrMagFreqDist.constantRelStdDev(incrementalMagFreqDist, 0.1);
            uncertainMFDs.add(uMFD);
        }
        this.constraints.add(new MFDInversionConstraint(this.rupSet, 1.0, false, ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY, uncertainMFDs));
        return this;
    }

    public NSHM23_ConstraintBuilder sectSupraRates() {
        SupraSeisBValInversionTargetMFDs target = this.getTargetMFDs(this.supraBVal, this.sectSpecificBValues);
        double[] targetRates = new double[this.rupSet.getNumSections()];
        double[] targetRateStdDevs = new double[this.rupSet.getNumSections()];
        List<UncertainIncrMagFreqDist> sectSupraMFDs = target.getOnFaultSupraSeisNucleationMFDs();
        for (int s = 0; s < targetRates.length; ++s) {
            UncertainIncrMagFreqDist sectSupraMFD = sectSupraMFDs.get(s);
            targetRates[s] = sectSupraMFD.calcSumOfY_Vals();
            UncertainBoundedIncrMagFreqDist oneSigmaBoundedMFD = sectSupraMFD.estimateBounds(UncertaintyBoundType.ONE_SIGMA);
            double upperVal = oneSigmaBoundedMFD.getUpper().calcSumOfY_Vals();
            double lowerVal = oneSigmaBoundedMFD.getLower().calcSumOfY_Vals();
            targetRateStdDevs[s] = UncertaintyBoundType.ONE_SIGMA.estimateStdDev(lowerVal, upperVal);
        }
        this.constraints.add(new SectionTotalRateConstraint(this.rupSet, 1.0, ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY, targetRates, targetRateStdDevs, true));
        return this;
    }

    public NSHM23_ConstraintBuilder sectSupraNuclMFDs() {
        SupraSeisBValInversionTargetMFDs target = this.getTargetMFDs(this.supraBVal, this.sectSpecificBValues);
        List<UncertainIncrMagFreqDist> sectSupraMFDs = target.getOnFaultSupraSeisNucleationMFDs();
        this.constraints.add(new SubSectMFDInversionConstraint(this.rupSet, 1.0, ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY, sectSupraMFDs, true));
        return this;
    }

    public NSHM23_ConstraintBuilder excludeRupturesThroughCreeping() {
        int creepingParentID = FaultSectionUtils.findParentSectionID(this.rupSet.getFaultSectionDataList(), "San", "Andreas", "Creeping");
        Preconditions.checkState((creepingParentID >= 0 ? 1 : 0) != 0, (Object)"Creeping section not found");
        ArrayList<FaultSection> creepingSects = new ArrayList<FaultSection>();
        for (FaultSection faultSection : this.rupSet.getFaultSectionDataList()) {
            if (faultSection.getParentSectionId() != creepingParentID) continue;
            creepingSects.add(faultSection);
        }
        Preconditions.checkState((!creepingSects.isEmpty() ? 1 : 0) != 0);
        return this.excludeRuptures(new NSHM23_SegmentationModels.ExcludeRupsThroughCreepingSegmentationModel(creepingParentID));
    }

    public boolean rupSetHasCreepingSection() {
        return NSHM23_ConstraintBuilder.findCreepingSection(this.rupSet) >= 0;
    }

    public static int findCreepingSection(FaultSystemRupSet rupSet) {
        return FaultSectionUtils.findParentSectionID(rupSet.getFaultSectionDataList(), "San", "Andreas", "Creeping");
    }

    public static boolean isRupThroughCreeping(int creepingParentID, ClusterRupture rup) {
        boolean hasCreeping = false;
        for (FaultSubsectionCluster cluster : rup.getClustersIterable()) {
            if (cluster.parentSectionID != creepingParentID) continue;
            hasCreeping = true;
            break;
        }
        if (!hasCreeping) {
            return false;
        }
        RuptureTreeNavigator nav = rup.getTreeNavigator();
        FaultSubsectionCluster firstCluster = rup.clusters[0];
        if (firstCluster.parentSectionID == creepingParentID) {
            return false;
        }
        HashSet<Integer> sectsBefore = new HashSet<Integer>();
        HashSet<Integer> sectsAfter = new HashSet<Integer>();
        HashSet<Integer> endSects = new HashSet<Integer>();
        NSHM23_ConstraintBuilder.findSectsBeforeAfterCreeping(nav, firstCluster, sectsBefore, sectsAfter, endSects, false, creepingParentID);
        if (!sectsBefore.isEmpty() && !sectsAfter.isEmpty()) {
            boolean bl;
            boolean uniqueBefore = false;
            for (Integer n : sectsBefore) {
                if (sectsAfter.contains(n)) continue;
                uniqueBefore = true;
            }
            boolean uniqueAfter = false;
            for (Integer afterID : sectsAfter) {
                if (sectsBefore.contains(afterID)) continue;
                uniqueAfter = true;
            }
            boolean bl2 = false;
            for (Integer endID : endSects) {
                if (endID == creepingParentID) continue;
                bl = true;
            }
            if (uniqueBefore && uniqueAfter && bl) {
                return true;
            }
        }
        return false;
    }

    private static void findSectsBeforeAfterCreeping(RuptureTreeNavigator nav, FaultSubsectionCluster curCluster, HashSet<Integer> sectsBefore, HashSet<Integer> sectsAfter, HashSet<Integer> endSects, boolean creepingEncountered, int creepingParentID) {
        boolean curIsCreeping;
        boolean bl = curIsCreeping = curCluster.parentSectionID == creepingParentID;
        if (curIsCreeping) {
            creepingEncountered = true;
        } else if (creepingEncountered) {
            sectsAfter.add(curCluster.parentSectionID);
        } else {
            sectsBefore.add(curCluster.parentSectionID);
        }
        Collection<FaultSubsectionCluster> descendants = nav.getDescendants(curCluster);
        if (descendants == null || descendants.isEmpty()) {
            endSects.add(curCluster.parentSectionID);
        } else {
            for (FaultSubsectionCluster destCluster : descendants) {
                NSHM23_ConstraintBuilder.findSectsBeforeAfterCreeping(nav, destCluster, sectsBefore, sectsAfter, endSects, creepingEncountered, creepingParentID);
            }
        }
    }

    public NSHM23_ConstraintBuilder parkfieldSelection(ParkfieldSelectionCriteria parkfieldSelect) {
        Preconditions.checkNotNull((Object)((Object)parkfieldSelect));
        this.parkfieldSelect = parkfieldSelect;
        return this;
    }

    public ParkfieldSelectionCriteria getParkfieldSelectionCriteria() {
        return this.parkfieldSelect;
    }

    public List<Integer> findParkfieldRups() {
        return NSHM23_ConstraintBuilder.findParkfieldRups(this.rupSet, this.parkfieldSelect);
    }

    public static int findParkfieldSection(FaultSystemRupSet rupSet) {
        return FaultSectionUtils.findParentSectionID(rupSet.getFaultSectionDataList(), "San", "Andreas", "Parkfield");
    }

    public static List<Integer> findParkfieldRups(FaultSystemRupSet rupSet, ParkfieldSelectionCriteria parkfieldSelect) {
        int parkfieldID = NSHM23_ConstraintBuilder.findParkfieldSection(rupSet);
        if (parkfieldID < 0) {
            System.out.println("Warning: parkfield not found...removed?");
            return new ArrayList<Integer>();
        }
        return parkfieldSelect.select(rupSet, parkfieldID);
    }

    public boolean rupSetHasParkfield() {
        if (NSHM23_ConstraintBuilder.findParkfieldSection(this.rupSet) < 0) {
            return false;
        }
        List<Integer> parkfieldRups = this.findParkfieldRups();
        return !parkfieldRups.isEmpty();
    }

    public NSHM23_ConstraintBuilder parkfield() {
        double parkfieldMeanRate = NSHM23_ConstraintBuilder.PARKFIELD_RATE.bestEstimate;
        double parkfieldStdDev = PARKFIELD_RATE.getPreferredStdDev();
        List<Integer> parkfieldRups = this.findParkfieldRups();
        this.constraints.add(new ParkfieldInversionConstraint(1.0, parkfieldMeanRate, parkfieldRups, ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY, parkfieldStdDev));
        return this;
    }

    public NSHM23_ConstraintBuilder defaultMetaConstraints() {
        return this.supraPaleoSmooth().weight(10000.0);
    }

    public List<Integer> getRupIndexesBelowMinMag() {
        ModSectMinMags modMinMags = this.rupSet.requireModule(ModSectMinMags.class);
        Preconditions.checkNotNull((Object)modMinMags, (Object)"Rupture set must supply ModSectMinMags if minimization constraint is enabled");
        IncrementalMagFreqDist refMagFunc = FaultSysTools.initEmptyMFD(this.rupSet);
        ArrayList<Integer> belowMinIndexes = new ArrayList<Integer>();
        float maxMin = (float)StatUtils.max((double[])modMinMags.getMinMagForSections());
        for (int r = 0; r < this.rupSet.getNumRuptures(); ++r) {
            double mag = this.rupSet.getMagForRup(r);
            if ((float)mag >= maxMin || !modMinMags.isRupBelowSectMinMag(r, refMagFunc)) continue;
            belowMinIndexes.add(r);
        }
        System.out.println("Found " + belowMinIndexes.size() + " ruptures below sect min mags");
        return belowMinIndexes;
    }

    public IntegerSampler.ExclusionIntegerSampler getSkipBelowMinSampler() {
        List<Integer> indexesBelow = this.getRupIndexesBelowMinMag();
        if (indexesBelow.isEmpty()) {
            return null;
        }
        return new IntegerSampler.ExclusionIntegerSampler(0, this.rupSet.getNumRuptures(), indexesBelow);
    }

    public NSHM23_ConstraintBuilder minimizeBelowSectMinMag() {
        List<Integer> belowMinIndexes = this.getRupIndexesBelowMinMag();
        this.constraints.add(new RupRateMinimizationConstraint(100000.0, belowMinIndexes));
        return this;
    }

    public NSHM23_ConstraintBuilder supraSmooth() {
        this.constraints.add(new LaplacianSmoothingInversionConstraint(this.rupSet, 1000.0));
        return this;
    }

    public NSHM23_ConstraintBuilder supraPaleoSmooth() {
        HashSet<Integer> paleoParentIDs = new HashSet<Integer>();
        PaleoseismicConstraintData paleoData = this.rupSet.requireModule(PaleoseismicConstraintData.class);
        ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint> paleos = new ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint>();
        if (paleoData.hasPaleoRateConstraints()) {
            paleos.addAll(paleoData.getPaleoRateConstraints());
        }
        if (paleoData.hasPaleoSlipConstraints()) {
            paleos.addAll(paleoData.getPaleoSlipConstraints());
        }
        Preconditions.checkState((!paleos.isEmpty() ? 1 : 0) != 0);
        for (UncertainDataConstraint.SectMappedUncertainDataConstraint paleo : paleos) {
            paleoParentIDs.add(this.rupSet.getFaultSectionData(paleo.sectionIndex).getParentSectionId());
        }
        LaplacianSmoothingInversionConstraint constraint = new LaplacianSmoothingInversionConstraint(this.rupSet, 1000.0, paleoParentIDs);
        if (constraint.getNumRows() > 0) {
            this.constraints.add(constraint);
        }
        return this;
    }

    public NSHM23_ConstraintBuilder weight(Class<? extends InversionConstraint> clazz, double weight) {
        int i = this.constraints.size();
        while (--i >= 0) {
            InversionConstraint constraint = this.constraints.get(i);
            if (!clazz.isAssignableFrom(constraint.getClass())) continue;
            constraint.setWeight(weight);
        }
        return this;
    }

    public NSHM23_ConstraintBuilder weight(double weight) {
        Preconditions.checkState((!this.constraints.isEmpty() ? 1 : 0) != 0);
        this.constraints.get(this.constraints.size() - 1).setWeight(weight);
        return this;
    }

    public NSHM23_ConstraintBuilder testFlipBVals(FaultSystemSolution prevSol, double targetBVal) {
        Preconditions.checkState((boolean)this.rupSet.isEquivalentTo(prevSol.getRupSet()));
        Preconditions.checkState((this.sectSpecificBValues == null ? 1 : 0) != 0);
        SupraSeisBValInversionTargetMFDs targetMFDs = this.getTargetMFDs(targetBVal, null);
        List<UncertainIncrMagFreqDist> origSupraNuclMFDs = targetMFDs.getOnFaultSupraSeisNucleationMFDs();
        double[] solRupMoRates = SectBValuePlot.calcRupMoments(prevSol.getRupSet());
        for (int r = 0; r < solRupMoRates.length; ++r) {
            int n = r;
            solRupMoRates[n] = solRupMoRates[n] * prevSol.getRateForRup(r);
        }
        double[] targetNuclRates = new double[this.rupSet.getNumSections()];
        double[] targetNuclRateStdDevs = new double[this.rupSet.getNumSections()];
        DataUtils.MinMaxAveTracker solBVals = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker flippedBVals = new DataUtils.MinMaxAveTracker();
        for (int s = 0; s < targetNuclRates.length; ++s) {
            IncrementalMagFreqDist origMFD = origSupraNuclMFDs.get(s);
            double minMag = Double.POSITIVE_INFINITY;
            double maxMag = 0.0;
            for (int i = 0; i < origMFD.size(); ++i) {
                if (!(origMFD.getY(i) > 0.0)) continue;
                double x = origMFD.getX(i);
                minMag = Math.min(minMag, x);
                maxMag = Math.max(maxMag, x);
            }
            double solSupraNuclRate = 0.0;
            double solSupraMoRate = 0.0;
            double sectArea = this.rupSet.getAreaForSection(s);
            for (int r : this.rupSet.getRupturesForSection(s)) {
                double rate = prevSol.getRateForRup(r);
                if (!(rate > 0.0)) continue;
                double fract = sectArea / this.rupSet.getAreaForRup(r);
                solSupraNuclRate += rate * fract;
                solSupraMoRate += solRupMoRates[r] * fract;
            }
            int numOrig = 1 + origMFD.getClosestXIndex(maxMag) - origMFD.getClosestXIndex(minMag);
            GutenbergRichterMagFreqDist grWithSolRate = new GutenbergRichterMagFreqDist(minMag, numOrig, origMFD.getDelta());
            grWithSolRate.setAllButBvalue(minMag, maxMag, solSupraMoRate, solSupraNuclRate);
            double solBVal = grWithSolRate.get_bValue();
            solBVals.addValue(solBVal);
            double flippedBVal = targetBVal + (targetBVal - solBVal);
            flippedBVals.addValue(flippedBVal);
            GutenbergRichterMagFreqDist grWithFlippedB = new GutenbergRichterMagFreqDist(minMag, numOrig, origMFD.getDelta());
            grWithFlippedB.setAllButTotCumRate(minMag, maxMag, origMFD.getTotalMomentRate(), flippedBVal);
            double flippedNuclRate = grWithFlippedB.getTotalIncrRate();
            System.out.println(s + ". targetB=" + (float)targetBVal + "\ttargetRate=" + (float)origMFD.getTotalIncrRate() + "\ttargetMoRate=" + (float)origMFD.getTotalMomentRate() + "\tsolMoRate=" + (float)solSupraMoRate + "\tsolRate=" + (float)solSupraNuclRate + "\tsolBVal=" + (float)solBVal + "\tflippedBVal=" + (float)flippedBVal + "\tflippedRate=" + (float)flippedNuclRate);
            targetNuclRates[s] = flippedNuclRate;
            targetNuclRateStdDevs[s] = 0.1 * targetNuclRates[s];
        }
        System.out.println("Solution b-values: " + String.valueOf(solBVals));
        System.out.println("Flipped b-values: " + String.valueOf(flippedBVals));
        this.constraints.add(new SectionTotalRateConstraint(this.rupSet, 1.0, ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY, targetNuclRates, targetNuclRateStdDevs, true));
        return this;
    }

    public NSHM23_ConstraintBuilder testSameBVals(FaultSystemSolution prevSol) {
        Preconditions.checkState((boolean)this.rupSet.isEquivalentTo(prevSol.getRupSet()));
        double[] targetNuclRates = new double[this.rupSet.getNumSections()];
        double[] targetNuclRateStdDevs = new double[this.rupSet.getNumSections()];
        for (int s = 0; s < targetNuclRates.length; ++s) {
            double solSupraNuclRate = 0.0;
            double sectArea = this.rupSet.getAreaForSection(s);
            for (int r : this.rupSet.getRupturesForSection(s)) {
                solSupraNuclRate += prevSol.getRateForRup(r) * sectArea / this.rupSet.getAreaForRup(r);
            }
            targetNuclRates[s] = solSupraNuclRate;
            targetNuclRateStdDevs[s] = 0.1 * targetNuclRates[s];
        }
        this.constraints.add(new SectionTotalRateConstraint(this.rupSet, 1.0, ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY, targetNuclRates, targetNuclRateStdDevs, true));
        return this;
    }

    public IntegerPDF_FunctionSampler testGetSampleAllNew(FaultSystemSolution prevSol, boolean skipBelow) {
        Preconditions.checkState((boolean)this.rupSet.isEquivalentTo(prevSol.getRupSet()));
        double[] weights = new double[this.rupSet.getNumRuptures()];
        Arrays.fill(weights, 1.0);
        if (skipBelow) {
            for (int r : this.getRupIndexesBelowMinMag()) {
                weights[r] = 0.0;
            }
        }
        for (int r = 0; r < weights.length; ++r) {
            if (!(prevSol.getRateForRup(r) > 0.0)) continue;
            weights[r] = 0.0;
        }
        return new IntegerPDF_FunctionSampler(weights);
    }

    public NSHM23_ConstraintBuilder u2NuclBVals(boolean aFaults, boolean reproduce) {
        U3LogicTreeBranch branch = this.rupSet.requireModule(U3LogicTreeBranch.class);
        AveSlipModule aveSlipModule = this.rupSet.requireModule(AveSlipModule.class);
        ScalingRelationships scalingRel = branch.getValue(ScalingRelationships.class);
        double fractGR = 0.33333;
        FaultSystemSolution u2Sol = null;
        FaultSystemRupSet u2RupSet = null;
        if (aFaults && reproduce) {
            u2Sol = UCERF2_ComparisonSolutionFetcher.getUCERF2Solution(this.rupSet, branch.getValue(FaultModels.class), aveSlipModule);
            u2RupSet = u2Sol.getRupSet();
        }
        double[] targetNuclRates = new double[this.rupSet.getNumSections()];
        double[] targetNuclRateStdDevs = new double[this.rupSet.getNumSections()];
        SectSlipRates slipRates = this.rupSet.getSectSlipRates();
        SupraSeisBValInversionTargetMFDs targetB1 = new SupraSeisBValInversionTargetMFDs.Builder(u2RupSet, 1.0).subSeisMoRateReduction(SupraSeisBValInversionTargetMFDs.SubSeisMoRateReduction.SYSTEM_AVG_IMPLIED_FROM_SUPRA_B).build();
        this.rupSet.addModule(slipRates);
        DataUtils.MinMaxAveTracker implBValU2Track = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker implBValU2AFaultTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker implBValTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker implBValAFaultTrack = new DataUtils.MinMaxAveTracker();
        Map<Integer, List<FaultSection>> sectsByParent = this.rupSet.getFaultSectionDataList().stream().collect(Collectors.groupingBy(S -> S.getParentSectionId()));
        ArrayList<U3SectionMFD_constraint> u2Constraints = null;
        if (!reproduce) {
            u2Constraints = FaultSystemRupSetCalc.getCharInversionSectMFD_Constraints(this.rupSet);
            aFaults = false;
        }
        HashMap<Integer, Double> parentAreas = new HashMap<Integer, Double>();
        HashMap<Integer, Double> parentLengths = new HashMap<Integer, Double>();
        for (Integer parentID : sectsByParent.keySet()) {
            double area = 0.0;
            double len = 0.0;
            for (FaultSection sect : sectsByParent.get(parentID)) {
                area += this.rupSet.getAreaForSection(sect.getSectionId());
                len += sect.getTraceLength() * 0.001;
            }
            parentAreas.put(parentID, area);
            parentLengths.put(parentID, len);
        }
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            FaultSection data = this.rupSet.getFaultSectionData(s);
            IncrementalMagFreqDist sectNuclB1 = targetB1.getOnFaultSupraSeisNucleationMFDs().get(s);
            int minIndex = -1;
            int maxIndex = 0;
            for (int i = 0; i < sectNuclB1.size(); ++i) {
                if (!(sectNuclB1.getY(i) > 0.0)) continue;
                maxIndex = i;
                if (minIndex >= 0) continue;
                minIndex = i;
            }
            double minMag = sectNuclB1.getX(minIndex);
            double maxMag = sectNuclB1.getX(maxIndex);
            double totSectMoment = sectNuclB1.getTotalMomentRate();
            boolean aFault = false;
            double maxCharMag = 0.0;
            int maxCharMagIndex = -1;
            if (!reproduce) {
                U3SectionMFD_constraint u2Constr = (U3SectionMFD_constraint)u2Constraints.get(s);
                if (u2Constr == null) {
                    targetNuclRates[s] = Double.NaN;
                    targetNuclRateStdDevs[s] = Double.NaN;
                } else {
                    targetNuclRates[s] = u2Constr.getCumMFD().getY(0);
                    targetNuclRateStdDevs[s] = 0.1 * targetNuclRates[s];
                    maxCharMag = u2Constr.getMag(u2Constr.getNumMags() - 1);
                    maxCharMagIndex = sectNuclB1.getClosestXIndex(maxCharMag);
                    if (maxCharMagIndex < minIndex) {
                        System.err.println("WARNING: characteristic mag (" + (float)maxCharMag + ") is below sect min mag (" + (float)minMag + "), setting to sect min: " + s + ". " + data.getName());
                        maxCharMagIndex = minIndex;
                    }
                    maxCharMag = sectNuclB1.getX(maxCharMagIndex);
                    aFault = UCERF2_A_FaultMapper.wasUCERF2_TypeAFault(data.getParentSectionId());
                }
            }
            if (targetNuclRates[s] == 0.0 && aFaults && UCERF2_A_FaultMapper.wasUCERF2_TypeAFault(data.getParentSectionId())) {
                double solSupraNuclRate = 0.0;
                double sectArea = this.rupSet.getAreaForSection(s);
                maxCharMag = 0.0;
                for (int r : u2RupSet.getRupturesForSection(s)) {
                    double rate = u2Sol.getRateForRup(r);
                    solSupraNuclRate += rate * sectArea / u2RupSet.getAreaForRup(r);
                    if (!(rate > 0.0)) continue;
                    maxCharMag = Math.max(maxCharMag, u2RupSet.getMagForRup(r));
                }
                maxCharMagIndex = sectNuclB1.getClosestXIndex(maxCharMag);
                if (maxCharMagIndex < minIndex) {
                    System.err.println("WARNING: characteristic mag (" + (float)maxCharMag + ") is below sect min mag (" + (float)minMag + "), setting to sect min: " + s + ". " + data.getName());
                    maxCharMagIndex = minIndex;
                }
                maxCharMag = sectNuclB1.getX(maxCharMagIndex);
                if (solSupraNuclRate == 0.0) {
                    System.err.println("WARNING: no a-fault nucl rate for " + s + ". " + data.getName() + ", reverting to b-fault formula");
                } else {
                    Preconditions.checkState((solSupraNuclRate > 0.0 ? 1 : 0) != 0, (String)"nucl rate is zero for a-fault: %s. %s", (int)s, (Object)data.getName());
                    targetNuclRates[s] = solSupraNuclRate;
                    targetNuclRateStdDevs[s] = 0.1 * targetNuclRates[s];
                    aFault = true;
                }
            }
            if (targetNuclRates[s] == 0.0) {
                double width;
                double length;
                double area = (Double)parentAreas.get(data.getParentSectionId());
                maxCharMag = scalingRel.getMag(area, length = ((Double)parentLengths.get(data.getParentSectionId())).doubleValue(), width = area / length, width, data.getAveRake());
                maxCharMagIndex = sectNuclB1.getClosestXIndex(maxCharMag);
                if (maxCharMagIndex < minIndex) {
                    System.err.println("WARNING: characteristic mag (" + (float)maxCharMag + ") is below sect min mag (" + (float)minMag + "), setting to sect min: " + s + ". " + data.getName());
                    maxCharMagIndex = minIndex;
                }
                Preconditions.checkState((maxCharMagIndex <= maxIndex ? 1 : 0) != 0, (String)"charMag=%s, charMagIndex%s, supraMin=%s, supraMinIndex=%s, supraMax=%s, supraMaxIndex=%s", (Object[])new Object[]{maxCharMag, maxCharMagIndex, minMag, minIndex, maxMag, maxIndex});
                maxCharMag = sectNuclB1.getX(maxCharMagIndex);
                GutenbergRichterMagFreqDist charMFD = new GutenbergRichterMagFreqDist(sectNuclB1.getMinX(), sectNuclB1.size(), sectNuclB1.getDelta());
                double charMoment = (1.0 - fractGR) * totSectMoment;
                charMFD.setAllButTotCumRate(maxCharMag, maxCharMag, charMoment, 1.0);
                GutenbergRichterMagFreqDist grMFD = new GutenbergRichterMagFreqDist(sectNuclB1.getMinX(), sectNuclB1.size(), sectNuclB1.getDelta());
                double grMoment = fractGR * totSectMoment;
                grMFD.setAllButTotCumRate(minMag, maxCharMag, grMoment, 1.0);
                Preconditions.checkState(((float)(grMFD.getTotalMomentRate() + charMFD.getTotalMomentRate()) == (float)totSectMoment ? 1 : 0) != 0);
                SummedMagFreqDist u2Target = new SummedMagFreqDist(charMFD.getMinX(), charMFD.size(), charMFD.getDelta());
                u2Target.addIncrementalMagFreqDist(grMFD);
                u2Target.addIncrementalMagFreqDist(charMFD);
                Preconditions.checkState(((float)u2Target.getTotalMomentRate() == (float)totSectMoment ? 1 : 0) != 0);
                targetNuclRates[s] = u2Target.getTotalIncrRate();
                Preconditions.checkState((targetNuclRates[s] > 0.0 ? 1 : 0) != 0, (String)"nucl rate is zero for b-fault: %s. %s", (int)s, (Object)data.getName());
                targetNuclRateStdDevs[s] = 0.1 * targetNuclRates[s];
            }
            if (!Double.isFinite(targetNuclRates[s])) {
                System.out.println(s + ".\tNONE");
                continue;
            }
            GutenbergRichterMagFreqDist grWithSolRate = new GutenbergRichterMagFreqDist(sectNuclB1.getMinX(), sectNuclB1.size(), sectNuclB1.getDelta());
            grWithSolRate.setAllButBvalue(sectNuclB1.getX(minIndex), maxMag, totSectMoment, targetNuclRates[s]);
            double implB = grWithSolRate.get_bValue();
            grWithSolRate = new GutenbergRichterMagFreqDist(sectNuclB1.getMinX(), sectNuclB1.size(), sectNuclB1.getDelta());
            grWithSolRate.setAllButBvalue(sectNuclB1.getX(minIndex), maxCharMag, totSectMoment, targetNuclRates[s]);
            double implU2B = grWithSolRate.get_bValue();
            System.out.println(s + ".\trate=" + (float)targetNuclRates[s] + "\tb=" + (float)implB + "\tb-to-char-max=" + (float)implU2B + "\taFault=" + aFault + "\tsectMin=" + (float)minMag + "\tcharMax=" + (float)maxCharMag + "\tcharBins=" + (1 + maxCharMagIndex - minIndex));
            if (minIndex == maxIndex) continue;
            if (aFault) {
                implBValAFaultTrack.addValue(implB);
                if (minIndex == maxCharMagIndex) continue;
                implBValU2AFaultTrack.addValue(implU2B);
                continue;
            }
            implBValTrack.addValue(implB);
            if (minIndex == maxCharMagIndex) continue;
            implBValU2Track.addValue(implU2B);
        }
        if (implBValAFaultTrack.getNum() > 0) {
            System.out.println("UCERF2-style implied b-values:");
            System.out.println("\t" + implBValAFaultTrack.getNum() + " a-faults: " + String.valueOf(implBValAFaultTrack));
            System.out.println("\t" + implBValAFaultTrack.getNum() + " a-faults, to char-max: " + String.valueOf(implBValU2AFaultTrack));
            System.out.println("\t" + implBValTrack.getNum() + " b-faults: " + String.valueOf(implBValTrack));
            System.out.println("\t" + implBValTrack.getNum() + " b-faults, to char-max: " + String.valueOf(implBValU2Track));
        } else {
            System.out.println("UCERF2-style implied b-values: " + String.valueOf(implBValTrack));
            System.out.println("UCERF2-style implied b-values, to char-max: " + String.valueOf(implBValU2Track));
        }
        this.constraints.add(new SectionTotalRateConstraint(this.rupSet, 1.0, ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY, targetNuclRates, targetNuclRateStdDevs, true));
        return this;
    }

    public IntegerPDF_FunctionSampler testSampleFaultsEqually(boolean skipBelow, double cap) {
        Map<Integer, List<FaultSection>> sectsByParent = this.rupSet.getFaultSectionDataList().stream().collect(Collectors.groupingBy(S -> S.getParentSectionId()));
        ClusterRuptures cRups = this.rupSet.requireModule(ClusterRuptures.class);
        HashMap<Integer, Integer> parentRupCounts = new HashMap<Integer, Integer>();
        int maxRups = 0;
        int minRups = Integer.MAX_VALUE;
        HashSet<Integer> skipRups = null;
        if (skipBelow) {
            skipRups = new HashSet<Integer>(this.getRupIndexesBelowMinMag());
        }
        for (int parentID : sectsByParent.keySet()) {
            List<Integer> rups = this.rupSet.getRupturesForParentSection(parentID);
            int count = rups.size();
            if (skipBelow) {
                for (Integer r : rups) {
                    if (!skipRups.contains(r)) continue;
                    --count;
                }
            }
            maxRups = Integer.max(maxRups, count);
            if (count > 0) {
                minRups = Integer.min(minRups, count);
            }
            parentRupCounts.put(parentID, count);
        }
        System.out.println("Max ruptures per section: " + maxRups);
        System.out.println("Min ruptures per section: " + minRups);
        double[] sampleRates = new double[this.rupSet.getNumRuptures()];
        DataUtils.MinMaxAveTracker scoreTrack = new DataUtils.MinMaxAveTracker();
        for (int r = 0; r < sampleRates.length; ++r) {
            if (skipBelow && skipRups.contains(r)) continue;
            ClusterRupture rup = cRups.get(r);
            double avgScore = 0.0;
            for (FaultSubsectionCluster cluster : rup.getClustersIterable()) {
                avgScore += (double)maxRups / ((Integer)parentRupCounts.get(cluster.parentSectionID)).doubleValue();
            }
            avgScore /= (double)rup.getTotalNumClusters();
            sampleRates[r] = avgScore = Math.min(avgScore, cap);
            scoreTrack.addValue(avgScore);
        }
        System.out.println("Sample score range: " + String.valueOf(scoreTrack));
        return new IntegerPDF_FunctionSampler(sampleRates);
    }

    public NSHM23_ConstraintBuilder parkfieldHackSectSupraRates(double parkfieldRelStdDev) {
        SupraSeisBValInversionTargetMFDs target = this.getTargetMFDs(this.supraBVal, this.sectSpecificBValues);
        double[] targetRates = new double[this.rupSet.getNumSections()];
        double[] targetRateStdDevs = new double[this.rupSet.getNumSections()];
        System.err.println("WARNING: temporary relative standard deviation of 0.1 set for all section target rates");
        List<UncertainIncrMagFreqDist> sectSupraMFDs = target.getOnFaultSupraSeisNucleationMFDs();
        int numPark = 0;
        for (int s = 0; s < targetRates.length; ++s) {
            targetRates[s] = sectSupraMFDs.get(s).calcSumOfY_Vals();
            targetRateStdDevs[s] = 0.1 * targetRates[s];
            if (!this.rupSet.getFaultSectionData(s).getName().toLowerCase().contains("parkfield")) continue;
            targetRateStdDevs[s] = targetRates[s] * parkfieldRelStdDev;
            ++numPark;
        }
        Preconditions.checkState((numPark > 0 ? 1 : 0) != 0);
        this.constraints.add(new SectionTotalRateConstraint(this.rupSet, 1.0, ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY, targetRates, targetRateStdDevs, true));
        return this;
    }

    public IntegerPDF_FunctionSampler testGetJumpDistSampler(double maxJumpDist, boolean skipBelow) {
        double[] weights = new double[this.rupSet.getNumRuptures()];
        Arrays.fill(weights, 1.0);
        if (skipBelow) {
            for (int r : this.getRupIndexesBelowMinMag()) {
                weights[r] = 0.0;
            }
        }
        ClusterRuptures cRups = this.rupSet.requireModule(ClusterRuptures.class);
        block1: for (int r = 0; r < weights.length; ++r) {
            for (Jump jump : cRups.get(r).getJumpsIterable()) {
                if (!((float)jump.distance > (float)maxJumpDist)) continue;
                weights[r] = 0.0;
                continue block1;
            }
        }
        return new IntegerPDF_FunctionSampler(weights);
    }

    public double[] getParkfieldInitial(boolean ensureNotSkipped, SupraSeisBValInversionTargetMFDs targetMFDs) {
        ArrayList<Integer> parkRups = new ArrayList<Integer>(this.findParkfieldRups());
        double[] initial = new double[this.rupSet.getNumRuptures()];
        if (ensureNotSkipped) {
            HashSet<Integer> skips = new HashSet<Integer>(this.getRupIndexesBelowMinMag());
            int r = parkRups.size();
            while (--r >= 0) {
                if (!skips.contains(parkRups.get(r))) continue;
                parkRups.remove(r);
            }
            Preconditions.checkState((!skips.isEmpty() ? 1 : 0) != 0, (Object)"All parkfield rups are skipped!");
        }
        double target = NSHM23_ConstraintBuilder.PARKFIELD_RATE.bestEstimate;
        if (targetMFDs != null && targetMFDs.getOnFaultSupraSeisNucleationMFDs() != null) {
            boolean fullCloser;
            int parkfieldSect = NSHM23_ConstraintBuilder.findParkfieldSection(this.rupSet);
            List<UncertainIncrMagFreqDist> mfds = targetMFDs.getOnFaultSupraSeisNucleationMFDs();
            double impliedMappedRate = 0.0;
            double impliedFullNuclRate = 0.0;
            for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
                int i;
                if (this.rupSet.getFaultSectionData(s).getParentSectionId() != parkfieldSect) continue;
                UncertainIncrMagFreqDist mfd = mfds.get(s);
                boolean[] rupBinAssocs = new boolean[mfd.size()];
                int minAssocBin = mfd.size();
                Iterator iterator = parkRups.iterator();
                while (iterator.hasNext()) {
                    int rupIndex = (Integer)iterator.next();
                    for (int sectIndex : this.rupSet.getSectionsIndicesForRup(rupIndex)) {
                        if (sectIndex != s) continue;
                        int binIndex = mfd.getClosestXIndex(this.rupSet.getMagForRup(rupIndex));
                        rupBinAssocs[binIndex] = true;
                        minAssocBin = Integer.min(minAssocBin, binIndex);
                    }
                }
                for (i = 0; i < rupBinAssocs.length; ++i) {
                    if (!rupBinAssocs[i]) continue;
                    impliedMappedRate += mfd.getY(i);
                }
                for (i = minAssocBin; i < mfd.size(); ++i) {
                    impliedFullNuclRate += mfd.getY(i);
                }
            }
            System.out.println("Implied Parkfield rates for initial: exactMapped=" + (float)impliedMappedRate + ", fullNucl=" + (float)impliedFullNuclRate);
            double lowerBound = target - 2.0 * PARKFIELD_RATE.getPreferredStdDev();
            double upperBound = target + 2.0 * PARKFIELD_RATE.getPreferredStdDev();
            double mappedDiff = impliedMappedRate - target;
            double fullDiff = impliedFullNuclRate - target;
            boolean bl = fullCloser = Math.abs(fullDiff) < Math.abs(mappedDiff);
            double impliedRate = impliedMappedRate < lowerBound && fullCloser ? (impliedFullNuclRate < lowerBound ? impliedFullNuclRate : 0.5 * (lowerBound + impliedFullNuclRate)) : impliedMappedRate;
            if (impliedRate < target) {
                if (impliedRate <= lowerBound) {
                    System.out.println("Adjusted Parkfield initial rate to -2sigma of " + (float)lowerBound + " (was " + (float)target + ", implied is " + (float)impliedRate + ")");
                    target = lowerBound;
                } else {
                    System.out.println("Adjusted Parkfield initial rate to implied of " + (float)impliedRate + " (was " + (float)target + ")");
                    target = impliedRate;
                }
            } else if (impliedRate > target) {
                if (impliedRate >= upperBound) {
                    System.out.println("Adjusted Parkfield initial rate to +2sigma of " + (float)upperBound + " (was " + (float)target + ", implied is " + (float)impliedRate + ")");
                    target = upperBound;
                } else {
                    System.out.println("Adjusted Parkfield initial rate to implied of " + (float)impliedRate + " (was " + (float)target + ")");
                    target = impliedRate;
                }
            }
        }
        double rateEach = target / (double)parkRups.size();
        Iterator iterator = parkRups.iterator();
        while (iterator.hasNext()) {
            int rup = (Integer)iterator.next();
            initial[rup] = rateEach;
        }
        return initial;
    }

    public static enum ParkfieldSelectionCriteria {
        SECT_COUNT{

            @Override
            List<Integer> select(FaultSystemRupSet rupSet, int parkfieldID) {
                List<Integer> potentialRups = rupSet.getRupturesForParentSection(parkfieldID);
                ArrayList<Integer> parkfieldRups = new ArrayList<Integer>();
                if (potentialRups == null) {
                    System.out.println("Warning: parkfield not found...removed?");
                    return parkfieldRups;
                }
                for (int i = 0; i < potentialRups.size(); ++i) {
                    Integer commonID;
                    List<FaultSection> rupSects = rupSet.getFaultSectionDataForRupture(potentialRups.get(i));
                    if (rupSects.size() < 6 || rupSects.size() > 8 || (commonID = FaultSectionUtils.getCommonParentID(rupSects)) == null || commonID != parkfieldID) continue;
                    parkfieldRups.add(potentialRups.get(i));
                }
                return parkfieldRups;
            }
        }
        ,
        MAG_6{

            @Override
            List<Integer> select(FaultSystemRupSet rupSet, int parkfieldID) {
                HashSet<Integer> rupIndexes = new HashSet<Integer>();
                for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                    if (faultSection.getParentSectionId() != parkfieldID) continue;
                    double minAbove6 = Double.POSITIVE_INFINITY;
                    int minAboveIndex = -1;
                    double maxBelow6 = Double.NEGATIVE_INFINITY;
                    int maxBelowIndex = -1;
                    boolean matchFound = false;
                    for (int rupIndex : rupSet.getRupturesForSection(faultSection.getSectionId())) {
                        Integer commonID = FaultSectionUtils.getCommonParentID(rupSet.getFaultSectionDataForRupture(rupIndex));
                        if (commonID == null || commonID != parkfieldID) continue;
                        double mag = rupSet.getMagForRup(rupIndex);
                        if ((float)mag >= 6.0f && (float)mag <= 6.1f) {
                            rupIndexes.add(rupIndex);
                            matchFound = true;
                            continue;
                        }
                        if ((float)mag > 6.0f) {
                            if (!(mag < minAbove6)) continue;
                            minAbove6 = mag;
                            minAboveIndex = rupIndex;
                            continue;
                        }
                        if (!(mag > maxBelow6)) continue;
                        maxBelow6 = mag;
                        maxBelowIndex = rupIndex;
                    }
                    if (matchFound) continue;
                    if (minAboveIndex >= 0) {
                        rupIndexes.add(minAboveIndex);
                        continue;
                    }
                    if (maxBelowIndex < 0) continue;
                    rupIndexes.add(maxBelowIndex);
                }
                ArrayList<Integer> ret = new ArrayList<Integer>(rupIndexes);
                Collections.sort(ret);
                return ret;
            }
        };


        abstract List<Integer> select(FaultSystemRupSet var1, int var2);
    }
}

