/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.data;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.uncertainty.BoundedUncertainty;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoSlipProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.PaleoseismicConstraintData;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.data.NSHM23_PaleoProbabilityModel;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.NSHM23_RegionLoader;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.utils.aveSlip.U3AveSlipConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoProbabilityModel;

public class NSHM23_PaleoDataLoader {
    public static boolean INCLUDE_U3_PALEO_SLIP = false;
    private static final String NSHM23_PALEO_RI_PATH_PREFIX = "/data/erf/nshm23/constraints/paleo_ri/";
    private static final String CA_PALEO_PATH = "/data/erf/nshm23/constraints/paleo_ri/McPhillips_California_RIs_2022_07_13.csv";
    private static final String WASATCH_PALEO_PATH = "/data/erf/nshm23/constraints/paleo_ri/wasatch_paleo_data_2022_11_10.csv";
    private static final String NSHM23_PALEO_SLIP_PATH_PREFIX = "/data/erf/nshm23/constraints/paleo_slip/";
    private static final String U3_PALEO_SLIP_PATH_1 = "/data/erf/nshm23/constraints/paleo_slip/Table_R5v4.csv";
    private static final String U3_PALEO_SLIP_PATH_2 = "/data/erf/nshm23/constraints/paleo_slip/Table_R6v5.csv";
    public static double LOC_MAX_DIST_NONE_CONTAINED = 40.0;
    public static double LOC_MAX_DIST_OTHER_CONTAINED = 1.0;
    public static final double LOC_MAX_DIST_CONTAINED = 20.0;

    public static PaleoseismicConstraintData load(FaultSystemRupSet rupSet) throws IOException {
        PaleoProbabilityModel paleoProbModel;
        List<UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoRateConstraints;
        List<? extends FaultSection> subSects = rupSet.getFaultSectionDataList();
        List<UncertainDataConstraint.SectMappedUncertainDataConstraint> caRateConstraints = NSHM23_PaleoDataLoader.loadCAPaleoRateData(subSects);
        boolean hasCA = NSHM23_PaleoDataLoader.hasMappedConstraints(caRateConstraints);
        List<UncertainDataConstraint.SectMappedUncertainDataConstraint> wasatchRateConstraints = NSHM23_PaleoDataLoader.loadWasatchPaleoRateData(subSects);
        boolean hasWasatch = NSHM23_PaleoDataLoader.hasMappedConstraints(wasatchRateConstraints);
        if (hasCA && hasWasatch) {
            paleoRateConstraints = new ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint>();
            paleoRateConstraints.addAll(caRateConstraints);
            paleoRateConstraints.addAll(wasatchRateConstraints);
            paleoProbModel = new NSHM23_PaleoProbabilityModel();
        } else if (hasCA) {
            paleoRateConstraints = caRateConstraints;
            paleoProbModel = UCERF3_PaleoProbabilityModel.load();
        } else if (hasWasatch) {
            paleoRateConstraints = wasatchRateConstraints;
            paleoProbModel = new NSHM23_PaleoProbabilityModel.WasatchPaleoProbabilityModel();
        } else {
            paleoRateConstraints = null;
            paleoProbModel = null;
        }
        List<UncertainDataConstraint.SectMappedUncertainDataConstraint> aveSlipConstraints = null;
        PaleoSlipProbabilityModel paleoSlipProbModel = null;
        if (INCLUDE_U3_PALEO_SLIP) {
            aveSlipConstraints = NSHM23_PaleoDataLoader.loadU3PaleoSlipData(subSects);
            paleoSlipProbModel = U3AveSlipConstraint.slip_prob_model;
        }
        return new PaleoseismicConstraintData(rupSet, paleoRateConstraints, paleoProbModel, aveSlipConstraints, paleoSlipProbModel);
    }

    public static List<UncertainDataConstraint.SectMappedUncertainDataConstraint> loadCAPaleoRateData(List<? extends FaultSection> subSects) throws IOException {
        CSVFile<String> csv = CSVFile.readStream(NSHM23_PaleoDataLoader.class.getResourceAsStream(CA_PALEO_PATH), false);
        ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint> ret = new ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint>();
        for (int row = 2; row < csv.getNumRows(); ++row) {
            int col;
            boolean isData = true;
            List<String> line = csv.getLine(row);
            if (line.size() < 9) continue;
            for (col = 0; col < 9; ++col) {
                if (!line.get(col).isBlank()) continue;
                isData = false;
                break;
            }
            if (!isData) continue;
            col = 0;
            String name = csv.get(row, col++);
            double lat = csv.getDouble(row, col++);
            double lon = csv.getDouble(row, col++);
            ++col;
            ++col;
            int n = ++col;
            double ri = csv.getDouble(row, n);
            int n2 = ++col;
            ++col;
            String ciStr = csv.get(row, n2);
            double rate = 1.0 / ri;
            Preconditions.checkState((boolean)ciStr.contains("-"));
            String[] ciSplit = ciStr.split("-");
            Preconditions.checkState((ciSplit.length == 2 ? 1 : 0) != 0);
            double lowerRI = Double.parseDouble(ciSplit[0]);
            double upperRI = Double.parseDouble(ciSplit[1]);
            double lowerRate = 1.0 / upperRI;
            double upperRate = 1.0 / lowerRI;
            Location loc = new Location(lat, lon);
            FaultSection mappedSect = null;
            if (subSects != null && (mappedSect = PaleoseismicConstraintData.findMatchingSect(loc, subSects, LOC_MAX_DIST_NONE_CONTAINED, LOC_MAX_DIST_OTHER_CONTAINED, 20.0)) == null) {
                System.err.println("WARNING: no matching fault section found for paleo site " + name + " at " + lat + ", " + lon);
                continue;
            }
            BoundedUncertainty uncert = BoundedUncertainty.fromMeanAndBounds(UncertaintyBoundType.CONF_95, rate, lowerRate, upperRate);
            if (mappedSect == null) {
                ret.add(new UncertainDataConstraint.SectMappedUncertainDataConstraint(name, -1, null, loc, rate, uncert));
                continue;
            }
            ret.add(new UncertainDataConstraint.SectMappedUncertainDataConstraint(name, mappedSect.getSectionId(), mappedSect.getSectionName(), loc, rate, uncert));
        }
        return ret;
    }

    public static List<UncertainDataConstraint.SectMappedUncertainDataConstraint> loadU3PaleoSlipData(List<? extends FaultSection> subSects) throws IOException {
        ArrayList<CSVFile<String>> csvs = new ArrayList<CSVFile<String>>();
        csvs.add(CSVFile.readStream(NSHM23_PaleoDataLoader.class.getResourceAsStream(U3_PALEO_SLIP_PATH_1), false));
        csvs.add(CSVFile.readStream(NSHM23_PaleoDataLoader.class.getResourceAsStream(U3_PALEO_SLIP_PATH_2), false));
        ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint> ret = new ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint>();
        for (CSVFile cSVFile : csvs) {
            for (int row = 3; row < cSVFile.getNumRows(); ++row) {
                boolean isData = true;
                List line = cSVFile.getLine(row);
                if (line.size() < 24) continue;
                for (int col = 0; col < 3; ++col) {
                    if (!((String)line.get(col)).isBlank()) continue;
                    isData = false;
                    break;
                }
                if (((String)line.get(21)).isBlank() || ((String)line.get(21)).isBlank() || ((String)line.get(21)).isBlank()) {
                    isData = false;
                }
                if (!isData) continue;
                String name = ((String)cSVFile.get(row, 0)).trim();
                if (Character.isDigit(name.charAt(name.length() - 1)) && name.length() > 2 && !Character.isDigit(name.charAt(name.length() - 2))) {
                    name = name.substring(0, name.length() - 1);
                }
                double lat = cSVFile.getDouble(row, 1);
                double lon = cSVFile.getDouble(row, 2);
                double aveSlip = cSVFile.getDouble(row, 21);
                double upper = aveSlip + cSVFile.getDouble(row, 22);
                double lower = aveSlip - cSVFile.getDouble(row, 23);
                Location loc = new Location(lat, lon);
                FaultSection mappedSect = null;
                if (subSects != null && (mappedSect = PaleoseismicConstraintData.findMatchingSect(loc, subSects, LOC_MAX_DIST_NONE_CONTAINED, LOC_MAX_DIST_OTHER_CONTAINED, 20.0)) == null) {
                    System.err.println("WARNING: no matching fault section found for paleo site " + name + " at " + lat + ", " + lon);
                    continue;
                }
                BoundedUncertainty uncert = BoundedUncertainty.fromMeanAndBounds(UncertaintyBoundType.TWO_SIGMA, aveSlip, lower, upper);
                if (mappedSect == null) {
                    ret.add(new UncertainDataConstraint.SectMappedUncertainDataConstraint(name, -1, null, loc, aveSlip, uncert));
                    continue;
                }
                ret.add(new UncertainDataConstraint.SectMappedUncertainDataConstraint(name, mappedSect.getSectionId(), mappedSect.getSectionName(), loc, aveSlip, uncert));
            }
        }
        return ret;
    }

    public static List<UncertainDataConstraint.SectMappedUncertainDataConstraint> loadWasatchPaleoRateData(List<? extends FaultSection> subSects) throws IOException {
        CSVFile<String> csv = CSVFile.readStream(NSHM23_PaleoDataLoader.class.getResourceAsStream(WASATCH_PALEO_PATH), false);
        ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint> ret = new ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint>();
        boolean siteNameCol = false;
        boolean parentNameCol = true;
        int parentIDCol = 2;
        int latCol = 4;
        int lonCol = 5;
        int rateCol = 15;
        int upperCol = 16;
        int lowerCol = 17;
        UncertaintyBoundType boundType = UncertaintyBoundType.CONF_95;
        ArrayList<FaultSection> wasatchSubSects = new ArrayList<FaultSection>();
        for (FaultSection faultSection : subSects) {
            if (!faultSection.getParentSectionName().toLowerCase().contains("wasatch")) continue;
            wasatchSubSects.add(faultSection);
        }
        for (int row = 2; row < csv.getNumRows(); ++row) {
            int n = csv.getLine(row).size();
            if (n <= 18 || csv.get(row, 17).isBlank()) continue;
            String name = csv.get(row, 0).replace("*", "");
            double lat = csv.getDouble(row, 4);
            double lon = csv.getDouble(row, 5);
            double rate = csv.getDouble(row, 15);
            double lowerRate = csv.getDouble(row, 17);
            double upperRate = csv.getDouble(row, 16);
            double stdDev = boundType.estimateStdDev(lowerRate, upperRate);
            Location loc = new Location(lat, lon);
            FaultSection mappedSect = null;
            if (wasatchSubSects != null) {
                mappedSect = PaleoseismicConstraintData.findMatchingSect(loc, wasatchSubSects, LOC_MAX_DIST_NONE_CONTAINED, LOC_MAX_DIST_OTHER_CONTAINED, 20.0);
                if (mappedSect == null) {
                    System.err.println("WARNING: no matching fault section found for paleo site " + name + " at " + lat + ", " + lon);
                    continue;
                }
                int parentID = csv.getInt(row, 2);
                if (parentID != mappedSect.getParentSectionId()) {
                    System.err.println("WARNING: mapping mismatch for " + name + "? CSV parentID=" + parentID + ", csv parentName=" + csv.get(row, 1) + ", mapped parentID=" + mappedSect.getParentSectionId() + ", name=" + mappedSect.getParentSectionName());
                }
            }
            BoundedUncertainty uncert = new BoundedUncertainty(boundType, lowerRate, upperRate, stdDev);
            if (mappedSect == null) {
                ret.add(new UncertainDataConstraint.SectMappedUncertainDataConstraint(name, -1, null, loc, rate, uncert));
                continue;
            }
            ret.add(new UncertainDataConstraint.SectMappedUncertainDataConstraint(name, mappedSect.getSectionId(), mappedSect.getSectionName(), loc, rate, uncert));
        }
        return ret;
    }

    private static boolean hasMappedConstraints(List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> constraints) {
        for (UncertainDataConstraint.SectMappedUncertainDataConstraint sectMappedUncertainDataConstraint : constraints) {
            if (sectMappedUncertainDataConstraint.sectionIndex < 0) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws IOException {
        FaultSystemRupSet rupSet = FaultSystemRupSet.load(new File("/home/kevin/OpenSHA/nshm23/rup_sets/cache/rup_sets_NSHM18_WUS_PlusU3_FM_3p1_GEOL/rup_set_CoulombRupSet_4228_sects_13693_trace_locs_500367461464_area_2p7441094E19_moment.zip"));
        String prefix = "nshm18_paleo_mappings";
        String title = "NSHM23 Paleo Mappings to NSHM18 Sections";
        List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> datas = NSHM23_PaleoDataLoader.load(rupSet).getPaleoRateConstraints();
        Region reg = NSHM23_RegionLoader.loadFullConterminousWUS();
        List<? extends FaultSection> subSects = rupSet.getFaultSectionDataList();
        HashSet<FaultSection> mappedSects = new HashSet<FaultSection>();
        ArrayList<Location> siteLocs = new ArrayList<Location>();
        System.out.println("Loaded " + datas.size() + " values");
        for (UncertainDataConstraint.SectMappedUncertainDataConstraint sectMappedUncertainDataConstraint : datas) {
            System.out.println(sectMappedUncertainDataConstraint);
            if (sectMappedUncertainDataConstraint.sectionIndex < 0) continue;
            FaultSection sect = subSects.get(sectMappedUncertainDataConstraint.sectionIndex);
            double dist = sect.getFaultTrace().minDistToLine(sectMappedUncertainDataConstraint.dataLocation);
            System.out.println("\tMapped section: " + sect.getSectionName() + "\tdistance: " + (float)dist + " km");
            mappedSects.add(sect);
            siteLocs.add(sectMappedUncertainDataConstraint.dataLocation);
        }
        RupSetMapMaker mapMaker = new RupSetMapMaker(subSects, reg);
        mapMaker.setSectHighlights(mappedSects, new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLACK));
        mapMaker.plotScatters(siteLocs, Color.BLUE);
        mapMaker.setWriteGeoJSON(true);
        mapMaker.plot(new File("/tmp"), prefix, title);
        String string = "https://opensha.usc.edu/ftp/kmilner/nshm23/paleo_mappings/";
        System.out.println("GeoJSON.io URL: " + RupSetMapMaker.getGeoJSONViewerLink(string + prefix + ".geojson"));
    }
}

