/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.NSHM23_InvConfigFactory;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.NSHM23_RegionLoader;

public class NSHM23_GridFocalMechs {
    private static GriddedRegion u3Reg;

    public static double[] getFractStrikeSlip(NSHM23_RegionLoader.SeismicityRegions region, GriddedRegion gridRegion) throws IOException {
        double[] ret = NSHM23_GridFocalMechs.constant(gridRegion.getNodeCount(), Double.NaN);
        NSHM23_GridFocalMechs.mapConstant(gridRegion, ret, NSHM23_RegionLoader.FaultStyleRegions.WUS_COMPRESSIONAL.load(), 0.5);
        NSHM23_GridFocalMechs.mapConstant(gridRegion, ret, NSHM23_RegionLoader.FaultStyleRegions.WUS_EXTENSIONAL.load(), 0.5);
        NSHM23_GridFocalMechs.replaceNaNs(ret, 1.0);
        return ret;
    }

    public static double[] getFractReverse(NSHM23_RegionLoader.SeismicityRegions region, GriddedRegion gridRegion) throws IOException {
        double[] ret = NSHM23_GridFocalMechs.constant(gridRegion.getNodeCount(), Double.NaN);
        NSHM23_GridFocalMechs.mapConstant(gridRegion, ret, NSHM23_RegionLoader.FaultStyleRegions.WUS_COMPRESSIONAL.load(), 0.5);
        NSHM23_GridFocalMechs.replaceNaNs(ret, 0.0);
        return ret;
    }

    public static double[] getFractNormal(NSHM23_RegionLoader.SeismicityRegions region, GriddedRegion gridRegion) throws IOException {
        double[] ret = NSHM23_GridFocalMechs.constant(gridRegion.getNodeCount(), Double.NaN);
        NSHM23_GridFocalMechs.mapConstant(gridRegion, ret, NSHM23_RegionLoader.FaultStyleRegions.WUS_EXTENSIONAL.load(), 0.5);
        NSHM23_GridFocalMechs.replaceNaNs(ret, 0.0);
        return ret;
    }

    private static double[] constant(int length, double value) {
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = value;
        }
        return ret;
    }

    private static void replaceNaNs(double[] values, double value) {
        for (int i = 0; i < values.length; ++i) {
            if (!Double.isNaN(values[i])) continue;
            values[i] = value;
        }
    }

    private static void mapConstant(GriddedRegion gridReg, double[] values, Region reg, double value) {
        for (int i = 0; i < values.length; ++i) {
            Location loc = gridReg.locationForIndex(i);
            if (!reg.contains(loc)) continue;
            values[i] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mapU3(GriddedRegion gridReg, double[] values, double[] u3Vals) {
        Class<NSHM23_GridFocalMechs> clazz = NSHM23_GridFocalMechs.class;
        synchronized (NSHM23_GridFocalMechs.class) {
            if (u3Reg == null) {
                u3Reg = new CaliforniaRegions.RELM_TESTING_GRIDDED(gridReg.getSpacing());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            Preconditions.checkState((u3Reg.getNodeCount() == u3Vals.length ? 1 : 0) != 0);
            Preconditions.checkState((gridReg.getNodeCount() == values.length ? 1 : 0) != 0);
            double avgVal = 0.0;
            for (double val : u3Vals) {
                avgVal += val;
            }
            avgVal /= (double)u3Vals.length;
            for (int i = 0; i < values.length; ++i) {
                Location loc = gridReg.locationForIndex(i);
                int u3Ind = u3Reg.indexForLocation(loc);
                values[i] = u3Ind >= 0 ? u3Vals[u3Ind] : avgVal;
            }
            return;
        }
    }

    public static void main(String[] args) throws IOException {
        NSHM23_RegionLoader.SeismicityRegions reg = NSHM23_RegionLoader.SeismicityRegions.CONUS_WEST;
        GriddedRegion gridReg = NSHM23_InvConfigFactory.getGriddedSeisRegion(reg);
        double[] ss = NSHM23_GridFocalMechs.getFractStrikeSlip(reg, gridReg);
        double[] rev = NSHM23_GridFocalMechs.getFractReverse(reg, gridReg);
        double[] norm = NSHM23_GridFocalMechs.getFractNormal(reg, gridReg);
        for (int i = 0; i < gridReg.getNodeCount(); ++i) {
            double sum = ss[i] + rev[i] + norm[i];
            Preconditions.checkState(((float)sum == 1.0f ? 1 : 0) != 0, (String)"Bad sum: %s + %s + %s = %s; loc: %s", (Object)ss[i], (Object)rev[i], (Object)norm[i], (Object)gridReg.getLocation(i));
        }
        System.out.println("Validated");
    }
}

