/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.calc.nnls.NNLSWrapper;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.HardDistCutoffJumpProbCalc;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.RupturePlausibilityModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SegmentationModelBranchNode;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv")})
@Affects(value="rates.csv")
public enum MaxJumpDistModels implements LogicTreeNode,
SegmentationModelBranchNode
{
    THREE(3.0),
    FIVE(5.0),
    SEVEN(7.0),
    NINE(9.0),
    ELEVEN(11.0),
    THIRTEEN(13.0),
    FIFTEEN(15.0);

    public static double WEIGHT_TARGET_R0;
    private double weight;
    private final double maxDist;
    static final DecimalFormat oDF;

    private MaxJumpDistModels(double maxDist) {
        this.maxDist = maxDist;
        this.weight = -1.0;
    }

    public HardDistCutoffJumpProbCalc getModel(FaultSystemRupSet rupSet) {
        return new HardDistCutoffJumpProbCalc(this.getMaxDist());
    }

    @Override
    public String getShortName() {
        return "MaxDist" + oDF.format(this.maxDist) + "km";
    }

    @Override
    public String getName() {
        return "MaxDist=" + oDF.format(this.maxDist) + "km";
    }

    public double getMaxDist() {
        return this.maxDist;
    }

    public static void setWeights(double[] weights) {
        MaxJumpDistModels[] values = MaxJumpDistModels.values();
        Preconditions.checkState((weights.length == values.length ? 1 : 0) != 0);
        for (int i = 0; i < values.length; ++i) {
            values[i].weight = weights[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        if (fullBranch != null) {
            RupturePlausibilityModels model = fullBranch.getValue(RupturePlausibilityModels.class);
            if (this.maxDist > 5.0 && model == RupturePlausibilityModels.UCERF3) {
                return 0.0;
            }
        }
        if (this.weight < 0.0) {
            MaxJumpDistModels maxJumpDistModels = this;
            synchronized (maxJumpDistModels) {
                if (this.weight < 0.0) {
                    try {
                        MaxJumpDistModels.invertForWeights();
                    }
                    catch (IOException e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                }
            }
        }
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.getShortName();
    }

    public static double invertForWeights() throws IOException {
        MaxJumpDistModels[] values = MaxJumpDistModels.values();
        ArrayList<CSVFile<String>> dataCSVs = new ArrayList<CSVFile<String>>();
        for (MaxJumpDistModels value : values) {
            String name = "/data/erf/nshm23/constraints/segmentation/hard_cutoff_csvs/passthrough_rates_" + oDF.format(value.maxDist) + "km.csv";
            dataCSVs.add(CSVFile.readStream(MaxJumpDistModels.class.getResourceAsStream(name), true));
        }
        return MaxJumpDistModels.invertForWeights(values, dataCSVs, WEIGHT_TARGET_R0);
    }

    public static double invertForWeights(MaxJumpDistModels[] values, List<CSVFile<String>> dataCSVs, double target_ro) {
        int i;
        Preconditions.checkState((values.length == dataCSVs.size() ? 1 : 0) != 0);
        int numCols = values.length + 1;
        int numRows = dataCSVs.get(0).getNumRows();
        double[] d = new double[numRows];
        d[d.length - 1] = 1.0;
        double[][] C = new double[numRows][numCols];
        for (int col = 0; col < values.length; ++col) {
            CSVFile<String> csv = dataCSVs.get(col);
            for (int row = 0; row < numRows - 1; ++row) {
                C[row][col] = csv.getDouble(row + 1, 1);
            }
            C[numRows - 1][col] = 1.0;
        }
        for (int row = 0; row < numRows - 1; ++row) {
            double r = dataCSVs.get(0).getDouble(row + 1, 0);
            C[row][numCols - 1] = -Math.exp(-r / target_ro);
        }
        C[numRows - 1][numCols - 1] = 0.0;
        NNLSWrapper nnls = new NNLSWrapper();
        int nRow = C.length;
        int nCol = C[0].length;
        double[] A = new double[nRow * nCol];
        double[] x = new double[nCol];
        int k = 0;
        for (int j = 0; j < nCol; ++j) {
            for (i = 0; i < nRow; ++i) {
                A[k] = C[i][j];
                ++k;
            }
        }
        nnls.update(A, nRow, nCol);
        boolean converged = nnls.solve(d, x);
        if (!converged) {
            throw new RuntimeException("ERROR:  NNLS Inversion Failed");
        }
        for (i = 0; i < values.length; ++i) {
            values[i].weight = x[i];
        }
        return x[values.length];
    }

    public static void main(String[] args) throws IOException {
        double a = MaxJumpDistModels.invertForWeights();
        System.out.println("a: " + a);
        for (MaxJumpDistModels model : MaxJumpDistModels.values()) {
            System.out.println(model.getName() + ", weight=" + (float)model.getNodeWeight(null));
        }
    }

    @Override
    public HardDistCutoffJumpProbCalc getModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        return this.getModel(rupSet);
    }

    @Override
    public HardDistCutoffJumpProbCalc getExclusionModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        return this.getModel(rupSet, (LogicTreeBranch)branch);
    }

    static {
        WEIGHT_TARGET_R0 = 3.0;
        oDF = new DecimalFormat("0.#");
    }
}

