/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertainBoundedDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertainBoundedIncrMagFreqDist;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.geo.Region;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.RupSetDeformationModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetFaultModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetSubsectioningModel;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModelRegion;
import org.opensha.sha.earthquake.faultSysSolution.modules.NamedFaults;
import org.opensha.sha.earthquake.faultSysSolution.modules.RegionsOfInterest;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupSetTectonicRegimes;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.GeoJSONFaultReader;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSectionUtils;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.SubSectionBuilder;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_DeclusteringAlgorithms;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_DeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_RegionalSeismicity;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SeisSmoothingAlgorithms;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SingleStates;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.NSHM23_RegionLoader;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.TectonicRegionType;

@Affects.Affected(value={@Affects(value="fault_sections.geojson"), @Affects(value="indices.csv"), @Affects(value="properties.csv"), @Affects(value="rates.csv")})
public enum NSHM23_FaultModels implements LogicTreeNode,
RupSetFaultModel,
RupSetSubsectioningModel
{
    WUS_FM_v1p4("NSHM23 WUS Fault Model v1.4", "WUS FM v1.4", NSHM23_DeformationModels.GEOLOGIC, 0.0){

        @Override
        protected List<? extends FaultSection> loadFaultSections() throws IOException {
            String sectPath = "/data/erf/nshm23/fault_models/v1p4/NSHM23_FaultSections_v1p4.geojson";
            BufferedReader sectsReader = new BufferedReader(new InputStreamReader(GeoJSONFaultReader.class.getResourceAsStream(sectPath)));
            Preconditions.checkNotNull((Object)sectsReader, (String)"Fault model file not found: %s", (Object)sectPath);
            return GeoJSONFaultReader.readFaultSections(sectsReader);
        }

        @Override
        protected String getNamedFaultResourceName() {
            return null;
        }
    }
    ,
    WUS_FM_v2("NSHM23 WUS Fault Model v2", "WUS FM v2", NSHM23_DeformationModels.GEOLOGIC, 0.0){

        @Override
        protected List<? extends FaultSection> loadFaultSections() throws IOException {
            String sectPath = "/data/erf/nshm23/fault_models/v2/NSHM23_FSD_v2.geojson";
            BufferedReader sectsReader = new BufferedReader(new InputStreamReader(GeoJSONFaultReader.class.getResourceAsStream(sectPath)));
            Preconditions.checkNotNull((Object)sectsReader, (String)"Fault model file not found: %s", (Object)sectPath);
            return GeoJSONFaultReader.readFaultSections(sectsReader);
        }

        @Override
        protected String getNamedFaultResourceName() {
            return "/data/erf/nshm23/fault_models/v2/special_faults.json";
        }
    }
    ,
    WUS_FM_v3("NSHM23 WUS Fault Model v3", "WUS FM v3", NSHM23_DeformationModels.GEOLOGIC, 1.0){

        @Override
        protected List<? extends FaultSection> loadFaultSections() throws IOException {
            String sectPath = "/data/erf/nshm23/fault_models/v3/NSHM23_FSD_v3.geojson";
            BufferedReader sectsReader = new BufferedReader(new InputStreamReader(GeoJSONFaultReader.class.getResourceAsStream(sectPath)));
            Preconditions.checkNotNull((Object)sectsReader, (String)"Fault model file not found: %s", (Object)sectPath);
            return GeoJSONFaultReader.readFaultSections(sectsReader);
        }

        @Override
        protected String getNamedFaultResourceName() {
            return "/data/erf/nshm23/fault_models/v3/special_faults.json";
        }
    };

    private static final ConcurrentMap<NSHM23_FaultModels, List<? extends FaultSection>> sectsCache;
    public static final String NSHM23_SECTS_PATH_PREFIX = "/data/erf/nshm23/fault_models/";
    private String name;
    private String shortName;
    private RupSetDeformationModel defaultDM;
    private double weight;
    static final double DOWN_DIP_FRACT_DEFAULT = 0.5;
    static final double MAX_LEN_DEFAULT = Double.NaN;
    static final int MIN_SUB_SECTS_PER_FAULT_DEFAULT = 2;
    private static final DecimalFormat oDF;

    private NSHM23_FaultModels(String name, String shortName, RupSetDeformationModel defaultDM, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.defaultDM = defaultDM;
        this.weight = weight;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<? extends FaultSection> getFaultSections() throws IOException {
        List<? extends FaultSection> sects = (List<? extends FaultSection>)sectsCache.get(this);
        if (sects == null) {
            ConcurrentMap<NSHM23_FaultModels, List<? extends FaultSection>> concurrentMap = sectsCache;
            synchronized (concurrentMap) {
                sects = (List)sectsCache.get(this);
                if (sects == null) {
                    sects = this.loadFaultSections();
                    sectsCache.put(this, sects);
                }
            }
        }
        ArrayList<FaultSection> copy = new ArrayList<FaultSection>();
        for (FaultSection faultSection : sects) {
            copy.add(faultSection.clone());
        }
        return copy;
    }

    protected abstract List<? extends FaultSection> loadFaultSections() throws IOException;

    protected abstract String getNamedFaultResourceName();

    @Override
    public RupSetDeformationModel getDefaultDeformationModel() {
        return this.defaultDM;
    }

    public static ModelRegion getDefaultRegion(LogicTreeBranch<?> branch) throws IOException {
        if (branch != null && branch.hasValue(NSHM23_SingleStates.class)) {
            NSHM23_SingleStates state = branch.getValue(NSHM23_SingleStates.class);
            if (state == null) {
                return new ModelRegion(NSHM23_RegionLoader.loadFullConterminousWUS());
            }
            return new ModelRegion(state.loadRegion());
        }
        return new ModelRegion(NSHM23_RegionLoader.loadFullConterminousWUS());
    }

    @Override
    public void attachDefaultModules(final FaultSystemRupSet rupSet) {
        final LogicTreeBranch branch = rupSet.getModule(LogicTreeBranch.class);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<ModelRegion>(){
            final /* synthetic */ NSHM23_FaultModels this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ModelRegion call() throws Exception {
                return NSHM23_FaultModels.getDefaultRegion(branch);
            }
        }, ModelRegion.class);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<NamedFaults>(){
            final /* synthetic */ NSHM23_FaultModels this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public NamedFaults call() throws Exception {
                NamedFaults named = this.this$0.getNamedFaults();
                named.setParent(rupSet);
                return named;
            }
        }, NamedFaults.class);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<RegionsOfInterest>(){
            final /* synthetic */ NSHM23_FaultModels this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public RegionsOfInterest call() throws Exception {
                ArrayList<Region> regions = new ArrayList<Region>();
                ArrayList<IncrementalMagFreqDist> regionMFDs = new ArrayList<IncrementalMagFreqDist>();
                List<? extends FaultSection> subSects = rupSet.getFaultSectionDataList();
                for (NSHM23_RegionLoader.SeismicityRegions seisReg : NSHM23_RegionLoader.SeismicityRegions.values()) {
                    Region region = seisReg.load();
                    if (!FaultSectionUtils.anySectInRegion(region, subSects, true)) continue;
                    regionMFDs.add(NSHM23_FaultModels.getRegionalMFD(region, seisReg, branch));
                    regions.add(region);
                }
                for (Region region : NSHM23_RegionLoader.loadAnalysisRegions(subSects)) {
                    if (!FaultSectionUtils.anySectInRegion(region, subSects, true)) continue;
                    regionMFDs.add(NSHM23_FaultModels.getRegionalMFD(region, null, branch));
                    regions.add(region);
                }
                for (Region region : NSHM23_RegionLoader.loadLocalRegions(subSects)) {
                    if (!FaultSectionUtils.anySectInRegion(region, subSects, true)) continue;
                    regionMFDs.add(NSHM23_FaultModels.getRegionalMFD(region, null, branch));
                    regions.add(region);
                }
                for (int i = 0; i < regions.size(); ++i) {
                    String regName = ((Region)regions.get(i)).getName();
                    System.out.println(regName);
                    IncrementalMagFreqDist mfd = (IncrementalMagFreqDist)regionMFDs.get(i);
                    if (mfd == null) continue;
                    System.out.println("\t" + mfd.getName());
                    if (!(mfd instanceof UncertainBoundedDiscretizedFunc)) continue;
                    System.out.println("\t" + ((UncertainBoundedDiscretizedFunc)((Object)mfd)).getBoundName());
                }
                return new RegionsOfInterest(regions, regionMFDs);
            }
        }, RegionsOfInterest.class);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<RupSetTectonicRegimes>(){
            final /* synthetic */ NSHM23_FaultModels this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public RupSetTectonicRegimes call() throws Exception {
                Region stableReg = NSHM23_RegionLoader.GridSystemRegions.CEUS_STABLE.load();
                Map<Region, TectonicRegionType> regRegimes = Map.of(stableReg, TectonicRegionType.STABLE_SHALLOW);
                return RupSetTectonicRegimes.forRegions(rupSet, regRegimes, TectonicRegionType.ACTIVE_SHALLOW, 0.5);
            }
        }, RupSetTectonicRegimes.class);
    }

    @Override
    public NamedFaults getNamedFaults() {
        String resourceName = this.getNamedFaultResourceName();
        if (resourceName == null) {
            return null;
        }
        Gson gson = new GsonBuilder().create();
        BufferedReader reader = new BufferedReader(new InputStreamReader(NSHM23_FaultModels.class.getResourceAsStream(resourceName)));
        Type type = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, TypeToken.getParameterized(List.class, (Type[])new Type[]{Integer.class}).getType()}).getType();
        Map namedFaults = (Map)gson.fromJson((Reader)reader, type);
        Preconditions.checkState((!namedFaults.isEmpty() ? 1 : 0) != 0, (Object)"No named faults found");
        return new NamedFaults(null, namedFaults);
    }

    @Override
    public List<? extends FaultSection> buildSubSects(RupSetFaultModel faultModel, List<? extends FaultSection> fullSections) {
        return SubSectionBuilder.buildSubSects(fullSections, 2, 0.5, Double.NaN);
    }

    private static UncertainBoundedIncrMagFreqDist getRegionalMFD(Region region, NSHM23_RegionLoader.SeismicityRegions seisRegion, LogicTreeBranch<?> branch) throws IOException {
        NSHM23_DeclusteringAlgorithms declustering = NSHM23_DeclusteringAlgorithms.AVERAGE;
        if (branch != null && branch.hasValue(NSHM23_DeclusteringAlgorithms.class)) {
            declustering = branch.requireValue(NSHM23_DeclusteringAlgorithms.class);
        }
        NSHM23_SeisSmoothingAlgorithms smooth = NSHM23_SeisSmoothingAlgorithms.AVERAGE;
        if (branch != null && branch.hasValue(NSHM23_SeisSmoothingAlgorithms.class)) {
            smooth = branch.requireValue(NSHM23_SeisSmoothingAlgorithms.class);
        }
        double mMax = 8.99;
        IncrementalMagFreqDist refMFD = FaultSysTools.initEmptyMFD(mMax);
        if (seisRegion == null) {
            return NSHM23_RegionalSeismicity.getRemapped(region, declustering, smooth, refMFD, mMax);
        }
        return NSHM23_RegionalSeismicity.getBounded(seisRegion, refMFD, mMax);
    }

    private static UncertainBoundedIncrMagFreqDist getUncertGR(EvenlyDiscretizedFunc refMFD, double b, double prefRate, double lowerRate, double upperRate, UncertaintyBoundType type) {
        GutenbergRichterMagFreqDist prefGR = new GutenbergRichterMagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
        GutenbergRichterMagFreqDist lowGR = new GutenbergRichterMagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
        GutenbergRichterMagFreqDist highGR = new GutenbergRichterMagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
        double roundedMinMag = refMFD.getX(0);
        double roundedMaxMag = refMFD.getX(refMFD.size() - 1);
        prefGR.setAllButTotMoRate(roundedMinMag, roundedMaxMag, prefRate, b);
        lowGR.setAllButTotMoRate(roundedMinMag, roundedMaxMag, lowerRate, b);
        highGR.setAllButTotMoRate(roundedMinMag, roundedMaxMag, upperRate, b);
        UncertainBoundedIncrMagFreqDist ret = new UncertainBoundedIncrMagFreqDist(prefGR, lowGR, highGR, type);
        ret.setName("Total Observed [b=" + oDF.format(b) + ", N5=" + oDF.format(prefRate) + "]");
        return ret;
    }

    static {
        sectsCache = new ConcurrentHashMap<NSHM23_FaultModels, List<? extends FaultSection>>();
        oDF = new DecimalFormat("0.##");
    }
}

