/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import com.google.common.base.Preconditions;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;

public interface SectionSupraSeisBValues
extends LogicTreeNode {
    public double[] getSectBValues(FaultSystemRupSet var1);

    public double getB();

    public static double momentWeightedAverage(FaultSystemRupSet rupSet, double[] sectSpecificBValues) {
        double sumMoment = 0.0;
        double sumProduct = 0.0;
        Preconditions.checkState((sectSpecificBValues.length == rupSet.getNumSections() ? 1 : 0) != 0);
        for (int s = 0; s < sectSpecificBValues.length; ++s) {
            double moment = FaultMomentCalc.getMoment(rupSet.getAreaForSection(s), rupSet.getSlipRateForSection(s));
            sumMoment += moment;
            sumProduct += moment * sectSpecificBValues[s];
        }
        if (sumMoment == 0.0) {
            return StatUtils.mean((double[])sectSpecificBValues);
        }
        return sumProduct / sumMoment;
    }

    public static interface Constant
    extends SectionSupraSeisBValues {
        @Override
        default public double[] getSectBValues(FaultSystemRupSet rupSet) {
            return null;
        }
    }
}

