/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SectionSupraSeisBValues;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv")})
@Affects(value="rates.csv")
public enum SupraSeisBValues implements LogicTreeNode,
SectionSupraSeisBValues.Constant
{
    B_0p0(0.0, 0.2),
    B_0p25(0.25, 0.2),
    B_0p5(0.5, 0.2),
    B_0p75(0.75, 0.2),
    B_1p0(1.0, 0.2),
    AVERAGE(0.5, 0.0){

        @Override
        public String getShortName() {
            return "bAvg=" + (float)this.bValue;
        }

        @Override
        public String getName() {
            return super.getName() + " (Averaged)";
        }

        @Override
        public String getFilePrefix() {
            return "AvgSupraB";
        }
    };

    public final double bValue;
    public final double weight;

    private SupraSeisBValues(double bValue, double weight) {
        this.bValue = bValue;
        this.weight = weight;
    }

    @Override
    public String getShortName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return "b=" + (float)this.bValue;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return "SupraB" + (float)this.bValue;
    }

    @Override
    public double getB() {
        return this.bValue;
    }

    public static void main(String[] args) {
        double totWeight = 0.0;
        double avg = 0.0;
        for (SupraSeisBValues b : SupraSeisBValues.values()) {
            avg += b.weight * b.bValue;
            totWeight += b.weight;
        }
        System.out.println("weight average b: " + (float)(avg /= totWeight));
        System.out.println("tot weight: " + (float)totWeight);
    }
}

