/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.random;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.opensha.commons.calc.WeightedSampler;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.random.BranchDependentSampler;

abstract class AbstractSamplingNode<E extends BranchDependentSampler<E>>
implements LogicTreeNode.RandomlySampledNode {
    private String name;
    private String shortName;
    private String prefix;
    private double weight;
    private long seed;

    protected AbstractSamplingNode() {
    }

    protected AbstractSamplingNode(String name, String shortName, String prefix, double weight, long seed) {
        this.init(name, shortName, prefix, weight, seed);
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.prefix;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public void init(String name, String shortName, String prefix, double weight, long seed) {
        this.name = name;
        this.shortName = shortName;
        this.prefix = prefix;
        this.weight = weight;
        this.seed = seed;
    }

    public abstract E buildSampler(FaultSystemRupSet var1, LogicTreeBranch<?> var2, long var3);

    static <E extends LogicTreeNode> WeightedSampler<E> weightedNodeValueSampler(Random rand, List<E> nodes) {
        ArrayList<LogicTreeNode> filteredNodes = new ArrayList<LogicTreeNode>();
        ArrayList<Double> weights = new ArrayList<Double>();
        for (LogicTreeNode node : nodes) {
            double weight = node.getNodeWeight(null);
            if (!(weight > 0.0)) continue;
            filteredNodes.add(node);
            weights.add(node.getNodeWeight(null));
        }
        return new WeightedSampler(filteredNodes, weights, rand);
    }

    static <E extends Enum<E>> WeightedSampler<E> weightedNodeValueSampler(Random rand, Class<E> enumClass) {
        ArrayList<Enum> nodes = new ArrayList<Enum>();
        ArrayList<Double> weights = new ArrayList<Double>();
        for (Enum node : (Enum[])enumClass.getEnumConstants()) {
            double weight = ((LogicTreeNode)((Object)node)).getNodeWeight(null);
            if (!(weight > 0.0)) continue;
            nodes.add(node);
            weights.add(((LogicTreeNode)((Object)node)).getNodeWeight(null));
        }
        return new WeightedSampler(nodes, weights, rand);
    }
}

