/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.prior2018;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.Range;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.RupSetDeformationModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetFaultModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetSubsectioningModel;
import org.opensha.sha.earthquake.faultSysSolution.util.SubSectionBuilder;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_DeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.prior2018.NSHM18_FaultModels;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;

@Affects.Affected(value={@Affects(value="fault_sections.geojson"), @Affects(value="properties.csv"), @Affects(value="rates.csv")})
@DoesNotAffect(value="indices.csv")
public enum NSHM18_DeformationModels implements RupSetDeformationModel,
RupSetSubsectioningModel
{
    GEOL("Geologic", "GEO", 0.8),
    BIRD("Bird", "BIRD", 0.1),
    ZENG("Zeng", "ZENG", 0.1),
    BRANCH_AVERAGED("Branch Averaged", "BrAvg", 0.0);

    public static boolean APPLY_ACTIVITY_PROBABILITY;
    static final String NSHM18_DM_PATH = "/data/erf/nshm18/def_models/deformation-model-data.json";
    static final String ACTIVITY_PROB_PATH = "/data/erf/nshm18/special_cases/activity-probability.json";
    private String name;
    private String shortName;
    private double weight;
    private Map<Integer, ActivityProbRecord> activityProbabilities;

    private NSHM18_DeformationModels(String name, String shortName, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.weight = weight;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.name();
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isApplicableTo(RupSetFaultModel faultModel) {
        if (!(faultModel instanceof NSHM18_FaultModels)) {
            return false;
        }
        if (faultModel != NSHM18_FaultModels.NSHM18_WUS_NoCA) {
            return this == BRANCH_AVERAGED || this == GEOL;
        }
        return true;
    }

    @Override
    public List<? extends FaultSection> build(RupSetFaultModel faultModel, RupSetSubsectioningModel subSectionModel, LogicTreeBranch<? extends LogicTreeNode> branch) throws IOException {
        List<FaultSection> fullList;
        Preconditions.checkState((boolean)this.isApplicableTo(faultModel), (String)"%s is not applicable to %s", (Object)this.name, (Object)faultModel.getName());
        Preconditions.checkState((subSectionModel == null || subSectionModel == this ? 1 : 0) != 0, (Object)"NSHM18/UCERF3 DMs build their own subsections");
        List<? extends FaultSection> sectsOutsideCA = this.buildFullSects(NSHM18_FaultModels.NSHM18_WUS_NoCA);
        List<FaultSection> subsectsOutsideCA = SubSectionBuilder.buildSubSects(sectsOutsideCA);
        if (faultModel == NSHM18_FaultModels.NSHM18_WUS_PlusU3_FM_3p1) {
            List<? extends FaultSection> u3SubSects;
            if (this == BRANCH_AVERAGED) {
                u3SubSects = DeformationModels.MEAN_UCERF3.build(FaultModels.FM3_1, null, null);
            } else if (this == GEOL) {
                u3SubSects = DeformationModels.GEOLOGIC.build(FaultModels.FM3_1, null, null);
            } else {
                throw new IllegalStateException("Can only build stitched NSHM18 w/ U3 DM for geologic or branch averaged");
            }
            fullList = new ArrayList<FaultSection>(subsectsOutsideCA);
            for (FaultSection faultSection : u3SubSects) {
                if (faultSection.getParentSectionId() == 721 || faultSection.getParentSectionId() == 719) continue;
                int newID = fullList.size();
                FaultSection faultSection2 = faultSection.clone();
                faultSection2.setSectionId(newID);
                fullList.add(faultSection2);
            }
        } else {
            Preconditions.checkState((faultModel == NSHM18_FaultModels.NSHM18_WUS_NoCA ? 1 : 0) != 0);
            fullList = subsectsOutsideCA;
        }
        NSHM23_DeformationModels.applyStdDevDefaults(fullList);
        return fullList;
    }

    @Override
    public List<? extends FaultSection> apply(RupSetFaultModel faultModel, LogicTreeBranch<? extends LogicTreeNode> branch, List<? extends FaultSection> subSects) throws IOException {
        throw new UnsupportedOperationException("Not supported, NSHM18/UCERF3 must build the subsections");
    }

    @Override
    public List<? extends FaultSection> apply(RupSetFaultModel faultModel, LogicTreeBranch<? extends LogicTreeNode> branch, List<? extends FaultSection> fullSects, List<? extends FaultSection> subSects) throws IOException {
        throw new UnsupportedOperationException("Not supported, NSHM18/UCERF3 must build the subsections");
    }

    @Override
    public List<? extends FaultSection> buildSubSects(RupSetFaultModel faultModel, List<? extends FaultSection> fullSections) {
        try {
            return this.build(faultModel, this, null);
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    private synchronized Map<Integer, ActivityProbRecord> getActivityProbabilities() {
        if (this.activityProbabilities != null) {
            return this.activityProbabilities;
        }
        HashMap<Integer, ActivityProbRecord> activityProbabilities = new HashMap<Integer, ActivityProbRecord>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(NSHM18_DeformationModels.class.getResourceAsStream(ACTIVITY_PROB_PATH)));
        Preconditions.checkNotNull((Object)reader, (String)"Activity probability file not found: %s", (Object)NSHM18_DM_PATH);
        Gson gson = new GsonBuilder().create();
        List recs = (List)gson.fromJson((Reader)reader, TypeToken.getParameterized(List.class, (Type[])new Type[]{ActivityProbRecord.class}).getType());
        for (ActivityProbRecord rec : recs) {
            activityProbabilities.put(rec.id, rec);
        }
        this.activityProbabilities = activityProbabilities;
        return activityProbabilities;
    }

    public List<? extends FaultSection> buildFullSects(RupSetFaultModel faultModel) throws IOException {
        Preconditions.checkState((boolean)this.isApplicableTo(faultModel), (Object)"DM/FM mismatch");
        BufferedReader dmReader = new BufferedReader(new InputStreamReader(NSHM18_DeformationModels.class.getResourceAsStream(NSHM18_DM_PATH)));
        Preconditions.checkNotNull((Object)dmReader, (String)"Deformation model file not found: %s", (Object)NSHM18_DM_PATH);
        Gson gson = new GsonBuilder().create();
        List records = (List)gson.fromJson((Reader)dmReader, TypeToken.getParameterized(List.class, (Type[])new Type[]{DefModelRecord.class}).getType());
        System.out.println("Loaded " + records.size() + " deformation model records");
        HashMap<Integer, DefModelRecord> recordMap = new HashMap<Integer, DefModelRecord>();
        for (DefModelRecord record : records) {
            recordMap.put(record.id, record);
        }
        Preconditions.checkState((recordMap.size() == records.size() ? 1 : 0) != 0);
        Map<Integer, ActivityProbRecord> activityProbabilities = APPLY_ACTIVITY_PROBABILITY ? this.getActivityProbabilities() : null;
        List<? extends FaultSection> origSects = faultModel.getFaultSections();
        ArrayList<GeoJSONFaultSection> modSects = new ArrayList<GeoJSONFaultSection>();
        int numNonZero = 0;
        for (FaultSection faultSection : origSects) {
            double slipRate;
            boolean slipIsVertical;
            GeoJSONFaultSection modSect = new GeoJSONFaultSection(faultSection);
            DefModelRecord rec = (DefModelRecord)recordMap.get(faultSection.getSectionId());
            if (rec == null) {
                System.err.println("WARNING: no matching deformation model record for id=" + faultSection.getSectionId() + ", name=" + faultSection.getSectionName());
                continue;
            }
            DefModelSlipRecord slipRec = rec.rates.get(this.shortName);
            double rake = faultSection.getAveRake();
            Preconditions.checkState(((float)rake == -180.0f || (float)rake == -90.0f || (float)rake == 0.0f || (float)rake == 90.0f || (float)rake == 180.0f ? 1 : 0) != 0, (String)"Unexpected geologic rake: %s", (Object)rake);
            boolean bl = slipIsVertical = (float)rake == -90.0f || (float)rake == 90.0f;
            if (slipRec == null || slipRec.slip_rate == null) {
                if (rec.name.startsWith("Seattle")) {
                    if (rec.name.contains("east") || rec.name.contains("middle")) {
                        slipRate = 0.08;
                    } else if (rec.name.contains("north") || rec.name.contains("south")) {
                        slipRate = 0.17;
                    } else {
                        throw new IllegalStateException("Unexpected Seattle: " + rec.name);
                    }
                    System.err.println("WARNING: applying hardcoded NSHM23 draft slip rate for " + rec.name + ": " + (float)slipRate);
                    slipIsVertical = false;
                } else {
                    double sumOtherWeights = 0.0;
                    double rateWeightSum = 0.0;
                    for (NSHM18_DeformationModels dm : NSHM18_DeformationModels.values()) {
                        DefModelSlipRecord oSlipRec = rec.rates.get(dm.shortName);
                        if (oSlipRec == null || oSlipRec.slip_rate == null || !(oSlipRec.slip_rate > 0.0)) continue;
                        sumOtherWeights += dm.weight;
                        rateWeightSum += oSlipRec.slip_rate * dm.weight;
                    }
                    if (sumOtherWeights > 0.0) {
                        rateWeightSum /= sumOtherWeights;
                    }
                    if (this != BRANCH_AVERAGED) {
                        System.err.println("WARNING: no " + this.shortName + " slip rate for id=" + faultSection.getSectionId() + ", name=" + faultSection.getSectionName() + ", setting to weight average of other branch choices: " + (float)rateWeightSum);
                    }
                    slipRate = rateWeightSum;
                }
            } else {
                slipRate = slipRec.slip_rate;
            }
            Preconditions.checkState((boolean)Double.isFinite(slipRate), (String)"Bad slip rate for section %s. %s: %s", (Object)faultSection.getSectionId(), (Object)faultSection.getSectionName(), (Object)slipRate);
            if (slipIsVertical) {
                double origSlipRate = slipRate;
                Preconditions.checkState((boolean)Double.isFinite(slipRate /= Math.sin(Math.toRadians(faultSection.getAveDip()))), (String)"Bad slip rate after on-plane conversion for section %s. %s: %s. Vertical slip: %s", (Object)faultSection.getSectionId(), (Object)faultSection.getSectionName(), (Object)slipRate, (Object)origSlipRate);
            }
            if (activityProbabilities != null && activityProbabilities.containsKey(faultSection.getSectionId())) {
                ActivityProbRecord probs = activityProbabilities.get(faultSection.getSectionId());
                System.out.println("Applying activity probability of " + probs.probability + " for fault " + probs.id + ", name " + faultSection.getSectionName());
                slipRate *= probs.probability.doubleValue();
            }
            modSect.setAveSlipRate(slipRate);
            if (modSect.getOrigAveSlipRate() > 0.0) {
                ++numNonZero;
                modSect.setSlipRateStdDev(Math.max(1.0E-4, 0.5 * modSect.getOrigAveSlipRate()));
            } else {
                modSect.setSlipRateStdDev(1.0E-4);
            }
            modSects.add(modSect);
        }
        System.out.println("Built " + modSects.size() + " sections (of " + origSects.size() + " original), " + numNonZero + " have slip rates > 0");
        return modSects;
    }

    private static void plotML_Comparison(NSHM18_FaultModels fm, MagLengthRelationship ml) throws IOException {
        Map<Integer, FaultSection> sects = fm.getFaultSectionIDMap();
        BufferedReader dmReader = new BufferedReader(new InputStreamReader(NSHM18_DeformationModels.class.getResourceAsStream(NSHM18_DM_PATH)));
        Preconditions.checkNotNull((Object)dmReader, (String)"Deformation model file not found: %s", (Object)NSHM18_DM_PATH);
        Gson gson = new GsonBuilder().create();
        List records = (List)gson.fromJson((Reader)dmReader, TypeToken.getParameterized(List.class, (Type[])new Type[]{DefModelRecord.class}).getType());
        System.out.println("Loaded " + records.size() + " deformation model records");
        DefaultXY_DataSet scatter = new DefaultXY_DataSet();
        for (DefModelRecord record : records) {
            FaultSection sect = sects.get(record.id);
            if (!NSHM18_FaultModels.STATES.contains(record.state)) continue;
            if (sect == null) {
                System.err.println("WARNING: no matching sect for record " + record.id + ", " + record.name + " (" + record.state + ")");
                continue;
            }
            if (record.length == null || record.magnitude == null) continue;
            double calcMag = ml.getMedianMag(record.length);
            if (Math.abs(calcMag - record.magnitude) > 0.05 && record.magnitude < 7.49) {
                System.out.println(record.id + ". " + record.name);
                System.out.println("\tJSON length=" + record.length.floatValue() + "\tmag=" + record.magnitude.floatValue());
                System.out.println("\tCalc mag w/ JSON length: " + (float)ml.getMedianMag(record.length));
                System.out.println("\tCalc mag w/ our length (" + (float)sect.getFaultTrace().getTraceLength() + "): " + (float)ml.getMedianMag(sect.getFaultTrace().getTraceLength()));
            }
            scatter.set(record.magnitude, calcMag);
        }
        ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        Range range = new Range(5.0, 9.0);
        DefaultXY_DataSet line = new DefaultXY_DataSet();
        line.set(range.getLowerBound(), range.getLowerBound());
        line.set(range.getUpperBound(), range.getUpperBound());
        funcs.add(line);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
        funcs.add(scatter);
        chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 2.0f, Color.BLACK));
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        PlotSpec spec = new PlotSpec(funcs, chars, "M-L comparison", "Deformation Model JSON Characteristic Magnitude", ml.getName());
        gp.drawGraphPanel(spec, false, false, range, range);
        PlotUtils.writePlots(new File("/tmp"), "ml_scatter", (GraphPanel)gp, 800, false, true, false, false);
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Building GEOLOGIC");
        GEOL.build(NSHM18_FaultModels.NSHM18_WUS_NoCA, null, null);
        System.out.println("Building ZENG");
        ZENG.build(NSHM18_FaultModels.NSHM18_WUS_NoCA, null, null);
        System.out.println("Building BIRD");
        BIRD.build(NSHM18_FaultModels.NSHM18_WUS_NoCA, null, null);
        System.out.println("Building BA");
        BRANCH_AVERAGED.build(NSHM18_FaultModels.NSHM18_WUS_NoCA, null, null);
    }

    static {
        APPLY_ACTIVITY_PROBABILITY = true;
    }

    static class ActivityProbRecord {
        int id;
        String name;
        String state;
        Double probability;

        ActivityProbRecord() {
        }
    }

    static class DefModelRecord {
        int id;
        String name;
        String state;
        Double length;
        Double magnitude;
        Map<String, DefModelSlipRecord> rates;

        DefModelRecord() {
        }
    }

    @JsonAdapter(value=SlipRecordAdapter.class)
    static class DefModelSlipRecord {
        Double slip_rate;
        Double rake;
        Double gr_a_value;
        Double single_rate;

        DefModelSlipRecord() {
        }
    }

    private static class SlipRecordAdapter
    extends TypeAdapter<DefModelSlipRecord> {
        private SlipRecordAdapter() {
        }

        public void write(JsonWriter out, DefModelSlipRecord value) throws IOException {
            throw new UnsupportedOperationException();
        }

        public DefModelSlipRecord read(JsonReader in) throws IOException {
            in.beginObject();
            DefModelSlipRecord rec = new DefModelSlipRecord();
            block12: while (in.hasNext()) {
                String name = in.nextName();
                if (in.peek() == JsonToken.NULL) {
                    in.skipValue();
                    continue;
                }
                switch (name) {
                    case "slip-rate": {
                        rec.slip_rate = in.nextDouble();
                        continue block12;
                    }
                    case "rake": {
                        rec.rake = in.nextDouble();
                        continue block12;
                    }
                    case "gr-a-value": {
                        rec.gr_a_value = in.nextDouble();
                        continue block12;
                    }
                    case "single-rate": {
                        rec.single_rate = in.nextDouble();
                        continue block12;
                    }
                }
                System.err.println("Skipping unexpected key: " + name);
                in.skipValue();
            }
            in.endObject();
            return rec;
        }
    }
}

