/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.uncertainty.BoundedUncertainty;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoSlipProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.PaleoseismicConstraintData;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_PaleoUncertainties;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.SectNucleationMFD_Estimator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public abstract class PaleoSectNuclEstimator
extends SectNucleationMFD_Estimator {
    protected FaultSystemRupSet rupSet;
    private UncertainDataConstraint.SectMappedUncertainDataConstraint paleoConstraint;
    private boolean applyToParent;
    private int parentID = -1;

    public PaleoSectNuclEstimator(FaultSystemRupSet rupSet, UncertainDataConstraint.SectMappedUncertainDataConstraint paleoConstraint, boolean applyToParent) {
        this.rupSet = rupSet;
        this.paleoConstraint = paleoConstraint;
        this.applyToParent = applyToParent;
        if (applyToParent) {
            this.parentID = rupSet.getFaultSectionData(paleoConstraint.sectionIndex).getParentSectionId();
        }
    }

    @Override
    public boolean appliesTo(FaultSection sect) {
        if (this.applyToParent) {
            return sect.getParentSectionId() == this.parentID;
        }
        return sect.getSectionId() == this.paleoConstraint.sectionIndex;
    }

    @Override
    public IncrementalMagFreqDist estimateNuclMFD(FaultSection sect, IncrementalMagFreqDist curSectSupraSeisMFD, List<Integer> availableRupIndexes, List<Double> availableRupMags, UncertainDataConstraint sectMomentRate, boolean sparseGR) {
        Preconditions.checkState((boolean)this.appliesTo(sect));
        Preconditions.checkState((!availableRupIndexes.isEmpty() ? 1 : 0) != 0);
        ArrayList<Double> probObvs = new ArrayList<Double>();
        int[] rupsPerBin = new int[curSectSupraSeisMFD.size()];
        for (int r = 0; r < availableRupIndexes.size(); ++r) {
            int rupIndex = availableRupIndexes.get(r);
            double mag = availableRupMags.get(r);
            int n = curSectSupraSeisMFD.getClosestXIndex(mag);
            rupsPerBin[n] = rupsPerBin[n] + 1;
            probObvs.add(this.getProbObservation(rupIndex, sect));
        }
        double sectArea = this.rupSet.getAreaForSection(sect.getSectionId());
        BoundedUncertainty moRateBounds = sectMomentRate.estimateUncertaintyBounds(UncertaintyBoundType.ONE_SIGMA);
        BoundedUncertainty paleoBounds = this.paleoConstraint.estimateUncertaintyBounds(UncertaintyBoundType.CONF_68);
        double totMoRate = Double.NaN;
        double closestOrigDiff = Double.POSITIVE_INFINITY;
        for (int i = 0; i < 3; ++i) {
            IncrementalMagFreqDist testMFD;
            if (i == 0) {
                if (moRateBounds.lowerBound <= 0.0) continue;
                testMFD = curSectSupraSeisMFD.deepClone();
                testMFD.scaleToTotalMomentRate(moRateBounds.lowerBound);
            } else if (i == 1) {
                if (sectMomentRate.bestEstimate <= 0.0) continue;
                testMFD = curSectSupraSeisMFD;
            } else {
                testMFD = curSectSupraSeisMFD.deepClone();
                testMFD.scaleToTotalMomentRate(moRateBounds.upperBound);
            }
            double calcRate = this.estPaleoRate(availableRupMags, availableRupIndexes, probObvs, rupsPerBin, sectArea, testMFD);
            double diff = Math.abs(calcRate - this.paleoConstraint.bestEstimate);
            if (!(diff < closestOrigDiff)) continue;
            closestOrigDiff = diff;
            totMoRate = testMFD.getTotalMomentRate();
        }
        Preconditions.checkState((Double.isFinite(totMoRate) && totMoRate > 0.0 ? 1 : 0) != 0, (String)"Bad moment rate (%s) for sectID=%s with sectMoRate=%s, bounds=%s", (Object)totMoRate, (Object)sect.getSectionId(), (Object)sectMomentRate, (Object)moRateBounds);
        IncrementalMagFreqDist[] closest = new IncrementalMagFreqDist[3];
        double[] closestDiff = new double[3];
        for (int i = 0; i < closestDiff.length; ++i) {
            closestDiff[i] = Double.POSITIVE_INFINITY;
        }
        boolean D = false;
        if (D) {
            System.out.println("Paleo constr fits for " + String.valueOf(this.paleoConstraint));
        }
        for (double b = -3.0; b <= 3.0; b += 0.2) {
            IncrementalMagFreqDist mfd = PaleoSectNuclEstimator.buildGRFromBVal(curSectSupraSeisMFD, availableRupMags, b, totMoRate, sparseGR);
            double calcRate = this.estPaleoRate(availableRupMags, availableRupIndexes, probObvs, rupsPerBin, sectArea, mfd);
            for (int i = 0; i < closest.length; ++i) {
                double testVal = i == 0 ? paleoBounds.lowerBound : (i == 1 ? this.paleoConstraint.bestEstimate : paleoBounds.upperBound);
                double diff = Math.abs(calcRate - testVal);
                if (diff < closestDiff[i]) {
                    closestDiff[i] = diff;
                    closest[i] = mfd;
                }
                if (!D) continue;
                System.out.println("\tbTest=" + (float)b + "\tcalcRate=" + (float)calcRate + "\tdiff=" + (float)diff + "\tincrRate=" + (float)mfd.getTotalIncrRate());
            }
        }
        return this.getBounded(UncertaintyBoundType.ONE_SIGMA, closest);
    }

    public double estPaleoRate(List<Double> mags, List<Integer> rups, List<Double> probObvs, int[] rupsPerBin, double sectArea, IncrementalMagFreqDist mfd) {
        double calcRate = 0.0;
        for (int r = 0; r < rups.size(); ++r) {
            int bin = mfd.getClosestXIndex(mags.get(r));
            double nuclRate = mfd.getY(bin) / (double)rupsPerBin[bin];
            double particRate = nuclRate * this.rupSet.getAreaForRup(rups.get(r)) / sectArea;
            calcRate += particRate * probObvs.get(r);
        }
        return calcRate;
    }

    protected abstract double getProbObservation(int var1, FaultSection var2);

    public static List<PaleoSectNuclEstimator> buildPaleoEstimates(FaultSystemRupSet rupSet, boolean applyToParent) {
        return PaleoSectNuclEstimator.buildPaleoEstimates(rupSet, applyToParent, null);
    }

    public static List<PaleoSectNuclEstimator> buildPaleoEstimates(FaultSystemRupSet rupSet, boolean applyToParent, NSHM23_PaleoUncertainties paleoUncert) {
        List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> slipConstraints;
        PaleoseismicConstraintData data = rupSet.requireModule(PaleoseismicConstraintData.class);
        ArrayList<PaleoSectNuclEstimator> ret = new ArrayList<PaleoSectNuclEstimator>();
        List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> rateConstraints = data.getPaleoRateConstraints();
        if (rateConstraints != null) {
            if (paleoUncert != null) {
                rateConstraints = paleoUncert.getScaled(rateConstraints);
            }
            for (UncertainDataConstraint.SectMappedUncertainDataConstraint sectMappedUncertainDataConstraint : rateConstraints) {
                double slipRate = rupSet.getSlipRateForSection(sectMappedUncertainDataConstraint.sectionIndex);
                double slipRateStdDev = rupSet.getSlipRateStdDevForSection(sectMappedUncertainDataConstraint.sectionIndex);
                if (slipRate > 0.0 || slipRate + slipRateStdDev > 0.0) {
                    ret.add(new PaleoRateEstimator(rupSet, sectMappedUncertainDataConstraint, applyToParent, data.getPaleoProbModel()));
                    continue;
                }
                System.err.println("WARNING: skipping paleo rate estimator for section " + sectMappedUncertainDataConstraint.sectionIndex + ". " + sectMappedUncertainDataConstraint.sectionName + ", slipRate=" + (float)slipRate + ", stdDev=" + (float)slipRateStdDev);
            }
        }
        if ((slipConstraints = data.getPaleoSlipConstraints()) != null) {
            if (paleoUncert != null) {
                slipConstraints = paleoUncert.getScaled(slipConstraints);
            }
            for (UncertainDataConstraint.SectMappedUncertainDataConstraint constr : PaleoseismicConstraintData.inferRatesFromSlipConstraints(rupSet, slipConstraints, true)) {
                double slipRate = rupSet.getSlipRateForSection(constr.sectionIndex);
                double slipRateStdDev = rupSet.getSlipRateStdDevForSection(constr.sectionIndex);
                if (slipRate > 0.0 || slipRate + slipRateStdDev > 0.0) {
                    ret.add(new PaleoSlipRateEstimator(rupSet, constr, applyToParent, data.getPaleoSlipProbModel()));
                    continue;
                }
                System.err.println("WARNING: skipping paleo rate estimator for section " + constr.sectionIndex + ". " + constr.sectionName + ", slipRate=" + (float)slipRate + ", stdDev=" + (float)slipRateStdDev);
            }
        }
        return ret;
    }

    public static class PaleoRateEstimator
    extends PaleoSectNuclEstimator {
        private PaleoProbabilityModel probModel;

        public PaleoRateEstimator(FaultSystemRupSet rupSet, UncertainDataConstraint.SectMappedUncertainDataConstraint paleoConstraint, boolean applyToParent, PaleoProbabilityModel probModel) {
            super(rupSet, paleoConstraint, applyToParent);
            this.probModel = probModel;
        }

        @Override
        protected double getProbObservation(int rupIndex, FaultSection sect) {
            return this.probModel.getProbPaleoVisible(this.rupSet, rupIndex, sect.getSectionId());
        }
    }

    public static class PaleoSlipRateEstimator
    extends PaleoSectNuclEstimator {
        private PaleoSlipProbabilityModel probModel;
        private AveSlipModule aveSlipModule;
        private SlipAlongRuptureModel slipAlongModule;

        public PaleoSlipRateEstimator(FaultSystemRupSet rupSet, UncertainDataConstraint.SectMappedUncertainDataConstraint paleoConstraint, boolean applyToParent, PaleoSlipProbabilityModel probModel) {
            super(rupSet, paleoConstraint, applyToParent);
            this.probModel = probModel;
            this.aveSlipModule = rupSet.requireModule(AveSlipModule.class);
            this.slipAlongModule = rupSet.requireModule(SlipAlongRuptureModel.class);
        }

        @Override
        protected double getProbObservation(int rupIndex, FaultSection sect) {
            int sectIndexInRup = this.rupSet.getSectionsIndicesForRup(rupIndex).indexOf(sect.getSectionId());
            double slipOnSect = this.slipAlongModule.calcSlipOnSectionsForRup(this.rupSet, this.aveSlipModule, rupIndex)[sectIndexInRup];
            return this.probModel.getProbabilityOfObservedSlip(slipOnSect);
        }
    }
}

