/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_ScalingRelationships;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.SupraSeisBValInversionTargetMFDs;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.SectNucleationMFD_Estimator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class ScalingRelSlipRateMFD_Estimator
extends SectNucleationMFD_Estimator {
    private boolean adjustForSlipAlong;
    private double[] calcSectSlips;
    private double[] targetSectSupraMoRates;
    private double[] targetSectSupraSlipRates;
    private DataUtils.MinMaxAveTracker slipAdjustTrack = new DataUtils.MinMaxAveTracker();
    private DataUtils.MinMaxAveTracker absPercentTrack = new DataUtils.MinMaxAveTracker();

    public ScalingRelSlipRateMFD_Estimator(boolean adjustForSlipAlong) {
        this.adjustForSlipAlong = adjustForSlipAlong;
    }

    @Override
    public void init(FaultSystemRupSet rupSet, List<IncrementalMagFreqDist> origSectSupraSeisMFDs, double[] targetSectSupraMoRates, double[] targetSectSupraSlipRates, double[] sectSupraSlipRateStdDevs, List<BitSet> sectRupUtilizations, int[] sectMinMagIndexes, int[] sectMaxMagIndexes, int[][] sectRupInBinCounts, EvenlyDiscretizedFunc refMFD) {
        SlipAlongRuptureModel slipAlong;
        this.targetSectSupraMoRates = targetSectSupraMoRates;
        this.targetSectSupraSlipRates = targetSectSupraSlipRates;
        super.init(rupSet, origSectSupraSeisMFDs, targetSectSupraMoRates, targetSectSupraSlipRates, sectSupraSlipRateStdDevs, sectRupUtilizations, sectMinMagIndexes, sectMaxMagIndexes, sectRupInBinCounts, refMFD);
        System.out.println("Adjusting targets to match actual rupture slips");
        AveSlipModule aveSlips = rupSet.requireModule(AveSlipModule.class);
        SlipAlongRuptureModel slipAlongRuptureModel = slipAlong = this.adjustForSlipAlong ? rupSet.requireModule(SlipAlongRuptureModel.class) : null;
        if (slipAlong != null && slipAlong.isUniform()) {
            slipAlong = null;
        }
        this.calcSectSlips = new double[rupSet.getNumSections()];
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            double[] slips;
            List<Integer> sectIDs = rupSet.getSectionsIndicesForRup(r);
            if (slipAlong == null) {
                slips = new double[sectIDs.size()];
                double aveSlip = aveSlips.getAveSlip(r);
                for (int i = 0; i < slips.length; ++i) {
                    slips[i] = aveSlip;
                }
            } else {
                slips = slipAlong.calcSlipOnSectionsForRup(rupSet, aveSlips, r);
                Preconditions.checkState((slips.length == sectIDs.size() ? 1 : 0) != 0);
            }
            int magIndex = refMFD.getClosestXIndex(rupSet.getMagForRup(r));
            double rupArea = rupSet.getAreaForRup(r);
            for (int i = 0; i < slips.length; ++i) {
                double sectBinNuclRate;
                int s = sectIDs.get(i);
                if (!sectRupUtilizations.get(s).get(r) || !((sectBinNuclRate = origSectSupraSeisMFDs.get(s).getY(magIndex)) > 0.0)) continue;
                double particRate = sectBinNuclRate * rupArea / rupSet.getAreaForSection(s);
                int n = s;
                this.calcSectSlips[n] = this.calcSectSlips[n] + slips[i] * particRate / (double)sectRupInBinCounts[s][magIndex];
            }
        }
    }

    @Override
    public boolean appliesTo(FaultSection sect) {
        return true;
    }

    @Override
    public IncrementalMagFreqDist estimateNuclMFD(FaultSection sect, IncrementalMagFreqDist curSectSupraSeisMFD, List<Integer> availableRupIndexes, List<Double> availableRupMags, UncertainDataConstraint sectMomentRate, boolean sparseGR) {
        Preconditions.checkState((boolean)sparseGR, (Object)"Scaling relationship adjustments only work with sparseGR=true");
        Preconditions.checkNotNull((Object)this.calcSectSlips, (Object)"Not initialized");
        int s = sect.getSectionId();
        if (this.targetSectSupraSlipRates[s] > 0.0 && this.targetSectSupraMoRates[s] > 0.0) {
            double slipRatio = this.targetSectSupraSlipRates[s] / this.calcSectSlips[s];
            this.slipAdjustTrack.addValue(slipRatio);
            this.absPercentTrack.addValue(100.0 * Math.abs((this.targetSectSupraSlipRates[s] - this.calcSectSlips[s]) / this.calcSectSlips[s]));
            curSectSupraSeisMFD = curSectSupraSeisMFD.deepClone();
            curSectSupraSeisMFD.scale(slipRatio);
        }
        return curSectSupraSeisMFD;
    }

    public void printStats() {
        System.out.println("Scaling relationship MFD adjustment ratios: " + String.valueOf(this.slipAdjustTrack));
        System.out.println("Scaling relationship MFD adjustment abs % changes: " + String.valueOf(this.absPercentTrack));
    }

    public static void main(String[] args) throws IOException {
        FaultSystemRupSet rupSet = FaultSystemRupSet.load(new File("/home/kevin/OpenSHA/UCERF4/batch_inversions/2023_04_11-nshm23_branches-NSHM23_v2-CoulombRupSet-TotNuclRate-NoRed-ThreshAvgIterRelGR/results_NSHM23_v2_CoulombRupSet_branch_averaged_gridded.zip"));
        ArrayList<NSHM23_ScalingRelationships> scales = new ArrayList<NSHM23_ScalingRelationships>();
        ArrayList<ScalingRelSlipRateMFD_Estimator> estimators = new ArrayList<ScalingRelSlipRateMFD_Estimator>();
        double avgFromMoment = 0.0;
        int numFromMoment = 0;
        double avgOther = 0.0;
        int numOther = 0;
        for (NSHM23_ScalingRelationships scale : NSHM23_ScalingRelationships.values()) {
            if (!(scale.getNodeWeight(null) > 0.0)) continue;
            scales.add(scale);
            ScalingRelSlipRateMFD_Estimator estimator = new ScalingRelSlipRateMFD_Estimator(false);
            rupSet = FaultSystemRupSet.buildFromExisting(rupSet, false).forScalingRelationship(scale).build();
            SupraSeisBValInversionTargetMFDs.Builder mfdBuilder = new SupraSeisBValInversionTargetMFDs.Builder(rupSet, 0.5);
            mfdBuilder.adjustTargetsForData(estimator);
            mfdBuilder.build();
            estimators.add(estimator);
            if (scale.getName().toLowerCase().contains("from moment")) {
                avgFromMoment += estimator.absPercentTrack.getAverage();
                ++numFromMoment;
                continue;
            }
            avgOther += estimator.absPercentTrack.getAverage();
            ++numOther;
        }
        for (int i = 0; i < scales.size(); ++i) {
            System.out.println(((NSHM23_ScalingRelationships)scales.get(i)).getName());
            ((ScalingRelSlipRateMFD_Estimator)estimators.get(i)).printStats();
            System.out.println();
        }
        System.out.println("From-Moment abs % change: " + (float)(avgFromMoment /= (double)numFromMoment) + " %");
        System.out.println("Other abs % change: " + (float)(avgOther /= (double)numOther) + " %");
    }
}

