/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.scec.getfile.GetFile;

public class NSHM23_Downloader
extends GetFile {
    private static final List<URI> ENDPOINTS = List.of(URI.create("https://g-3a9041.a78b8.36fe.data.globus.org/getfile/nshm23/nshm23.json"), URI.create("https://data.opensha.org/getfile/nshm23/nshm23.json"), URI.create("https://opensha.scec.org/getfile/nshm23/nshm23.json"));

    public NSHM23_Downloader(File storeDir, boolean showProgress) {
        super("NSHM 2023", new File(storeDir, "nshm23_client.json"), ENDPOINTS, showProgress);
    }

    public NSHM23_Downloader(boolean showProgress) {
        this(NSHM23_Downloader.getStoreDir(), showProgress);
    }

    public NSHM23_Downloader(File storeDir) {
        this(storeDir, true);
    }

    public NSHM23_Downloader() {
        this(true);
    }

    public static File getStoreDir() {
        Path storeDir = Paths.get(System.getProperty("user.home"), ".opensha", "nshm23");
        try {
            Files.createDirectories(storeDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("NSHM23_Downloader failed to create storeDir at " + String.valueOf(storeDir));
            e.printStackTrace();
        }
        return storeDir.toFile();
    }
}

