/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.util;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.geo.json.FeatureCollection;
import org.opensha.commons.geo.json.GeoJSON_Type;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSectionUtils;
import org.opensha.sha.faultSurface.FaultSection;

public class NSHM23_RegionLoader {
    private static final String NSHM23_REG_PATH_PREFIX = "/data/erf/nshm23/seismicity/regions";
    private static final String ANALYSIS_REG_PATH = "/data/erf/nshm23/seismicity/regions/analysis";
    private static final String SEIS_REG_PATH = "/data/erf/nshm23/seismicity/regions/collection";
    private static final String LOCAL_REG_PATH = "/data/erf/nshm23/seismicity/regions/local";
    private static final String STITCHED_REG_PATH = "/data/erf/nshm23/seismicity/regions/stitched";
    private static final String FAULT_STYLE_REG_PATH = "/data/erf/nshm23/seismicity/regions/fault-style";
    private static final String GRID_SYSTEM_REG_PATH = "/data/erf/nshm23/seismicity/regions/grid-system";
    private static String SEIS_REG_SUFFIX = "";
    private static Map<NSHM23_BaseRegion, Region> regionCache = new ConcurrentHashMap<NSHM23_BaseRegion, Region>();
    public static NSHM23_BaseRegion CATCH_ALL_REGION = new NSHM23_BaseRegion(){
        Region region;

        @Override
        public String name() {
            return "FULL";
        }

        @Override
        public String getResourcePath() {
            return null;
        }

        @Override
        public synchronized Region load() throws IOException {
            if (this.region == null) {
                this.region = new Region(new Location(10.0, -180.0), new Location(80.0, 0.0));
                this.region.setName("Full");
            }
            return this.region;
        }
    };

    public static synchronized void setSeismicityRegionVersion(int version) {
        SEIS_REG_SUFFIX = "-v" + version;
        regionCache.remove(SeismicityRegions.CONUS_WEST);
        regionCache.remove(SeismicityRegions.CONUS_EAST);
    }

    public static List<Region> loadAnalysisRegions() throws IOException {
        return NSHM23_RegionLoader.loadAnalysisRegions(null);
    }

    public static List<Region> loadAnalysisRegions(List<? extends FaultSection> subSects) throws IOException {
        return NSHM23_RegionLoader.doLoadRegions(AnalysisRegions.values(), subSects);
    }

    public static List<Region> loadLocalRegions() throws IOException {
        return NSHM23_RegionLoader.loadLocalRegions(null);
    }

    public static List<Region> loadLocalRegions(List<? extends FaultSection> subSects) throws IOException {
        return NSHM23_RegionLoader.doLoadRegions(LocalRegions.values(), subSects);
    }

    public static List<Region> loadAllRegions() throws IOException {
        return NSHM23_RegionLoader.loadAllRegions(null);
    }

    public static List<Region> loadAllRegions(List<? extends FaultSection> subSects) throws IOException {
        ArrayList<Region> ret = new ArrayList<Region>();
        ret.addAll(NSHM23_RegionLoader.loadAnalysisRegions(subSects));
        ret.addAll(NSHM23_RegionLoader.loadLocalRegions(subSects));
        return ret;
    }

    private static List<Region> doLoadRegions(NSHM23_BaseRegion[] regions, List<? extends FaultSection> subSects) throws IOException {
        ArrayList<Region> ret = new ArrayList<Region>();
        for (NSHM23_BaseRegion baseReg : regions) {
            Region region = baseReg.load();
            if (subSects != null && !FaultSectionUtils.anySectInRegion(region, subSects, true)) continue;
            ret.add(region);
        }
        return ret;
    }

    public static Region loadFullConterminousWUS() throws IOException {
        return StitchedRegions.CONUS_WEST.load();
    }

    public static Region loadFullConterminousUS() throws IOException {
        return StitchedRegions.CONUS.load();
    }

    public static void main(String[] args) throws IOException {
        NSHM23_RegionLoader.loadFullConterminousUS();
        NSHM23_RegionLoader.loadFullConterminousWUS();
        double gridSpacing = 0.1;
        GriddedRegion fullGriddedWUS = new GriddedRegion(NSHM23_RegionLoader.loadFullConterminousWUS(), gridSpacing, GriddedRegion.ANCHOR_0_0);
        int numMapped = 0;
        int numMultiplyMapped = 0;
        List<Region> regions = NSHM23_RegionLoader.loadAnalysisRegions();
        for (int i = 0; i < fullGriddedWUS.getNodeCount(); ++i) {
            Location loc = fullGriddedWUS.getLocation(i);
            int matches = 0;
            for (Region region : regions) {
                if (!region.contains(loc)) continue;
                ++matches;
            }
            if (matches > 0) {
                ++numMapped;
            }
            if (matches <= 1) continue;
            ++numMultiplyMapped;
        }
        System.out.println(numMapped + "/" + fullGriddedWUS.getNodeCount() + " grid nodes are mapped to at least 1 sub-region");
        System.out.println(numMultiplyMapped + "/" + fullGriddedWUS.getNodeCount() + " grid nodes are mapped to multiple sub-regions");
        int countAcrossIndv = 0;
        for (Region region : regions) {
            countAcrossIndv += new GriddedRegion(region, gridSpacing, GriddedRegion.ANCHOR_0_0).getNodeCount();
        }
        System.out.println(countAcrossIndv + " vs " + fullGriddedWUS.getNodeCount() + " if you sum individual gridded regions");
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        for (SeismicityRegions reg : SeismicityRegions.values()) {
            Feature feature = reg.load().toFeature();
            featureList.add(feature);
        }
        FeatureCollection features = new FeatureCollection(featureList);
        FeatureCollection.write(features, new File("/tmp/nshm23_conus_seismicity_regions.geojson"));
        String url = "https://opensha.usc.edu/ftp/kmilner/nshm23/misc_maps/nshm23_conus_seismicity_regions.geojson";
        System.out.print(RupSetMapMaker.getGeoJSONViewerLink(url));
    }

    public static enum SeismicityRegions implements NSHM23_BaseRegion
    {
        CONUS_EAST("collection-ceus" + SEIS_REG_SUFFIX + ".geojson"),
        CONUS_WEST("collection-wus" + SEIS_REG_SUFFIX + ".geojson");

        private String fileName;

        private SeismicityRegions(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public String getResourcePath() {
            return "/data/erf/nshm23/seismicity/regions/collection/" + this.fileName;
        }
    }

    public static enum AnalysisRegions implements NSHM23_BaseRegion
    {
        ALASKA("alaska.geojson"),
        CONUS_EAST("ceus.geojson"),
        CONUS_IMW("intermountain-west.geojson"),
        CONUS_PNW("pacific-northwest.geojson"),
        CONUS_U3_RELM("ucerf.geojson");

        private String fileName;

        private AnalysisRegions(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public String getResourcePath() {
            return "/data/erf/nshm23/seismicity/regions/analysis/" + this.fileName;
        }
    }

    public static interface NSHM23_BaseRegion {
        public String getResourcePath();

        public String name();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        default public Region load() throws IOException {
            Feature feature;
            Region cached = regionCache.get(this);
            if (cached != null) {
                return cached;
            }
            String path = this.getResourcePath();
            System.out.println("Reading " + path);
            GeoJSON_Type type = GeoJSON_Type.detect(new BufferedReader(new InputStreamReader(NSHM23_RegionLoader.class.getResourceAsStream(path))));
            BufferedReader reader = new BufferedReader(new InputStreamReader(NSHM23_RegionLoader.class.getResourceAsStream(path)));
            if (type == GeoJSON_Type.Feature) {
                feature = Feature.read(reader);
            } else if (type == GeoJSON_Type.FeatureCollection) {
                FeatureCollection features = FeatureCollection.read(reader);
                Preconditions.checkState((features.features.size() == 1 ? 1 : 0) != 0, (Object)"Expected 1 feature in collection");
                feature = (Feature)features.features.get(0);
            } else {
                throw new IllegalStateException("Expected Feature or FeatureCollection, have " + String.valueOf((Object)type));
            }
            reader.close();
            Region reg = Region.fromFeature(feature);
            if (feature.id == null && feature.properties != null) {
                Object name;
                if (feature.properties.containsKey("title")) {
                    Object title = feature.properties.get("title");
                    if (title instanceof String && !((String)title).isBlank()) {
                        reg.setName((String)title);
                    }
                } else if (feature.properties.containsKey("name") && (name = feature.properties.get("name")) instanceof String && !((String)name).isBlank()) {
                    reg.setName((String)name);
                }
            }
            Map<NSHM23_BaseRegion, Region> map = regionCache;
            synchronized (map) {
                regionCache.putIfAbsent(this, reg);
            }
            return reg;
        }
    }

    public static enum LocalRegions implements NSHM23_BaseRegion
    {
        CONUS_LA_BASIN("conus-la-basin.geojson"),
        CONUS_NEW_MADRID("conus-new-madrid.geojson"),
        CONUS_PUGET("conus-puget.geojson"),
        CONUS_SF_BAY("conus-sf-bay.geojson"),
        CONUS_WASATCH("conus-wasatch.geojson");

        private String fileName;

        private LocalRegions(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public String getResourcePath() {
            return "/data/erf/nshm23/seismicity/regions/local/" + this.fileName;
        }
    }

    public static enum StitchedRegions implements NSHM23_BaseRegion
    {
        CONUS("conus.geojson"),
        CONUS_WEST("conus-wus.geojson");

        private String fileName;

        private StitchedRegions(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public String getResourcePath() {
            return "/data/erf/nshm23/seismicity/regions/stitched/" + this.fileName;
        }
    }

    public static enum GridSystemRegions implements NSHM23_BaseRegion
    {
        WUS_ACTIVE("grid-system-active.geojson"),
        CEUS_STABLE("grid-system-stable.geojson");

        private String fileName;

        private GridSystemRegions(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public String getResourcePath() {
            return "/data/erf/nshm23/seismicity/regions/grid-system/" + this.fileName;
        }
    }

    public static enum FaultStyleRegions implements NSHM23_BaseRegion
    {
        CEUS_STABLE("focal-mech-ceus-stable.geojson"),
        WUS_COMPRESSIONAL("focal-mech-wus-compressional.geojson"),
        WUS_EXTENSIONAL("focal-mech-wus-extensional.geojson");

        private String fileName;

        private FaultStyleRegions(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public String getResourcePath() {
            return "/data/erf/nshm23/seismicity/regions/fault-style/" + this.fileName;
        }
    }
}

