/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.uncertainty.BoundedUncertainty;
import org.opensha.commons.data.uncertainty.UncertainArbDiscFunc;
import org.opensha.commons.data.uncertainty.UncertainBoundedIncrMagFreqDist;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv"), @DoesNotAffect(value="rates.csv"), @DoesNotAffect(value="grid_region.geojson"), @DoesNotAffect(value="grid_mech_weights.csv"), @DoesNotAffect(value="grid_source_locations.csv")})
@Affects.Affected(value={@Affects(value="grid_sub_seis_mfds.csv"), @Affects(value="grid_unassociated_mfds.csv"), @Affects(value="grid_sources.csv")})
public enum PRVI25_SeismicityRateEpoch implements LogicTreeNode
{
    FULL("Full (1900-2023)", "Full", "1900_2023", 0.3333333333333333),
    RECENT("Recent (1973-2023)", "Recent", "1973_2023", 0.3333333333333333),
    RECENT_SCALED("Recent, scaled to full rate", "Recent (scaled to full)", null, 0.3333333333333333);

    public static PRVI25_SeismicityRateEpoch DEFAULT;
    private String name;
    private String shortName;
    private String rateDirName;
    private double weight;
    private static boolean AVG_UNCERT_IN_LOG10;

    private PRVI25_SeismicityRateEpoch(String name, String shortName, String rateDirName, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.rateDirName = rateDirName;
        this.weight = weight;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.name();
    }

    public String getRateSubDirName() {
        return this.rateDirName;
    }

    public static UncertainBoundedIncrMagFreqDist averageUncert(List<UncertainBoundedIncrMagFreqDist> mfds, List<Double> weights) {
        if (mfds.size() == 1) {
            return mfds.get(0);
        }
        UncertainBoundedIncrMagFreqDist refMFD = mfds.get(0);
        double sumWeight = 0.0;
        for (int i = 0; i < mfds.size(); ++i) {
            UncertainBoundedIncrMagFreqDist mfd = mfds.get(i);
            Preconditions.checkNotNull((Object)((Object)mfd.getBoundType()));
            Preconditions.checkState((mfd.getBoundType() == refMFD.getBoundType() ? 1 : 0) != 0);
            Preconditions.checkState((mfd.getDelta() == refMFD.getDelta() ? 1 : 0) != 0);
            Preconditions.checkState((mfd.getMinX() == refMFD.getMinX() ? 1 : 0) != 0);
            Preconditions.checkState((mfd.size() == refMFD.size() ? 1 : 0) != 0);
            sumWeight += weights.get(i).doubleValue();
        }
        Preconditions.checkState((boolean)Precision.equals((double)sumWeight, (double)1.0, (double)1.0E-4));
        IncrementalMagFreqDist pref = new IncrementalMagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
        IncrementalMagFreqDist lower = new IncrementalMagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
        IncrementalMagFreqDist upper = new IncrementalMagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
        for (int i = 0; i < refMFD.size(); ++i) {
            boolean anyNonZero = false;
            for (int j = 0; !anyNonZero && j < mfds.size(); ++j) {
                anyNonZero = mfds.get(j).getY(i) > 0.0;
            }
            if (!anyNonZero) continue;
            double average = 0.0;
            double sumNonzeroWeight = 0.0;
            WeightedList<BoundedUncertainty> uncertainties = new WeightedList<BoundedUncertainty>(mfds.size());
            for (int j = 0; j < mfds.size(); ++j) {
                UncertainBoundedIncrMagFreqDist mfd = mfds.get(j);
                double y = mfd.getY(i);
                if (!(y > 0.0)) continue;
                double weight = weights.get(j);
                sumNonzeroWeight += weight;
                average += weight * y;
                double lowerY = mfd.getLowerY(i);
                double upperY = mfd.getUpperY(i);
                if (AVG_UNCERT_IN_LOG10) {
                    uncertainties.add(new BoundedUncertainty(mfd.getBoundType(), Math.log10(lowerY), Math.log10(upperY), mfd.getBoundType().estimateStdDev(Math.log10(lowerY), Math.log10(upperY))), weight);
                    continue;
                }
                uncertainties.add(new BoundedUncertainty(mfd.getBoundType(), lowerY, upperY, mfd.getStdDev(i)), weight);
            }
            pref.set(i, average);
            BoundedUncertainty uncertMix = BoundedUncertainty.weightedCombination(uncertainties);
            if (AVG_UNCERT_IN_LOG10) {
                lower.set(i, Math.pow(10.0, uncertMix.lowerBound) * sumNonzeroWeight);
                upper.set(i, Math.pow(10.0, uncertMix.upperBound) * sumNonzeroWeight);
                continue;
            }
            lower.set(i, uncertMix.lowerBound * sumNonzeroWeight);
            upper.set(i, uncertMix.upperBound * sumNonzeroWeight);
        }
        UncertainBoundedIncrMagFreqDist ret = new UncertainBoundedIncrMagFreqDist(pref, lower, upper, refMFD.getBoundType());
        ret.setName(refMFD.getName());
        return ret;
    }

    public static UncertainArbDiscFunc averageUncertCml(List<UncertainArbDiscFunc> mfds, List<Double> weights) {
        if (mfds.size() == 1) {
            return mfds.get(0);
        }
        UncertainArbDiscFunc refMFD = mfds.get(0);
        double sumWeight = 0.0;
        for (int i = 0; i < mfds.size(); ++i) {
            UncertainArbDiscFunc mfd = mfds.get(i);
            Preconditions.checkState((mfd.getMinX() == refMFD.getMinX() ? 1 : 0) != 0, (String)"MFD minX=%s != ref minX=%s", (Object)mfd.getMinX(), (Object)refMFD.getMinX());
            Preconditions.checkState((mfd.getMaxX() == refMFD.getMaxX() ? 1 : 0) != 0, (String)"MFD maxX=%s != ref maxX=%s", (Object)mfd.getMaxX(), (Object)refMFD.getMaxX());
            Preconditions.checkState((mfd.size() == refMFD.size() ? 1 : 0) != 0, (String)"MFD size=%s != ref size=%s", (int)mfd.size(), (int)refMFD.size());
            sumWeight += weights.get(i).doubleValue();
        }
        Preconditions.checkState((boolean)Precision.equals((double)sumWeight, (double)1.0, (double)1.0E-4));
        ArbitrarilyDiscretizedFunc pref = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc lower = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc upper = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < refMFD.size(); ++i) {
            boolean anyNonZero = false;
            for (int j = 0; !anyNonZero && j < mfds.size(); ++j) {
                anyNonZero = mfds.get(j).getY(i) > 0.0;
            }
            if (!anyNonZero) continue;
            double x = refMFD.getX(i);
            double average = 0.0;
            double sumNonzeroWeight = 0.0;
            WeightedList<BoundedUncertainty> uncertainties = new WeightedList<BoundedUncertainty>(mfds.size());
            for (int j = 0; j < mfds.size(); ++j) {
                UncertainArbDiscFunc mfd = mfds.get(j);
                double y = mfd.getY(i);
                if (!(y > 0.0)) continue;
                double weight = weights.get(j);
                sumNonzeroWeight += weight;
                average += weight * mfd.getY(i);
                double lowerY = mfd.getLowerY(i);
                double upperY = mfd.getUpperY(i);
                if (AVG_UNCERT_IN_LOG10) {
                    uncertainties.add(new BoundedUncertainty(mfd.getBoundType(), Math.log10(lowerY), Math.log10(upperY), mfd.getBoundType().estimateStdDev(Math.log10(lowerY), Math.log10(upperY))), weight);
                    continue;
                }
                uncertainties.add(new BoundedUncertainty(mfd.getBoundType(), lowerY, upperY, mfd.getStdDev(i)), weight);
            }
            pref.set(x, average);
            BoundedUncertainty uncertMix = BoundedUncertainty.weightedCombination(uncertainties);
            if (AVG_UNCERT_IN_LOG10) {
                lower.set(x, Math.pow(10.0, uncertMix.lowerBound) * sumNonzeroWeight);
                upper.set(x, Math.pow(10.0, uncertMix.upperBound) * sumNonzeroWeight);
                continue;
            }
            lower.set(x, uncertMix.lowerBound * sumNonzeroWeight);
            upper.set(x, uncertMix.upperBound * sumNonzeroWeight);
        }
        UncertainArbDiscFunc ret = new UncertainArbDiscFunc(pref, lower, upper, refMFD.getBoundType());
        ret.setName(refMFD.getName());
        return ret;
    }

    static {
        DEFAULT = FULL;
        AVG_UNCERT_IN_LOG10 = true;
    }
}

