/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree;

import java.util.ArrayList;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.sha.earthquake.faultSysSolution.RupSetScalingRelationship;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="grid_region.geojson"), @DoesNotAffect(value="grid_source_locations.csv")})
@Affects.Affected(value={@Affects(value="properties.csv"), @Affects(value="rates.csv"), @Affects(value="grid_sources.csv")})
public enum PRVI25_SubductionScalingRelationships implements RupSetScalingRelationship
{
    LOGA_C4p1("LogA+4.1", "LogA+4.1", "LogA_C4p1"){

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            return Math.log10(area *= 1.0E-6) + 4.1;
        }

        @Override
        public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
            return 1.0;
        }

        @Override
        public MagAreaRelationship getMagAreaRelationship() {
            return new LogAPlusC(4.1);
        }
    }
    ,
    LOGA_C4p0("LogA+4.0", "LogA+4.0", "LogA_C4p0"){

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            return Math.log10(area *= 1.0E-6) + 4.0;
        }

        @Override
        public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
            return 1.0;
        }

        @Override
        public MagAreaRelationship getMagAreaRelationship() {
            return new LogAPlusC(4.0);
        }
    }
    ,
    LOGA_C3p9("LogA+3.9", "LogA+3.9", "LogA_C3p9"){

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            return Math.log10(area *= 1.0E-6) + 3.9;
        }

        @Override
        public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
            return 1.0;
        }

        @Override
        public MagAreaRelationship getMagAreaRelationship() {
            return new LogAPlusC(3.9);
        }
    }
    ,
    AVERAGE("PRVI25 Subduction Average", "PRVI25-Sub-Avg", "PRVI_SubAvg"){

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            double sum = 0.0;
            double sumWeights = 0.0;
            for (PRVI25_SubductionScalingRelationships scale : 4.values()) {
                double weight = scale.getNodeWeight(null);
                if (!(weight > 0.0) || scale == this) continue;
                sum += scale.getMag(area, length, width, origWidth, aveRake) * weight;
                sumWeights += weight;
            }
            return sum / sumWeights;
        }

        @Override
        public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
            double sum = 0.0;
            double sumWeights = 0.0;
            for (PRVI25_SubductionScalingRelationships scale : 4.values()) {
                double weight = scale.getNodeWeight(null);
                if (!(weight > 0.0) || scale == this) continue;
                sum += scale.getAveSlip(area, length, width, origWidth, aveRake) * weight;
                sumWeights += weight;
            }
            return sum / sumWeights;
        }

        @Override
        public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
            return 0.0;
        }

        @Override
        public MagAreaRelationship getMagAreaRelationship() {
            final ArrayList<MagAreaRelationship> others = new ArrayList<MagAreaRelationship>();
            final ArrayList<Double> weights = new ArrayList<Double>();
            for (PRVI25_SubductionScalingRelationships scale : 4.values()) {
                double weight = scale.getNodeWeight(null);
                if (!(weight > 0.0) || scale == this) continue;
                others.add(scale.getMagAreaRelationship());
                weights.add(weight);
            }
            final double sumWeight = weights.stream().mapToDouble(D -> D).sum();
            return new MagAreaRelationship(this){
                final /* synthetic */ 4 this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public String getName() {
                    return AVERAGE.getName();
                }

                @Override
                public double getMedianMag(double area) {
                    double sum = 0.0;
                    for (int i = 0; i < others.size(); ++i) {
                        sum += ((MagAreaRelationship)others.get(i)).getMedianMag(area) * (Double)weights.get(i);
                    }
                    return sum / sumWeight;
                }

                @Override
                public double getMedianArea(double mag) {
                    double sum = 0.0;
                    for (int i = 0; i < others.size(); ++i) {
                        sum += ((MagAreaRelationship)others.get(i)).getMedianArea(mag) * (Double)weights.get(i);
                    }
                    return sum / sumWeight;
                }

                @Override
                public double getMagStdDev() {
                    return Double.NaN;
                }

                @Override
                public double getAreaStdDev() {
                    return Double.NaN;
                }
            };
        }
    };

    private String name;
    private String shortName;
    private String filePrefix;

    private PRVI25_SubductionScalingRelationships(String name, String shortName, String filePrefix) {
        this.name = name;
        this.shortName = shortName;
        this.filePrefix = filePrefix;
    }

    public abstract MagAreaRelationship getMagAreaRelationship();

    @Override
    public String getFilePrefix() {
        return this.filePrefix;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
        double mag = this.getMag(area, length, width, origWidth, aveRake);
        double moment = MagUtils.magToMoment(mag);
        return FaultMomentCalc.getSlip(area, moment);
    }

    @Override
    public abstract double getMag(double var1, double var3, double var5, double var7, double var9);

    public static class LogAPlusC
    extends MagAreaRelationship {
        private double c;

        public LogAPlusC(double c) {
            this.c = c;
        }

        @Override
        public double getMedianMag(double area) {
            return this.c + Math.log(area) * 0.434294;
        }

        @Override
        public double getMagStdDev() {
            return Double.NaN;
        }

        @Override
        public double getMedianArea(double mag) {
            return Math.pow(10.0, mag - this.c);
        }

        @Override
        public double getAreaStdDev() {
            return Double.NaN;
        }

        @Override
        public String getName() {
            return "LogA+" + (float)this.c;
        }
    }
}

