/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.step.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.gui.beans.IMLorProbSelectorGuiBean;
import org.opensha.sha.gui.beans.MapGuiBean;

public class STEP_MapViewerApp
extends JPanel {
    JSplitPane mainSplitPane = new JSplitPane();
    JSplitPane gmtSplitPane = new JSplitPane();
    JSplitPane siteSplitPane = new JSplitPane();
    JPanel dataSetPanel = new JPanel();
    JPanel gmtPanel = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JPanel sitePanel = new JPanel();
    JPanel imlProbPanel = new JPanel();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();
    JComboBox dataSetCombo = new JComboBox();
    JTextArea dataSetText = new JTextArea();
    Border border1;
    JLabel jLabel2 = new JLabel();
    JButton mapButton = new JButton();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    Hashtable metaDataHash = new Hashtable();
    Hashtable lonHash = new Hashtable();
    Hashtable latHash = new Hashtable();
    ParameterList sitesParamList;
    ParameterListEditor sitesEditor;
    private static final String MIN_LAT_PARAM_NAME = "Min Lat";
    private static final String MAX_LAT_PARAM_NAME = "Max Lat";
    private static final String MIN_LON_PARAM_NAME = "Min Lon";
    private static final String MAX_LON_PARAM_NAME = "Max Lon";
    private static final String GRIDSPACING_PARAM_NAME = "GridSpacing";
    private static final String SITES_TITLE = "Choose Region";
    private static final String NO_DATA_EXISTS = "No STEP Map Data Exists";
    private static final String TITLE = "STEP Map Viewer";
    private static final String STEP_DIR = "step/";
    private static final int W = 800;
    private static final int H = 800;
    private IMLorProbSelectorGuiBean imlProbGuiBean;
    private MapGuiBean mapGuiBean;
    DecimalFormat d = new DecimalFormat("0.00##");
    private Insets defaultInsets = new Insets(4, 4, 4, 4);
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout5 = new GridBagLayout();

    public String getParameter(String key, String def) {
        return System.getProperty(key, def);
    }

    public void init() {
        try {
            this.loadDataSets();
            this.jbInit();
            this.initIML_ProbGuiBean();
            this.initMapGuiBean();
            this.addDataInfo();
            this.fillLatLonAndGridSpacing();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, new Color(248, 254, 255), new Color(121, 124, 136));
        this.setLayout(this.gridBagLayout5);
        this.mainSplitPane.setBottomComponent(this.gmtSplitPane);
        this.mainSplitPane.setLeftComponent(null);
        this.sitePanel.setLayout(this.gridBagLayout3);
        this.imlProbPanel.setLayout(this.gridBagLayout4);
        this.jLabel1.setForeground(new Color(80, 80, 133));
        this.jLabel1.setText("Choose Data Set:");
        this.dataSetCombo.setBackground(new Color(200, 200, 230));
        this.dataSetCombo.setForeground(new Color(80, 80, 133));
        this.dataSetCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                STEP_MapViewerApp.this.dataSetCombo_actionPerformed(e);
            }
        });
        this.dataSetText.setBorder(this.border1);
        this.dataSetText.setLineWrap(true);
        this.jLabel2.setForeground(new Color(80, 80, 133));
        this.jLabel2.setText("Data Set Info:");
        this.mapButton.setBackground(new Color(200, 200, 230));
        this.mapButton.setForeground(new Color(80, 80, 133));
        this.mapButton.setText("Show Map");
        this.mapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                STEP_MapViewerApp.this.mapButton_actionPerformed(e);
            }
        });
        this.mainSplitPane.add((Component)this.gmtSplitPane, "bottom");
        this.mainSplitPane.setRightComponent(this.gmtSplitPane);
        this.gmtSplitPane.setLeftComponent(this.siteSplitPane);
        this.gmtSplitPane.setRightComponent(this.gmtPanel);
        this.dataSetPanel.setLayout(this.gridBagLayout1);
        this.gmtPanel.setLayout(this.gridBagLayout2);
        this.siteSplitPane.setOrientation(0);
        this.add((Component)this.mainSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 4), 274, -2));
        this.mainSplitPane.add((Component)this.dataSetPanel, "top");
        this.gmtSplitPane.add((Component)this.gmtPanel, "right");
        this.gmtSplitPane.add((Component)this.siteSplitPane, "left");
        this.siteSplitPane.add((Component)this.sitePanel, "left");
        this.siteSplitPane.add((Component)this.imlProbPanel, "right");
        this.dataSetPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(24, 8, 0, 0), 22, 4));
        this.dataSetPanel.add((Component)this.dataSetCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(24, 7, 0, 0), 65, 0));
        this.dataSetPanel.add((Component)this.dataSetText, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 8, 0, 11), 0, 369));
        this.dataSetPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(22, 16, 0, 170), 82, 1));
        this.dataSetPanel.add((Component)this.mapButton, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(11, 95, 10, 119), 50, 11));
        this.mainSplitPane.setDividerLocation(350);
        this.gmtSplitPane.setDividerLocation(190);
        this.siteSplitPane.setDividerLocation(340);
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    public static void main(String[] args) {
        STEP_MapViewerApp applet = new STEP_MapViewerApp();
        Frame frame = new Frame(){

            @Override
            protected void processWindowEvent(WindowEvent e) {
                super.processWindowEvent(e);
                if (e.getID() == 201) {
                    System.exit(0);
                }
            }

            @Override
            public synchronized void setTitle(String title) {
                super.setTitle(title);
                this.enableEvents(64L);
            }
        };
        frame.setTitle(TITLE);
        frame.add((Component)applet, "Center");
        applet.init();
        applet.start();
        frame.setSize(800, 800);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }

    private void loadDataSets() {
        try {
            File dirs = new File(STEP_DIR);
            File[] dirList = dirs.listFiles();
            if (dirList == null) {
                JOptionPane.showMessageDialog(this, NO_DATA_EXISTS);
                System.exit(0);
            }
            for (int i = 0; i < dirList.length; ++i) {
                BufferedReader in;
                FileReader dataReader;
                if (!dirList[i].isDirectory()) continue;
                Object dataSetDescription = new String();
                try {
                    dataReader = new FileReader(STEP_DIR + dirList[i].getName() + "/metadata.dat");
                    this.dataSetCombo.addItem(dirList[i].getName());
                    in = new BufferedReader(dataReader);
                    dataSetDescription = "";
                    String str = in.readLine();
                    while (str != null) {
                        dataSetDescription = (String)dataSetDescription + str + "\n";
                        str = in.readLine();
                    }
                    this.metaDataHash.put(dirList[i].getName(), dataSetDescription);
                    in.close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
                try {
                    dataReader = new FileReader(STEP_DIR + dirList[i].getName() + "/sites.dat");
                    in = new BufferedReader(dataReader);
                    String latitude = in.readLine();
                    this.latHash.put(dirList[i].getName(), latitude);
                    String longitude = in.readLine();
                    this.lonHash.put(dirList[i].getName(), longitude);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void dataSetCombo_actionPerformed(ActionEvent e) {
        this.addDataInfo();
        this.fillLatLonAndGridSpacing();
    }

    private void fillLatLonAndGridSpacing() {
        double lon;
        double lat;
        String latitude = this.latHash.get(this.dataSetCombo.getSelectedItem()).toString();
        StringTokenizer tokenizer = new StringTokenizer(latitude);
        double minLat = Double.parseDouble(tokenizer.nextToken());
        double maxLat = Double.parseDouble(tokenizer.nextToken());
        ArrayList<CallSite> minLatVector = new ArrayList<CallSite>();
        ArrayList<CallSite> maxLatVector = new ArrayList<CallSite>();
        double intervalLat = Double.parseDouble(tokenizer.nextToken());
        for (lat = minLat; lat < maxLat; lat += intervalLat) {
            minLatVector.add((CallSite)((Object)this.d.format(lat)));
        }
        for (lat = maxLat; lat > minLat; lat -= intervalLat) {
            maxLatVector.add((CallSite)((Object)this.d.format(lat)));
        }
        String longitude = this.lonHash.get(this.dataSetCombo.getSelectedItem()).toString();
        tokenizer = new StringTokenizer(longitude);
        double minLon = Double.parseDouble(tokenizer.nextToken());
        double maxLon = Double.parseDouble(tokenizer.nextToken());
        double intervalLon = Double.parseDouble(tokenizer.nextToken());
        ArrayList<CallSite> minLonVector = new ArrayList<CallSite>();
        ArrayList<CallSite> maxLonVector = new ArrayList<CallSite>();
        for (lon = minLon; lon < maxLon; lon += intervalLon) {
            minLonVector.add((CallSite)((Object)this.d.format(lon)));
        }
        for (lon = maxLon; lon > minLon; lon -= intervalLon) {
            maxLonVector.add((CallSite)((Object)this.d.format(lon)));
        }
        StringParameter minLatParam = new StringParameter(MIN_LAT_PARAM_NAME, minLatVector, (String)minLatVector.get(0));
        StringParameter maxLatParam = new StringParameter(MAX_LAT_PARAM_NAME, maxLatVector, (String)maxLatVector.get(0));
        StringParameter minLonParam = new StringParameter(MIN_LON_PARAM_NAME, minLonVector, (String)minLonVector.get(0));
        StringParameter maxLonParam = new StringParameter(MAX_LON_PARAM_NAME, maxLonVector, (String)maxLonVector.get(0));
        DoubleParameter gridSpacingParam = new DoubleParameter(GRIDSPACING_PARAM_NAME, intervalLat);
        this.sitesParamList = new ParameterList();
        this.sitesParamList.addParameter(minLatParam);
        this.sitesParamList.addParameter(maxLatParam);
        this.sitesParamList.addParameter(minLonParam);
        this.sitesParamList.addParameter(maxLonParam);
        this.sitesParamList.addParameter(gridSpacingParam);
        this.sitesEditor = new ParameterListEditor(this.sitesParamList);
        this.sitesEditor.setTitle(SITES_TITLE);
        this.sitePanel.removeAll();
        this.sitePanel.add((Component)this.sitesEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
        this.mapGuiBean.setRegionParams(minLat, maxLat, minLon, maxLon, intervalLat);
    }

    private void addDataInfo() {
        String dataSetDescription = this.metaDataHash.get(this.dataSetCombo.getSelectedItem()).toString();
        this.dataSetText.setEditable(true);
        this.dataSetText.setText(dataSetDescription);
        this.dataSetText.setEditable(false);
    }

    private void initIML_ProbGuiBean() {
        this.imlProbGuiBean = new IMLorProbSelectorGuiBean();
        this.imlProbPanel.add((Component)this.imlProbGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
    }

    private void initMapGuiBean() {
        this.mapGuiBean = new MapGuiBean();
        this.gmtPanel.add((Component)this.mapGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
        this.mapGuiBean.showRegionParams(false);
    }

    void mapButton_actionPerformed(ActionEvent e) {
        double minLat = Double.parseDouble((String)this.sitesParamList.getParameter(MIN_LAT_PARAM_NAME).getValue());
        double maxLat = Double.parseDouble((String)this.sitesParamList.getParameter(MAX_LAT_PARAM_NAME).getValue());
        double minLon = Double.parseDouble((String)this.sitesParamList.getParameter(MIN_LON_PARAM_NAME).getValue());
        double maxLon = Double.parseDouble((String)this.sitesParamList.getParameter(MAX_LON_PARAM_NAME).getValue());
        double gridSpacing = (Double)this.sitesParamList.getParameter(GRIDSPACING_PARAM_NAME).getValue();
        String selectedSet = this.dataSetCombo.getSelectedItem().toString();
        this.mapGuiBean.setRegionParams(minLat, maxLat, minLon, maxLon, gridSpacing);
        boolean isProbAt_IML = true;
        if (this.imlProbGuiBean.getSelectedOption().equalsIgnoreCase("IML@Prob")) {
            isProbAt_IML = false;
        }
        double val = this.imlProbGuiBean.getIML_Prob();
        this.mapGuiBean.makeMap(this.readAndWriteFile(minLat, maxLat, minLon, maxLon, gridSpacing, selectedSet, isProbAt_IML, val), null, "Prob", this.dataSetText.getText());
    }

    private GeoDataSet readAndWriteFile(double minLat, double maxLat, double minLon, double maxLon, double gridSpacing, String selectedSet, boolean isProbAt_IML, double val) {
        File dir = new File(STEP_DIR + selectedSet + "/");
        ArbDiscrGeoDataSet xyzData = new ArbDiscrGeoDataSet(true);
        String[] fileList = dir.list();
        DecimalFormat d = new DecimalFormat("0.00##");
        for (int i = 0; i < fileList.length; ++i) {
            if (!fileList[i].endsWith("txt")) continue;
            String lat = fileList[i].substring(0, fileList[i].indexOf("_"));
            String lon = fileList[i].substring(fileList[i].indexOf("_") + 1, fileList[i].indexOf(".txt"));
            double mLat = Double.parseDouble(lat);
            double mLon = Double.parseDouble(lon);
            double diffLat = Double.parseDouble(d.format(mLat - minLat));
            double diffLon = Double.parseDouble(d.format(mLon - minLon));
            if (!(Math.abs(Math.IEEEremainder(diffLat, gridSpacing)) < 1.0E-4) || !(Math.abs(Math.IEEEremainder(diffLon, gridSpacing)) < 1.0E-4) || !(mLat >= minLat) || !(mLat <= maxLat) || !(mLon >= minLon) || !(mLon <= maxLon)) continue;
            try {
                StringTokenizer st;
                boolean readFlag = true;
                FileReader fr = new FileReader(STEP_DIR + selectedSet + "/" + fileList[i]);
                BufferedReader bf = new BufferedReader(fr);
                String dataLine = bf.readLine();
                double prevIML = 0.0;
                double prevProb = 0.0;
                if (dataLine != null) {
                    st = new StringTokenizer(dataLine);
                    prevIML = Double.parseDouble(st.nextToken());
                    prevProb = Double.parseDouble(st.nextToken());
                }
                while (readFlag) {
                    dataLine = bf.readLine();
                    if (dataLine == null || dataLine == "" || dataLine.trim().length() == 0) {
                        readFlag = false;
                        break;
                    }
                    st = new StringTokenizer(dataLine);
                    double currentIML = Double.parseDouble(st.nextToken());
                    double currentProb = Double.parseDouble(st.nextToken());
                    if (isProbAt_IML) {
                        if (val >= prevIML && val <= currentIML || val <= prevIML && val >= currentIML) {
                            double finalProb = this.interpolateProb(val, prevIML, currentIML, prevProb, currentProb);
                            xyzData.set(new Location(mLat, mLon), Math.log(finalProb));
                            break;
                        }
                    } else if (val >= prevProb && val <= currentProb || val <= prevProb && val >= currentProb) {
                        double finalIML = this.interpolateIML(val, prevProb, currentProb, prevIML, currentIML);
                        xyzData.set(new Location(mLat, mLon), Math.log(finalIML));
                        break;
                    }
                    prevIML = currentIML;
                    prevProb = currentProb;
                }
                fr.close();
                bf.close();
                continue;
            }
            catch (IOException e) {
                System.out.println("File Not Found :" + String.valueOf(e));
            }
        }
        return xyzData;
    }

    private double interpolateProb(double iml, double x1, double x2, double y1, double y2) {
        return (iml - x1) / (x2 - x1) * (y2 - y1) + y1;
    }

    private double interpolateIML(double prob, double y1, double y2, double x1, double x2) {
        return (prob - y1) / (y2 - y1) * (x2 - x1) + x1;
    }
}

