/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import java.util.Iterator;
import java.util.List;
import org.opensha.commons.exceptions.FaultException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurfaceWithSubsets;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.SimpleFaultData;

public abstract class EvenlyGriddedSurfFromSimpleFaultData
extends AbstractEvenlyGriddedSurfaceWithSubsets {
    private static final long serialVersionUID = 1L;
    protected static final String C = "EvenlyGriddedSurfFromSimpleFaultData";
    protected static final boolean D = false;
    protected FaultTrace faultTrace;
    protected double upperSeismogenicDepth = Double.NaN;
    protected double lowerSeismogenicDepth = Double.NaN;
    protected double aveDip;

    protected EvenlyGriddedSurfFromSimpleFaultData() {
    }

    protected EvenlyGriddedSurfFromSimpleFaultData(SimpleFaultData simpleFaultData, double gridSpacing) throws FaultException {
        this(simpleFaultData.getFaultTrace(), simpleFaultData.getAveDip(), simpleFaultData.getUpperSeismogenicDepth(), simpleFaultData.getLowerSeismogenicDepth(), gridSpacing);
    }

    protected EvenlyGriddedSurfFromSimpleFaultData(FaultTrace faultTrace, double aveDip, double upperSeismogenicDepth, double lowerSeismogenicDepth, double gridSpacing) throws FaultException {
        this.set(faultTrace, aveDip, upperSeismogenicDepth, lowerSeismogenicDepth, gridSpacing, gridSpacing);
    }

    protected EvenlyGriddedSurfFromSimpleFaultData(List<SimpleFaultData> simpleFaultDataList, double gridSpacing) {
        this(SimpleFaultData.getCombinedSimpleFaultData(simpleFaultDataList), gridSpacing);
    }

    protected EvenlyGriddedSurfFromSimpleFaultData(SimpleFaultData simpleFaultData, double maxGridSpacingAlong, double maxGridSpacingDown) throws FaultException {
        this(simpleFaultData.getFaultTrace(), simpleFaultData.getAveDip(), simpleFaultData.getUpperSeismogenicDepth(), simpleFaultData.getLowerSeismogenicDepth(), maxGridSpacingAlong, maxGridSpacingDown);
    }

    protected EvenlyGriddedSurfFromSimpleFaultData(FaultTrace faultTrace, double aveDip, double upperSeismogenicDepth, double lowerSeismogenicDepth, double maxGridSpacingAlong, double maxGridSpacingDown) throws FaultException {
        double length = faultTrace.getTraceLength();
        double gridSpacingAlong = length / Math.ceil(length / maxGridSpacingAlong);
        double downDipWidth = (lowerSeismogenicDepth - upperSeismogenicDepth) / Math.sin(aveDip * Math.PI / 180.0);
        double gridSpacingDown = downDipWidth / Math.ceil(downDipWidth / maxGridSpacingDown);
        this.set(faultTrace, aveDip, upperSeismogenicDepth, lowerSeismogenicDepth, gridSpacingAlong, gridSpacingDown);
    }

    protected EvenlyGriddedSurfFromSimpleFaultData(List<SimpleFaultData> simpleFaultDataList, double maxGridSpacingAlong, double maxGridSpacingDown) {
        this(SimpleFaultData.getCombinedSimpleFaultData(simpleFaultDataList), maxGridSpacingAlong, maxGridSpacingDown);
    }

    protected void set(FaultTrace faultTrace, double aveDip, double upperSeismogenicDepth, double lowerSeismogenicDepth, double gridSpacingAlong, double gridSpacingDown) {
        this.faultTrace = faultTrace;
        this.aveDip = aveDip;
        this.upperSeismogenicDepth = upperSeismogenicDepth;
        this.lowerSeismogenicDepth = lowerSeismogenicDepth;
        this.gridSpacingAlong = gridSpacingAlong;
        this.gridSpacingDown = gridSpacingDown;
        this.sameGridSpacing = true;
        if (gridSpacingDown != gridSpacingAlong) {
            this.sameGridSpacing = false;
        }
    }

    public FaultTrace getFaultTrace() {
        return this.faultTrace;
    }

    public double getUpperSeismogenicDepth() {
        return this.upperSeismogenicDepth;
    }

    public double getLowerSeismogenicDepth() {
        return this.lowerSeismogenicDepth;
    }

    protected void assertValidData() throws FaultException {
        if (this.faultTrace == null) {
            throw new FaultException("EvenlyGriddedSurfFromSimpleFaultDataFault Trace is null");
        }
        FaultUtils.assertValidDip(this.aveDip);
        FaultUtils.assertValidSeisUpperAndLower(this.upperSeismogenicDepth, this.lowerSeismogenicDepth);
        if (this.gridSpacingAlong == Double.NaN) {
            throw new FaultException("EvenlyGriddedSurfFromSimpleFaultDatainvalid gridSpacing");
        }
        double depth = ((Location)this.faultTrace.get(0)).getDepth();
        if (depth > this.upperSeismogenicDepth) {
            throw new FaultException("EvenlyGriddedSurfFromSimpleFaultData depth on faultTrace (" + this.faultTrace.getName() + ") locations must be < upperSeisDepth; depth=" + depth + "; upperSeismogenicDepth=" + this.upperSeismogenicDepth);
        }
        Iterator it = this.faultTrace.iterator();
        while (it.hasNext()) {
            if (((Location)it.next()).getDepth() == depth) continue;
            throw new FaultException("EvenlyGriddedSurfFromSimpleFaultData:All depth on faultTrace locations must be equal");
        }
    }

    @Override
    public double getAveDip() {
        return this.aveDip;
    }

    @Override
    public double getAveRupTopDepth() {
        return this.upperSeismogenicDepth;
    }

    @Override
    public double getAveStrike() {
        return this.faultTrace.getAveStrike();
    }

    @Override
    public FaultTrace getUpperEdge() {
        double aveTraceDepth = 0.0;
        for (Location loc : this.faultTrace) {
            aveTraceDepth += loc.getDepth();
        }
        double diff = Math.abs((aveTraceDepth /= (double)this.faultTrace.size()) - this.upperSeismogenicDepth);
        if (diff < 0.001) {
            return this.faultTrace;
        }
        throw new RuntimeException(" method not yet implemented where depths in the trace differ from upperSeismogenicDepth (and projecting will cleate loops for FrankelGriddedSurface projections; aveTraceDepth=" + aveTraceDepth + "\tupperSeismogenicDepth=" + this.upperSeismogenicDepth);
    }
}

