/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.opensha.commons.data.Named;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.util.FaultUtils;

public class FaultTrace
extends LocationList
implements Named {
    private static final long serialVersionUID = 1L;
    private String faultName;

    public FaultTrace(String faultName, int initialCapacity) {
        super(initialCapacity);
        this.faultName = faultName;
    }

    public FaultTrace(String faultName) {
        this.faultName = faultName;
    }

    public void setName(String faultName) {
        this.faultName = faultName;
    }

    @Override
    public String getName() {
        return this.faultName;
    }

    public int getNumLocations() {
        return this.size();
    }

    public double getTraceLength() {
        double totLength = 0.0;
        Iterator it = this.iterator();
        Location lastLoc = (Location)it.next();
        Location loc = null;
        while (it.hasNext()) {
            loc = (Location)it.next();
            totLength += LocationUtils.horzDistance(lastLoc, loc);
            lastLoc = loc;
        }
        return totLength;
    }

    public double getAveStrike() {
        ArrayList<Double> azimuths = new ArrayList<Double>();
        for (int i = 1; i < this.size(); ++i) {
            azimuths.add(LocationUtils.azimuth((Location)this.get(i - 1), (Location)this.get(i)));
        }
        return FaultUtils.getLengthBasedAngleAverage(this, azimuths);
    }

    public double getStrikeDirection() {
        return LocationUtils.azimuth((Location)this.get(0), (Location)this.get(this.size() - 1));
    }

    public double getDipDirection() {
        double dipDir;
        for (dipDir = this.getStrikeDirection() + 90.0; dipDir > 360.0; dipDir -= 360.0) {
        }
        return dipDir;
    }

    public double getStrikeDirectionDifference(FaultTrace trace) {
        double diff = trace.getStrikeDirection() - this.getStrikeDirection();
        if (diff > 180.0) {
            return diff - 360.0;
        }
        if (diff < -180.0) {
            return diff + 360.0;
        }
        return diff;
    }

    public double getMinDistance(FaultTrace faultTrace, double discrInterval) {
        double minFaultTraceDist = Double.POSITIVE_INFINITY;
        int num = (int)(faultTrace.getTraceLength() / discrInterval) + 1;
        FaultTrace discrFaultTrace = FaultUtils.resampleTrace(faultTrace, num);
        for (int i = 0; i < discrFaultTrace.getNumLocations(); ++i) {
            double dist = this.minDistToLine((Location)discrFaultTrace.get(i));
            if (!(dist < minFaultTraceDist)) continue;
            minFaultTraceDist = dist;
        }
        return minFaultTraceDist;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer().append("Fault Trace: ").append(this.faultName).append(IOUtils.LINE_SEPARATOR).append("       size: ").append(this.size()).append(IOUtils.LINE_SEPARATOR).append("Locations: ");
        for (Location loc : this) {
            b.append(loc).append(IOUtils.LINE_SEPARATOR).append("           ");
        }
        return b.toString();
    }

    @Override
    public FaultTrace clone() {
        FaultTrace trace = new FaultTrace(this.getName());
        for (Location loc : this) {
            trace.add(loc);
        }
        return trace;
    }
}

