/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import org.dom4j.Element;
import org.opensha.commons.geo.Location;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;

public class GriddedSurfaceImpl
extends AbstractEvenlyGriddedSurface
implements XMLSaveable {
    public static String XML_METADATA_NAME = "GriddedSurfaceImpl";
    private static final long serialVersionUID = 1L;

    public GriddedSurfaceImpl(int numRows, int numCols, double gridSpacing) {
        super(numRows, numCols, gridSpacing);
    }

    public void setLocation(int row, int column, Location location) {
        this.set(row, column, location);
    }

    @Override
    public double getAveDip() throws UnsupportedOperationException {
        throw new RuntimeException("Method not yet supported (need to implement computation)");
    }

    @Override
    public double getAveStrike() throws UnsupportedOperationException {
        return this.getRowAsTrace(0).getAveStrike();
    }

    @Override
    public double getAveDipDirection() {
        throw new RuntimeException("Method not yet supported (need to implement computation)");
    }

    @Override
    public double getAveRupTopDepth() {
        double dep = 0.0;
        FaultTrace trace = this.getRowAsTrace(0);
        for (Location loc : trace) {
            dep += loc.getDepth();
        }
        return dep / (double)trace.size();
    }

    @Override
    protected AbstractEvenlyGriddedSurface getNewInstance() {
        return new GriddedSurfaceImpl(this.numRows, this.numCols, this.getGridSpacingAlongStrike());
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element el = root.addElement(XML_METADATA_NAME);
        el.addAttribute("rows", "" + this.getNumRows());
        el.addAttribute("cols", "" + this.getNumCols());
        el.addAttribute("gridSpacing", "" + this.getAveGridSpacing());
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int col = 0; col < this.getNumCols(); ++col) {
                Element pointEl = el.addElement("Point");
                pointEl.addAttribute("row", "" + row);
                pointEl.addAttribute("col", "" + col);
                this.getLocation(row, col).toXMLMetadata(pointEl);
            }
        }
        return root;
    }

    public static GriddedSurfaceImpl fromXMLMetadata(Element el) {
        int rows = Integer.parseInt(el.attributeValue("rows"));
        int cols = Integer.parseInt(el.attributeValue("cols"));
        double gridSpacing = Double.parseDouble(el.attributeValue("gridSpacing"));
        GriddedSurfaceImpl surf = new GriddedSurfaceImpl(rows, cols, gridSpacing);
        for (Element pointEl : XMLUtils.getSubElementsList(el, "Point")) {
            int row = Integer.parseInt(pointEl.attributeValue("row"));
            int col = Integer.parseInt(pointEl.attributeValue("col"));
            Location loc = Location.fromXMLMetadata(pointEl.element("Location"));
            surf.set(row, col, loc);
        }
        return surf;
    }
}

