/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;

public class InterpolatedEvenlyGriddedSurface
extends AbstractEvenlyGriddedSurface {
    private EvenlyGriddedSurface loResSurf;
    private int discrRowPnts;
    private int discrColPnts;
    private static final int maxCacheSize = 5000;
    private LoadingCache<IDPairing, Location> locCache;

    public InterpolatedEvenlyGriddedSurface(EvenlyGriddedSurface loResSurf, double hiResSpacing) {
        this(loResSurf, hiResSpacing, hiResSpacing);
    }

    public InterpolatedEvenlyGriddedSurface(EvenlyGriddedSurface loResSurf, double hiResRowSpacing, double hiResColSpacing) {
        this.loResSurf = loResSurf;
        Preconditions.checkArgument(((float)loResSurf.getGridSpacingAlongStrike() > (float)hiResColSpacing ? 1 : 0) != 0);
        double discrPntsDouble = loResSurf.getGridSpacingAlongStrike() / hiResColSpacing;
        Preconditions.checkState(((float)discrPntsDouble == (float)Math.floor(discrPntsDouble) ? 1 : 0) != 0, (Object)"can't evenly divide los res spacing by high res spacing");
        this.discrColPnts = (int)discrPntsDouble;
        Preconditions.checkArgument(((float)loResSurf.getGridSpacingDownDip() >= (float)hiResRowSpacing ? 1 : 0) != 0);
        discrPntsDouble = loResSurf.getGridSpacingDownDip() / hiResRowSpacing;
        Preconditions.checkState(((float)discrPntsDouble == (float)Math.floor(discrPntsDouble) ? 1 : 0) != 0, (Object)"can't evenly divide los res spacing by high res spacing");
        this.discrRowPnts = (int)discrPntsDouble;
        int origRows = loResSurf.getNumRows();
        int origCols = loResSurf.getNumCols();
        this.numRows = (origRows - 1) * this.discrRowPnts + 1;
        this.numCols = (origCols - 1) * this.discrColPnts + 1;
        this.size = (long)this.numRows * (long)this.numCols;
        this.data = null;
        this.gridSpacingAlong = hiResColSpacing;
        this.gridSpacingDown = hiResRowSpacing;
        this.sameGridSpacing = (float)hiResColSpacing == (float)hiResRowSpacing;
        this.locCache = CacheBuilder.newBuilder().maximumSize(5000L).build((CacheLoader)new LocCacheLoader());
    }

    public EvenlyGriddedSurface getLowResSurface() {
        return this.loResSurf;
    }

    @Override
    public double getAveStrike() {
        return this.loResSurf.getAveStrike();
    }

    @Override
    public double getAveRupTopDepth() {
        return this.loResSurf.getAveRupTopDepth();
    }

    @Override
    public double getAveDipDirection() {
        return this.loResSurf.getAveDipDirection();
    }

    @Override
    public double getAveDip() {
        return this.loResSurf.getAveDip();
    }

    @Override
    public Location get(int row, int column) {
        try {
            return (Location)this.locCache.get((Object)new IDPairing(row, column));
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    @Override
    protected AbstractEvenlyGriddedSurface getNewInstance() {
        throw new UnsupportedOperationException("Not supported for Interpolated Surface");
    }

    private class LocCacheLoader
    extends CacheLoader<IDPairing, Location> {
        private LocCacheLoader() {
        }

        public Location load(IDPairing pair) throws Exception {
            double depthDelta;
            double vertAz;
            double vertDist;
            double horzAz;
            double horzDist;
            int row = pair.getID1();
            int column = pair.getID2();
            int origRow = row / InterpolatedEvenlyGriddedSurface.this.discrRowPnts;
            int origCol = column / InterpolatedEvenlyGriddedSurface.this.discrColPnts;
            int rowI = row % InterpolatedEvenlyGriddedSurface.this.discrRowPnts;
            int colI = column % InterpolatedEvenlyGriddedSurface.this.discrColPnts;
            Location topLeftLoc = (Location)InterpolatedEvenlyGriddedSurface.this.loResSurf.get(origRow, origCol);
            if (origCol + 1 == InterpolatedEvenlyGriddedSurface.this.loResSurf.getNumCols()) {
                horzDist = 0.0;
                horzAz = 0.0;
            } else {
                Location topRightLoc = (Location)InterpolatedEvenlyGriddedSurface.this.loResSurf.get(origRow, origCol + 1);
                horzDist = LocationUtils.horzDistance(topLeftLoc, topRightLoc);
                horzAz = LocationUtils.azimuthRad(topLeftLoc, topRightLoc);
            }
            if (origRow + 1 == InterpolatedEvenlyGriddedSurface.this.loResSurf.getNumRows()) {
                vertDist = 0.0;
                vertAz = 0.0;
                depthDelta = 0.0;
            } else {
                Location botLeftLoc = (Location)InterpolatedEvenlyGriddedSurface.this.loResSurf.get(origRow + 1, origCol);
                vertDist = LocationUtils.horzDistance(topLeftLoc, botLeftLoc);
                vertAz = LocationUtils.azimuthRad(topLeftLoc, botLeftLoc);
                depthDelta = botLeftLoc.getDepth() - topLeftLoc.getDepth();
            }
            double relativeVertPos = (double)rowI / (double)InterpolatedEvenlyGriddedSurface.this.discrRowPnts;
            double relativeHorzPos = (double)colI / (double)InterpolatedEvenlyGriddedSurface.this.discrColPnts;
            Location loc = topLeftLoc;
            loc = LocationUtils.location(loc, horzAz, horzDist * relativeHorzPos);
            if ((float)vertDist > 0.0f) {
                loc = LocationUtils.location(loc, vertAz, vertDist * relativeVertPos);
            }
            return new Location(loc.getLatitude(), loc.getLongitude(), loc.getDepth() + depthDelta * relativeVertPos);
        }
    }
}

