/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ListIterator;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.utils.GriddedSurfaceUtils;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrection;

public class PointSurface
implements RuptureSurface,
Serializable {
    private static final long serialVersionUID = 1L;
    private Location pointLocation;
    static final double SEIS_DEPTH = 3.0;
    protected double magForDistCorr = Double.NaN;
    protected PointSourceDistanceCorrection distCorr = null;
    protected double aveStrike = Double.NaN;
    protected double aveDip = Double.NaN;
    protected double aveWidth = 0.0;
    protected String name;

    public PointSurface(double lat, double lon, double depth) {
        this(new Location(lat, lon, depth));
    }

    public PointSurface(Location loc) {
        this.setLocation(loc);
    }

    public PointSurface() {
        this.setLocation(null);
    }

    public void setAveStrike(double aveStrike) throws InvalidRangeException {
        FaultUtils.assertValidStrike(aveStrike);
        this.aveStrike = aveStrike;
    }

    @Override
    public double getAveStrike() {
        return this.aveStrike;
    }

    public void setAveDip(double aveDip) throws InvalidRangeException {
        FaultUtils.assertValidDip(aveDip);
        this.aveDip = aveDip;
    }

    @Override
    public double getAveDip() {
        return this.aveDip;
    }

    public void setLocation(Location location) {
        this.pointLocation = location;
    }

    public double getDepth() {
        return this.pointLocation.getDepth();
    }

    public void setDepth(double depth) {
        Location newLocation = new Location(this.pointLocation.getLatitude(), this.pointLocation.getLongitude(), depth);
        this.setLocation(newLocation);
    }

    public Location getLocation() {
        return this.pointLocation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getSurfaceMetadata() {
        String surfaceMetadata = (float)this.aveDip + "\t";
        surfaceMetadata = surfaceMetadata + (float)this.getAveLength() + "\t";
        surfaceMetadata = surfaceMetadata + (float)this.getAveWidth() + "\t";
        surfaceMetadata = surfaceMetadata + "NaN\t";
        surfaceMetadata = surfaceMetadata + "1\t";
        surfaceMetadata = surfaceMetadata + "1\t";
        surfaceMetadata = surfaceMetadata + "1\n";
        surfaceMetadata = surfaceMetadata + "#Surface locations (Lat Lon Depth) \n";
        surfaceMetadata = surfaceMetadata + (float)this.pointLocation.getLatitude() + "\t";
        surfaceMetadata = surfaceMetadata + (float)this.pointLocation.getLongitude() + "\t";
        surfaceMetadata = surfaceMetadata + (float)this.pointLocation.getDepth();
        return surfaceMetadata;
    }

    @Override
    public double getAveDipDirection() {
        throw new RuntimeException("Method not yet implemented");
    }

    @Override
    public double getAveRupTopDepth() {
        return this.pointLocation.getDepth();
    }

    @Override
    public LocationList getPerimeter() {
        return this.getEvenlyDiscritizedPerimeter();
    }

    private FaultTrace getFaultTrace() {
        FaultTrace trace = new FaultTrace(null);
        trace.add(this.pointLocation);
        return trace;
    }

    @Override
    public FaultTrace getUpperEdge() {
        return this.getFaultTrace();
    }

    public void setDistanceCorrection(PointSourceDistanceCorrection correction, EqkRupture rupture) {
        this.setDistanceCorrection(correction, rupture.getMag());
    }

    public void setDistanceCorrection(PointSourceDistanceCorrection correction, double mag) {
        Preconditions.checkState((this.distCorr == null || Double.isFinite(mag) ? 1 : 0) != 0, (Object)"Magnitude must be finite if a distance correction is supplied");
        this.distCorr = correction;
        this.magForDistCorr = mag;
    }

    public PointSourceDistanceCorrection getDistanceCorrection() {
        return this.distCorr;
    }

    @Override
    public double getDistanceRup(Location siteLoc) {
        double depth = this.getDepth();
        double djb = this.getDistanceJB(siteLoc);
        return Math.sqrt(depth * depth + djb * djb);
    }

    @Override
    public double getDistanceJB(Location siteLoc) {
        double horzDist = LocationUtils.horzDistanceFast(this.pointLocation, siteLoc);
        if (this.distCorr == null) {
            return horzDist;
        }
        return this.distCorr.getCorrectedDistanceJB(this.magForDistCorr, this, horzDist);
    }

    @Override
    public double getDistanceSeis(Location siteLoc) {
        double depth = Math.max(3.0, this.pointLocation.getDepth());
        double djb = this.getDistanceJB(siteLoc);
        return Math.sqrt(depth * depth + djb * djb);
    }

    @Override
    public double getQuickDistance(Location siteLoc) {
        return LocationUtils.horzDistanceFast(this.pointLocation, siteLoc);
    }

    @Override
    public double getDistanceX(Location siteLoc) {
        return 0.0;
    }

    @Override
    public String getInfo() {
        return new String("\tPoint-Surface Location (lat, lon, depth (km):\n\n\t\t" + (float)this.pointLocation.getLatitude() + ", " + (float)this.pointLocation.getLongitude() + ", " + (float)this.pointLocation.getDepth());
    }

    @Override
    public boolean isPointSurface() {
        return true;
    }

    @Override
    public double getArea() {
        return 0.0;
    }

    @Override
    public double getAreaInsideRegion(Region region) {
        return 0.0;
    }

    @Override
    public double getAveGridSpacing() {
        return 0.0;
    }

    @Override
    public double getAveLength() {
        return 0.0;
    }

    public void setAveWidth(double aveWidth) {
        this.aveWidth = aveWidth;
    }

    @Override
    public double getAveWidth() {
        return this.aveWidth;
    }

    private LocationList getLocationList() {
        LocationList list = new LocationList();
        list.add(this.pointLocation);
        return list;
    }

    @Override
    public LocationList getEvenlyDiscritizedListOfLocsOnSurface() {
        return this.getLocationList();
    }

    @Override
    public LocationList getEvenlyDiscritizedPerimeter() {
        return this.getLocationList();
    }

    @Override
    public FaultTrace getEvenlyDiscritizedUpperEdge() {
        return this.getFaultTrace();
    }

    @Override
    public LocationList getEvenlyDiscritizedLowerEdge() {
        return this.getLocationList();
    }

    @Override
    public Location getFirstLocOnUpperEdge() {
        return this.pointLocation;
    }

    @Override
    public Location getLastLocOnUpperEdge() {
        return this.pointLocation;
    }

    @Override
    public double getFractionOfSurfaceInRegion(Region region) {
        if (region.contains(this.pointLocation)) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public ListIterator<Location> getLocationsIterator() {
        return this.getLocationList().listIterator();
    }

    @Override
    public double getMinDistance(RuptureSurface surface) {
        return GriddedSurfaceUtils.getMinDistanceBetweenSurfaces(surface, this);
    }

    public static void main(String[] args) {
    }

    @Override
    public PointSurface getMoved(LocationVector v) {
        PointSurface moved = this.copyShallow();
        moved.setLocation(LocationUtils.location(moved.getLocation(), v));
        return moved;
    }

    @Override
    public PointSurface copyShallow() {
        PointSurface o = new PointSurface(this.pointLocation);
        o.distCorr = this.distCorr;
        o.aveStrike = this.aveStrike;
        o.aveDip = this.aveDip;
        o.aveWidth = this.aveWidth;
        o.name = this.name;
        return o;
    }
}

