/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.faultSurface.GriddedSubsetSurface;
import org.opensha.sha.faultSurface.RuptureSurface;

public class GriddedSurfaceUtils {
    protected static final String C = "GriddedSurfaceUtils";
    protected static final boolean D = false;
    public static final double SEIS_DEPTH = 3.0;

    public static double[] getPropagationDistances(EvenlyGriddedSurface surface, Location loc) {
        ListIterator<Location> it;
        Location loc1 = loc;
        double distJB = Double.MAX_VALUE;
        double distSeis = Double.MAX_VALUE;
        double distRup = Double.MAX_VALUE;
        boolean projectToDepth = false;
        if (surface.getNumRows() == 1 && surface.getLocation(0, 0).getDepth() < 3.0) {
            projectToDepth = true;
        }
        try {
            if (surface.getAveDip() > 89.0) {
                it = surface.getColumnIterator(0);
                if (surface.getLocation(0, 0).getDepth() < 3.0) {
                    projectToDepth = true;
                }
            } else {
                it = surface.getLocationsIterator();
            }
        }
        catch (RuntimeException e) {
            it = surface.getLocationsIterator();
        }
        while (it.hasNext()) {
            double rupDist;
            Location loc2 = it.next();
            double vertDist = LocationUtils.vertDistance(loc1, loc2);
            double horzDist = LocationUtils.horzDistanceFast(loc1, loc2);
            if (horzDist < distJB) {
                distJB = horzDist;
            }
            if ((rupDist = horzDist * horzDist + vertDist * vertDist) < distRup) {
                distRup = rupDist;
            }
            if (loc2.getDepth() >= 3.0) {
                if (!(rupDist < distSeis)) continue;
                distSeis = rupDist;
                continue;
            }
            if (!projectToDepth || !((rupDist = horzDist * horzDist + 9.0) < distSeis)) continue;
            distSeis = rupDist;
        }
        distRup = Math.pow(distRup, 0.5);
        distSeis = Math.pow(distSeis, 0.5);
        if (distJB < surface.getAveGridSpacing()) {
            boolean frankelTypeSurface = false;
            if (surface instanceof FrankelGriddedSurface) {
                frankelTypeSurface = true;
            } else if (surface instanceof GriddedSubsetSurface && ((GriddedSubsetSurface)surface).getParentSurface() instanceof FrankelGriddedSurface) {
                frankelTypeSurface = true;
            }
            if (frankelTypeSurface) {
                if (GriddedSurfaceUtils.isDjbZeroFrankel(surface, distJB)) {
                    distJB = 0.0;
                }
            } else if (GriddedSurfaceUtils.isDjbZero(surface.getPerimeter(), loc)) {
                distJB = 0.0;
            }
        }
        double[] results = new double[]{distRup, distJB, distSeis};
        return results;
    }

    public static double getDistanceX_old(FaultTrace trace, Location siteLoc) {
        double distanceX;
        if (trace.size() == 1) {
            distanceX = 0.0;
        } else {
            Location firstTraceLoc = (Location)trace.get(0);
            Location lastTraceLoc = (Location)trace.get(trace.size() - 1);
            LocationVector dir = LocationUtils.vector(lastTraceLoc, firstTraceLoc);
            dir.setHorzDistance(1000.0);
            dir.setVertDistance(0.0);
            Location projectedLoc1 = LocationUtils.location(firstTraceLoc, dir);
            dir.setAzimuth(dir.getAzimuth() + 180.0);
            Location projectedLoc2 = LocationUtils.location(lastTraceLoc, dir);
            dir.setAzimuth(dir.getAzimuth() + 90.0);
            Location projectedLoc3 = LocationUtils.location(projectedLoc1, dir);
            Location projectedLoc4 = LocationUtils.location(projectedLoc2, dir);
            LocationList locsForExtendedTrace = new LocationList();
            LocationList locsForRegion = new LocationList();
            locsForExtendedTrace.add(projectedLoc1);
            locsForRegion.add(projectedLoc1);
            for (int c = 0; c < trace.size(); ++c) {
                locsForExtendedTrace.add((Location)trace.get(c));
                locsForRegion.add((Location)trace.get(c));
            }
            locsForExtendedTrace.add(projectedLoc2);
            locsForRegion.add(projectedLoc2);
            locsForRegion.add(projectedLoc4);
            locsForRegion.add(projectedLoc3);
            Region polygon = null;
            try {
                polygon = new Region(locsForRegion, BorderType.MERCATOR_LINEAR);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("==== trace  ====");
                System.out.println(trace);
                System.out.println("==== region ====");
                System.out.println(locsForRegion);
            }
            boolean isInside = polygon.contains(siteLoc);
            double distToExtendedTrace = locsForExtendedTrace.minDistToLine(siteLoc);
            distanceX = isInside || distToExtendedTrace == 0.0 ? distToExtendedTrace : -distToExtendedTrace;
        }
        return distanceX;
    }

    public static double getDistanceX(FaultTrace trace, Location siteLoc) {
        if (trace.size() == 1) {
            return 0.0;
        }
        Location traceStart = trace.first();
        Location traceEnd = trace.last();
        double latRefRad = 0.5 * siteLoc.getLatRad() + 0.25 * traceStart.getLatRad() + 0.25 * traceEnd.getLatRad();
        double lonRefRad = 0.5 * siteLoc.getLonRad() + 0.25 * traceStart.getLonRad() + 0.25 * traceEnd.getLonRad();
        double lonScale = Math.cos(latRefRad);
        double[] traceX = new double[trace.size()];
        double[] traceY = new double[traceX.length];
        for (int i = 0; i < traceX.length; ++i) {
            Location loc = (Location)trace.get(i);
            traceX[i] = (loc.getLonRad() - lonRefRad) * lonScale;
            traceY[i] = loc.getLatRad() - latRefRad;
        }
        double siteX = (siteLoc.getLonRad() - lonRefRad) * lonScale;
        double siteY = siteLoc.getLatRad() - latRefRad;
        double[] angularSegDistsSq = new double[trace.size() - 1];
        double minAngularSegDistSq = Double.POSITIVE_INFINITY;
        int minSegDistIndex = -1;
        for (int i = 0; i < angularSegDistsSq.length; ++i) {
            angularSegDistsSq[i] = Line2D.ptSegDistSq(traceX[i], traceY[i], traceX[i + 1], traceY[i + 1], siteX, siteY);
            if (!(angularSegDistsSq[i] < minAngularSegDistSq)) continue;
            minAngularSegDistSq = angularSegDistsSq[i];
            minSegDistIndex = i;
        }
        double minSegDist = Math.sqrt(minAngularSegDistSq) * 6371.0072;
        double x0 = traceX[0];
        double y0 = traceY[0];
        double xN = traceX[traceX.length - 1];
        double yN = traceY[traceY.length - 1];
        double dxAll = xN - x0;
        double dyAll = yN - y0;
        double lenSqAll = dxAll * dxAll + dyAll * dyAll;
        double sx = siteX - x0;
        double sy = siteY - y0;
        double dotAll = dxAll * sx + dyAll * sy;
        if (dotAll < 0.0 || dotAll > lenSqAll) {
            boolean backwards = dotAll < 0.0;
            double azRad = LocationUtils.azimuthRad(traceStart, traceEnd);
            if (backwards) {
                return GriddedSurfaceUtils.calcExtendedDistanceX(traceStart, siteLoc, azRad + Math.PI, minSegDist, minAngularSegDistSq, true);
            }
            return GriddedSurfaceUtils.calcExtendedDistanceX(traceEnd, siteLoc, azRad, minSegDist, minAngularSegDistSq, false);
        }
        boolean leftOfClosest = GriddedSurfaceUtils.cross2D(traceX[minSegDistIndex + 1] - traceX[minSegDistIndex], traceY[minSegDistIndex + 1] - traceY[minSegDistIndex], siteX - traceX[minSegDistIndex], siteY - traceY[minSegDistIndex]) > 0.0;
        double checkPrecision = 1.0E-10;
        int equidistantIndex = -1;
        if (minSegDistIndex > 0 && Precision.equals((double)angularSegDistsSq[minSegDistIndex], (double)angularSegDistsSq[minSegDistIndex - 1], (double)checkPrecision)) {
            equidistantIndex = minSegDistIndex - 1;
        } else if (minSegDistIndex < angularSegDistsSq.length - 1 && Precision.equals((double)angularSegDistsSq[minSegDistIndex], (double)angularSegDistsSq[minSegDistIndex + 1], (double)checkPrecision)) {
            equidistantIndex = minSegDistIndex + 1;
        }
        if (equidistantIndex >= 0) {
            boolean leftOfEquidistant;
            boolean bl = leftOfEquidistant = GriddedSurfaceUtils.cross2D(traceX[equidistantIndex + 1] - traceX[equidistantIndex], traceY[equidistantIndex + 1] - traceY[equidistantIndex], siteX - traceX[equidistantIndex], siteY - traceY[equidistantIndex]) > 0.0;
            if (leftOfClosest != leftOfEquidistant) {
                boolean leftAfter;
                boolean leftBefore;
                if (equidistantIndex < minSegDistIndex) {
                    leftBefore = leftOfEquidistant;
                    leftAfter = leftOfClosest;
                } else {
                    leftBefore = leftOfClosest;
                    leftAfter = leftOfEquidistant;
                }
                int firstMatchIndex = Integer.min(equidistantIndex, minSegDistIndex);
                double xBefore = traceX[firstMatchIndex];
                double yBefore = traceY[firstMatchIndex];
                double xCorner = traceX[firstMatchIndex + 1];
                double yCorner = traceY[firstMatchIndex + 1];
                double xAfter = traceX[firstMatchIndex + 2];
                double yAfter = traceY[firstMatchIndex + 2];
                double bx = xBefore - xCorner;
                double by = yBefore - yCorner;
                double ax = xAfter - xCorner;
                double ay = yAfter - yCorner;
                double bLen = Math.hypot(bx, by);
                double aLen = Math.hypot(ax, ay);
                if (bLen < 1.0E-12 || aLen < 1.0E-12) {
                    leftOfClosest = leftBefore;
                } else {
                    double cross;
                    double wLen;
                    double bxn = bx / bLen;
                    double byn = by / bLen;
                    double axn = ax / aLen;
                    double ayn = ay / aLen;
                    double crossBA = GriddedSurfaceUtils.cross2D(bx, by, ax, ay);
                    double wx = bxn + axn;
                    double wy = byn + ayn;
                    if (crossBA < 0.0) {
                        wx = -wx;
                        wy = -wy;
                    }
                    leftOfClosest = (wLen = Math.hypot(wx, wy)) < 1.0E-12 ? leftAfter : ((cross = GriddedSurfaceUtils.cross2D(wx, wy, sx = siteX - xCorner, sy = siteY - yCorner)) < 0.0 ? leftBefore : leftAfter);
                }
            }
        }
        if (leftOfClosest) {
            return -minSegDist;
        }
        return minSegDist;
    }

    private static double calcExtendedDistanceX(Location startLoc, Location siteLoc, double azimuthRad, double distToEnd, double angularDistToEndSq, boolean backwards) {
        double siteY;
        double siteX;
        double y2;
        double x2;
        double y1;
        double latRefRad;
        double lonScale;
        double lat1 = startLoc.getLatRad();
        double lon1 = startLoc.getLonRad();
        double sinLat1 = Math.sin(lat1);
        double cosLat1 = Math.cos(lat1);
        double siteLat = siteLoc.getLatRad();
        double siteLon = siteLoc.getLonRad();
        double dSiteLon = siteLon - lon1;
        double sinSiteLat = Math.sin(siteLat);
        double cosSiteLat = Math.cos(siteLat);
        double siteAz = Math.atan2(Math.sin(dSiteLon) * cosSiteLat, cosLat1 * sinSiteLat - Math.sin(lat1) * cosSiteLat * Math.cos(dSiteLon));
        siteAz = (siteAz + Math.PI * 2) % (Math.PI * 2);
        double diff = siteAz - azimuthRad;
        if ((diff = (diff + Math.PI) % (Math.PI * 2)) < 0.0) {
            diff += Math.PI * 2;
        }
        double destDist = Math.max(10.0, distToEnd * Math.cos(diff -= Math.PI));
        double ad = destDist / 6371.0072;
        double sinD = Math.sin(ad);
        double cosD = Math.cos(ad);
        double lat2 = Math.asin(sinLat1 * cosD + cosLat1 * sinD * Math.cos(azimuthRad));
        double lon2 = lon1 + Math.atan2(Math.sin(azimuthRad) * sinD * cosLat1, cosD - sinLat1 * Math.sin(lat2));
        double lonRefRad = 0.5 * (lon2 + siteLon);
        double x1 = (lon1 - lonRefRad) * (lonScale = Math.cos(latRefRad = 0.5 * (lat2 + siteLat)));
        double angularDistSq = Line2D.ptLineDistSq(x1, y1 = lat1 - latRefRad, x2 = (lon2 - lonRefRad) * lonScale, y2 = lat2 - latRefRad, siteX = (siteLon - lonRefRad) * lonScale, siteY = siteLat - latRefRad);
        double dist = angularDistSq < angularDistToEndSq ? Math.sqrt(angularDistSq) * 6371.0072 : distToEnd;
        double cross = GriddedSurfaceUtils.cross2D(x2 - x1, y2 - y1, siteX, siteY);
        if (cross > 0.0) {
            dist = -dist;
        }
        if (backwards) {
            dist = -dist;
        }
        return dist;
    }

    private static double cross2D(double ax, double ay, double bx, double by) {
        return ax * by - ay * bx;
    }

    public static double getDistanceY0(FaultTrace trace, Location siteLoc) {
        return Math.abs(GriddedSurfaceUtils.getDistanceY(trace, siteLoc));
    }

    public static double getDistanceY(FaultTrace trace, Location siteLoc) {
        double traceVectorAz;
        double endSiteAz;
        Location p1;
        Location p0;
        double distToLast;
        if (trace.size() == 1) {
            return 0.0;
        }
        Location firstTraceLoc = trace.first();
        Location lastTraceLoc = trace.last();
        double distToFirst = LocationUtils.horzDistanceFast(firstTraceLoc, siteLoc);
        if (distToFirst < (distToLast = LocationUtils.horzDistanceFast(lastTraceLoc, siteLoc))) {
            p0 = lastTraceLoc;
            p1 = firstTraceLoc;
        } else {
            p0 = firstTraceLoc;
            p1 = lastTraceLoc;
        }
        LocationVector traceVector = LocationUtils.vector(p0, p1);
        LocationVector endToSite = LocationUtils.vector(p1, siteLoc);
        for (endSiteAz = endToSite.getAzimuth(); endSiteAz < 0.0; endSiteAz += 360.0) {
        }
        for (traceVectorAz = traceVector.getAzimuth(); traceVectorAz < 0.0; traceVectorAz += 360.0) {
        }
        double azDiff = endSiteAz - traceVectorAz;
        if (azDiff < -90.0) {
            azDiff += 360.0;
        } else if (azDiff > 90.0) {
            azDiff -= 360.0;
        }
        azDiff = Math.abs(azDiff);
        Preconditions.checkState((azDiff >= 0.0 ? 1 : 0) != 0);
        if (azDiff > 90.0) {
            return 0.0;
        }
        LocationVector abovePoint = new LocationVector(traceVector.getAzimuth() + 90.0, endToSite.getHorzDistance() * 2.0, 0.0);
        LocationVector belowPoint = new LocationVector(traceVector.getAzimuth() - 90.0, endToSite.getHorzDistance() * 2.0, 0.0);
        Location perpP1 = LocationUtils.location(p1, abovePoint);
        Location perpP2 = LocationUtils.location(p1, belowPoint);
        return LocationUtils.distanceToLine(perpP1, perpP2, siteLoc);
    }

    public static String getSurfaceInfo(EvenlyGriddedSurface surf) {
        Location loc1 = surf.getLocation(0, 0);
        Location loc2 = surf.getLocation(0, surf.getNumCols() - 1);
        Location loc3 = surf.getLocation(surf.getNumRows() - 1, 0);
        Location loc4 = surf.getLocation(surf.getNumRows() - 1, surf.getNumCols() - 1);
        return new String("\tRup. Surf. Corner Locations (lat, lon, depth (km):\n\n\t\t" + (float)loc1.getLatitude() + ", " + (float)loc1.getLongitude() + ", " + (float)loc1.getDepth() + "\n\t\t" + (float)loc2.getLatitude() + ", " + (float)loc2.getLongitude() + ", " + (float)loc2.getDepth() + "\n\t\t" + (float)loc3.getLatitude() + ", " + (float)loc3.getLongitude() + ", " + (float)loc3.getDepth() + "\n\t\t" + (float)loc4.getLatitude() + ", " + (float)loc4.getLongitude() + ", " + (float)loc4.getDepth() + "\n");
    }

    public static LocationList getEvenlyDiscritizedPerimeter(EvenlyGriddedSurface surface) {
        int r;
        int c;
        LocationList locList = new LocationList();
        int lastRow = surface.getNumRows() - 1;
        int lastCol = surface.getNumCols() - 1;
        for (c = 0; c <= lastCol; ++c) {
            locList.add((Location)surface.get(0, c));
        }
        for (r = 0; r <= lastRow; ++r) {
            locList.add((Location)surface.get(r, lastCol));
        }
        for (c = lastCol; c >= 0; --c) {
            locList.add((Location)surface.get(lastRow, c));
        }
        for (r = lastRow; r >= 0; --r) {
            locList.add((Location)surface.get(r, 0));
        }
        return locList;
    }

    public static LocationList getEvenlyDiscretizedLine(Location start, Location end, double gridSpacing) {
        double length = LocationUtils.linearDistance(start, end);
        if (gridSpacing > length) {
            gridSpacing = length;
        }
        LocationVector vector = LocationUtils.vector(start, end);
        double numSpans = Math.ceil(length / gridSpacing);
        vector.setHorzDistance(vector.getHorzDistance() / numSpans);
        vector.setVertDistance(vector.getVertDistance() / numSpans);
        LocationList line = new LocationList();
        line.add(start);
        Location prevPt = start;
        for (int i = 0; i < (int)numSpans; ++i) {
            Location loc = LocationUtils.location(prevPt, vector);
            line.add(loc);
            prevPt = loc;
        }
        return line;
    }

    public static double getMinDistanceBetweenSurfaces(RuptureSurface surface1, RuptureSurface surface2) {
        ListIterator<Location> it = surface1.getLocationsIterator();
        double min3dDist = Double.POSITIVE_INFINITY;
        while (it.hasNext()) {
            Location loc1 = (Location)it.next();
            for (Location loc2 : surface2.getEvenlyDiscritizedListOfLocsOnSurface()) {
                double dist = LocationUtils.linearDistanceFast(loc1, loc2);
                if (!(dist < min3dDist)) continue;
                min3dDist = dist;
            }
        }
        return min3dDist;
    }

    private static boolean isDjbZero(LocationList border, Location pt) {
        Path2D.Double path = new Path2D.Double(0, border.size());
        boolean starting = true;
        for (Location loc : border) {
            double lat = loc.getLatitude();
            double lon = loc.getLongitude();
            if (starting) {
                ((Path2D)path).moveTo(lon, lat);
                starting = false;
                continue;
            }
            ((Path2D)path).lineTo(lon, lat);
        }
        path.closePath();
        Area area = new Area(path);
        return area.contains(pt.getLongitude(), pt.getLatitude());
    }

    private static boolean isDjbZeroFrankel(EvenlyGriddedSurface surface, double distJB) {
        if (surface.getNumCols() > 1 && surface.getNumRows() > 1) {
            double d2;
            double d1 = LocationUtils.horzDistanceFast(surface.getLocation(0, 0), surface.getLocation(1, 1));
            double min_dist = 1.1 * Math.min(d1, d2 = LocationUtils.horzDistanceFast(surface.getLocation(0, 1), surface.getLocation(1, 0))) / 2.0;
            return distJB <= min_dist;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static CompoundSurface trimEndsOfSurface(CompoundSurface compoundSurf, int numFromStart, int numFromEnd) {
        void var5_9;
        Preconditions.checkArgument((numFromStart > 0 || numFromEnd > 0 ? 1 : 0) != 0, (Object)"must remove at least one point");
        List<? extends RuptureSurface> surfList = compoundSurf.getSurfaceList();
        for (RuptureSurface ruptureSurface : surfList) {
            Preconditions.checkState((boolean)(ruptureSurface instanceof EvenlyGriddedSurface), (Object)"all sub surfaces must be evenly gridded");
        }
        ArrayList newSurfList = Lists.newArrayList();
        EvenlyGriddedSurface evenlyGriddedSurface = (EvenlyGriddedSurface)surfList.get(0);
        if (numFromStart > 0) {
            if (compoundSurf.isSubSurfaceReversed(0)) {
                EvenlyGriddedSurface evenlyGriddedSurface2 = GriddedSurfaceUtils.trimEndsOfSurface(evenlyGriddedSurface, 0, numFromStart);
            } else {
                EvenlyGriddedSurface evenlyGriddedSurface3 = GriddedSurfaceUtils.trimEndsOfSurface(evenlyGriddedSurface, numFromStart, 0);
            }
        }
        newSurfList.add(var5_9);
        int lastIndex = surfList.size() - 1;
        for (int i = 1; i < lastIndex; ++i) {
            newSurfList.add(surfList.get(i));
        }
        EvenlyGriddedSurface trimmedEnd = (EvenlyGriddedSurface)surfList.get(lastIndex);
        if (numFromEnd > 0) {
            trimmedEnd = compoundSurf.isSubSurfaceReversed(lastIndex) ? GriddedSurfaceUtils.trimEndsOfSurface(trimmedEnd, numFromEnd, 0) : GriddedSurfaceUtils.trimEndsOfSurface(trimmedEnd, 0, numFromEnd);
        }
        newSurfList.add(trimmedEnd);
        Preconditions.checkState((newSurfList.size() == surfList.size() ? 1 : 0) != 0, (Object)"Size is messed up");
        return new CompoundSurface(newSurfList);
    }

    public static EvenlyGriddedSurface trimEndsOfSurface(EvenlyGriddedSurface gridSurf, int numFromStart, int numFromEnd) {
        int numRows = gridSurf.getNumRows();
        int numPointsToRemove = numFromStart + numFromEnd;
        Preconditions.checkArgument((numPointsToRemove > 0 ? 1 : 0) != 0, (Object)"must remove at least one point");
        int numCols = gridSurf.getNumCols() - numPointsToRemove;
        Preconditions.checkState((numCols >= 1 ? 1 : 0) != 0, (Object)("Cannot trim " + numPointsToRemove + " from surface with only " + gridSurf.getNumCols() + " cols"));
        int startRow = 0;
        int startCol = numFromStart;
        return new GriddedSubsetSurface(numRows, numCols, startRow, startCol, gridSurf);
    }

    public static double getCornerMidpointDistance(EvenlyGriddedSurface surf, Location siteLoc) {
        double minDist = Double.POSITIVE_INFINITY;
        int numRows = surf.getNumRows();
        int numCols = surf.getNumCols();
        ArrayList<Location> quickLocs = new ArrayList<Location>();
        quickLocs.add((Location)surf.get(0, 0));
        quickLocs.add((Location)surf.get(numRows - 1, 0));
        quickLocs.add((Location)surf.get(0, numCols - 1));
        quickLocs.add((Location)surf.get(numRows - 1, numCols - 1));
        if (numCols > 2) {
            quickLocs.add((Location)surf.get(0, numCols / 2));
            quickLocs.add((Location)surf.get(numRows - 1, numCols / 2));
        }
        quickLocs.add(GriddedSurfaceUtils.getSurfaceMiddleLoc(surf));
        for (Location loc : quickLocs) {
            minDist = Math.min(minDist, LocationUtils.linearDistanceFast(siteLoc, loc));
        }
        return minDist;
    }

    public static Location getSurfaceMiddleLoc(RuptureSurface surf) {
        EvenlyGriddedSurface gridSurf;
        if (surf instanceof EvenlyGriddedSurface && (gridSurf = (EvenlyGriddedSurface)surf).getNumRows() > 2 && gridSurf.getNumCols() > 2) {
            return gridSurf.getLocation(gridSurf.getNumRows() / 2, gridSurf.getNumCols() / 2);
        }
        DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker depthTrack = new DataUtils.MinMaxAveTracker();
        for (Location loc : surf.getEvenlyDiscritizedListOfLocsOnSurface()) {
            latTrack.addValue(loc.getLatitude());
            lonTrack.addValue(loc.getLongitude());
            depthTrack.addValue(loc.getDepth());
        }
        return new Location(latTrack.getAverage(), lonTrack.getAverage(), depthTrack.getAverage());
    }
}

