/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.calc;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opensha.commons.calc.GaussianDistCalc;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.calc.AbstractCalculator;
import org.opensha.sha.calc.disaggregation.DisaggregationCalculator;
import org.opensha.sha.calc.params.filters.SourceFilter;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.gcim.Utils;
import org.opensha.sha.gcim.calc.GcimCalculatorAPI;
import org.opensha.sha.gcim.imCorrRel.ImCorrelationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_InterpolatedParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.util.TRTUtils;
import org.opensha.sha.util.TectonicRegionType;

public class GcimCalculator_extensionForAutomatedGMSelection
extends AbstractCalculator
implements GcimCalculatorAPI {
    private static final String C = "GcimCalculator";
    private static final boolean D = false;
    private Map<TectonicRegionType, ScalarIMR> imrjMap;
    private double[][] pRup_IMj;
    private double[][] epsilonIMj;
    private int numIMi = 0;
    private int currentIMi = -1;
    private ArrayList<? extends Map<TectonicRegionType, ScalarIMR>> imiAttenRels;
    private ArrayList<String> imiTypes;
    private ArrayList<? extends Map<TectonicRegionType, ImCorrelationRelationship>> imijCorrRels;
    private double[][] imiArray;
    private double[][] cdfIMi_IMjArray;
    private double[][][] mulnIMi_RupIMjArray;
    private double[][][] stdlnIMi_RupIMjArray;
    private double[][] rhoIMiIMk_IMj;
    private double[] zApprox;
    private String GcimResultsString = "";
    private boolean gcimComplete = false;
    private Site site;
    private ERF eqkRupForecast;

    public GcimCalculator_extensionForAutomatedGMSelection() {
        this.setApproxCDFvalues();
    }

    @Override
    public void getRuptureContributions(double iml, Site site, Map<TectonicRegionType, ScalarIMR> imrjMap, ERF eqkRupForecast, Collection<SourceFilter> sourceFilters, ParameterList calcParams) throws RemoteException {
        this.imrjMap = imrjMap;
        ScalarIMR firstIMRFromMap = TRTUtils.getFirstIMR(imrjMap);
        this.site = site;
        this.eqkRupForecast = eqkRupForecast;
        DisaggregationCalculator disaggCalc = new DisaggregationCalculator();
        disaggCalc.setStoreRupProbEpsilons(true);
        disaggCalc.disaggregate(iml, site, imrjMap, eqkRupForecast, sourceFilters, calcParams);
        double[][][] disaggRupDetails1 = disaggCalc.getRupProbEpsilons();
        double trate_imj = disaggCalc.getTotalRate();
        disaggCalc.disaggregate(iml * 1.01, site, imrjMap, eqkRupForecast, sourceFilters, calcParams);
        double[][][] disaggRupDetails2 = disaggCalc.getRupProbEpsilons();
        double trate_imj2 = disaggCalc.getTotalRate();
        int numSources = eqkRupForecast.getNumSources();
        if (numSources != disaggRupDetails1.length || numSources != disaggRupDetails2.length) {
            throw new IllegalArgumentException("Error: Num Sources != that from disagg calc");
        }
        this.pRup_IMj = new double[numSources][];
        this.epsilonIMj = new double[numSources][];
        double dtrate_imj = trate_imj - trate_imj2;
        for (int i = 0; i < numSources; ++i) {
            int j;
            int numRup = eqkRupForecast.getSource(i).getNumRuptures();
            this.pRup_IMj[i] = new double[numRup];
            this.epsilonIMj[i] = new double[numRup];
            if (disaggRupDetails1[i] == null) {
                for (j = 0; j < numRup; ++j) {
                    this.pRup_IMj[i][j] = 0.0;
                    this.epsilonIMj[i][j] = 0.0;
                }
                continue;
            }
            for (j = 0; j < numRup; ++j) {
                double pRup_imj = disaggRupDetails1[i][j][0];
                double pRup_imj2 = disaggRupDetails2[i][j][0];
                this.pRup_IMj[i][j] = (pRup_imj * trate_imj - pRup_imj2 * trate_imj2) / dtrate_imj;
                this.epsilonIMj[i][j] = disaggRupDetails1[i][j][1];
            }
        }
    }

    @Override
    public boolean getMultipleGcims(int numIMi, ArrayList<? extends Map<TectonicRegionType, ScalarIMR>> imiAttenRels, ArrayList<String> imiTypes, ArrayList<? extends Map<TectonicRegionType, ImCorrelationRelationship>> imijCorrRels, double maxDist, ArbitrarilyDiscretizedFunc magDistFilter) {
        this.numIMi = numIMi;
        this.imiAttenRels = imiAttenRels;
        this.imiTypes = imiTypes;
        this.imijCorrRels = imijCorrRels;
        this.setGcimOutputDimensions();
        this.mulnIMi_RupIMjArray = new double[numIMi][][];
        this.stdlnIMi_RupIMjArray = new double[numIMi][][];
        for (int i = 0; i < numIMi; ++i) {
            this.currentIMi = i + 1;
            Map<TectonicRegionType, ScalarIMR> imriMap = imiAttenRels.get(i);
            Map<TectonicRegionType, ImCorrelationRelationship> corrImijMap = imijCorrRels.get(i);
            this.getSingleGcim(i, imriMap, corrImijMap, maxDist, magDistFilter);
        }
        this.gcimComplete = true;
        return this.gcimComplete;
    }

    @Override
    public boolean getSingleGcim(int imiNumber, Map<TectonicRegionType, ScalarIMR> imriMap, Map<TectonicRegionType, ImCorrelationRelationship> imijCorrRelMap, double maxDist, ArbitrarilyDiscretizedFunc magDistFilter) {
        int j;
        int numRuptures;
        int i;
        this.signalReset();
        for (ScalarIMR imri : imriMap.values()) {
            imri.resetParameterEventListeners();
            imri.setUserMaxDistance(maxDist);
            imri.setSite(this.site);
        }
        int numSources = this.eqkRupForecast.getNumSources();
        double[][] mulnIMi_RupIMj = new double[numSources][];
        double[][] stdlnIMi_RupIMj = new double[numSources][];
        this.mulnIMi_RupIMjArray[imiNumber] = new double[numSources][];
        this.stdlnIMi_RupIMjArray[imiNumber] = new double[numSources][];
        boolean includeMagDistFilter = magDistFilter != null;
        double magThresh = 0.0;
        int numRupRejected = 0;
        for (i = 0; i < numSources; ++i) {
            if (this.isCancelled()) {
                return false;
            }
            ProbEqkSource source = this.eqkRupForecast.getSource(i);
            numRuptures = this.eqkRupForecast.getNumRuptures(i);
            mulnIMi_RupIMj[i] = new double[numRuptures];
            stdlnIMi_RupIMj[i] = new double[numRuptures];
            this.mulnIMi_RupIMjArray[imiNumber][i] = new double[numRuptures];
            this.stdlnIMi_RupIMjArray[imiNumber][i] = new double[numRuptures];
            double distance = source.getMinDistance(this.site);
            if (distance > maxDist) continue;
            TectonicRegionType trt = source.getTectonicRegionType();
            ScalarIMR imri = TRTUtils.getIMRforTRT(imriMap, trt);
            ImCorrelationRelationship imijCorrRel = Utils.getIMCorrRelForTRT(imijCorrRelMap, trt);
            double rho_lnIMilnIMj = imijCorrRel.getImCorrelation();
            for (int j2 = 0; j2 < numRuptures; ++j2) {
                ProbEqkRupture rupture = source.getRupture(j2);
                if (includeMagDistFilter && rupture.getMag() < magThresh) {
                    ++numRupRejected;
                    continue;
                }
                imri.setEqkRupture(rupture);
                double mulnIMi_Rup = imri.getMean();
                double stdlnIMi_Rup = imri.getStdDev();
                mulnIMi_RupIMj[i][j2] = mulnIMi_Rup + stdlnIMi_Rup * rho_lnIMilnIMj * this.epsilonIMj[i][j2];
                stdlnIMi_RupIMj[i][j2] = stdlnIMi_Rup * Math.sqrt(1.0 - Math.pow(rho_lnIMilnIMj, 2.0));
                this.mulnIMi_RupIMjArray[imiNumber][i][j2] = mulnIMi_RupIMj[i][j2];
                this.stdlnIMi_RupIMjArray[imiNumber][i][j2] = stdlnIMi_RupIMj[i][j2];
            }
        }
        double mulnIMi_IMj = 0.0;
        for (i = 0; i < numSources; ++i) {
            int numRuptures2 = this.eqkRupForecast.getNumRuptures(i);
            for (j = 0; j < numRuptures2; ++j) {
                mulnIMi_IMj += mulnIMi_RupIMj[i][j] * this.pRup_IMj[i][j];
            }
        }
        double varlnIMi_IMj = 0.0;
        for (i = 0; i < numSources; ++i) {
            int numRuptures3 = this.eqkRupForecast.getNumRuptures(i);
            for (j = 0; j < numRuptures3; ++j) {
                varlnIMi_IMj += (Math.pow(stdlnIMi_RupIMj[i][j], 2.0) + Math.pow(mulnIMi_RupIMj[i][j] - mulnIMi_IMj, 2.0)) * this.pRup_IMj[i][j];
            }
        }
        double stdlnIMi_IMj = Math.sqrt(varlnIMi_IMj);
        for (int n = 0; n < this.zApprox.length; ++n) {
            this.imiArray[n][imiNumber] = Math.exp(mulnIMi_IMj + this.zApprox[n] * stdlnIMi_IMj);
            this.cdfIMi_IMjArray[n][imiNumber] = 0.0;
            for (int i2 = 0; i2 < numSources; ++i2) {
                numRuptures = this.eqkRupForecast.getNumRuptures(i2);
                for (int j3 = 0; j3 < numRuptures; ++j3) {
                    double z = (Math.log(this.imiArray[n][imiNumber]) - mulnIMi_RupIMj[i2][j3]) / stdlnIMi_RupIMj[i2][j3];
                    double cdfIMi_RupIMj = GaussianDistCalc.getCDF(z);
                    double[] dArray = this.cdfIMi_IMjArray[n];
                    int n2 = imiNumber;
                    dArray[n2] = dArray[n2] + cdfIMi_RupIMj * this.pRup_IMj[i2][j3];
                }
            }
        }
        return true;
    }

    public boolean getIMiIMk_IMj_Correlation(int imiNumber, int imkNumber, HashMap<TectonicRegionType, ImCorrelationRelationship> imijCorrRelMap, HashMap<TectonicRegionType, ImCorrelationRelationship> imkjCorrRelMap, double maxDist, ArbitrarilyDiscretizedFunc magDistFilter) {
        int j;
        int i;
        int numSources = this.eqkRupForecast.getNumSources();
        boolean includeMagDistFilter = magDistFilter != null;
        double magThresh = 0.0;
        int numRupRejected = 0;
        for (i = 0; i < numSources; ++i) {
            ProbEqkSource source = this.eqkRupForecast.getSource(i);
            int numRuptures = this.eqkRupForecast.getNumRuptures(i);
            double distance = source.getMinDistance(this.site);
            if (distance > maxDist) continue;
            TectonicRegionType trt = source.getTectonicRegionType();
            ImCorrelationRelationship imijCorrRel = Utils.getIMCorrRelForTRT(imijCorrRelMap, trt);
            ImCorrelationRelationship imkjCorrRel = Utils.getIMCorrRelForTRT(imkjCorrRelMap, trt);
            double rho_lnIMilnIMj = imijCorrRel.getImCorrelation();
            double rho_lnIMklnIMj = imkjCorrRel.getImCorrelation();
            for (int j2 = 0; j2 < numRuptures; ++j2) {
                ProbEqkRupture rupture = source.getRupture(j2);
                if (!includeMagDistFilter || !(rupture.getMag() < magThresh)) continue;
                ++numRupRejected;
            }
        }
        for (i = 0; i < numSources; ++i) {
            int numRuptures = this.eqkRupForecast.getNumRuptures(i);
            for (j = 0; j < numRuptures; ++j) {
            }
        }
        for (i = 0; i < numSources; ++i) {
            int numRuptures = this.eqkRupForecast.getNumRuptures(i);
            for (j = 0; j < numRuptures; ++j) {
            }
        }
        this.rhoIMiIMk_IMj[imiNumber][imkNumber] = 0.0;
        return true;
    }

    @Override
    public void setApproxCDFvalues(double zmin, double zmax, double dz) {
        int num_z = (int)Math.round((zmax - zmin) / dz + 1.0);
        this.zApprox = new double[num_z];
        for (int i = 0; i < num_z; ++i) {
            this.zApprox[i] = zmin + (double)i * dz;
        }
    }

    @Override
    public void setApproxCDFvalues() {
        this.setApproxCDFvalues(-3.0, 3.0, 0.2);
    }

    @Override
    public double[] getApproxCDFvalues() {
        return this.zApprox;
    }

    @Override
    public void setGcimOutputDimensions() {
        this.imiArray = new double[this.zApprox.length][this.numIMi];
        this.cdfIMi_IMjArray = new double[this.zApprox.length][this.numIMi];
    }

    public String getGcimResultsString() {
        for (int i = 0; i < this.numIMi; ++i) {
            Map<TectonicRegionType, ScalarIMR> imriMap = this.imiAttenRels.get(i);
            ScalarIMR firstIMRiFromMap = TRTUtils.getFirstIMR(imriMap);
            this.GcimResultsString = this.GcimResultsString + "----------------------\n";
            this.GcimResultsString = firstIMRiFromMap.getIntensityMeasure().getName() == "SA" ? this.GcimResultsString + "Results for SA period: " + String.valueOf(((SA_Param)firstIMRiFromMap.getIntensityMeasure()).getPeriodParam().getValue()) + "\n" : (firstIMRiFromMap.getIntensityMeasure().getName() == "SA Interpolated" ? this.GcimResultsString + "Results for SA Interpolated period: " + String.valueOf(((SA_InterpolatedParam)firstIMRiFromMap.getIntensityMeasure()).getPeriodInterpolatedParam().getValue()) + "\n" : this.GcimResultsString + "Results for " + firstIMRiFromMap.getIntensityMeasure().getName() + "\n");
            for (int j = 0; j < this.zApprox.length; ++j) {
                this.GcimResultsString = this.GcimResultsString + this.imiArray[j][i] + "\t" + this.cdfIMi_IMjArray[j][i] + "\n";
            }
            this.GcimResultsString = this.GcimResultsString + "----------------------\n";
            this.GcimResultsString = this.GcimResultsString + "\n";
        }
        return this.GcimResultsString;
    }

    public void printResultsToConsole() {
        System.out.println(this.GcimResultsString);
    }

    private static void setSAPeriodInIMR(ScalarIMR imr, double period) {
        imr.getIntensityMeasure().getIndependentParameter("SA Period").setValue(period);
    }

    public int getCurrIMi() throws RemoteException {
        return this.currentIMi;
    }

    public int getTotIMi() throws RemoteException {
        return this.numIMi;
    }

    public boolean done() throws RemoteException {
        return this.gcimComplete;
    }
}

