/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gcim.imCorrRel.imCorrRelImpl;

import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.sha.gcim.imCorrRel.ImCorrelationRelationship;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodInterpolatedParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_InterpolatedParam;
import org.opensha.sha.imr.param.OtherParams.TectonicRegionTypeParam;
import org.opensha.sha.util.TectonicRegionType;

public class BakerJayaram08_ImCorrRel
extends ImCorrelationRelationship {
    static final String C = "BakerJayaram08_ImCorrRel";
    public static final String NAME = "Baker and Jayaram (2008)";
    public static final String SHORT_NAME = "BJ2008";
    private static final long serialVersionUID = 1234567890987654353L;
    public static final String TRT_ACTIVE_SHALLOW = TectonicRegionType.ACTIVE_SHALLOW.toString();
    private double t_min = 0.01;
    private double t_max = 10.0;

    public BakerJayaram08_ImCorrRel() {
        this.initOtherParams();
        this.initSupportedIntensityMeasureParams();
        this.ti = Double.NaN;
        this.tj = Double.NaN;
    }

    @Override
    public double getImCorrelation() {
        if (this.imi.getName() == "SA Interpolated" && this.imj.getName() == "SA Interpolated") {
            this.ti = (Double)((SA_InterpolatedParam)this.imi).getPeriodInterpolatedParam().getValue();
            this.tj = (Double)((SA_InterpolatedParam)this.imj).getPeriodInterpolatedParam().getValue();
            double t_min = Math.min(this.ti, this.tj);
            double t_max = Math.max(this.ti, this.tj);
            double c2 = Double.NaN;
            double c1 = 1.0 - Math.cos(1.5707963267948966 - Math.log(t_max / Math.max(t_min, 0.109)) * 0.366);
            if (t_max < 0.2) {
                c2 = 1.0 - 0.105 * (1.0 - 1.0 / (1.0 + Math.exp(100.0 * t_max - 5.0))) * (t_max - t_min) / (t_max - 0.0099);
            }
            double c3 = t_max < 0.109 ? c2 : c1;
            double c4 = c1 + 0.5 * (Math.sqrt(c3) - c3) * (1.0 + Math.cos(Math.PI * t_min / 0.109));
            if (t_max <= 0.109) {
                return c2;
            }
            if (t_min > 0.109) {
                return c1;
            }
            if (t_max < 0.2) {
                return Math.min(c2, c4);
            }
            return c4;
        }
        return Double.NaN;
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint trtConstraint = new StringConstraint();
        trtConstraint.addString(TRT_ACTIVE_SHALLOW);
        this.tectonicRegionTypeParam = new TectonicRegionTypeParam(trtConstraint, TRT_ACTIVE_SHALLOW);
        this.tectonicRegionTypeParam.setValueAsDefault();
        this.otherParams.replaceParameter("Tectonic Region", this.tectonicRegionTypeParam);
    }

    protected void initSupportedIntensityMeasureParams() {
        this.InterpPeriodiParam = new PeriodInterpolatedParam(this.t_min, this.t_max, 1.0, false);
        this.saiDampingParam = new DampingParam();
        this.saiInterpParam = new SA_InterpolatedParam(this.InterpPeriodiParam, this.saiDampingParam);
        this.saiInterpParam.setNonEditable();
        this.InterpPeriodjParam = new PeriodInterpolatedParam(this.t_min, this.t_max, 1.0, false);
        this.sajDampingParam = new DampingParam();
        this.sajInterpParam = new SA_InterpolatedParam(this.InterpPeriodjParam, this.sajDampingParam);
        this.sajInterpParam.setNonEditable();
        this.supportedIMiParams.clear();
        this.supportedIMjParams.clear();
        this.supportedIMiParams.add(this.saiInterpParam);
        this.supportedIMjParams.add(this.sajInterpParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }
}

