/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.apache.commons.lang3.SystemUtils;
import org.opensha.commons.data.region.SitesInGriddedRegion;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.sha.calc.HazusMapCalculator;
import org.opensha.sha.calc.params.MaxDistanceParam;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ERF_Ref;
import org.opensha.sha.gui.beans.ERF_GuiBean;
import org.opensha.sha.gui.beans.IMR_GuiBean;
import org.opensha.sha.gui.beans.IMR_GuiBeanAPI;
import org.opensha.sha.gui.beans.SitesInGriddedRectangularRegionGuiBean;
import org.opensha.sha.gui.controls.RegionsOfInterestControlPanel;
import org.opensha.sha.gui.controls.SetMinSourceSiteDistanceControlPanel;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.gui.infoTools.ExceptionWindow;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;

public class HazusDataSetCalcApp
extends JFrame
implements ParameterChangeListener,
IMR_GuiBeanAPI,
Runnable {
    protected static final String C = "HazusDataSetCalcApplet";
    protected static final boolean D = false;
    private static final int W = 600;
    private static final int H = 820;
    private Insets defaultInsets = new Insets(4, 4, 4, 4);
    private AttenuationRelationship attenRel;
    private boolean isStandalone;
    private static final String CONTROL_PANELS = "Control Panels";
    private static final String REGIONS_OF_INTEREST_CONTROL = "Regions of Interest";
    private static final String DISTANCE_CONTROL = "Max Source-Site Distance";
    private RegionsOfInterestControlPanel regionsOfInterest;
    private SetMinSourceSiteDistanceControlPanel distanceControlPanel;
    private ERF_GuiBean erfGuiBean;
    private IMR_GuiBean imrGuiBean;
    private SitesInGriddedRectangularRegionGuiBean sitesGuiBean;
    private JPanel mainPanel = new JPanel();
    private Border border1;
    private JSplitPane mainSplitPane = new JSplitPane();
    private JPanel buttonPanel = new JPanel();
    private JPanel eqkRupPanel = new JPanel();
    private JTabbedPane parameterTabbedPanel = new JTabbedPane();
    private JPanel imrPanel = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private JPanel gridRegionSitePanel = new JPanel();
    private JPanel imrSelectionPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    private static final String POWERED_BY_IMAGE = "logos/PoweredByOpenSHA_Agua.jpg";
    private int step;
    Timer timer;
    private CalcProgressBar calcProgress;
    private JPanel dataPanel = new JPanel();
    private JPanel imgPanel = new JPanel();
    private JLabel imgLabel = new JLabel(new ImageIcon(FileUtils.loadImage("logos/PoweredByOpenSHA_Agua.jpg")));
    private JButton addButton = new JButton();
    private JComboBox controlComboBox = new JComboBox();
    private GridBagLayout gridBagLayout7 = new GridBagLayout();
    private BorderLayout borderLayout3 = new BorderLayout();
    private JTextField datasetIdText = new JTextField();
    private JLabel datasetLabel = new JLabel();
    private Double maxDistance;
    private GridBagLayout gridBagLayout4 = new GridBagLayout();

    public void init() {
        ExceptionWindow bugWindow;
        try {
            this.initControlList();
            this.jbInit();
        }
        catch (Exception e) {
            bugWindow = new ExceptionWindow((Component)this, e, "Exception occured while initializing the application Parameters values have not been set yet.");
            bugWindow.setVisible(true);
            bugWindow.pack();
        }
        try {
            this.initIMRGuiBean();
        }
        catch (RuntimeException e) {
            JOptionPane.showMessageDialog(this, "Invalid parameter value", e.getMessage(), 0);
            return;
        }
        try {
            this.initGriddedRegionGuiBean();
        }
        catch (Exception ex) {
            bugWindow = new ExceptionWindow((Component)this, ex, "Exception occured while initializing the  region parameters in Hazard Dataset Calc App Parameters values have not been set yet.");
            bugWindow.setVisible(true);
            bugWindow.pack();
        }
        try {
            this.initERFSelector_GuiBean();
        }
        catch (RuntimeException e) {
            JOptionPane.showMessageDialog(this, "Could not connect with ERF's", "Error occur in ERF", 0);
            return;
        }
    }

    private void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, new Color(248, 254, 255), new Color(121, 124, 136));
        this.setSize(new Dimension(564, 834));
        this.getContentPane().setLayout(this.borderLayout1);
        this.mainPanel.setBorder(this.border1);
        this.mainPanel.setLayout(this.gridBagLayout);
        this.mainSplitPane.setOrientation(0);
        this.buttonPanel.setLayout(this.borderLayout3);
        this.eqkRupPanel.setLayout(this.gridBagLayout);
        this.imrPanel.setLayout(this.borderLayout2);
        this.buttonPanel.setMinimumSize(new Dimension(391, 50));
        this.gridRegionSitePanel.setLayout(this.gridBagLayout);
        this.imrSelectionPanel.setLayout(this.gridBagLayout);
        this.dataPanel.setLayout(this.gridBagLayout4);
        this.imgPanel.setLayout(this.gridBagLayout7);
        this.addButton.setBorder(null);
        this.addButton.setText("Start Calc");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HazusDataSetCalcApp.this.addButton_actionPerformed(e);
            }
        });
        this.controlComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HazusDataSetCalcApp.this.controlComboBox_actionPerformed(e);
            }
        });
        this.datasetLabel.setText("Dataset Id:");
        this.dataPanel.setMinimumSize(new Dimension(548, 150));
        this.dataPanel.setPreferredSize(new Dimension(549, 150));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.mainSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 2, 3), 0, 431));
        this.mainSplitPane.add((Component)this.buttonPanel, "bottom");
        this.buttonPanel.add((Component)this.dataPanel, "Center");
        this.dataPanel.add((Component)this.datasetIdText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(30, 80, 0, 0), 0, 0));
        this.dataPanel.add((Component)this.datasetLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(30, 0, 0, 40), 0, 0));
        this.dataPanel.add((Component)this.controlComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(30, 7, 0, 15), 25, 2));
        this.dataPanel.add((Component)this.addButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(27, 10, 20, 140), 79, 12));
        this.buttonPanel.add((Component)this.imgPanel, "South");
        this.imgPanel.add((Component)this.imgLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 235, 3, 246), 57, 28));
        this.mainSplitPane.add((Component)this.parameterTabbedPanel, "top");
        this.imrPanel.add((Component)this.imrSelectionPanel, "Center");
        this.parameterTabbedPanel.addTab("Intensity-Measure Relationship", this.imrPanel);
        this.parameterTabbedPanel.addTab("Region & Site Params", this.gridRegionSitePanel);
        this.parameterTabbedPanel.addTab("Earthquake Rupture Forecast", this.eqkRupPanel);
        this.mainSplitPane.setDividerLocation(550);
        this.setSize(600, 820);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dim.width - this.getSize().width) / 2, (dim.height - this.getSize().height) / 2);
        this.setDefaultCloseOperation(3);
        this.setTitle("Hazus Dataset generator application");
    }

    public static void main(String[] args) {
        HazusDataSetCalcApp application = new HazusDataSetCalcApp();
        application.init();
        application.setVisible(true);
    }

    private void initGriddedRegionGuiBean() {
        this.attenRel = (AttenuationRelationship)this.imrGuiBean.getSelectedIMR_Instance();
        this.sitesGuiBean = new SitesInGriddedRectangularRegionGuiBean();
        this.sitesGuiBean.addSiteParams(this.attenRel.getSiteParamsIterator());
        this.gridRegionSitePanel.add((Component)this.sitesGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
    }

    private void initIMRGuiBean() {
        this.imrGuiBean = new IMR_GuiBean(this);
        this.imrGuiBean.getParameterEditor("IMR").getParameter().addParameterChangeListener(this);
        this.imrSelectionPanel.add((Component)this.imrGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
    }

    private void initERFSelector_GuiBean() {
        try {
            this.erfGuiBean = new ERF_GuiBean(ERF_Ref.get(false, ServerPrefUtils.SERVER_PREFS));
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Connection to ERF servlets failed");
        }
        this.eqkRupPanel.add((Component)this.erfGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String S = "HazusDataSetCalcApplet: parameterChange(): ";
        String name1 = event.getParameterName();
        if (name1.equalsIgnoreCase("IMR")) {
            this.attenRel = (AttenuationRelationship)this.imrGuiBean.getSelectedIMR_Instance();
            this.sitesGuiBean.replaceSiteParams(this.attenRel.getSiteParamsIterator());
            this.sitesGuiBean.validate();
            this.sitesGuiBean.repaint();
        }
    }

    private void initControlList() {
        this.controlComboBox.addItem(CONTROL_PANELS);
        this.controlComboBox.addItem(REGIONS_OF_INTEREST_CONTROL);
        this.controlComboBox.addItem(DISTANCE_CONTROL);
    }

    private void initRegionsOfInterestControl() {
        if (this.regionsOfInterest == null) {
            this.regionsOfInterest = new RegionsOfInterestControlPanel(this, this.sitesGuiBean);
        }
        this.regionsOfInterest.getComponent().pack();
        this.regionsOfInterest.getComponent().setVisible(true);
    }

    private void initDistanceControl() {
        if (this.distanceControlPanel == null) {
            this.distanceControlPanel = new SetMinSourceSiteDistanceControlPanel((Component)this);
        }
        this.distanceControlPanel.pack();
        this.distanceControlPanel.setVisible(true);
    }

    public AttenuationRelationship getSelectedAttenuationRelationship() {
        return this.attenRel;
    }

    void controlComboBox_actionPerformed(ActionEvent e) {
        if (this.controlComboBox.getItemCount() <= 0) {
            return;
        }
        String selectedControl = this.controlComboBox.getSelectedItem().toString();
        if (selectedControl.equalsIgnoreCase(REGIONS_OF_INTEREST_CONTROL)) {
            this.initRegionsOfInterestControl();
        } else if (selectedControl.equalsIgnoreCase(DISTANCE_CONTROL)) {
            this.initDistanceControl();
        }
        this.controlComboBox.setSelectedItem(CONTROL_PANELS);
    }

    void addButton_actionPerformed(ActionEvent e) {
        this.calcProgress = new CalcProgressBar("Hazus Application", "Initializing Calculation ...");
        this.timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (HazusDataSetCalcApp.this.step != 0) {
                    HazusDataSetCalcApp.this.calcProgress.setProgressMessage("Submitting Calculations , Please wait ...");
                } else if (HazusDataSetCalcApp.this.step == 0) {
                    HazusDataSetCalcApp.this.addButton.setEnabled(true);
                    HazusDataSetCalcApp.this.timer.stop();
                    HazusDataSetCalcApp.this.calcProgress.dispose();
                    HazusDataSetCalcApp.this.calcProgress = null;
                }
            }
        });
        Thread t = new Thread(this);
        t.start();
    }

    @Override
    public void run() {
        this.timer.start();
        try {
            this.step = 1;
            this.maxDistance = this.distanceControlPanel == null ? Double.valueOf(MaxDistanceParam.DEFAULT) : Double.valueOf(this.distanceControlPanel.getDistance());
            HazusMapCalculator hazusCalc = new HazusMapCalculator();
            hazusCalc.setMaxSourceDistance(this.maxDistance);
            String dirName = this.datasetIdText.getText().trim();
            ScalarIMR imr = this.imrGuiBean.getSelectedIMR_Instance();
            SitesInGriddedRegion griddedSites = this.sitesGuiBean.getGriddedRegionSite();
            AbstractERF eqkRupForecast = (AbstractERF)this.erfGuiBean.getSelectedERF();
            this.step = 0;
            hazusCalc.getHazardMapCurves(dirName, griddedSites, imr, eqkRupForecast, this.getParametersInfo());
        }
        catch (Exception ee) {
            ee.printStackTrace();
            this.timer.stop();
            this.step = 0;
            JOptionPane.showMessageDialog(this, ee.getMessage(), "Input Error", 1);
            return;
        }
    }

    public String getParametersInfo() {
        String lf = SystemUtils.LINE_SEPARATOR;
        String metadata = this.imrGuiBean.getVisibleParametersCloned().getParameterListMetadataString() + lf + lf + this.sitesGuiBean.getVisibleParametersCloned().getParameterListMetadataString() + lf + lf + this.erfGuiBean.getERFParameterList().getParameterListMetadataString() + lf + this.erfGuiBean.getSelectedERFTimespanGuiBean().getParameterListMetadataString() + lf + lf + "Maximum Site Source Distance = " + this.maxDistance;
        return metadata;
    }

    @Override
    public void updateIM() {
    }

    @Override
    public void updateSiteParams() {
        ScalarIMR imr = this.imrGuiBean.getSelectedIMR_Instance();
        this.sitesGuiBean.replaceSiteParams(imr.getSiteParamsIterator());
        this.sitesGuiBean.validate();
        this.sitesGuiBean.repaint();
    }

    static {
        String osName = System.getProperty("os.name");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

