/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;

public class HazardDataSiteSelectionGuiBean
extends ParameterListEditor
implements ParameterChangeListener {
    public static final String GUI_BEAN_TITLE = "Choose DataSet and Site";
    public static String SERVLET_URL = "http://gravity.usc.edu/OpenSHA/servlet/HazardMapViewerServlet";
    public static String PLOTTER_CALC_SERVLET = "http://gravity.usc.edu/OpenSHA/servlet/HazardDataSetPlotterCalcServlet";
    private StringParameter dataSetParam;
    public String DATA_SET_PARAM_NAME = "Choose DataSet";
    private DoubleParameter latParam;
    public String LAT_PARAM_NAME = "Latitude";
    private DoubleParameter lonParam;
    public String LON_PARAM_NAME = "Longitude";
    private double latParamVal;
    private double lonParamVal;
    Hashtable metaDataHash = new Hashtable();
    Hashtable lonHash = new Hashtable();
    Hashtable latHash = new Hashtable();
    private String selectedDataSet;

    public HazardDataSiteSelectionGuiBean() {
        this.loadDataSets();
        this.selectedDataSet = (String)this.dataSetParam.getValue();
        this.fillLatLon();
        this.parameterList = new ParameterList();
        this.parameterList.addParameter(this.dataSetParam);
        this.parameterList.addParameter(this.latParam);
        this.parameterList.addParameter(this.lonParam);
        this.editorPanel.removeAll();
        this.addParameters();
        this.setTitle(GUI_BEAN_TITLE);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList openConnection() {
        try {
            URL hazardMapViewerServlet = new URL(PLOTTER_CALC_SERVLET);
            URLConnection servletConnection = hazardMapViewerServlet.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream toServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            toServlet.writeObject(this.selectedDataSet);
            toServlet.writeObject(this.latParam.getValue());
            toServlet.writeObject(this.lonParam.getValue());
            toServlet.flush();
            toServlet.close();
            ObjectInputStream fromServlet = new ObjectInputStream(servletConnection.getInputStream());
            ArrayList dataValues = (ArrayList)fromServlet.readObject();
            fromServlet.close();
            return dataValues;
        }
        catch (Exception e) {
            System.out.println("Exception in connection with servlet:" + String.valueOf(e));
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String name = e.getParameterName();
        if (name.equalsIgnoreCase(this.DATA_SET_PARAM_NAME)) {
            this.selectedDataSet = (String)this.dataSetParam.getValue();
            this.fillLatLon();
        } else if (name.equalsIgnoreCase(this.LAT_PARAM_NAME)) {
            if ((Double)this.latParam.getValue() != null) {
                this.latParamVal = (Double)this.latParam.getValue();
            }
        } else if (name.equalsIgnoreCase(this.LON_PARAM_NAME) && (Double)this.lonParam.getValue() != null) {
            this.lonParamVal = (Double)this.lonParam.getValue();
        }
    }

    private void loadDataSets() {
        try {
            URL hazardMapViewerServlet = new URL(SERVLET_URL);
            URLConnection servletConnection = hazardMapViewerServlet.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            outputToServlet.writeObject("Get Data");
            outputToServlet.flush();
            outputToServlet.close();
            ObjectInputStream inputToServlet = new ObjectInputStream(servletConnection.getInputStream());
            this.metaDataHash = (Hashtable)inputToServlet.readObject();
            this.lonHash = (Hashtable)inputToServlet.readObject();
            this.latHash = (Hashtable)inputToServlet.readObject();
            inputToServlet.close();
        }
        catch (Exception e) {
            System.out.println("Exception in connection with servlet:" + String.valueOf(e));
            e.printStackTrace();
        }
        Enumeration enum1 = this.metaDataHash.keys();
        ArrayList keys = new ArrayList();
        while (enum1.hasMoreElements()) {
            keys.add(enum1.nextElement());
        }
        Collections.sort(keys);
        this.dataSetParam = new StringParameter(this.DATA_SET_PARAM_NAME, keys, (String)keys.get(0));
        this.dataSetParam.addParameterChangeListener(this);
        this.latParam = new DoubleParameter(this.LAT_PARAM_NAME);
        this.lonParam = new DoubleParameter(this.LON_PARAM_NAME);
        this.latParam.addParameterChangeListener(this);
        this.lonParam.addParameterChangeListener(this);
    }

    private void fillLatLon() {
        String latitude = (String)this.latHash.get(this.selectedDataSet);
        StringTokenizer tokenizer = new StringTokenizer(latitude);
        double minLat = Double.parseDouble(tokenizer.nextToken());
        double maxLat = Double.parseDouble(tokenizer.nextToken());
        String longitude = (String)this.lonHash.get(this.selectedDataSet);
        tokenizer = new StringTokenizer(longitude);
        double minLon = Double.parseDouble(tokenizer.nextToken());
        double maxLon = Double.parseDouble(tokenizer.nextToken());
        double intervalLon = Double.parseDouble(tokenizer.nextToken());
        this.latParam.setConstraint(new DoubleConstraint(minLat, maxLat));
        this.lonParam.setConstraint(new DoubleConstraint(minLon, maxLon));
        if (!this.latParam.getConstraint().isAllowed(this.latParamVal)) {
            this.latParam.setValue(minLat);
        }
        if (!this.lonParam.getConstraint().isAllowed(this.lonParamVal)) {
            this.lonParam.setValue(minLon);
        }
        if (this.parameterList != null) {
            this.parameterList = new ParameterList();
            this.parameterList.addParameter(this.dataSetParam);
            this.parameterList.addParameter(this.latParam);
            this.parameterList.addParameter(this.lonParam);
            this.editorPanel.removeAll();
            this.addParameters();
            this.editorPanel.validate();
            this.editorPanel.repaint();
            this.setTitle(GUI_BEAN_TITLE);
        }
    }

    private String geSelectedDataSetName() {
        String name = "Selected DataSet: " + this.selectedDataSet + "\t";
        name = name + "Latitude: " + (Double)this.latParam.getValue() + "\t";
        name = name + "Longitude: " + (Double)this.lonParam.getValue();
        return name;
    }

    private String getMetadataForSelectedDataSet() {
        return (String)this.metaDataHash.get(this.selectedDataSet);
    }

    public ArbitrarilyDiscretizedFunc getChoosenFunction() {
        ArrayList dataValues = this.openConnection();
        ArbitrarilyDiscretizedFunc function = new ArbitrarilyDiscretizedFunc();
        int size = dataValues.size();
        for (int i = 0; i < size; ++i) {
            StringTokenizer st = new StringTokenizer((String)dataValues.get(i));
            double xVal = Double.parseDouble(st.nextToken().trim());
            double yVal = Double.parseDouble(st.nextToken().trim());
            function.set(xVal, yVal);
        }
        function.setName(this.geSelectedDataSetName());
        function.setInfo(this.getMetadataForSelectedDataSet());
        return function;
    }
}

