/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.opensha.commons.gui.LabeledBoxPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.util.ListUtils;
import org.opensha.commons.util.NtoNMap;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.sha.gui.beans.IMR_ParamEditor;
import org.opensha.sha.gui.beans.event.IMTChangeEvent;
import org.opensha.sha.gui.beans.event.IMTChangeListener;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.event.ScalarIMRChangeEvent;
import org.opensha.sha.imr.event.ScalarIMRChangeListener;
import org.opensha.sha.util.TectonicRegionType;

public class IMR_MultiGuiBean
extends LabeledBoxPanel
implements ActionListener,
IMTChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Font trtFont = new Font("TRTFont", 1, 16);
    private ArrayList<ScalarIMRChangeListener> imrChangeListeners = new ArrayList();
    private JPanel checkPanel;
    protected JCheckBox singleIMRBox = new JCheckBox("Single IMR For All Tectonic Region Types");
    private List<? extends ScalarIMR> imrs;
    private ArrayList<Boolean> imrEnables;
    private ArrayList<TectonicRegionType> regions = null;
    private IMR_ParamEditor paramEdit = null;
    private int chooserForEditor = 0;
    private ArrayList<ShowHideButton> showHideButtons = null;
    private ArrayList<ChooserComboBox> chooserBoxes = null;
    private HashMap<TectonicRegionType, ScalarIMR> imrMap;
    private Parameter<Double> imt = null;
    private int maxChooserChars = Integer.MAX_VALUE;
    private int defaultIMRIndex = 0;
    private Color backgroundColor;
    private static String showParamsTitle = "Edit IMR Params";
    private static String hideParamsTitle = "Hide IMR Params";
    protected static final Font supportedTRTFont = new Font("supportedFont", 1, 12);
    protected static final Font unsupportedTRTFont = new Font("supportedFont", 2, 12);

    public IMR_MultiGuiBean(List<? extends ScalarIMR> imrs) {
        this.imrs = imrs;
        Preconditions.checkNotNull(imrs, (Object)"IMR list cannot be null!");
        Preconditions.checkArgument((!imrs.isEmpty() ? 1 : 0) != 0, (Object)"IMR list cannot be empty!");
        Color defaultBackground = UIManager.getColor("Panel.background");
        double avgColor = (double)(defaultBackground.getRed() + defaultBackground.getGreen() + defaultBackground.getBlue()) / 3.0;
        this.backgroundColor = avgColor > 127.0 ? Color.WHITE : defaultBackground;
        ArrayList<String> names = new ArrayList<String>();
        for (ScalarIMR scalarIMR : imrs) {
            String name = scalarIMR.getName();
            Preconditions.checkState((!names.contains(name) ? 1 : 0) != 0, (Object)("IMR list cannot contain 2 IMRs with the same name! Duplicate: " + name + ", class: " + String.valueOf(scalarIMR.getClass())));
            names.add(name);
        }
        this.imrEnables = new ArrayList();
        for (int i = 0; i < imrs.size(); ++i) {
            this.imrEnables.add(Boolean.TRUE);
        }
        this.initGUI();
        this.updateIMRMap();
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this.editorPanel, 1));
        this.singleIMRBox.setFont(new Font("My Font", 0, 10));
        this.singleIMRBox.addActionListener(this);
        this.paramEdit = new IMR_ParamEditor();
        this.setTitle("Set IMR");
        this.rebuildGUI();
    }

    public void rebuildGUI() {
        this.rebuildGUI(false);
    }

    private void rebuildGUI(boolean refreshOnly) {
        this.removeAll();
        if (this.regions == null || this.regions.size() <= 1) {
            this.singleIMRBox.setSelected(true);
        } else {
            this.checkPanel = new JPanel();
            this.checkPanel.setLayout(new BoxLayout(this.checkPanel, 0));
            this.checkPanel.add(this.singleIMRBox);
            this.add(this.checkPanel);
        }
        if (!refreshOnly) {
            this.chooserBoxes = new ArrayList();
            this.showHideButtons = null;
        }
        if (!this.singleIMRBox.isSelected()) {
            if (!refreshOnly) {
                this.showHideButtons = new ArrayList();
            }
            for (int i = 0; i < this.regions.size(); ++i) {
                ShowHideButton button;
                ChooserComboBox chooser;
                TectonicRegionType region = this.regions.get(i);
                JLabel label = new JLabel(region.toString());
                label.setFont(trtFont);
                this.add(IMR_MultiGuiBean.wrapInPanel(label));
                if (refreshOnly) {
                    chooser = this.chooserBoxes.get(i);
                    button = this.showHideButtons.get(i);
                } else {
                    chooser = new ChooserComboBox(i);
                    this.chooserBoxes.add(chooser);
                    button = new ShowHideButton(false);
                    button.addActionListener(this);
                    this.showHideButtons.add(button);
                }
                this.add(IMR_MultiGuiBean.wrapInPanel(chooser));
                this.add(IMR_MultiGuiBean.wrapInPanel(button));
                if (!button.isShowing()) continue;
                this.chooserForEditor = i;
                this.updateParamEdit(chooser);
                this.add(this.paramEdit);
            }
        } else {
            ChooserComboBox chooser;
            if (refreshOnly) {
                chooser = this.chooserBoxes.get(0);
                chooser.resetRenderer();
            } else {
                chooser = new ChooserComboBox(0);
                chooser.setBackground(this.backgroundColor);
                this.chooserBoxes.add(chooser);
            }
            this.add(IMR_MultiGuiBean.wrapInPanel(chooser));
            this.chooserForEditor = 0;
            this.updateParamEdit(chooser);
            this.add(this.paramEdit);
        }
        this.validate();
        this.paintAll(this.getGraphics());
    }

    private static JPanel wrapInPanel(JComponent comp) {
        JPanel panel = new JPanel();
        panel.add(comp);
        return panel;
    }

    public boolean isCheckBoxVisible() {
        if (this.checkPanel == null) {
            return false;
        }
        return this.checkPanel.isAncestorOf(this.singleIMRBox) && this.isAncestorOf(this.checkPanel);
    }

    public void setTectonicRegions(ArrayList<TectonicRegionType> regions) {
        boolean newSingle;
        boolean refreshOnly = (regions == null || regions.size() < 2) && !this.isCheckBoxVisible();
        this.regions = regions;
        boolean prevSingle = !this.isMultipleIMRs();
        this.rebuildGUI(refreshOnly);
        boolean bl = newSingle = !this.isMultipleIMRs();
        if (!(refreshOnly || prevSingle && newSingle)) {
            this.fireUpdateIMRMap();
        }
    }

    public ArrayList<TectonicRegionType> getTectonicRegions() {
        return this.regions;
    }

    private static ArrayList<TectonicRegionType> wrapInList(TectonicRegionType trt) {
        if (trt == null) {
            return null;
        }
        ArrayList<TectonicRegionType> trts = new ArrayList<TectonicRegionType>();
        trts.add(trt);
        return trts;
    }

    protected ChooserComboBox getChooser(TectonicRegionType trt) {
        if (!this.isMultipleIMRs()) {
            return this.chooserBoxes.get(0);
        }
        for (int i = 0; i < this.regions.size(); ++i) {
            if (!this.regions.get(i).toString().equals(trt.toString())) continue;
            return this.chooserBoxes.get(i);
        }
        return null;
    }

    private void updateParamEdit(ChooserComboBox chooser) {
        if (chooser.getIndex() == 0 && !this.isMultipleIMRs()) {
            this.defaultIMRIndex = chooser.getSelectedIndex();
        }
        if (this.chooserForEditor == chooser.getIndex()) {
            ScalarIMR imr = this.imrs.get(chooser.getSelectedIndex());
            this.paramEdit.setIMR(imr);
            this.paramEdit.setTRTParamVisible(true);
            this.paramEdit.setTitle("IMR Params: " + imr.getShortName());
            this.paramEdit.validate();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof ShowHideButton) {
            ShowHideButton button = (ShowHideButton)source;
            button.toggle();
            for (ShowHideButton theButton : this.showHideButtons) {
                if (theButton == button) continue;
                theButton.hideParams();
            }
            this.rebuildGUI(true);
        } else if (source == this.singleIMRBox) {
            this.rebuildGUI();
            this.fireUpdateIMRMap();
        }
    }

    private ScalarIMR getIMRForChooser(int chooserID) {
        ChooserComboBox chooser = this.chooserBoxes.get(chooserID);
        return this.imrs.get(chooser.getSelectedIndex());
    }

    public boolean isMultipleIMRs() {
        return !this.singleIMRBox.isSelected();
    }

    public void setMultipleIMRsEnabled(boolean enabled) {
        if (!enabled) {
            this.setMultipleIMRs(false);
        }
        this.singleIMRBox.setEnabled(enabled);
    }

    public ScalarIMR getSelectedIMR() {
        if (this.isMultipleIMRs()) {
            throw new RuntimeException("Cannot get single selected IMR when multiple selected!");
        }
        return this.getIMRForChooser(0);
    }

    public void showParamEditor(TectonicRegionType trt) {
        if (!this.isMultipleIMRs()) {
            throw new RuntimeException("Cannot show param editor for TRT in single IMR mode!");
        }
        for (int i = 0; i < this.regions.size(); ++i) {
            if (!this.regions.get(i).toString().equals(trt.toString())) continue;
            ShowHideButton button = this.showHideButtons.get(i);
            if (button.isShowing()) {
                button.doClick();
            }
            return;
        }
        throw new RuntimeException("TRT '" + trt.toString() + "' not found!");
    }

    protected IMR_ParamEditor getParamEdit() {
        return this.paramEdit;
    }

    public Map<TectonicRegionType, ScalarIMR> getIMRMap() {
        return ImmutableMap.copyOf(this.imrMap);
    }

    public void updateIMRMap() {
        HashMap<TectonicRegionType, ScalarIMR> map = new HashMap<TectonicRegionType, ScalarIMR>();
        if (!this.isMultipleIMRs()) {
            ScalarIMR imr = this.getIMRForChooser(0);
            map.put(TectonicRegionType.ACTIVE_SHALLOW, imr);
        } else {
            for (int i = 0; i < this.regions.size(); ++i) {
                TectonicRegionType region = this.regions.get(i);
                map.put(region, this.getIMRForChooser(i));
            }
        }
        this.imrMap = map;
    }

    public void setMultipleIMRs(boolean multipleIMRs) {
        if (multipleIMRs && (this.regions == null || this.regions.size() <= 1)) {
            throw new RuntimeException("Cannot be set to multiple IMRs if < 2 tectonic regions sepcified");
        }
        boolean previous = this.isMultipleIMRs();
        if (previous != multipleIMRs) {
            this.singleIMRBox.setSelected(!multipleIMRs);
            this.rebuildGUI(false);
            this.fireUpdateIMRMap();
        }
    }

    public void setSelectedSingleIMR(String imrName) {
        this.setMultipleIMRs(false);
        ChooserComboBox chooser = this.chooserBoxes.get(0);
        int index = ListUtils.getIndexByName(this.imrs, imrName);
        if (index < 0) {
            throw new NoSuchElementException("IMR '" + imrName + "' not found");
        }
        ScalarIMR imr = this.imrs.get(index);
        if (!this.shouldEnableIMR(imr)) {
            throw new RuntimeException("IMR '" + imrName + "' cannot be set because it is not supported by the current IMT, '" + this.imt.getName() + "'.");
        }
        chooser.setSelectedIndex(index);
    }

    public void setIMR(String imrName, TectonicRegionType trt) {
        if (!this.isMultipleIMRs()) {
            throw new RuntimeException("IMR cannot be set for a Tectonic Region in single IMR mode");
        }
        if (trt == null) {
            throw new IllegalArgumentException("Tectonic Region Type cannot be null!");
        }
        for (int i = 0; i < this.regions.size(); ++i) {
            if (!trt.toString().equals(this.regions.get(i).toString())) continue;
            int index = ListUtils.getIndexByName(this.imrs, imrName);
            if (index < 0) {
                throw new NoSuchElementException("IMR '" + imrName + "' not found");
            }
            ScalarIMR imr = this.imrs.get(index);
            if (!this.shouldEnableIMR(imr)) {
                throw new RuntimeException("IMR '" + imrName + "' cannot be set because it is not supported by the current IMT, '" + this.imt.getName() + "'.");
            }
            this.chooserBoxes.get(i).setSelectedIndex(index);
            return;
        }
        throw new RuntimeException("TRT '" + trt.toString() + "' not found!");
    }

    public void addIMRChangeListener(ScalarIMRChangeListener listener) {
        this.imrChangeListeners.add(listener);
    }

    public void removeIMRChangeListener(ScalarIMRChangeListener listener) {
        this.imrChangeListeners.remove(listener);
    }

    private void fireUpdateIMRMap() {
        HashMap<TectonicRegionType, ScalarIMR> oldMap = this.imrMap;
        this.updateIMRMap();
        this.fireIMRChangeEvent(oldMap, this.imrMap);
    }

    private void fireIMRChangeEvent(HashMap<TectonicRegionType, ScalarIMR> oldMap, HashMap<TectonicRegionType, ScalarIMR> newMap) {
        ScalarIMRChangeEvent event = new ScalarIMRChangeEvent(this, oldMap, newMap);
        for (ScalarIMRChangeListener listener : this.imrChangeListeners) {
            listener.imrChange(event);
        }
    }

    public Iterator<Parameter<?>> getMultiIMRSiteParamIterator() {
        return IMR_MultiGuiBean.getMultiIMRSiteParamIterator(this.imrMap);
    }

    public static Iterator<Parameter<?>> getMultiIMRSiteParamIterator(HashMap<TectonicRegionType, ScalarIMR> imrMap) {
        ArrayList params = new ArrayList();
        for (TectonicRegionType trt : imrMap.keySet()) {
            ScalarIMR imr = imrMap.get(trt);
            ListIterator<Parameter<?>> siteParams = imr.getSiteParamsIterator();
            while (siteParams.hasNext()) {
                params.add(siteParams.next());
            }
        }
        return params.iterator();
    }

    public boolean isIMREnabled(String imrName) {
        int index = ListUtils.getIndexByName(this.imrs, imrName);
        if (index < 0) {
            throw new NoSuchElementException("IMR '" + imrName + "' not found!");
        }
        return this.imrEnables.get(index);
    }

    private boolean shouldEnableIMR(ScalarIMR imr) {
        return this.imt == null || imr.isIntensityMeasureSupported(this.imt.getName());
    }

    public void setIMT(Parameter<Double> newIMT) {
        this.imt = newIMT;
        for (int i = 0; i < this.imrs.size(); ++i) {
            ScalarIMR imr = this.imrs.get(i);
            Boolean enabled = this.shouldEnableIMR(imr);
            this.imrEnables.set(i, enabled);
        }
        for (ChooserComboBox chooser : this.chooserBoxes) {
            if (!this.imrEnables.get(chooser.getSelectedIndex()).booleanValue()) {
                for (int i = 0; i < chooser.getItemCount(); ++i) {
                    if (!this.imrEnables.get(i).booleanValue()) continue;
                    chooser.setSelectedIndex(i);
                    break;
                }
            }
            chooser.repaint();
        }
    }

    public List<? extends ScalarIMR> getIMRs() {
        return ImmutableList.copyOf(this.imrs);
    }

    public NtoNMap<TectonicRegionType, ScalarIMR> getNtoNMap() {
        return IMR_MultiGuiBean.getNtoNMap(this.imrMap);
    }

    public static NtoNMap<TectonicRegionType, ScalarIMR> getNtoNMap(Map<TectonicRegionType, ScalarIMR> imrMap) {
        NtoNMap<TectonicRegionType, ScalarIMR> map = new NtoNMap<TectonicRegionType, ScalarIMR>();
        for (TectonicRegionType trt : imrMap.keySet()) {
            map.put(trt, imrMap.get(trt));
        }
        return map;
    }

    public static String getIMRMetadataHTML(Map<TectonicRegionType, ScalarIMR> imrMap) {
        NtoNMap<TectonicRegionType, ScalarIMR> map = IMR_MultiGuiBean.getNtoNMap(imrMap);
        Object meta = null;
        Set<ScalarIMR> myIMRs = map.getRights();
        for (ScalarIMR imr : myIMRs) {
            meta = meta == null ? "" : (String)meta + "<br>";
            meta = (String)meta + "--- IMR: " + imr.getName() + " ---<br>";
            Object trtNames = null;
            Collection<TectonicRegionType> trtsForIMR = map.getLefts(imr);
            for (TectonicRegionType trt : trtsForIMR) {
                trtNames = trtNames == null ? "" : (String)trtNames + ", ";
                trtNames = (String)trtNames + trt.toString();
            }
            meta = (String)meta + "--- TectonicRegion";
            if (trtsForIMR.size() > 1) {
                meta = (String)meta + "s";
            }
            meta = (String)meta + ": " + (String)trtNames + " ---<br>";
            meta = (String)meta + "--- Params ---<br>";
            ParameterList paramList = (ParameterList)imr.getOtherParams().clone();
            if (paramList.containsParameter("Tectonic Region")) {
                paramList.removeParameter("Tectonic Region");
            }
            meta = (String)meta + paramList.getParameterListMetadataString();
        }
        return meta;
    }

    public String getIMRMetadataHTML() {
        if (this.isMultipleIMRs()) {
            return IMR_MultiGuiBean.getIMRMetadataHTML(this.imrMap);
        }
        String meta = "IMR = " + this.getSelectedIMR().getName() + "; ";
        meta = meta + this.paramEdit.getVisibleParameters().getParameterListMetadataString();
        return meta;
    }

    @Override
    public void imtChange(IMTChangeEvent e) {
        this.setIMT(e.getNewIMT());
    }

    public void setMaxChooserChars(int maxChooserChars) {
        this.maxChooserChars = maxChooserChars;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 800);
        List<AttenuationRelationship> imrs = AttenRelRef.instanceList(null, true, ServerPrefUtils.SERVER_PREFS);
        for (ScalarIMR scalarIMR : imrs) {
            scalarIMR.setParamDefaults();
        }
        IMR_MultiGuiBean choose = new IMR_MultiGuiBean(imrs);
        frame.setContentPane(choose);
        frame.setVisible(true);
    }

    public class ChooserComboBox
    extends JComboBox {
        private static final long serialVersionUID = 1L;
        private int comboBoxIndex;

        public ChooserComboBox(int index) {
            for (ScalarIMR scalarIMR : IMR_MultiGuiBean.this.imrs) {
                String name = scalarIMR.getName();
                if (name.length() > IMR_MultiGuiBean.this.maxChooserChars) {
                    name = name.substring(0, IMR_MultiGuiBean.this.maxChooserChars);
                }
                this.addItem(name);
            }
            if (!IMR_MultiGuiBean.this.imrEnables.get(IMR_MultiGuiBean.this.defaultIMRIndex).booleanValue()) {
                for (int i = 0; i < IMR_MultiGuiBean.this.imrEnables.size(); ++i) {
                    if (!IMR_MultiGuiBean.this.imrEnables.get(i).booleanValue()) continue;
                    IMR_MultiGuiBean.this.defaultIMRIndex = i;
                    break;
                }
            }
            this.setMaximumRowCount(40);
            this.setSelectedIndex(IMR_MultiGuiBean.this.defaultIMRIndex);
            this.comboBoxIndex = index;
            this.resetRenderer();
            this.addActionListener(new ComboListener(this));
            this.setMaximumSize(new Dimension(15, 150));
        }

        public void resetRenderer() {
            EnableableCellRenderer renderer;
            if (IMR_MultiGuiBean.this.isMultipleIMRs()) {
                TectonicRegionType trt = IMR_MultiGuiBean.this.regions.get(this.comboBoxIndex);
                renderer = new EnableableCellRenderer(trt);
            } else {
                renderer = new EnableableCellRenderer(IMR_MultiGuiBean.this.regions);
            }
            this.setRenderer(renderer);
        }

        public int getIndex() {
            return this.comboBoxIndex;
        }
    }

    private class ShowHideButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private boolean showing;

        public ShowHideButton(boolean initial) {
            this.showing = initial;
            this.updateText();
        }

        private void updateText() {
            if (this.showing) {
                this.setText(hideParamsTitle);
            } else {
                this.setText(showParamsTitle);
            }
        }

        private void hideParams() {
            this.showing = false;
            this.updateText();
        }

        public void toggle() {
            this.showing = !this.showing;
            this.updateText();
        }

        @Override
        public boolean isShowing() {
            return this.showing;
        }
    }

    class ComboListener
    implements ActionListener {
        ChooserComboBox combo;
        Object currentItem;

        ComboListener(ChooserComboBox combo) {
            this.combo = combo;
            this.currentItem = combo.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object tempItem = this.combo.getSelectedItem();
            if (!IMR_MultiGuiBean.this.imrEnables.get(this.combo.getSelectedIndex()).booleanValue()) {
                this.combo.setSelectedItem(this.currentItem);
                IMR_MultiGuiBean.this.updateParamEdit(this.combo);
            } else {
                this.currentItem = tempItem;
                IMR_MultiGuiBean.this.updateParamEdit(this.combo);
                IMR_MultiGuiBean.this.fireUpdateIMRMap();
            }
        }
    }

    public class EnableableCellRenderer
    extends BasicComboBoxRenderer {
        protected ArrayList<Boolean> trtSupported = null;
        private static final long serialVersionUID = 1L;

        public EnableableCellRenderer(TectonicRegionType trt) {
            this(IMR_MultiGuiBean.wrapInList(trt));
        }

        public EnableableCellRenderer(ArrayList<TectonicRegionType> trts) {
            if (trts != null) {
                this.trtSupported = new ArrayList();
                for (ScalarIMR scalarIMR : IMR_MultiGuiBean.this.imrs) {
                    boolean supportsAll = true;
                    for (TectonicRegionType trt : trts) {
                        supportsAll = supportsAll && scalarIMR.isTectonicRegionSupported(trt);
                    }
                    this.trtSupported.add(supportsAll);
                }
            }
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!isSelected) {
                comp.setBackground(IMR_MultiGuiBean.this.backgroundColor);
            }
            if (index >= 0) {
                comp.setEnabled(IMR_MultiGuiBean.this.imrEnables.get(index));
                this.setFont(comp, index);
            } else {
                int selIndex = list.getSelectedIndex();
                this.setFont(comp, selIndex);
                comp.setEnabled(true);
            }
            return comp;
        }

        public void setFont(Component comp, int index) {
            if (this.trtSupported != null) {
                if (this.trtSupported.get(index).booleanValue()) {
                    comp.setFont(supportedTRTFont);
                } else {
                    comp.setFont(unsupportedTRTFont);
                }
            }
        }
    }
}

