/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JOptionPane;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.mapping.gmt.gui.GMT_MapGuiBean;
import org.opensha.commons.mapping.gmt.gui.ImageViewerWindow;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.gui.servlets.ScenarioShakeMapForHazusGeneratorServlet;
import org.opensha.sha.gui.servlets.ScenarioShakeMapGeneratorServlet;
import org.opensha.sha.mapping.GMT_MapGeneratorForShakeMaps;

public class MapGuiBean
extends GMT_MapGuiBean {
    protected static final String C = "MapGuiBean";
    private boolean hazusFileGeneratorCheck;
    boolean generateMapInLogSpace;
    String mapColorScaleValue;

    public MapGuiBean() {
        this.gmtMap = null;
        this.gmtMap = new GMT_MapGeneratorForShakeMaps();
        this.initParamListAndEditor();
    }

    public void makeMap(String xyzVals, EqkRupture eqkRupture, String imt, String metadataAsHTML) {
        try {
            try {
                this.imgName = this.openConnectionToServerToGenerateShakeMap(xyzVals, eqkRupture, imt, (String)metadataAsHTML);
            }
            catch (GMT_MapException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Incorrect GMT params ", 1);
                return;
            }
            String webaddr = this.imgName.substring(0, this.imgName.lastIndexOf("/") + 1);
            metadataAsHTML = (String)metadataAsHTML + MapGuiBean.getClickHereHTML(webaddr);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Server Problem", 1);
            return;
        }
        if (this.showMapInSeperateWindow) {
            ImageViewerWindow imageViewerWindow = new ImageViewerWindow(this.imgName, (String)metadataAsHTML, true);
        }
        this.dirName = null;
    }

    public void makeMap(GeoDataSet xyzVals, EqkRupture eqkRupture, String imt, String metadataAsHTML) {
        boolean gmtServerCheck = (Boolean)this.gmtMap.getAdjustableParamsList().getParameter("Use GMT WebService").getValue();
        if (gmtServerCheck) {
            try {
                this.imgName = ((GMT_MapGeneratorForShakeMaps)this.gmtMap).makeMapUsingServlet(xyzVals, eqkRupture, imt, (String)metadataAsHTML, this.dirName);
                metadataAsHTML = (String)metadataAsHTML + MapGuiBean.getClickHereHTML(this.gmtMap.getGMTFilesWebAddress());
            }
            catch (GMT_MapException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Incorrect GMT params ", 1);
                return;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getMessage(), "Server Problem", 1);
                return;
            }
        }
        try {
            this.imgName = ((GMT_MapGeneratorForShakeMaps)this.gmtMap).makeMapLocally(xyzVals, eqkRupture, imt, (String)metadataAsHTML, this.dirName);
        }
        catch (GMT_MapException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Incorrect GMT params ", 1);
            return;
        }
        catch (RuntimeException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            return;
        }
        if (this.showMapInSeperateWindow) {
            ImageViewerWindow imageViewerWindow = new ImageViewerWindow(this.imgName, (String)metadataAsHTML, gmtServerCheck);
        }
        this.dirName = null;
    }

    public void makeHazusShapeFilesAndMap(GeoDataSet sa03_xyzVals, GeoDataSet sa10_xyzVals, GeoDataSet pga_xyzVals, GeoDataSet pgv_xyzVals, EqkRupture eqkRupture, String metadataAsHTML) {
        String[] imgNames = null;
        try {
            imgNames = ((GMT_MapGeneratorForShakeMaps)this.gmtMap).makeHazusFileSetUsingServlet(sa03_xyzVals, sa10_xyzVals, pga_xyzVals, pgv_xyzVals, eqkRupture, (String)metadataAsHTML, this.dirName);
            metadataAsHTML = (String)metadataAsHTML + MapGuiBean.getClickHereHTML(this.gmtMap.getGMTFilesWebAddress());
        }
        catch (GMT_MapException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Incorrect GMT params ", 1);
            return;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Server Problem", 1);
            return;
        }
        if (this.showMapInSeperateWindow) {
            ImageViewerWindow imageViewerWindow = new ImageViewerWindow(imgNames, (String)metadataAsHTML, true);
        }
        this.dirName = null;
    }

    public void makeHazusShapeFilesAndMap(String sa03_xyzVals, String sa10_xyzVals, String pga_xyzVals, String pgv_xyzVals, EqkRupture eqkRupture, String metadataAsHTML) {
        String[] imgNames = null;
        try {
            try {
                imgNames = this.openConnectionToServerToGenerateShakeMapForHazus(sa03_xyzVals, sa10_xyzVals, pga_xyzVals, pgv_xyzVals, eqkRupture, (String)metadataAsHTML);
            }
            catch (GMT_MapException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Incorrect GMT params", 1);
                return;
            }
            String webaddr = imgNames[0].substring(0, imgNames[0].lastIndexOf("/") + 1);
            metadataAsHTML = (String)metadataAsHTML + MapGuiBean.getClickHereHTML(this.gmtMap.getGMTFilesWebAddress());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Server Problem", 1);
            return;
        }
        if (this.showMapInSeperateWindow) {
            ImageViewerWindow imageViewerWindow = new ImageViewerWindow(imgNames, (String)metadataAsHTML, true);
        }
        this.dirName = null;
    }

    public void setGMT_ParamsForHazus() {
        ParameterList paramList = this.gmtMap.getAdjustableParamsList();
        this.hazusFileGeneratorCheck = (Boolean)paramList.getParameter("Generate Hazus Shape Files").getValue();
        if (!this.hazusFileGeneratorCheck) {
            paramList.getParameter("Generate Hazus Shape Files").setValue(true);
        }
        this.generateMapInLogSpace = (Boolean)paramList.getParameter("Plot Log").getValue();
        if (this.generateMapInLogSpace) {
            paramList.getParameter("Plot Log").setValue(false);
        }
        this.mapColorScaleValue = (String)paramList.getParameter("Color Scale Limits").getValue();
        if (!this.mapColorScaleValue.equals("From Data")) {
            paramList.getParameter("Color Scale Limits").setValue("From Data");
        }
    }

    public void setGMT_ParamsChangedForHazusToOriginalValue() {
        ParameterList paramList = this.gmtMap.getAdjustableParamsList();
        if (!this.hazusFileGeneratorCheck) {
            paramList.getParameter("Generate Hazus Shape Files").setValue(false);
        }
        if (this.generateMapInLogSpace) {
            paramList.getParameter("Plot Log").setValue(true);
        }
        if (!this.mapColorScaleValue.equals("From Data")) {
            paramList.getParameter("Color Scale Limits").setValue(this.mapColorScaleValue);
        }
    }

    private String openConnectionToServerToGenerateShakeMap(String xyzVals, EqkRupture eqkRupture, String imt, String metadata) throws GMT_MapException {
        String webaddr = null;
        try {
            URL gmtMapServlet = new URL(ScenarioShakeMapGeneratorServlet.SERVLET_URL);
            URLConnection servletConnection = gmtMapServlet.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            outputToServlet.writeObject(this.gmtMap);
            outputToServlet.writeObject(xyzVals);
            outputToServlet.writeObject(eqkRupture);
            outputToServlet.writeObject(imt);
            outputToServlet.writeObject(metadata);
            outputToServlet.writeObject(this.dirName);
            outputToServlet.flush();
            outputToServlet.close();
            ObjectInputStream inputToServlet = new ObjectInputStream(servletConnection.getInputStream());
            Object messageFromServlet = inputToServlet.readObject();
            inputToServlet.close();
            if (messageFromServlet instanceof String) {
                webaddr = (String)messageFromServlet;
            } else {
                if (messageFromServlet instanceof GMT_MapException) {
                    throw (GMT_MapException)messageFromServlet;
                }
                if (messageFromServlet instanceof RuntimeException) {
                    throw (RuntimeException)messageFromServlet;
                }
            }
        }
        catch (GMT_MapException e) {
            throw new GMT_MapException(e.getMessage());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Server is down , please try again later");
        }
        return webaddr;
    }

    private String[] openConnectionToServerToGenerateShakeMapForHazus(String sa_03xyzVals, String sa_10xyzVals, String pga_xyzVals, String pgv_xyzVals, EqkRupture eqkRupture, String metadata) throws GMT_MapException {
        Object webaddr = null;
        try {
            URL gmtMapServlet = new URL(ScenarioShakeMapForHazusGeneratorServlet.SERVLET_URL);
            URLConnection servletConnection = gmtMapServlet.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            outputToServlet.writeObject(this.gmtMap);
            outputToServlet.writeObject(sa_03xyzVals);
            outputToServlet.writeObject(sa_10xyzVals);
            outputToServlet.writeObject(pga_xyzVals);
            outputToServlet.writeObject(pgv_xyzVals);
            outputToServlet.writeObject(eqkRupture);
            outputToServlet.writeObject(metadata);
            outputToServlet.writeObject(this.dirName);
            outputToServlet.flush();
            outputToServlet.close();
            ObjectInputStream inputToServlet = new ObjectInputStream(servletConnection.getInputStream());
            webaddr = inputToServlet.readObject();
            inputToServlet.close();
            if (webaddr instanceof GMT_MapException) {
                throw (GMT_MapException)webaddr;
            }
            return (String[])webaddr;
        }
        catch (GMT_MapException e) {
            throw new GMT_MapException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Server is down , please try again later");
        }
    }
}

